<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2017 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}


/**
 * Class ControllerPagesExtensionEnhancedAdmin
 * @property ModelExtensionEnhancedAdmin $model_extension_enhanced_admin
 */

class ControllerPagesExtensionEnhancedAdmin extends AController {
    private $error = array();
    private $errors = array('user_id', 'postcode');
    public $data = array();
    private $fields = array(
        'enhanced_admin_project_url',
        'enhanced_admin_doc_url',
        'enhanced_admin_support_url',
    );

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this,__FUNCTION__);
        $this->request->get['extension'] = 'enhanced_admin';
        $this->loadLanguage('enhanced_admin/enhanced_admin');
        $this->loadLanguage('extension/extensions');
        $this->document->setTitle( $this->language->get('text_additional_settings') );
        $this->load->model('setting/setting');
        $this->loadModel('extension/enhanced_admin');

        if ( $this->request->is_POST() && $this->_validate()) {
            $this->model_setting_setting->editSetting('enhanced_admin', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->redirect($this->html->getSecureURL('extension/enhanced_admin'));
        }

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }
        $this->data['success'] = $this->session->data['success'];
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/enhanced_admin'),
            'text'      => $this->language->get('enhanced_admin_name'),
            'separator' => ' :: ',
            'current'   => true
        ));

        $this->view->assign('addition_note',$this->language->get('enhanced_admin_addition_note'));

        foreach ( $this->fields as $f ) {
            if (isset ( $this->request->post [$f] )) {
                $this->data [$f] = $this->request->post [$f];
            } else {
                $this->data [$f] = $this->config->get($f);
            }
        }

        $this->data ['action'] = $this->html->getSecureURL ( 'extension/enhanced_admin', '&extension=enhanced_admin' );
        $this->data['cancel'] = $this->html->getSecureURL('extension/enhanced_admin');
        $this->data ['heading_title'] = $this->language->get ( 'text_additional_settings' );
        $this->data ['form_title'] = $this->language->get ( 'enhanced_admin_name' );
        $this->data ['update'] = $this->html->getSecureURL ( 'r/extension/enhanced_admin_save/update' );

        $form = new AForm ( 'HS' );
        $form->setForm ( array ('form_name' => 'editFrm', 'update' => $this->data ['update'] ) );

        $this->data['form']['form_open'] = $form->getFieldHtml ( array (
            'type' => 'form',
            'name' => 'editFrm',
            'action' => $this->data ['action'],
            'attr' => 'data-confirm-exit="true" class="aform form-horizontal"'
        ) );
        $this->data['form']['submit'] = $form->getFieldHtml ( array (
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get ( 'button_save' )
        ) );
        $this->data['form']['default'] = $form->getFieldHtml ( array (
            'type' => 'button',
            'name' => 'default',
            'text' => $this->language->get ( 'button_default' )
        ) );
        $this->data['form']['cancel'] = $form->getFieldHtml ( array (
            'type' => 'button',
            'name' => 'cancel',
            'text' => $this->language->get ( 'button_cancel' )
        ) );

        $master_id=$this->user->getUserGroupId();
        if ($master_id==1) {
            $this->data['form']['fields']['feed_url'] = $form->getFieldHtml(array(
                'type' => 'input',
                'name' => 'enhanced_admin_feed_url',
                'value' => $this->config->get('enhanced_admin_feed_url'),
                'style' => 'large-field',
            ));
        }
        $this->data['form']['fields']['bottom_sf'] = $form->getFieldHtml(array(
            'type' => 'textarea',
            'name' => 'enhanced_admin_bottom_sf',
            'value' => $this->config->get('enhanced_admin_bottom_sf'),
            'style'  => 'xl-field',
        ));
        //$this->data['form']['fields']['bottom_email'] = $form->getFieldHtml(array(
        //    'type' => 'textarea',
        //    'name' => 'enhanced_admin_bottom_email',
        //    'value' => $this->config->get('enhanced_admin_bottom_email'),
        //    'style'  => 'xl-field',
        //));
        $this->data['form']['fields']['copyright_year'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'enhanced_admin_copyright_year',
            'value' => $this->config->get('enhanced_admin_copyright_year'),
            'style'  => 'large-field',
        ));

        //load tabs controller

        $this->data['groups'][] = 'additional_settings';
        $this->data['link_additional_settings'] = '';
        $this->data['active_group'] = 'additional_settings';
        //$this->data['button_restore']=$this->language->get('fs_button_restore');
        $tabs_obj = $this->dispatch('pages/extension/extension_tabs', array( $this->data ) );
        $this->data['tabs'] = $tabs_obj->dispatchGetOutput();
        unset($tabs_obj);

        $obj = $this->dispatch('pages/extension/extension_summary', array( $this->data ) );
        $this->data['extension_summary'] = $obj->dispatchGetOutput();
        unset($obj);

        $this->view->batchAssign( $this->data );

        $this->processTemplate('pages/extension/enhanced_admin.tpl');

        //update controller data
        $this->extensions->hk_UpdateData($this,__FUNCTION__);
    }

    public function delete() {
        $id = $this->request->get ['id'];
        $this->log->write($id);
        $this->load->model('extension/enhanced_admin');
        if ( $id ) {
            $this->model_extension_enhanced_admin->deleteFeed($id);
        }
    }

    private function _validate() {
        if (!$this->user->canModify('extension/enhanced_admin')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

}