<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$table="CREATE TABLE IF NOT EXISTS ".$this->db->table('banner_statistic_manager_chart')."(
  `chart_id` int(11) NOT NULL AUTO_INCREMENT,
  `banner_id` varchar(64) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `value` mediumtext COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`chart_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;";

$this->db->query($table);

$rm = new AResourceManager();
$rm->setType('image');
$language_id = $this->language->getContentLanguageID();
$data = [];
$data['resource_code'] = '<i class="fa fa-bar-chart"></i>&nbsp;';
$data['name'] = [$language_id => 'Banner Statistic Manager'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$menu = new AMenu ( "admin" );
$menu->insertMenuItem ( ["item_id" => "banner_statistic_manager",
                                 "parent_id" => "reports",
                                 "item_text" => "Banner Statistic Manager",
                                 "item_url" => "extension/banner_statistic_manager",
                                 "item_type" => "extension",
                                 "sort_order"=>"10",
                                 "item_icon_rl_id" => $resource_id
	]
);

$sql1 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("banner_statistic_manager_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql1);

if (HTTPS===true) {
	$domain = HTTPS_SERVER;
} else {
	$domain = HTTP_SERVER;
}

$message = "This is an email notification to let you know that Banner Statistic Manager extension v 1.3.2 is installed in ".$domain;
$mail = new AMail($this->config);
$mail->setTo('installs@wehearyou2.net');
$mail->setFrom('installs@wehearyou2.net');
$mail->setSubject('Extension installation information');
$mail->setSender('Information');
$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
$mail->send();