<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2020 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}
include_once DIR_EXT . 'ups_integration' . DIR_EXT_CORE . 'lib/autoload.php';
class ControllerResponsesExtensionUpsTest extends AController {
    private $cfg = array();

    public function test() {
        $this->loadLanguage('ups_integration/ups_integration');
        $this->loadModel('setting/setting');
        $this->cfg = $this->model_setting_setting->getSetting('ups_integration',(int)$this->session->data['current_store_id']);
        $json = array ();
        $required_fields = array (
            'key'        	 => 'ups_integration_key',
            'username'   	 => 'ups_integration_username',
            'pass'       	 => 'ups_integration_password',
            'city'       	 => 'ups_integration_city',
            'postcode'   	 => 'ups_integration_postcode',
            'state'   		 => 'ups_integration_state',
            'origin'	 	 => 'ups_integration_country',
            'classification' => 'ups_integration_classification',
            'packaging'		 => 'ups_integration_packaging',
            'pickup'		 => 'ups_integration_pickup',
        );
        $address = array ();
        foreach ($required_fields as $k => $fld){
            if (!$this->cfg[$fld]){
                $json['error'] = true;
                $json['message'] = 'Error: Please fill and save all required fields and try again.';
                break;
            }
            $address[$k] = $this->cfg[$fld];
        }


        if ($json['error'] != true){

            $test_result = $this->_processRequest($address);
            $test_mode = $this->cfg['ups_integration_test'] ? 'ON' : 'OFF';
            if (!$test_result){
                $json['error'] = true;
                $json['message'] = 'UPS Error: Wrong data was given. Please check your API Credentials and try again.' . "\n" . 'Also please note that Test mode is ' . $test_mode . '!';
            } else if ($test_result['error']){
                $json['error'] = true;
                $json['message'] = 'UPS Error: ' . $test_result['error'] . "\n" . 'Please check your API Credentials and try again.' . "\n" . 'Also please note that Test mode is ' . $test_mode . '!';

            } else{
                $json['message'] = $this->language->get('text_connection_success');
                $json['error'] = false;
            }
        }
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }

    private function _processRequest($address){
        //ups Key
        $ups_key = $this->cfg['ups_integration_key'];
        //ups Meter Id
        $ups_username = $this->cfg['ups_integration_username'];
        //ups Password
        $ups_password = $this->cfg['ups_integration_password'];
        //ups Account
        $ups_account = $this->cfg['ups_integration_account'];

        $ups_classification=$this->cfg['ups_integration_classification'];
        $ups_packaging=$this->cfg['ups_integration_packaging'];
        $ups_pickup=$this->cfg['ups_integration_pickup'];
        $ups_city = $this->cfg['ups_integration_city'];
        $ups_postcode = $this->cfg['ups_integration_postcode'];
        $ups_origin = $this->cfg['ups_integration_country'];

        //Recepient Info
        $shipping_address = $address;

        $this->load->model('localisation/zone');
        $f = new \RocketShipItUps\Rate('ups');
        if ($this->config->get('ups_integration_test') == '1') {
            $f->setParameter('debugMode', 1);
        } else {
            $f->setParameter('debugMode', 0);
        }
        $f->setParameter('license', $ups_key);
        $f->setParameter('username', $ups_username);
        $f->setParameter('password', $ups_password);
        $f->setParameter('accountNumber', $ups_account);
        $f->setParameter('PickupType', $ups_pickup);
        $f->setParameter('customerClassification', $ups_classification);
        $f->setParameter('shipCity', $ups_city);
        $f->setParameter('shipCode', $ups_postcode);
        $f->setParameter('shipCountry', $ups_origin);
        $f->setParameter('fromCity', $ups_city);
        $f->setParameter('fromCode', $ups_postcode);
        $f->setParameter('fromCountry', $ups_origin);
        $f->setParameter('toCity', $shipping_address['city']);
        $f->setParameter('toCountry', $shipping_address['origin']);
        $f->setParameter('toCode', $shipping_address['postcode']);
        $f->setParameter('toState', $shipping_address['state']);
        $f->setParameter('packagingType', $ups_packaging);
        $f->setParameter('lengthUnit', $this->config->get('config_length_class'));
        $f->setparameter('length', '1');
        $f->setparameter('width', '1');
        $f->setparameter('height', '1');
        if ($this->config->get('config_weight_class') == 'lb') {
            $weightUnit = 'lbs';
        } elseif ($this->config->get('config_weight_class') == 'kg') {
            $weightUnit = 'kgs';
        }
        $f->setParameter('weightUnit', $weightUnit);
        $f->setParameter('weight', '1');
        $error_msg='';
        $response = $f->getSimpleRates();
        if ($response['error'] != '') {
            $error_msg = $response['error'];
        }

        return array ('error' => $error_msg);
    }
}