<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com
  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)
------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT. "telephone_option" . DIR_EXT_CORE ."updater.php";

/**
 * Class ExtensionTelephoneOption
 * @property AController baseObject
 * @property ModelAccountTelephone $model_account_telephone
 */
class ExtensionTelephoneOption extends Extension {
    public $data = [];
    public $errors = [];
    private $error=[];
    protected $registry;
    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "telephone_option";
    public $zeroDates = [
        '0000-00-00 00:00:00',
        '1970-01-01 00:00:00',
    ];

    private $address_fields = [
        'firstname' => [
            'type' => 'input',
            'required' => true
        ],
        'lastname' => [
            'type' => 'input',
            'required' => true
        ],
        'company' => [
            'type' => 'input',
            'required' => false
        ],
        'address_1' => [
            'type' => 'input',
            'required' => true
        ],
        'address_2' => [
            'type' => 'input',
            'required' => false
        ],
        'city' => [
            'type' => 'input',
            'required' => true
        ],
        'postcode' => [
            'type' => 'input',
            'required' => false
        ],
        //note! this field is pair of country_id and zone_id
        'country_id' => [
            'type' => 'zones',
            'required' => true]
    ];

    public function  __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get('telephone_option_status') ? $this->verify() : false;
    }

	public function verify() {
		$that =& $this->baseObject;
        $that->load->model('extension/telephone_option_license_info');
		$license_key = $that->config->get('telephone_option_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('telephone_option_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_telephone_option_license_info->getStoreId();
                $license_key = $that->model_extension_telephone_option_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_telephone_option_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 604800;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_telephone_option_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $public_key = "";
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/telephone_option_license_info');
                    $current_version = $that->model_extension_telephone_option_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 604800;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/telephone_option_license_info');
                            $that->model_extension_telephone_option_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyUpsPlus() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'ups_integration_plus_status' ) === '1' ) {
            $that->load->model('extension/ups_integration_plus_license_info');
            $license_key = $that->config->get('ups_integration_plus_license_code');
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('ups_integration_plus_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_ups_integration_plus_license_info->getStoreId();
                    $license_key = $that->model_extension_ups_integration_plus_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_ups_integration_plus_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                    $ttl = 604800;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_ups_integration_plus_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }

    public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('telephone_option_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/telephone_option_license_info');
                    $store_id = $that->model_extension_telephone_option_license_info->getStoreId();
                    $license_info = $that->model_extension_telephone_option_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_telephone_option_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/telephone_option_updater');
                        $current_version = $that->model_extension_telephone_option_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 604800;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/telephone_option_license_info');
                                $that->model_extension_telephone_option_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_InitData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'edit') {
            $extension = $that->request->get['extension'];
            if ($extension === 'telephone_option') {
                if ($that->request->is_POST()) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['telephone_option_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/telephone_option_license_info');

                    $store_id = (int)$that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int)$that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['current_store_id']) {
                            $store_id = (int)$that->session->data['current_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_telephone_option_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id !== '' && !is_null($installed_store_id)) {
                        $that->model_extension_telephone_option_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_telephone_option_license_info->getLicenseCode($store_id);
                    $data['multi'] = false;
                    $split_existing_license_key = explode('-', $existing_license_key);
                    $split_license_key = explode('-', $license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi'] = true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/telephone_option_updater');
                    $current_version = $that->model_extension_telephone_option_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 604800;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/telephone_option_license_info');
                        $data['telephone_option_licensed_store_id_' . $store_id] = 1;

                        $that->model_setting_setting->editSetting('telephone_option', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT . 'telephone_option/core/helpers.php')) {
                                unlink(DIR_EXT . 'telephone_option/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/telephone_option_license_info');
                            $that->model_extension_telephone_option_license_info->saveLicenseData($data);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='telephone_option') {
                $that->load->language('telephone_option/telephone_option');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('telephone_option/telephone_option');
            if ( $extension === 'telephone_option' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_telephone_option_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/telephone_option_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/telephone';
                $data['manual_title'] = $that->language->get('telephone_option_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/telephone_option_manual.tpl'));
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'telephone_option') {
            return false;
        }
        if (isset($that->request->post['telephone_option_license_code'])) {
            $that->request->post['telephone_option_license_code'] = trim($that->request->post['telephone_option_license_code']);
        }
    }

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('telephone_option/telephone_option');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('telephone_option_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'telephone_option_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion!=='') {
                                $update_now_url = $that->html->getSecureURL('extension/telephone_option_updater','&version='.str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    .'<br>'
                                    .sprintf(
                                        $that->language->get('text_update_telephone_option_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    .'</p>';
                                $that->data['response']->rows[$k]['cell'][$key] = $cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
			if ($that->request->post['telephone_option_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['telephone_option_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/telephone_option_license_info');

                $installed_store_id = $that->model_extension_telephone_option_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_telephone_option_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/telephone_option_updater');
                $current_version = $that->model_extension_telephone_option_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 604800;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/telephone_option_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/telephone_option_license_info');
                        $that->model_extension_telephone_option_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }

    //Hook Guest Step 1 Validation
    public function onControllerPagesCheckoutGuestStep1_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('checkout/guest_step_1');
        $that->loadLanguage('account/telephone');
        $telephone = $that->request->post['telephone'];
        $fax = $that->request->post['fax'];
        $company = $that->request->post['company'];
        $shipping_company = $that->request->post['shipping_company'];
        $default_local_delivery_status = $that->config->get('default_local_delivery_status');
        if ($that->config->get('telephone_option_mandatory_status')) {
            $pattern = $that->config->get('config_phone_validation_pattern') ?: '/^[0-9]{3,32}$/';
            if ($telephone === ''
                && (mb_strlen($telephone) < 3
                    || mb_strlen($telephone) > 32
                    || !preg_match($pattern, $telephone))
            ) {
                 $that->error['telephone'] = $that->language->get('telephone_error');
            }
        } elseif ($default_local_delivery_status) {
            $telephone_error = $that->error['telephone'];
            $that->error['telephone'] = $telephone_error;
        }
        if ($that->config->get('fax_option_mandatory_status')
            && $that->config->get('fax_option_show')) {
            if (empty($fax) || ((mb_strlen($fax) < 3 || mb_strlen($fax) > 32) && strtolower($fax) != 'na' && strtolower($fax) != 'none')) {
                $that->error['fax'] = $that->language->get('fax_error');
            }
        }
        if ($that->config->get('company_option_mandatory_status')) {
            if ($company == '') {
                $that->error['company'] = $that->language->get('company_error');
            }
            if ($that->request->post['shipping_indicator']) {
                if ($shipping_company == '') {
                    $that->error['shipping_company'] = $that->language->get('company_error');
                }
            }
        }
        if (count($that->error)) {
            $that->view->assign('error_warning', $that->language->get('gen_data_entry_error'));
        }
    }

    public function onControllerPagesCheckoutGuestStep1_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        $form = new AForm();
		    $form->setForm( ['form_name' => 'guestFrm' ] );
		    $that->loadLanguage( 'account/telephone' );
		    $field_errors = $that->error;

		    if ( $field_errors ) {
			    foreach ( $field_errors as $key => $field_error ) {
				    $that->view->assign( 'error_' . $key, $field_error );
			    }
		    }

        $form=$that->view->getData('form');

        if (isset($that->request->post['telephone'])) {
            $telephone = $that->request->post['telephone'];
        } elseif (isset($that->session->data['guest']['telephone'])) {
            $telephone = $that->session->data['guest']['telephone'];
        } else {
            $telephone = '';
        }
        $default_local_delivery_status = $that->config->get('default_local_delivery_status');

        $form['fields']['general']['telephone'] = $that->html->buildInput(
            [
                'name' => 'telephone',
                'value' => $telephone,
                'required' => $that->config->get('telephone_option_mandatory_status') || $default_local_delivery_status
            ]);

        $show_fax = $that->config->get('fax_option_show');
        if ($show_fax === '1') {
            if (isset($that->request->post['fax'])) {
                $fax = $that->request->post['fax'];
            } elseif (isset($that->session->data['guest']['fax'])) {
                $fax = $that->session->data['guest']['fax'];
            } else {
                $fax = '';
            }

            $form['fields']['general']['fax'] = $that->html->buildInput(
                [
                    'name' => 'fax',
                    'value' => $fax,
                    'placeholder' => $that->config->get('fax_option_placeholder'),
                    'required' => $that->config->get('fax_option_mandatory_status')
                ]);
        }
        if (isset($that->request->post['company'])) {
            $company = $that->request->post['company'];
        } elseif (isset($that->session->data['guest']['company'])) {
            $company = $that->session->data['guest']['company'];
        } else {
            $company = '';
        }

        $form['fields']['address']['company'] = $that->html->buildInput(
            [
                'name' => 'company',
                'value' => $company,
                'required' => false,
                'placeholder' => $that->config->get('company_option_placeholder'),
                'required' => $that->config->get('company_option_mandatory_status')
            ]);

        if (isset($that->request->post['shipping_company'])) {
            $shipping_company = $that->request->post['shipping_company'];
        } elseif (isset($that->session->data['guest']['shipping']['company'])) {
            $shipping_company = $that->session->data['guest']['shipping']['company'];
        } else {
            $shipping_company = '';
        }
        $form['fields']['shipping']['shipping_company'] = $that->html->buildInput(
            [
                'name' => 'shipping_company',
                'value' => $shipping_company,
                'placeholder' => $that->config->get('company_option_placeholder'),
                'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
            ]);
        $that->view->assign('form',$form);
    }

    public function onControllerPagesCheckoutConfirm_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {

            $payment_address = $that->model_account_address->getAddress($that->session->data['payment_address_id']);
            $shipping_address = $that->model_account_address->getAddress($that->session->data['shipping_address_id']);
            if ($payment_address['company'] !== '' && strtolower($payment_address['company']) !== 'na' && strtolower($payment_address['company'] !== 'none')) {
                $that->view->addHookVar('checkout_confirm_payment_info_pre_2', $payment_address['company'].'<br>');
            }
            if ($shipping_address['company'] !== '' && strtolower($shipping_address['company']) !== 'na' && strtolower($shipping_address['company'] !== 'none')) {
                $that->view->addHookVar('checkout_confirm_shipping_info_pre_2', $shipping_address['company'].'<br>');
            }
            $fax = $that->customer->getFax();
            if ($fax!=='' && strtolower($fax)!=='na' && strtolower($fax)!=='none') {
                if ($that->customer->getTelephone()) {
                    $that->view->assign('telephone',$that->data['telephone'].'<br>'.$fax);
                } else {
                    $that->view->assign('telephone',$fax);
                }
            }
        }
    }

    public function onControllerPagesCheckoutGuestStep3_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $payment_address = $that->session->data['guest'];
            $shipping_address = $that->session->data['guest']['shipping'];
            if ($payment_address['company'] !== '' && strtolower($payment_address['company']) !== 'na' && strtolower($payment_address['company'] !== 'none')) {
                $that->view->addHookVar('checkout_confirm_payment_info_pre_2', $payment_address['company'].'<br>');
            }
            if ($shipping_address && $shipping_address['company'] !== '' && strtolower($shipping_address['company']) !== 'na' && strtolower($shipping_address['company'] !== 'none')) {
                $that->view->addHookVar('checkout_confirm_shipping_info_pre_2', $shipping_address['company'] . '<br>');
            }
            $phone = $that->session->data['guest']['telephone'];
            $fax = $that->session->data['guest']['fax'];
            if ($fax!=='' && strtolower($fax)!=='na' && strtolower($fax)!=='none') {
                if ($phone!=='') {
                    $that->view->assign('telephone',$that->data['telephone'].'<br>'.$fax);
                } else {
                    $that->view->assign('telephone',$fax);
                }
            }
        }
    }

    //Hook Create new shipping address, new payment address,create new address, edit address validation
    public function onModelAccountAddress_ValidateData(){
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
        $that->load->language('account/address');
        $that->load->language('account/telephone');
        $that->load->language('checkout/guest_step_1');
        if ($that->config->get('company_option_mandatory_status') === '1') {
            if ((mb_strlen($that->request->post['company']) === 0)) {
                $that->error['company'] = $that->language->get('company_error');
            }
        }
        if (count($that->error)) {
            $that->error('error_warning', $that->language->get('gen_data_entry_error'));
        }
    }

    public function onControllerPagesCheckoutAddress_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method == 'shipping') {
            $form = $that->view->getData('form');
            $that->view->assign('error_company',$that->error['company']);
            $form['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $that->request->post['company'],
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method == 'payment') {
            $form = $that->view->getData('form');
            $that->view->assign('error_company',$that->error['company']);
            $form['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $that->request->post['company'],
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        }
    }

    //Hook Create new account,edit account validation
    public function onModelAccountCustomer_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $telephone = $that->request->post['telephone'];
        $fax = $that->request->post['fax'];
        $company = $that->request->post['company'];
        $that->load->language('account/create');
        $that->load->language('checkout/guest_step_1');
        $that->load->language('account/telephone');
        $rt = $that->request->get['rt'];
        if ($rt === 'account/create') {
            if ($that->config->get('telephone_option_mandatory_status') === '1') {
                if (empty($telephone) || (mb_strlen($telephone) < 3) || (mb_strlen($telephone) > 32)) {
                    $that->error['telephone'] = $that->language->get('telephone_error');
                }
            }
            if ($that->config->get('fax_option_mandatory_status') === '1'
                && $that->config->get('fax_option_show') === '1') {
                if (empty($fax) || ((mb_strlen($fax) < 3 || mb_strlen($fax) > 32) && strtolower($fax) != 'na' && strtolower($fax) != 'none')) {
                    $that->error['fax'] = $that->language->get('fax_error');
                }
            }
            if ($that->config->get('company_option_mandatory_status') === '1') {
                if (empty($company) && strtolower($company) !== 'na' && strtolower($company) !== 'none') {
                    $that->error['company'] = $that->language->get('company_error');
                }
            }
        } elseif ($rt === 'account/edit') {
            if ($that->config->get('telephone_option_mandatory_status') === '1') {
                if (empty($telephone) || (mb_strlen($telephone) < 3) || (mb_strlen($telephone) > 32)) {
                    $that->error['telephone'] = $that->language->get('telephone_error');
                }
            }
            if ($that->config->get('fax_option_mandatory_status') === '1'
                && $that->config->get('fax_option_show') === '1') {
                if (empty($fax) || ((mb_strlen($fax) < 3 || mb_strlen($fax) > 32) && strtolower($fax) != 'na' && strtolower($fax) != 'none')) {
                    $that->error['fax'] = $that->language->get('fax_error');
                }
            }
            if (count($that->error)) {
                $that->error['warning'] = $that->language->get('gen_data_entry_error');
            }
        }
    }

    public function onControllerPagesAccountCreate_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $data = [];
            $that->loadModel('account/telephone');
            $that->load->language('account/telephone');
            $form = $that->view->getData('form');
            $that->view->assign('error_telephone', $that->errors['telephone']);
            $that->view->assign('error_fax', $that->errors['fax']);
            $that->view->assign('error_company', $that->errors['company']);

            $form['fields']['general']['telephone'] = $that->html->buildInput(
                [
                    'name' => 'telephone',
                    'value' => $that->request->post['telephone'],
                    'required' => ($that->config->get('telephone_option_mandatory_status') == '1') ? true : false
                ]);
            $show_fax = $that->config->get('fax_option_show');
            if ($show_fax === '1') {
                $form['fields']['general']['fax'] = $that->html->buildInput(
                    [
                        'name' => 'fax',
                        'value' => $that->request->post['fax'],
                        'placeholder' => $that->config->get('fax_option_placeholder'),
                        'required' => ($that->config->get('fax_option_mandatory_status') == '1') ? true : false
                    ]);
            } else {
                unset($form['fields']['general']['fax']);
            }

            $form['fields']['address']['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $that->request->post['company'],
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        }
    }

    public function onControllerPagesAccountEdit_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'main' ) {
			    $that->loadModel( 'account/telephone' );
			    $that->loadLanguage( 'account/telephone' );

			    $that->view->assign('error_telephone',  $that->error['telephone']);
			    $that->view->assign('error_fax',        $that->error['fax']);

			    if ( $that->request->is_GET() ) {
				    $customer_info                    = $that->model_account_customer->getCustomer( $that->customer->getId() );
				    $that->session->data['loginname'] = $customer_info['loginname'];
			    }

			    $request_data = $that->request->post;

                $form=$that->view->getData('form');

			    if ( isset( $request_data['telephone'] ) ) {
				    $telephone = $request_data['telephone'];
			    } elseif ( isset( $customer_info ) ) {
				    $telephone = $customer_info['telephone'];
			    } elseif ( $request_data['telephone'] == '' ) {
				    $telephone = '';
			    }

                $form['fields']['telephone'] = $that->html->buildInput(
				    [
					    'name'     => 'telephone',
					    'value'    => $telephone,
					    'required' => ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) ? true : false
				    ] );

			    $show_fax = $that->config->get( 'fax_option_show' );
			    if ( $show_fax === '1' ) {
				    if ( isset( $request_data['fax'] ) ) {
					    $fax = $request_data['fax'];
				    } elseif ( isset( $customer_info ) ) {
					    $fax = $customer_info['fax'];
				    } elseif ( $request_data['fax'] == '' ) {
					    $fax = '';
				    }

                    $form['fields']['fax'] = $that->html->buildInput(
					    [
						    'name'        => 'fax',
						    'value'       => $fax,
						    'placeholder' => $that->config->get( 'fax_option_placeholder' ),
						    'required'    => ( $that->config->get( 'fax_option_mandatory_status' ) == '1' ) ? true : false
					    ] );
			    } else {
                    unset( $form['fields']['fax']);
                }
                $that->view->assign('form', $form);
		    }
    }

    public function onControllerPagesAccountAddress_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $this->getList();
        } elseif ($this->baseObject_method === 'insert') {
            if (isset($that->request->get['address_id']) && $that->request->is_GET()) {
                $address_info = $that->model_account_address->getAddress($that->request->get['address_id']);
            }
            if (isset($that->request->post['company'])) {
                $company = $that->request->post['company'];
            } elseif (isset($address_info)) {
                $company = $address_info['company'];
            } else {
                $company = '';
            }
            $that->view->assign('error_company', $that->error['company']);
            $form = $that->view->getData('form');
            $form['fields']['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $company,
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method === 'update') {
            if (isset($that->request->get['address_id']) && $that->request->is_GET()) {
                $address_info = $that->model_account_address->getAddress($that->request->get['address_id']);
            }
            if (isset($that->request->post['company'])) {
                $company = $that->request->post['company'];
            } elseif (isset($address_info)) {
                $company = $address_info['company'];
            } else {
                $company = '';
            }
            $that->view->assign('error_company', $that->error['company']);
            $form = $that->view->getData('form');
            $form['fields']['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $company,
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        }
    }

    public function onControllerResponsesCommonViewPort_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'modal') {
            $page_rt = $that->request->get['viewport_rt'];
            if ($page_rt) {
                $that->session->data['viewport_mode']='modal';
            }
        }
    }

    //Hook Sale Customer Validation
    public function onControllerPagesSaleCustomer_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        $rt   = $that->request->get['rt'];
		    $that->loadLanguage( 'telephone_option/telephone_option' );
		    $telephone = $that->request->post['telephone'];
		    $fax       = $that->request->post['fax'];
		    $company   = $that->request->post['company'];
		    if ( $rt === 'sale/customer/insert_address' || $rt === 'sale/customer/update_address' ) {
			    if ( $that->config->get( 'company_option_mandatory_status' ) == '1' ) {
				    if ( $company == '' ) {
					    $that->error['company'] = $that->language->get( 'company_error' );
				    }
			    }
		    } else {
			    if ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) {
				    if ( empty( $telephone ) || mb_strlen( $telephone ) < 3 || mb_strlen( $telephone ) > 32 ) {
					    $that->error['telephone'] = $that->language->get( 'telephone_error' );
				    }
			    }

			    if ( $that->config->get( 'fax_option_mandatory_status' ) == '1' ) {
				    if ( empty( $fax ) || ( ( mb_strlen( $fax ) < 3 || mb_strlen( $fax ) > 32 ) && strtolower( $fax ) != 'na' && strtolower( $fax ) != 'none' ) ) {
					    $that->error['fax'] = $that->language->get( 'fax_error' );
				    }
			    }
		    }
    }

    public function onControllerPagesSaleCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
        if ($this->baseObject_method === 'insert') {
            $form = $that->view->getData('form');
            $that->view->assign('error', $that->error);
            $form['fields']['details']['telephone'] = $that->html->buildInput(
                [
                    'name' => 'telephone',
                    'value' => $that->request->post['telephone'],
                    'required' => $that->config->get('telephone_option_mandatory_status') === '1' ? true : false
                ]);
            $form['fields']['details']['fax'] = $that->html->buildInput(
                [
                    'name' => 'fax',
                    'value' => $that->request->post['fax'],
                    'required' => $that->config->get('fax_option_mandatory_status') === '1' ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method === 'update') {
            $customer_id = $that->request->get['customer_id'];
            if (has_value($customer_id)) {
                $customer_info = $that->model_sale_customer->getCustomer($customer_id);
            }
            $form = $that->view->getData('form');
            $that->view->assign('error', $that->error);
            $form['fields']['details']['telephone'] = $that->html->buildInput(
                [
                    'name' => 'telephone',
                    'value' => $customer_info['telephone'],
                    'required' => $that->config->get('telephone_option_mandatory_status') === '1' ? true : false
                ]);
            $form['fields']['details']['fax'] = $that->html->buildInput(
                [
                    'name' => 'fax',
                    'value' => $customer_info['fax'],
                    'required' => $that->config->get('fax_option_mandatory_status') === '1' ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method === 'insert_address') {
            $current_address = [];
            $current_address = $that->request->post;
            foreach ($current_address as $name => $value) {
                $this->data['address'][$name] = $value;
            }
            $form = $that->view->getData('form');
            $form['fields']['address']['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $this->data['address']['company'],
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method === 'update_address') {
            $address_id = $that->request->get['address_id'];
            $customer_id = $that->request->get['customer_id'];
            if (has_value($customer_id)) {
                $customer_info = $that->model_sale_customer->getCustomer($customer_id);
                $this->data['addresses'] = $that->model_sale_customer->getAddressesByCustomerId($customer_id);
                $current_address = [];
                if ($this->data['addresses']) {
                    foreach ($this->data['addresses'] as &$a) {
                        $a['href'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id . '&address_id=' . $a['address_id']);
                        $a['title'] = $a['address_1'] . ' ' . $a['address_2'];
                        //mark default address
                        if ($customer_info['address_id'] === $a['address_id']) {
                            $a['default'] = 1;
                        }
                        if ($address_id === $a['address_id']) {
                            $current_address = $a;
                            $this->data['current_address'] = $a['title'];
                        }
                    }
                }
                foreach ($current_address as $name => $value) {
                    $this->data['address'][$name] = $value;
                }
                $form = $that->view->getData('form');
                $form['fields']['address']['company'] = $that->html->buildInput(
                    [
                        'name' => 'company',
                        'value' => $this->data['address']['company'],
                        'placeholder' => $that->config->get('company_option_placeholder'),
                        'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                    ]);
                $that->view->assign('form',$form);

            }
        }
    }

    public function onControllerPagesAccountInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (isset($that->request->get['order_id'])) {
                $order_id = (int)$that->request->get['order_id'];
            } else {
                $order_id = 0;
            }
            $that->loadModel('account/customer');
            $that->load->model('account/order');
            $enc = new AEncryption($that->config->get('encryption_key'));
            $guest = false;

            $ups_plus_status = $this->verifyUpsPlus();
            if ($ups_plus_status === '1') {
                $that->load->model('extension/ups_integration_plus_order');
            }

            if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                //try to decrypt order token
                $order_token = $that->request->get['ot'];
                if ($order_token) {
                    list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $guest = true;
                        if ($ups_plus_status === '1') {
                            $order_info = $that->model_extension_ups_integration_plus_order->getOrder($order_id);
                        } else {
                            $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                        }
                    }
                }
            }

            if ($that->request->is_POST() && $this->_validate()) {
                $guest = true;

                $order_id = $that->request->post['order_id'];
                $email = $that->request->post['email'];
                $order_token = $enc->encrypt($order_id . '::' . $email);
                if ($ups_plus_status === '1') {
                    $order_info = $that->model_extension_ups_integration_plus_order->getOrder($order_id);
                } else {
                    $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                }

                //compare emails
                if ($order_info['email'] != $email) {
                    unset($order_info, $order_id, $email);
                }
            }

            if (!$order_id && $that->customer->isLogged()) {
                redirect($that->html->getSecureURL('account/history'));
            }

            //get info for registered customers
            if (!$order_info) {
                if ($ups_plus_status === '1') {
                    $order_info = $that->model_extension_ups_integration_plus_order->getOrder($order_id);
                } else {
                    $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                }
            }

            if ($order_info) {
                $fax = $order_info['fax'];
                if ($fax!=='' && strtolower($fax)!=='na' && strtolower($fax)!=='none') {
                    $that->view->assign('fax', $fax);
                } else {
                    $that->view->assign('fax', '');
                }

                if ($ups_plus_status === '1') {
                    $shipping_data = [
                        'firstname' => $order_info['shipping_firstname'],
                        'lastname' => $order_info['shipping_lastname'],
                        'company' => $order_info['shipping_company'],
                        'address_1' => $order_info['shipping_address_1'],
                        'address_2' => $order_info['shipping_address_2'],
                        'city' => $order_info['shipping_city'],
                        'postcode' => $order_info['shipping_postcode'],
                        'zone' => $order_info['shipping_zone'],
                        'zone_code' => $order_info['shipping_zone_code'],
                        'country' => $order_info['shipping_country'],
                        'location_phone' => $order_info['location_phone']
                    ];
                } else {
                    $shipping_data = [
                        'firstname' => $order_info['shipping_firstname'],
                        'lastname' => $order_info['shipping_lastname'],
                        'company' => $order_info['shipping_company'],
                        'address_1' => $order_info['shipping_address_1'],
                        'address_2' => $order_info['shipping_address_2'],
                        'city' => $order_info['shipping_city'],
                        'postcode' => $order_info['shipping_postcode'],
                        'zone' => $order_info['shipping_zone'],
                        'zone_code' => $order_info['shipping_zone_code'],
                        'country' => $order_info['shipping_country']
                    ];
                }

                $that->view->assign('shipping_address', $this->getFormattedAddress($shipping_data));

                $payment_data = [
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                ];

                $that->view->assign('payment_address', $this->getFormattedAddress($payment_data));
            }
        }
    }

    public function onControllerPagesCheckoutShipping_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $address_rt = 'checkout/address/shipping';
            $that->loadModel('account/address');
            $shipping_address = $that->model_account_address->getAddress($that->session->data['shipping_address_id']);

            //something wrong with shipping address go to address selection page
            if (!$shipping_address) {
                redirect($that->html->getSecureURL($address_rt));
            }

            $that->view->assign('address', $this->getFormattedAddress($shipping_address));
        }
    }

    public function onControllerPagesCheckoutPayment_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $address_rt = 'checkout/address/payment';
            $that->loadModel('account/address');
            $payment_address = $that->model_account_address->getAddress($that->session->data['payment_address_id']);
            if (!$payment_address) {
                redirect($that->html->getSecureURL($address_rt));
            }
            $that->view->assign('address', $this->getFormattedAddress($payment_address));
        }
    }

    /**
     * Used By Fast Checkout
     */
    public function onControllerPagesAccountOrderDetails_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $fax=$that->data['fax'];
            if (strtolower($fax)==='na' || strtolower($fax)==='none') {
                $that->view->assign('fax','');
            }
            $shipping_address=$that->data['shipping_address'];
            $find_shipping_address=["na<br />","none<br />","NA<br />","None<br />","NONE<br />"];
            $replace_shipping_address=["","","","",""];
            $that->view->assign('shipping_address',str_replace($find_shipping_address,$replace_shipping_address,$shipping_address));

            $payment_address=$that->data['payment_address'];
            $find_shipping_address=["na<br />","none<br />","NA<br />","None<br />","NONE<br />"];
            $replace_payment_address=["","","","",""];
            $that->view->assign('payment_address',str_replace($find_shipping_address,$replace_payment_address,$payment_address));
        }
    }


    public function onControllerResponsesCheckoutPay_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'address') {
            if (!$that->customer->isLogged() && $that->request->is_POST()) {
                $that->session->data['fc']['fax'] = $that->request->post['fax'];
                $that->session->data['fc']['company'] = $that->request->post['company'];
            }
        }
    }

    public function onControllerResponsesCheckoutPay_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $additional = ['fax','company'];
            $that->loadLanguage('account/telephone');
            $that->load->model('account/address');
            $fields = [];

            if (!$that->customer->isLogged()) {
                $that->session->data['guest']['fax'] = $that->session->data['fc']['fax'];
                $that->session->data['guest']['company'] = $that->session->data['fc']['company'];
                $that->session->data['fc']['guest']['fax'] = $that->session->data['fc']['fax'];
                $that->session->data['fc']['guest']['company'] = $that->session->data['fc']['company'];
            }

            foreach ($additional as $v) {
                if ($that->config->get($v.'_option_mandatory_status')
                    || ($that->config->get($v.'_option_show') === '1')) {
                    array_push($fields, $v);
                }
            }

            if ($that->customer->isLogged()) {
                $info['fax'] = $that->customer->getFax();
                $payment_address = $that->model_account_address->getAddress($that->session->data['fc']['payment_address_id']);
                $info['company'] = $payment_address['company'];
            } else {
                $info = $that->session->data['fc'];
            }
            foreach ($fields as $v) {
                $data['additional'][$v] = $v;
                $data[$v.'_data'] = $info[$v];
                $data[$v.'_placeholder'] = $that->language->get('fc_'.$v.'_placeholder').': '.$that->config->get($v.'_option_placeholder');
            }
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('customer_additional_attributes', $view->fetch('pages/account/fc_payment_fields.tpl'));
        } elseif ($this->baseObject_method === '_addressForm') {
            $that->loadLanguage('account/telephone');
            $fields = [];
            $additional = ['fax','company'];
            foreach ($additional as $v) {
                if ($that->config->get($v.'_option_mandatory_status')
                    || ($that->config->get($v.'_option_show') === '1')) {
                    array_push($fields, $v);
                }
            }
            foreach ($fields as $v) {
                $data['additional'][$v] = $v;
                $data[$v.'_data'] = $that->session->data['fc'][$v];
                $data[$v.'_placeholder'] = $that->language->get('fc_'.$v.'_placeholder').': '.$that->config->get($v.'_option_placeholder');
            }
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('address_attributes', $view->fetch('pages/account/fc_guest_fields.tpl'));
        }
    }

    public function onModelCheckoutOrder_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='sf_order_confirm_mail') {
            $ups_plus_status = $this->verifyUpsPlus();
            $order_id=$that->data['mail_template_data']['order_id'];
            if ( $ups_plus_status === true ) {
                $order_query = $that->db->query( "SELECT o.*,
												l.filename AS filename,
												l.directory AS directory,
												ap.location_phone
										 FROM `" . $that->db->table( "orders" ) . "` o
										 LEFT JOIN " . $that->db->table( "languages" ) . " l ON (o.language_id = l.language_id)
										 LEFT JOIN " . $that->db->table( "ap_address_phone" ) . " ap ON ap.order_id=o.order_id
										 WHERE o.order_id = " . (int)$order_id);
            } else {
                $order_query = $that->db->query( "SELECT *,
												l.filename AS filename,
												l.directory AS directory
										 FROM `" . $that->db->table( "orders" ) . "` o
										 LEFT JOIN " . $that->db->table( "languages" ) . " l ON (o.language_id = l.language_id)
										 WHERE o.order_id = " . (int)$order_id);
            }

            if ( ! $order_query->num_rows ) {
                return false;
            }
            $order_row = $that->dcrypt->decrypt_data( $order_query->row, 'orders' );
            $that->load->model('localisation/zone');
            $shipping_zone_row = $that->model_localisation_zone->getZone($order_row['shipping_zone_id']);
            if ($shipping_zone_row) {
                $shipping_zone_code = $shipping_zone_row['code'];
            } else {
                $shipping_zone_code = '';
            }
            $shipping_data = [
                'firstname' => $order_row['shipping_firstname'],
                'lastname'  => $order_row['shipping_lastname'],
                'company'   => strtolower($order_row['shipping_company'])==='na' || strtolower($order_row['shipping_company'])==='none' ? "" : $order_row['shipping_company'],
                'address_1' => $order_row['shipping_address_1'],
                'address_2' => $order_row['shipping_address_2'],
                'city'      => $order_row['shipping_city'],
                'postcode'  => $order_row['shipping_postcode'],
                'zone'      => $order_row['shipping_zone'],
                'zone_code' => $shipping_zone_code,
                'country'   => $order_row['shipping_country'],
            ];

            $that->data['mail_template_data']['shipping_data'] = $shipping_data;
            $that->data['mail_template_data']['shipping_address'] = $this->getFormattedAddress( $shipping_data );

            $payment_zone_row = $that->model_localisation_zone->getZone($order_row['payment_zone_id']);
            if ($payment_zone_row) {
                $payment_zone_code = $payment_zone_row['code'];
            } else {
                $payment_zone_code = '';
            }

            $payment_data = [
                'firstname' => $order_row['payment_firstname'],
                'lastname' => $order_row['payment_lastname'],
                'company' => strtolower($order_row['payment_company']) === 'na' || strtolower($order_row['payment_company']) === 'none' ? "" : $order_row['payment_company'],
                'address_1' => $order_row['payment_address_1'],
                'address_2' => $order_row['payment_address_2'],
                'city' => $order_row['payment_city'],
                'postcode' => $order_row['payment_postcode'],
                'zone' => $order_row['payment_zone'],
                'zone_code' => $payment_zone_code,
                'country' => $order_row['payment_country'],
            ];

            if ( $that->config->get( 'taxid_show_seller_info' ) === '1' ) {
                $that->data['mail_template_data']['seller_info']  = html_entity_decode( nl2br( $that->config->get( 'taxid_seller_info' ) ) );
            } else {
                $that->data['mail_template_data']['seller_info']  = "";
            }
            $that->data['mail_template_data']['customer_fax'] = strtolower($order_row['fax'])==='na' || strtolower($order_row['fax'])==='none' ? '' : $order_row['fax'];
            $that->data['mail_template_data']['payment_data'] = $payment_data;
            $that->data['mail_template_data']['payment_address'] = $this->getFormattedAddress( $payment_data );
        }
    }

    /**
     * @param $data_array
     * @param string $type
     * @param array $locate
     * @return mixed
     */
    private function getFormattedAddress($data_array) {
        $that =& $this->baseObject;
        $format = '';
        $data_array = (array)$data_array;
        $ups_plus_status=$this->verifyUpsPlus();
        if ($ups_plus_status==='1') {
            $that->load->language('ups_integration_plus/ups_integration_plus');
        }
        $company = '';
        if (strtolower($data_array['company']) !== 'none' && strtolower($data_array['company']) !== 'na' && $data_array['company'] !== '') {
            $company = ' {company} '. "\n";
        }
        // Set default format
        if ($data_array['location_phone'] !== '' && !empty($data_array['location_phone'])) {
            $format = '{firstname} {lastname}' . "\n" . $company . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}' . "\n" .$that->language->get('text_ups_plus_telephone') . ' {location_phone}';
        } else {
            $format = '{firstname} {lastname}' . "\n" . $company . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
        }
        //Set default variable to be set for address based on the data
        $locate = [];
        foreach ($data_array as $key => $value) {
            $locate[] = "{" . $key . "}";
        }

        return str_replace(["\r\n", "\r", "\n"], '<br />',preg_replace(["/\s\s+/", "/\r\r+/", "/\n\n+/"],  '<br />', trim(str_replace($locate, $data_array, $format))));
    }

    private function _validate(){
        $that =& $this->baseObject;
        if (!(int)$that->request->post['order_id']){
            $this->error['order_id'] = $that->language->get('error_order_id');
        }

        if (mb_strlen($that->request->post['email']) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $that->request->post['email'])){
            $this->error['email'] = $that->language->get('error_email');
        }

        $that->extensions->hk_ValidateData($this);

        return !$this->error ? true : false;

    }

    private function getList() {
        $that =& $this->baseObject;
        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('index/home'),
            'text' => $that->language->get('text_home'),
            'separator' => FALSE
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/account'),
            'text' => $that->language->get('text_account'),
            'separator' => $that->language->get('text_separator')
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/address'),
            'text' => $that->language->get('heading_title'),
            'separator' => $that->language->get('text_separator')
        ]);

        $that->view->assign('error_warning', $this->error['warning']);
        $that->view->assign('success', $that->session->data['success']);

        $addresses = [];

        $results = $that->model_account_address->getAddresses();

        foreach ($results as $result) {
            $formated_address = $this->getFormattedAddress($result);

            $edit = HtmlElementFactory::create([
                'type' => 'button',
                'text' => $that->language->get('button_edit'),
                'style' => 'button btn-primary',
                'icon' => 'fa-edit fa',
                'attr' => 'onclick="location = \'' . $that->html->getSecureURL('account/address/update', '&address_id=' . $result['address_id']) . '\'" ']);
            $delete = HtmlElementFactory::create([
                'type' => 'button',
                'text' => $that->language->get('button_delete'),
                'style' => '',
                'icon' => 'fa fa-remove',
                'attr' => 'onclick="location = \'' . $that->html->getSecureURL('account/address/delete', '&address_id=' . $result['address_id']) . '\'" ']);

            $addresses[] = [
                'address_id' => $result['address_id'],
                'address' => $formated_address,
                'button_edit' => $edit,
                'button_delete' => $delete,
                'default' => $that->customer->getAddressId() == $result['address_id'] ? true : false,
            ];
        }

        $that->view->assign('addresses', $addresses);

        $that->view->assign('insert', $that->html->getSecureURL('account/address/insert'));

        $insert = HtmlElementFactory::create([
            'type' => 'button',
            'name' => 'insert',
            'text' => $that->language->get('button_new_address'),
            'icon' => 'fa fa-plus',
            'style' => 'button']);
        $that->view->assign('button_insert', $insert);

        $back = HtmlElementFactory::create([
            'type' => 'button',
            'name' => 'back',
            'text' => $that->language->get('button_back'),
            'icon' => 'fa fa-arrow-left',
            'style' => 'button']);
        $that->view->assign('button_back', $back);
        $that->view->assign('back', $that->html->getSecureURL('account/account'));

        $that->processTemplate('pages/account/addresses.tpl');
    }
    
    public function onControllerCommonHead_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('telephone_option/telephone_option');
                    $that->load->model('extension/telephone_option_updater');
                    $total = $that->model_extension_telephone_option_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_telephone_option_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_telephone_option_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_telephone_option_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_telephone_option_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_telephone_option_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('telephone_option_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('telephone_option_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/telephone_option_license_info');
                $store_id = $that->model_extension_telephone_option_license_info->getStoreId();

                $license_key = $that->model_extension_telephone_option_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_telephone_option_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 604800;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('telephone_option/telephone_option');
                $getVersions = telephoneUpdaterGetAllVersions();
                $that->load->model('extension/telephone_option_updater');
                $current_version = $that->model_extension_telephone_option_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_telephone_option_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_telephone_option_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }
}