<?php
/**
 * License Manager Integration Library
 *
 * Application integration code, used for validating license data supplied by
 * the Blesta License Manager Plugin.
 *
 * Requires PHP 5.1.2 or greater.
 *
 * @license http://opensource.org/licenses/mit-license.php MIT License
 * @copyright Copyright (c) 2014, Phillips Data Inc.
 */
class License {

	/**
	 * @param LicenseManager The license manager
	 */
	private $LicenseManager;

	/**
	 * Initializes the LicenseManager only after verifying its trustworhiness
	 *
	 * @param string $path_to_phpseclib The full path to the phpseblib library
	 * @param string $install_path The full server path to the root directory of the client software. Defaults to current directory.
	 * @see License::getManager()
	 */
	public function __construct($path_to_phpseclib, $install_path = null) {
		$signature_mode = "sha256";
		$signatures = array(
			$path_to_phpseclib . "Crypt" . DIRECTORY_SEPARATOR . "AES.php" => array(
				"bfb6dee5ed24b7261e796b071dfdab8182a2f46e446814c041caf81f84497bd1", // with \n EOL
				"d55f4cf8660dd1aa2a70f931cac6db09117b77f8105227efb7390ad67238d38a" // with \r\n EOL
			),
			$path_to_phpseclib . "Crypt" . DIRECTORY_SEPARATOR . "Rijndael.php" => array(
				"6dc30bf43b1dd34b85ef1795285566250b728b37dc9bd377d4d0f239e1c6427d", // with \n EOL
				"3dd8860e58b30b295066305516de2a52b08006fcfe0cb9485ed3c3f9a5e560a2" // with \r\n EOL
			),
			$path_to_phpseclib . "Crypt" . DIRECTORY_SEPARATOR . "RSA.php" => array(
				"b4cfcabfdeed662ec605c60c21578cd2311299544e9dfddc9b0046e3f66efe37", // with \n EOL
				"7ce08d23725eafe3e93d8622f5d113bab58b16d4be83fd4c0c53b8d7ce37c042" // with \r\n EOL
			),
			$path_to_phpseclib . "Crypt" . DIRECTORY_SEPARATOR . "Hash.php" => array(
				"3366d7e5947a765defb4cbf671d8ea385e7abfac205bd7b0b3fd5ac0333afc55", // with \n EOL
				"4cb71e8b41dae96fc6739b37a35a0edb5c7191d7a6bf07883981c3f5c0ec0d2f" // with \r\n EOL
			),
			$path_to_phpseclib . "Math" . DIRECTORY_SEPARATOR . "BigInteger.php" => array(
				"dc1b6f8df79056661612ff16294a8e5212a53af6a820359f1ffc140ee8aa0b1c", // with \n EOL
				"f028fd62096014bad9a8412709e3f96b8b403eeb374f80fbd09aef7c6b8220c9" // with \r\n EOL
			)
		);

		// Initialize LicenseManager if possible
		if ($this->verify()) {
			require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . "license_manager.php";
			$this->LicenseManager = new LicenseManager($path_to_phpseclib, $signature_mode, $signatures, $install_path);
		}
	}

	/**
	 * Returns the LicenseManager
	 *
	 * @return LicenseManager The initialized LicenseManager object
	 */
	public function getManager() {
		return $this->LicenseManager;
	}

	/**
	 * Verify that the license manager can be initialized
	 *
	 * @return boolean True if the license manager is valid
	 * @throws Exception If the license manager is invalid and therefore cannot be initialized
	 */
	private function verify() {
		$hash = array(
			"d561abc38955a120f53ad58939632f1225fb95f038d1f317d8a4f3f31c00301d", // with \n EOL
			"4451bb070fe287aca4f6b2bf5ed0e5fd7b66734224da7c1e4116ba0d12a57cc0", // with \r\n EOL
		);

		if (!in_array(hash_file("sha256", dirname(__FILE__) . DIRECTORY_SEPARATOR . "license_manager.php"), $hash))
			throw new Exception("LicenseManager invalid, LicenseManager can not be initialized.");
		return true;
	}
}
?>