<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

class ModelOptionPriceProProductOptions extends Model {

	public function verifyAdvancedReportsStatus() {
		if ( $this->config->get( 'advanced_reports_status' ) === '1' ) {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'advanced_reports_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = advancedReportsVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

    /**
     * @param int $product_id
     * @param int $option_value_id
     * @return array
     */
    public function getProductOptionValue($product_id, $option_value_id) {

        $product_option_value = $this->db->query(
            "SELECT *
            FROM " . $this->db->table("product_option_values") . "
            WHERE product_id = '" . (int)$product_id . "'
                AND product_option_value_id = '" . (int)$option_value_id . "'
                AND group_id = 0
            ORDER BY sort_order");

        $option_value = $product_option_value->row;
        $value_description_data = array();
        $value_description = $this->db->query(
            "SELECT *
		    FROM " . $this->db->table("product_option_value_descriptions") . "
		    WHERE product_option_value_id = '" . (int)$option_value['product_option_value_id'] . "'");

        foreach ($value_description->rows as $description) {
            //regular option value name
            $value_description_data[$description['language_id']]['name'] = $description['name'];
            //get children (grouped options) individual names array
            if ($description['grouped_attribute_names']) {
                $value_description_data[$description['language_id']]['children_options_names'] = unserialize($description['grouped_attribute_names']);
            }
        }

        if($this->verifyAdvancedReportsStatus()===true) {
            $result = array(
                'product_option_value_id' => $option_value['product_option_value_id'],
                'language' => $value_description_data,
                'sku' => $option_value['sku'],
                'quantity' => $option_value['quantity'],
                'subtract' => $option_value['subtract'],
                'price' => $option_value['price'],
                'cost'  => $option_value['cost'],
                'prefix' => $option_value['prefix'],
                'link' => $option_value['link'],
                'weight' => $option_value['weight'],
                'weight_type' => $option_value['weight_type'],
                'attribute_value_id' => $option_value['attribute_value_id'],
                'grouped_attribute_data' => $option_value['grouped_attribute_data'],
                'sort_order' => $option_value['sort_order'],
                'default' => $option_value['default']
            );
        } else {
            $result = array(
                'product_option_value_id' => $option_value['product_option_value_id'],
                'language' => $value_description_data,
                'sku' => $option_value['sku'],
                'quantity' => $option_value['quantity'],
                'subtract' => $option_value['subtract'],
                'price' => $option_value['price'],
                'prefix' => $option_value['prefix'],
                'link' => $option_value['link'],
                'weight' => $option_value['weight'],
                'weight_type' => $option_value['weight_type'],
                'attribute_value_id' => $option_value['attribute_value_id'],
                'grouped_attribute_data' => $option_value['grouped_attribute_data'],
                'sort_order' => $option_value['sort_order'],
                'default' => $option_value['default']
            );
        }

        //get children (grouped options) data
        $child_option_values = unserialize($result['grouped_attribute_data']);
        if (is_array($child_option_values) && sizeof($child_option_values)) {
            $result['children_options'] = array();
            foreach ($child_option_values as $child_value) {
                $result['children_options'][$child_value['attr_id']] = (int)$child_value['attr_v_id'];
            }
        }

        return $result;
    }
}