<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionEnhancedFlatRateShippingLicenseInfo extends Model {

    /**
     * @return mixed
     */
    public function getCurrentVersion() {
        $query = $this->db->query("SELECT version FROM ".$this->db->table("extensions")." WHERE `key`='enhanced_flat_rate_shipping'");
        return $query->row['version'];
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getLicenseData($store_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table("enhanced_flat_rate_shipping_license_info")." WHERE `store_id`='".$store_id."'");
        return $query->row;
    }

    /**
     * @param $store_id
     * @return mixed
     * @throws AException
     */
    public function getLicenseCode($store_id) {
        $sql = "SELECT `value` FROM ".$this->db->table("settings")." 
                    WHERE `key` = 'enhanced_flat_rate_shipping_license_code'
                            AND `store_id` = '".$this->db->escape($store_id)."'";
        $query = $this->db->query($sql);
        return trim($query->row['value']);
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getStoreId() {
        if (HTTPS) {
            $url = str_replace(['www.','https://'], '', HTTPS_SERVER);
            $query = $this->db->query("SELECT `store_id` FROM ".$this->db->table("settings")." WHERE `key`='config_ssl_url' AND `value` LIKE '%".$url."%'");
        } else {
            $url = str_replace(['www.','http://'], '', HTTP_SERVER);
            $query = $this->db->query("SELECT `store_id` FROM ".$this->db->table("settings")." WHERE `key`='config_url' AND `value` LIKE '%".$url."%'");
        }

        $store_id = $query->row['store_id'];
        return $store_id;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getLicensedStoreStatus() {
        $store_id = $this->getStoreId();
        $query = $this->db->query("SELECT `value` FROM ".$this->db->table("settings")." WHERE `key`='enhanced_flat_rate_shipping_licensed_store_id_".$store_id."'");
        return $query->row['value'];
    }
}