<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesExtensionTracking
 * @property ModelExtensionTracking $model_extension_tracking
 * @property ModelExtensionEmailOrder $model_extension_email_order
 */


class ControllerResponsesExtensionTracking extends AController {
    public $data = [];

	/**
	 * @throws AException
	 */
    public function addTracking() {
        $json = [];

        if (has_value($this->request->get['order_id'])) {
            $order = $this->request->get['order_id'];
			$trshipperid = $this->request->post['shipperId'];
            $trcode = $this->request->post['trackcode'] ? $this->request->post['trackcode'] : '';
            $trurl = $this->request->post['url'] ? $this->request->post['url']: '';
            $trdeliveryDate = $this->request->post['deliveryDate'] ? $this->request->post['deliveryDate'] : '';
            $additional = $this->request->post['additional'] ? $this->request->post['additional'] : '';
            $orderStatus = $this->request->post['orderStatus'] ? $this->request->post['orderStatus'] : '';
            $orderdata = $trshipperid.'|'.$trcode.'|'.$trurl.'|'.$trdeliveryDate.'|'.$additional."|".$orderStatus;

            if ($order > 0) {
                $this->loadModel('sale/order');
                $order_info = $this->model_sale_order->getOrder($order);

                $this->loadModel('extension/tracking');
	            $this->loadModel('extension/email_order');
                $this->loadLanguage('email_editor/email_editor');
                $this->model_extension_tracking->processUpdateOrderData($order, $orderdata);
	            $trcname = $this->model_extension_tracking->getShipperNameById($trshipperid);
				if ($trshipperid!=='9' && $trshipperid!=='10') {
					$comment = $this->model_extension_tracking->getCommentTemplate();
					$search  = [ '{shipper_name}', '{tracking_number}', '{tracking_url}' ];
					$replace = [
						$trcname,
						$trcode,
						"<a href='" . $trurl . "' target='_BLANK'>" . $trurl . "</a>"
					];
					$comment = str_replace( $search, $replace, $comment );
				} else {
					if ($trshipperid==='9') {
						$searchLocalComment  = [ '{shipper_name}', '{available_date}'];
						$localComment = $this->model_extension_tracking->getStorePickupTemplate();
					} else {
						$searchLocalComment  = [ '{shipper_name}', '{delivery_date}'];
						$localComment = $this->model_extension_tracking->getLocalCommentTemplate();
					}

					$replaceLocalComment = [
						$trcname,
						$trdeliveryDate.'.'.$additional,
					];
					$comment = str_replace( $searchLocalComment, $replaceLocalComment, $localComment );
				}
                $notifydata = [];
                $notifydata['comment'] = $comment;
                if ($this->config->get('email_editor_notify_customer')) {
                    $notifydata['notify'] = '1';
                } else {
                    $notifydata['notify'] = '0';
                }
                if ($this->config->get('email_editor_append_comments')) {
                    $notifydata['append'] = '1';
                }

                if ($trshipperid==='9' || $trshipperid==='10') {
	                $status['order_status_id'] = $orderStatus;
	                $notifydata['order_status_id'] = $orderStatus;
                } else {
	                $status['order_status_id'] = '3';
	                $notifydata['order_status_id'] = '3';
                }
				$this->model_sale_order->editOrder($order,$status);
                $this->model_extension_email_order->addOrderHistory($order, $notifydata);
            } else {
                // no data
                $this->session->data['error'] = $this->language->get('error_empty_data');
            }
        } else {
            // no order_id
            $this->session->data['error'] = $this->language->get('error_no_order_id');
        }

        $json['href'] = $this->html->getSecureURL('sale/order/details', '&order_id=' . (int) $this->request->get['order_id']);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }

    public function getTrackingUrl() {
        $json = [];
        $this->load->model('extension/tracking');
        $code = $this->request->post['code'];
        $shipperId = $this->request->post['id'];
        $url = $this->model_extension_tracking->getTrackingUrlById($shipperId);
        $json['url'] = str_replace('{tracking_number}',$code,$url);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }
}
