<?php if ($license_status===true) { ?>
<?php if ($export==='pdf') { ?>
<html>
<head>
	<style>
		table, th, td {
			border: 1px solid black;
		}
		table {
			margin-left:auto;margin-right:auto;
		}
	</style>
</head>
<body>
<div id="header" style="text-align: center;">
	<?php echo $title; ?>
</div>
<br>
<div style="text-align:center">
   <img src="<?php echo $img;?>" width="90%"/>
</div>
<br>
<div>
	<table>
		<thead>
		<tr>
			<td style="text-align: center; width:300px" ><?php echo $column_banner_name; ?></td>
			<td style="text-align: center; width:300px" ><?php echo $column_banner_time; ?></td>
			<td style="text-align: center; width:100px" ><?php echo $column_banner_viewed; ?></td>
			<td style="text-align: center; width:100px" ><?php echo $column_banner_clicked; ?></td>
		</tr>
		</thead>
		<tbody>
		<?php if($results) { ?>
		<?php foreach ($results as $key => $result) { ?>
		<?php if($result) { ?>
		<tr>
			<td><?php echo $result['name'];?></td>
			<td><?php echo $result['time'];?></td>
			<td><?php echo $result['viewed'];?></td>
			<td><?php echo $result['clicked'];?></td>
		</tr>
		<?php } ?>
		<?php } ?>
		<?php } ?>
		</tbody>
	</table>
</div>
</body>
</html>
<?php } else { ?>
<?php include($tpl_common_dir . 'action_confirm.tpl'); ?>
<div id="content" class="panel panel-default">
	<div class="panel-heading col-xs-12">
		<div class="primary_content_actions pull-left">
			<?php
			if (!empty($search_form)) {
				?>
			<form id="<?php echo $search_form['form_open']->name; ?>"
				  method="<?php echo $search_form['form_open']->method; ?>"
				  name="<?php echo $search_form['form_open']->name; ?>" class="form-inline" role="form">

				<?php
					foreach ($search_form['fields'] as $name=> $f) {
				?>
				<label class="control-label" style="padding-top: 5px"><?php echo $this->language->get('entry_'.$name); ?> </label>
				<div class="form-group">
					<div class="input-group input-group-sm">
						<?php echo $f; ?>
					</div>
				</div>
				<?php } ?>
				<div class="form-group">
					<button id="process" type="submit" class="btn btn-xs btn-primary tooltips" title="<?php echo $button_filter; ?>">
						<?php echo $search_form['submit']->text ?>
					</button>
					<button type="reset" class="btn btn-xs btn-default tooltips" title="<?php echo $button_reset; ?>">
						<i class="fa fa-refresh"></i>
					</button>
				</div>
				<div class="clearfix"></div>
				<div class="form-group">
					<label class="control-label" style="padding-top: 5px"><?php echo $entry_export_to;?> </label>
					<div class="input-group input-group-sm">
						<select class="form-control aselect " data-placeholder="" name="export_type" id="banner_stat_grid_search_export_type" data-orgvalue="">
							<option value="xlsx" data-orgvalue="false"><?php echo $text_xlsx;?></option>
							<option value="xls" data-orgvalue="false"><?php echo $text_xls;?></option>
							<option value="csv" data-orgvalue="false"><?php echo $text_csv;?></option>
							<option value="pdf" data-orgvalue="false"><?php echo $text_pdf;?></option>
						</select>
					</div>
				</div>
				<div class="form-group">
					<button id="export" class="btn btn-xs btn-primary tooltips" title="" data-original-title="Export"><?php echo $text_export;?></button>
				</div>
			</form>
			<div class="form-group">
				<button id="filter" style="display: none"></button>
			</div>
			<?php
			}
			?>
		</div>
		<?php include($tpl_common_dir . 'content_buttons.tpl'); ?>
	</div>
	<div class="panel-body panel-body-nopadding tab-content col-xs-12">
		<div id="report" style="width: 100%; height: 480px; margin: auto;"></div>
		<br><br>
		<?php echo $listing_grid; ?>
	</div>
</div>
<script type="text/javascript">
	google.charts.load('current', {'packages':['corechart']});
	google.charts.setOnLoadCallback(drawChart);
	function drawChart() {
		var period = $('#banner_stat_grid_search_period :selected').val();
		var banner_id = $('#banner_stat_grid_search_banner_id :selected').val();
		var start = $('#banner_stat_grid_search_filter_date_start').val();
		var end = $('#banner_stat_grid_search_filter_date_end').val();

		var data = new google.visualization.DataTable();
		data.addColumn('string', '<?php echo $text_date;?>');
		data.addColumn('number', '<?php echo $text_viewed;?>');
		data.addColumn('number', '<?php echo $text_clicked;?>');
		$.ajax({
			type: 'GET',
			url: '<?php echo $chart_url; ?>&period='+period+'&banner_id='+banner_id+'&from='+start+'&to='+end,
			dataType: 'json',
			async: false,
			success: function(json) {
				data.addRows(json);
			}
		});

		var options = {
			series: {
				0: {
					lineWidth:4,
				    pointShape: 'circle'},
				1: {
					lineWidth:4,
					color: 'green',
				    pointShape: 'triangle'},
			},
			title:'Banner Statistic',
			legend:{position:'bottom'},
			explorer: {
				axis: 'vertical',
				keepInBounds: true,
				maxZoomIn: 4.0
			}
		};
		var chart = new google.visualization.ColumnChart(document.getElementById('report'));
		google.visualization.events.addListener(chart, 'ready', function (){
			var data = { banner_id: banner_id, chart: chart.getImageURI() };
			$.ajax({
			  url: '<?php echo $save_chart;?>',
			  type: 'post',
			  data: data,
			  dataType: 'json',
			  cache: false,
			  success: function(json) {
			  // No action needed
			  }
			});
		});
		chart.draw(data, options);
	}
</script>

<script type="text/javascript">
	$(document).ready(function () {

		$('#banner_stat_grid_search_filter_date_start').datepicker({
			onSelect: function (date) {
				if ($('#banner_stat_grid_search_filter_date_end').val()!=='') {
					$('#filter').trigger('click');
				}
			},
			dateFormat: 'yy-mm-dd'
		});

		$('#banner_stat_grid_search_filter_date_end').datepicker({
			onSelect: function (date) {
				if ($('#banner_stat_grid_search_filter_date_start').val()!=='') {
					$('#filter').trigger('click');
				}
			},
			dateFormat: 'yy-mm-dd'
		});

	<?php if ($export!=='pdf') { ?>
			$('#export').click(function (e) {
				e.preventDefault();
				var export_type = $('#banner_stat_grid_search_export_type :selected').val();
				var period = $('#banner_stat_grid_search_period :selected').val();
				var banner_id = $('#banner_stat_grid_search_banner_id :selected').val();
				var start = $('#banner_stat_grid_search_filter_date_start').val();
				var end = $('#banner_stat_grid_search_filter_date_end').val();
				var banner_name = $('#banner_stat_grid_search_banner_id :selected').text();
					var url = '<?php echo $export_url;?>';
					url += '&banner_id=' + banner_id;
					url += '&banner_name=' + banner_name;
					url += '&period=' + period;
					url += '&from=' + start;
					url += '&to=' + end;
					url += '&export_type=' + export_type;
					location = url;
			});
			$(window).resize(function(){
				drawChart();
			});
		});

	$('#banner_stat_grid_search_period').change(function() {
		//if ($('#banner_stat_grid_search_filter_date_start').val()!=='' && $('#banner_stat_grid_search_filter_date_end').val()!=='') {
			$('#process').trigger('submit');
			//drawChart();
		//}
	});

	$('#banner_stat_grid_search_banner_id').change(function() {
		$('#process').trigger('submit');
		//drawChart();
	});

	$('#filter').click(function (e) {
		$('#process').trigger('submit');
		//drawChart();
	});

	$('#banner_stat_grid').on('reloadGrid',function (e) {
		drawChart();
	});

	<?php } ?>
</script>
<?php } ?>
<?php } else { ?>
<div id="content">
	<div class="box">
		<div class="content center">
			<?php echo $text_unauthorized; ?>
		</div>
	</div>
</div>
<?php } ?>