<?php
/**
 * ServiceSummaryEstimatedArrival
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Rating
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Rate
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Rating\Rating;

use \ArrayAccess;
use \UPS\Rating\ObjectSerializer;

/**
 * ServiceSummaryEstimatedArrival Class Doc Comment
 *
 * @category Class
 * @description Container for the Time-In-Transit arrival information by service
 * @package  UPS\Rating
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ServiceSummaryEstimatedArrival implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ServiceSummary_EstimatedArrival';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'arrival' => '\UPS\Rating\Rating\EstimatedArrivalArrival',
        'business_days_in_transit' => 'string',
        'pickup' => '\UPS\Rating\Rating\EstimatedArrivalPickup',
        'day_of_week' => 'string',
        'customer_center_cutoff' => 'string',
        'delay_count' => 'string',
        'holiday_count' => 'string',
        'rest_days' => 'string',
        'total_transit_days' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'arrival' => null,
        'business_days_in_transit' => null,
        'pickup' => null,
        'day_of_week' => null,
        'customer_center_cutoff' => null,
        'delay_count' => null,
        'holiday_count' => null,
        'rest_days' => null,
        'total_transit_days' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'arrival' => 'Arrival',
        'business_days_in_transit' => 'BusinessDaysInTransit',
        'pickup' => 'Pickup',
        'day_of_week' => 'DayOfWeek',
        'customer_center_cutoff' => 'CustomerCenterCutoff',
        'delay_count' => 'DelayCount',
        'holiday_count' => 'HolidayCount',
        'rest_days' => 'RestDays',
        'total_transit_days' => 'TotalTransitDays'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'arrival' => 'setArrival',
        'business_days_in_transit' => 'setBusinessDaysInTransit',
        'pickup' => 'setPickup',
        'day_of_week' => 'setDayOfWeek',
        'customer_center_cutoff' => 'setCustomerCenterCutoff',
        'delay_count' => 'setDelayCount',
        'holiday_count' => 'setHolidayCount',
        'rest_days' => 'setRestDays',
        'total_transit_days' => 'setTotalTransitDays'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'arrival' => 'getArrival',
        'business_days_in_transit' => 'getBusinessDaysInTransit',
        'pickup' => 'getPickup',
        'day_of_week' => 'getDayOfWeek',
        'customer_center_cutoff' => 'getCustomerCenterCutoff',
        'delay_count' => 'getDelayCount',
        'holiday_count' => 'getHolidayCount',
        'rest_days' => 'getRestDays',
        'total_transit_days' => 'getTotalTransitDays'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['arrival'] = isset($data['arrival']) ? $data['arrival'] : null;
        $this->container['business_days_in_transit'] = isset($data['business_days_in_transit']) ? $data['business_days_in_transit'] : null;
        $this->container['pickup'] = isset($data['pickup']) ? $data['pickup'] : null;
        $this->container['day_of_week'] = isset($data['day_of_week']) ? $data['day_of_week'] : null;
        $this->container['customer_center_cutoff'] = isset($data['customer_center_cutoff']) ? $data['customer_center_cutoff'] : null;
        $this->container['delay_count'] = isset($data['delay_count']) ? $data['delay_count'] : null;
        $this->container['holiday_count'] = isset($data['holiday_count']) ? $data['holiday_count'] : null;
        $this->container['rest_days'] = isset($data['rest_days']) ? $data['rest_days'] : null;
        $this->container['total_transit_days'] = isset($data['total_transit_days']) ? $data['total_transit_days'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['arrival'] === null) {
            $invalidProperties[] = "'arrival' can't be null";
        }
        if ($this->container['business_days_in_transit'] === null) {
            $invalidProperties[] = "'business_days_in_transit' can't be null";
        }
        if ($this->container['pickup'] === null) {
            $invalidProperties[] = "'pickup' can't be null";
        }
        if ($this->container['day_of_week'] === null) {
            $invalidProperties[] = "'day_of_week' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets arrival
     *
     * @return \UPS\Rating\Rating\EstimatedArrivalArrival
     */
    public function getArrival()
    {
        return $this->container['arrival'];
    }

    /**
     * Sets arrival
     *
     * @param \UPS\Rating\Rating\EstimatedArrivalArrival $arrival arrival
     *
     * @return $this
     */
    public function setArrival($arrival)
    {
        $this->container['arrival'] = $arrival;

        return $this;
    }

    /**
     * Gets business_days_in_transit
     *
     * @return string
     */
    public function getBusinessDaysInTransit()
    {
        return $this->container['business_days_in_transit'];
    }

    /**
     * Sets business_days_in_transit
     *
     * @param string $business_days_in_transit Number of business days from Origin to Destination Locations.
     *
     * @return $this
     */
    public function setBusinessDaysInTransit($business_days_in_transit)
    {
        $this->container['business_days_in_transit'] = $business_days_in_transit;

        return $this;
    }

    /**
     * Gets pickup
     *
     * @return \UPS\Rating\Rating\EstimatedArrivalPickup
     */
    public function getPickup()
    {
        return $this->container['pickup'];
    }

    /**
     * Sets pickup
     *
     * @param \UPS\Rating\Rating\EstimatedArrivalPickup $pickup pickup
     *
     * @return $this
     */
    public function setPickup($pickup)
    {
        $this->container['pickup'] = $pickup;

        return $this;
    }

    /**
     * Gets day_of_week
     *
     * @return string
     */
    public function getDayOfWeek()
    {
        return $this->container['day_of_week'];
    }

    /**
     * Sets day_of_week
     *
     * @param string $day_of_week Day of week for arrival. Valid values are: MONTUEWEDTHUFRISAT
     *
     * @return $this
     */
    public function setDayOfWeek($day_of_week)
    {
        $this->container['day_of_week'] = $day_of_week;

        return $this;
    }

    /**
     * Gets customer_center_cutoff
     *
     * @return string
     */
    public function getCustomerCenterCutoff()
    {
        return $this->container['customer_center_cutoff'];
    }

    /**
     * Sets customer_center_cutoff
     *
     * @param string $customer_center_cutoff Customer Service call time. Returned for domestic as well as international requests.
     *
     * @return $this
     */
    public function setCustomerCenterCutoff($customer_center_cutoff)
    {
        $this->container['customer_center_cutoff'] = $customer_center_cutoff;

        return $this;
    }

    /**
     * Gets delay_count
     *
     * @return string
     */
    public function getDelayCount()
    {
        return $this->container['delay_count'];
    }

    /**
     * Sets delay_count
     *
     * @param string $delay_count Number of days delayed at customs. Returned for International requests.
     *
     * @return $this
     */
    public function setDelayCount($delay_count)
    {
        $this->container['delay_count'] = $delay_count;

        return $this;
    }

    /**
     * Gets holiday_count
     *
     * @return string
     */
    public function getHolidayCount()
    {
        return $this->container['holiday_count'];
    }

    /**
     * Sets holiday_count
     *
     * @param string $holiday_count Number of National holidays during transit. Returned for International requests.
     *
     * @return $this
     */
    public function setHolidayCount($holiday_count)
    {
        $this->container['holiday_count'] = $holiday_count;

        return $this;
    }

    /**
     * Gets rest_days
     *
     * @return string
     */
    public function getRestDays()
    {
        return $this->container['rest_days'];
    }

    /**
     * Sets rest_days
     *
     * @param string $rest_days Number of rest days, i.e. non movement. Returned for International requests.
     *
     * @return $this
     */
    public function setRestDays($rest_days)
    {
        $this->container['rest_days'] = $rest_days;

        return $this;
    }

    /**
     * Gets total_transit_days
     *
     * @return string
     */
    public function getTotalTransitDays()
    {
        return $this->container['total_transit_days'];
    }

    /**
     * Sets total_transit_days
     *
     * @param string $total_transit_days The total number of days in transit from one location to the next. Returned for International requests.
     *
     * @return $this
     */
    public function setTotalTransitDays($total_transit_days)
    {
        $this->container['total_transit_days'] = $total_transit_days;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
