# UPS\OAuthAuthCode\DefaultApi

All URIs are relative to *https://wwwcie.ups.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**authorizeClient**](DefaultApi.md#authorizeclient) | **GET** /security/v1/oauth/authorize | Authorize Client
[**generateToken**](DefaultApi.md#generatetoken) | **POST** /security/v1/oauth/token | 
[**refreshToken**](DefaultApi.md#refreshtoken) | **POST** /security/v1/oauth/refresh | Refresh Token

# **authorizeClient**
> authorizeClient($client_id, $redirect_uri, $response_type, $state, $scope)

Authorize Client

The Authorize Client endpoint initiates the OAuth Authorization Code flow by redirecting the user to UPS for logging-in and authorize the client application. To begin the authorization flow, the application constructs a URL using the application's client Id, the redirect URI, the scope of permissions requested, and a random string used for subsequent verification. A successful response redirects back to the client with an authorization code that can be exchanged for an access token.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new UPS\OAuthAuthCode\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$client_id = "client_id_example"; // string | The public identifier for your application, obtained when you, the developer first registered the application.
$redirect_uri = "redirect_uri_example"; // string | URL that tells the authorization server where to send the user back to after they approve the request.
$response_type = "response_type_example"; // string | Valid Values: code
$state = "state_example"; // string | A random string generated by the application and included in the request to prevent CSRF attacks. The application checks that the same value is returned after the user authorizes the app.
$scope = "scope_example"; // string | One or more space-separated strings indicating which permissions the application is requesting.

try {
    $apiInstance->authorizeClient($client_id, $redirect_uri, $response_type, $state, $scope);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->authorizeClient: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **client_id** | **string**| The public identifier for your application, obtained when you, the developer first registered the application. |
 **redirect_uri** | **string**| URL that tells the authorization server where to send the user back to after they approve the request. |
 **response_type** | **string**| Valid Values: code |
 **state** | **string**| A random string generated by the application and included in the request to prevent CSRF attacks. The application checks that the same value is returned after the user authorizes the app. | [optional]
 **scope** | **string**| One or more space-separated strings indicating which permissions the application is requesting. | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **generateToken**
> \UPS\OAuthAuthCode\OAuthAuthCode\GenerateTokenSuccessResponse generateToken($grant_type, $code, $redirect_uri)



The Generate Token endpoint exchanges the authorization code received from the client application for an access token and a refresh token. The client uses the access token to make API requests on behalf of the user by including it in the authorization header. The access token will expire after a certain period and can be refreshed by using the /refresh endpoint.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure HTTP basic authorization: basicAuth
$config = UPS\OAuthAuthCode\Configuration::getDefaultConfiguration()
              ->setUsername('YOUR_USERNAME')
              ->setPassword('YOUR_PASSWORD');


$apiInstance = new UPS\OAuthAuthCode\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$grant_type = "grant_type_example"; // string | 
$code = "code_example"; // string | 
$redirect_uri = "redirect_uri_example"; // string | 

try {
    $result = $apiInstance->generateToken($grant_type, $code, $redirect_uri);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->generateToken: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **grant_type** | **string**|  | [optional]
 **code** | **string**|  | [optional]
 **redirect_uri** | **string**|  | [optional]

### Return type

[**\UPS\OAuthAuthCode\OAuthAuthCode\GenerateTokenSuccessResponse**](../Model/GenerateTokenSuccessResponse.md)

### Authorization

[basicAuth](../../README.md#basicAuth)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **refreshToken**
> \UPS\OAuthAuthCode\OAuthAuthCode\RefreshTokenSuccessResponse refreshToken($grant_type, $refresh_token)

Refresh Token

The /refresh endpoint is used to refresh an expired access token in order to continue accessing a UPS API on behalf of a user. The endpoint generates a new access/refresh token pair by exchanging a valid refresh token. A successful response returns new access and refresh tokens for ongoing API access without re-prompting the user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure HTTP basic authorization: basicAuth
$config = UPS\OAuthAuthCode\Configuration::getDefaultConfiguration()
              ->setUsername('YOUR_USERNAME')
              ->setPassword('YOUR_PASSWORD');


$apiInstance = new UPS\OAuthAuthCode\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$grant_type = "grant_type_example"; // string | 
$refresh_token = "refresh_token_example"; // string | 

try {
    $result = $apiInstance->refreshToken($grant_type, $refresh_token);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->refreshToken: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **grant_type** | **string**|  | [optional]
 **refresh_token** | **string**|  | [optional]

### Return type

[**\UPS\OAuthAuthCode\OAuthAuthCode\RefreshTokenSuccessResponse**](../Model/RefreshTokenSuccessResponse.md)

### Authorization

[basicAuth](../../README.md#basicAuth)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

