<?php
/**
 * LandedCostRequestShipment
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\LandedCost
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Landed Cost Quote API
 *
 * The Landed Cost Quote API allows you to estimate the all-inclusive cost of international shipments - including applicable duties, VAT, taxes, brokerage fees, and other fees. Required parameters include the currency and shipment details, such as the commodity ID, price, quantity, and country code of origin.  Key Business Values: - **Enhanced Customer Experience**: Get a quick and accurate quote on the landed cost of a shipment, including the cost of goods, transportation, and any other fees associated with getting the goods to their destination. - **Operational Efficiency**: Simplify the process of calculating landed costs by eliminating the need to manually research and calculate all of the different fees involved. - **Data-Driven Decision Making**: Improve decision-making by having a clear understanding of the total cost of shipping goods before you commit to a purchase.. - **Optimizing Cash Flow**: Streamline your shipping process by integrating the Landed Cost Quote API into your existing systems.
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\LandedCost\LandedCost;

use \ArrayAccess;
use \UPS\LandedCost\ObjectSerializer;

/**
 * LandedCostRequestShipment Class Doc Comment
 *
 * @category Class
 * @description Every Landed Cost request must be based on a shipment.
 * @package  UPS\LandedCost
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class LandedCostRequestShipment implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'LandedCostRequest_Shipment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'string',
        'import_country_code' => 'string',
        'import_province' => 'string',
        'ship_date' => 'string',
        'incoterms' => 'string',
        'export_country_code' => 'string',
        'trans_modes' => 'string',
        'transport_cost' => 'float',
        'shipment_type' => 'string',
        'shipment_items' => '\UPS\LandedCost\LandedCost\RequestShipmentItems[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'id' => null,
        'import_country_code' => null,
        'import_province' => null,
        'ship_date' => null,
        'incoterms' => null,
        'export_country_code' => null,
        'trans_modes' => null,
        'transport_cost' => null,
        'shipment_type' => null,
        'shipment_items' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'import_country_code' => 'importCountryCode',
        'import_province' => 'importProvince',
        'ship_date' => 'shipDate',
        'incoterms' => 'incoterms',
        'export_country_code' => 'exportCountryCode',
        'trans_modes' => 'transModes',
        'transport_cost' => 'transportCost',
        'shipment_type' => 'shipmentType',
        'shipment_items' => 'shipmentItems'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'import_country_code' => 'setImportCountryCode',
        'import_province' => 'setImportProvince',
        'ship_date' => 'setShipDate',
        'incoterms' => 'setIncoterms',
        'export_country_code' => 'setExportCountryCode',
        'trans_modes' => 'setTransModes',
        'transport_cost' => 'setTransportCost',
        'shipment_type' => 'setShipmentType',
        'shipment_items' => 'setShipmentItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'import_country_code' => 'getImportCountryCode',
        'import_province' => 'getImportProvince',
        'ship_date' => 'getShipDate',
        'incoterms' => 'getIncoterms',
        'export_country_code' => 'getExportCountryCode',
        'trans_modes' => 'getTransModes',
        'transport_cost' => 'getTransportCost',
        'shipment_type' => 'getShipmentType',
        'shipment_items' => 'getShipmentItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['import_country_code'] = isset($data['import_country_code']) ? $data['import_country_code'] : null;
        $this->container['import_province'] = isset($data['import_province']) ? $data['import_province'] : null;
        $this->container['ship_date'] = isset($data['ship_date']) ? $data['ship_date'] : null;
        $this->container['incoterms'] = isset($data['incoterms']) ? $data['incoterms'] : 'FOB';
        $this->container['export_country_code'] = isset($data['export_country_code']) ? $data['export_country_code'] : null;
        $this->container['trans_modes'] = isset($data['trans_modes']) ? $data['trans_modes'] : null;
        $this->container['transport_cost'] = isset($data['transport_cost']) ? $data['transport_cost'] : null;
        $this->container['shipment_type'] = isset($data['shipment_type']) ? $data['shipment_type'] : null;
        $this->container['shipment_items'] = isset($data['shipment_items']) ? $data['shipment_items'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['import_country_code'] === null) {
            $invalidProperties[] = "'import_country_code' can't be null";
        }
        if ($this->container['export_country_code'] === null) {
            $invalidProperties[] = "'export_country_code' can't be null";
        }
        if ($this->container['shipment_items'] === null) {
            $invalidProperties[] = "'shipment_items' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id Specifies the Shipment ID in the Landed Cost quote. It is an arbitrary string provided by the user of the API and will be  returned with the Landed Cost Quote to indicate which shipment the tariffs apply to. There are similar IDs associated with the Product and Order objects.
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets import_country_code
     *
     * @return string
     */
    public function getImportCountryCode()
    {
        return $this->container['import_country_code'];
    }

    /**
     * Sets import_country_code
     *
     * @param string $import_country_code Specifies the Import/Ship-To/Destination/Final country of the shipment. Please check country list in the Appendix.
     *
     * @return $this
     */
    public function setImportCountryCode($import_country_code)
    {
        $this->container['import_country_code'] = $import_country_code;

        return $this;
    }

    /**
     * Gets import_province
     *
     * @return string
     */
    public function getImportProvince()
    {
        return $this->container['import_province'];
    }

    /**
     * Sets import_province
     *
     * @param string $import_province Province/State is supported only for a few countries such as Mexico, Canada, etc. Please check Province list in the Appendix
     *
     * @return $this
     */
    public function setImportProvince($import_province)
    {
        $this->container['import_province'] = $import_province;

        return $this;
    }

    /**
     * Gets ship_date
     *
     * @return string
     */
    public function getShipDate()
    {
        return $this->container['ship_date'];
    }

    /**
     * Sets ship_date
     *
     * @param string $ship_date Defaults to current date if not provided. Date format: YYYY-MM-DD.
     *
     * @return $this
     */
    public function setShipDate($ship_date)
    {
        $this->container['ship_date'] = $ship_date;

        return $this;
    }

    /**
     * Gets incoterms
     *
     * @return string
     */
    public function getIncoterms()
    {
        return $this->container['incoterms'];
    }

    /**
     * Sets incoterms
     *
     * @param string $incoterms Supported Incoterm Values: 1. CFR - Cost & Freight  2. CIF - Cost, Insurance & Freight  3. CIP - Carriage and Insurance Paid-To  4. CPT - Carriage Paid-To  5. DAP - Delivered At Place  6. DAT - Delivered At Terminal  7. DDP - Delivered Duty Paid  8. DPU - Delivered at Place Unloaded  9. EXW - Ex Works  10. FAS - Free Alongside Ship  11. FCA - Free Carrier  12. FOB - Free On Board (Default)
     *
     * @return $this
     */
    public function setIncoterms($incoterms)
    {
        $this->container['incoterms'] = $incoterms;

        return $this;
    }

    /**
     * Gets export_country_code
     *
     * @return string
     */
    public function getExportCountryCode()
    {
        return $this->container['export_country_code'];
    }

    /**
     * Sets export_country_code
     *
     * @param string $export_country_code Specifies the export/ship-from/origin country of the shipment. Please check country List in the Appendix section.  **Note:** Export country code must be different from the import country code.
     *
     * @return $this
     */
    public function setExportCountryCode($export_country_code)
    {
        $this->container['export_country_code'] = $export_country_code;

        return $this;
    }

    /**
     * Gets trans_modes
     *
     * @return string
     */
    public function getTransModes()
    {
        return $this->container['trans_modes'];
    }

    /**
     * Sets trans_modes
     *
     * @param string $trans_modes The modes of transportation (in upper case). Supported Values:  1. INT_AIR 2.  INT_OCEAN  3. INT_RAIL  4. INT_TRUCK  5. DOM_AIR  6. DOM_OCEAN  7. DOM_RAIL  8. DOM_TRUCK   Default value will vary based on the import country.
     *
     * @return $this
     */
    public function setTransModes($trans_modes)
    {
        $this->container['trans_modes'] = $trans_modes;

        return $this;
    }

    /**
     * Gets transport_cost
     *
     * @return float
     */
    public function getTransportCost()
    {
        return $this->container['transport_cost'];
    }

    /**
     * Sets transport_cost
     *
     * @param float $transport_cost Specifies the Freight charge or transport costs, which are used for tariff calculations. Landed cost result might have some dependency on the freight charges in some countries. Therefore, freight amount should be always provided for accurate Landed Cost result.   Allowed values:  1. Any non-negative floating-point number.  2. Numeric value with optional decimal value.
     *
     * @return $this
     */
    public function setTransportCost($transport_cost)
    {
        $this->container['transport_cost'] = $transport_cost;

        return $this;
    }

    /**
     * Gets shipment_type
     *
     * @return string
     */
    public function getShipmentType()
    {
        return $this->container['shipment_type'];
    }

    /**
     * Sets shipment_type
     *
     * @param string $shipment_type Specifies the shipment type such as Gift, Document, Commercial (Sale), etc.  Supported Shipment Types:  1. GIFT  2. COMMERCIAL  3. SALE  4. SAMPLE  5. REPAIR  6. RETURN  7. OTHER   Default value will vary and based on import country.
     *
     * @return $this
     */
    public function setShipmentType($shipment_type)
    {
        $this->container['shipment_type'] = $shipment_type;

        return $this;
    }

    /**
     * Gets shipment_items
     *
     * @return \UPS\LandedCost\LandedCost\RequestShipmentItems[]
     */
    public function getShipmentItems()
    {
        return $this->container['shipment_items'];
    }

    /**
     * Sets shipment_items
     *
     * @param \UPS\LandedCost\LandedCost\RequestShipmentItems[] $shipment_items Array of shipment item objects (commodities), that are in a shipment.
     *
     * @return $this
     */
    public function setShipmentItems($shipment_items)
    {
        $this->container['shipment_items'] = $shipment_items;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
