<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelAccountTelephone
 */

/** @noinspection PhpUndefinedClassInspection */
class ModelAccountTelephone extends Model
{
    /**
     * @param $customer_id
     * @return mixed
     */
    public function getCustomerAdditionalValues($customer_id) {
        $sql = "SELECT *
				FROM " . $this->db->table('customer_additional_values') . "
				WHERE customer_id = " . (int)$customer_id;
        $query = $this->db->query($sql);

        return $query->row;
    }

    /**
     * @return array
     * @throws AException
     */
    public function getAddresses() {
        $address_data = [];

        $query = $this->db->query(
            "SELECT *
            FROM ".$this->db->table("addresses")."
            WHERE customer_id = '".(int) $this->customer->getId()."'"
        );

        foreach ($query->rows as $result) {
            $address_data[] = $this->_build_address_data($result);
        }
        return $address_data;
    }

    /**
     * @param array $address_row
     *
     * @return array
     * @throws AException
     */
    protected function _build_address_data($address_row)  {
        $addr_row = $this->dcrypt->decrypt_data($address_row, 'addresses');

        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');
        $country_row = $this->model_localisation_country->getCountry($addr_row['country_id']);

        if ($country_row) {
            $country = $country_row['name'];
            $iso_code_2 = $country_row['iso_code_2'];
            $iso_code_3 = $country_row['iso_code_3'];
            $address_format = $country_row['address_format'];
        } else {
            $country = '';
            $iso_code_2 = '';
            $iso_code_3 = '';
            $address_format = '';
        }

        $zone_row = $this->model_localisation_zone->getZone($addr_row['zone_id']);

        if ($zone_row) {
            $zone = $zone_row['name'];
            $code = $zone_row['code'];
        } else {
            $zone = '';
            $code = '';
        }

        $address = [
            'address_id'     => $addr_row['address_id'],
            'firstname'      => $addr_row['firstname'],
            'lastname'       => $addr_row['lastname'],
            'company'        => $addr_row['company'],
            'address_1'      => $addr_row['address_1'],
            'address_2'      => $addr_row['address_2'],
            'postcode'       => $addr_row['postcode'],
            'city'           => $addr_row['city'],
            'zone_id'        => $addr_row['zone_id'],
            'zone'           => $zone,
            'zone_code'      => $code,
            'country_id'     => $addr_row['country_id'],
            'country'        => $country,
            'iso_code_2'     => $iso_code_2,
            'iso_code_3'     => $iso_code_3,
            'address_format' => $address_format,
        ];

        if (strtolower($address['company']) === 'none' || strtolower($address['company']) === 'na' || $address['company'] === '') {
            unset($address['company']);
            $address['address_format'] = str_replace('{company}','',$address['address_format']);
        }
        return $address;
    }

}