<?php

defined('DS') ? NULL : define('DS',DIRECTORY_SEPARATOR);
//MAIN CONFIG FILE OF PHP AUTO UPDATE SCRIPT. CAN BE EDITED MANUALLY OR GENERATED USING Extra Tools > Configuration Generator TAB IN PHP AUTO UPDATE SCRIPT DASHBOARD. THE FILE MUST BE INCLUDED IN YOUR SCRIPT BEFORE YOU PROVIDE IT TO USER.

//-----------BASIC SETTINGS-----------//

//The URL (without / at the end) where PHP Auto Update Script from /WEB directory is installed on your server. No matter how many products you want to install and/or update, a single installation is enough.
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_ROOT_URL", "https://updater.wehearyou2.net");

//Unique numeric ID of product that needs to be installed and/or updated. Can be obtained by going to Products > View Products tab in PHP Auto Update Script dashboard and selecting product to be installed and/or updated. At the end of URL, you will see something like products_edit.php?product_id=NUMBER, where NUMBER is unique product ID. Cannot be modified after installing script.
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_ID", 61);

//Unique key of product that needs to be installed and/or updated. The key can be generated automatically or entered manually during product creation and can be obtained by going to Products > View Products tab in PHP Auto Update Script dashboard and selecting product to be installed and/or updated. If key is modified via PHP Auto Update Script dashboard, it must be updated in configuration file too.
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_KEY", "z6Fw3ltdGD2bOgih");

//Connection timeout in seconds. If product can't connect to and/or receive data from updates server after this period, connection will be dropped. Rule of thumb: 1 second for each MB to download. For example, if ZIP archives with your products are 50 MB in size, set this value to 50. As most compressed products only contain several MB of data, the default value of 30 should be enough. Increasing connection timeout will also slightly increase server resources usage.
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_CONNECTION_TIMEOUT", 30);

//Notification to be displayed when connection to server can't be established. Other notifications will be automatically fetched from server.
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_NO_CONNECTION", "Can't connect to updates server.");

//Notification to be displayed when ZipArchive class is missing on user's machine.
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_ZIPARCHIVE_CLASS_MISSING", "ZipArchive class is missing on this server.");

//Notification to be displayed when extracting downloaded ZIP archive fails.
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_ZIP_EXTRACT_ERROR", "Can't extract downloaded ZIP archive or write files.");

//Notification to be displayed when removing downloaded ZIP archive fails.
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_ZIP_DELETE_ERROR", "Can't delete downloaded ZIP archive.");


//-----------ADVANCED SETTINGS-----------//


//When option set to "YES", downloaded ZIP archive will be automatically deleted after extracting files.
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_DELETE_EXTRACTED", "YES");


//-----------NOTIFICATIONS FOR DEBUGGING PURPOSES ONLY. SHOULD NEVER BE DISPLAYED TO END USER-----------//


define("OPTIONPRO_WITH_DISCOUNT_UPDATER_CORE_NOTIFICATION_INVALID_ROOT_URL", "Configuration error: invalid root URL of PHP Auto Update Script installation");
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_CORE_NOTIFICATION_INVALID_PRODUCT_ID", "Configuration error: invalid product ID");
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_CORE_NOTIFICATION_INVALID_PRODUCT_KEY", "Configuration error: invalid product key");
define("OPTIONPRO_WITH_DISCOUNT_CORE_NOTIFICATION_INVALID_PERMISSIONS", "Configuration error: invalid root directory permissions");
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_CORE_NOTIFICATION_INACCESSIBLE_ROOT_URL", "Server error: impossible to establish connection to your PHP Auto Update Script installation");


//-----------SOME EXTRA STUFF. SHOULD NEVER BE REMOVED OR MODIFIED-----------//
define("OPTIONPRO_WITH_DISCOUNT_UPDATER_DIRECTORY", dirname(dirname(__DIR__)));

//validate integer and check if it's between min and max values
function optionProWithDiscountUpdaterValidateIntegerValue($number, $min_value=1, $max_value=999999999)
{
	$result=false;

	if (!is_float($number) && filter_var($number, FILTER_VALIDATE_INT, array("options"=>array("min_range"=>$min_value, "max_range"=>$max_value)))!==false) //don't allow numbers like 1.0 to bypass validation
	{
		$result=true;
	}

	return $result;
}


//make post requests with cookies and referrers, return array with server headers, errors, and body content
function optionProWithDiscountUpdaterCustomPost($url, $post_info="", $refer="")
{
	$user_agent="phpmillion cURL";
	$connect_timeout=OPTIONPRO_WITH_DISCOUNT_UPDATER_CONNECTION_TIMEOUT;
	$server_response_array=array();
	$formatted_headers_array=array();

	if (filter_var($url, FILTER_VALIDATE_URL) && !empty($post_info))
	{
		if (empty($refer) || !filter_var($refer, FILTER_VALIDATE_URL)) //use original URL as refer when no valid refer URL provided
		{
			$refer=$url;
		}

		$ch=curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_USERAGENT, $user_agent);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $connect_timeout);
		curl_setopt($ch, CURLOPT_TIMEOUT, $connect_timeout);
		curl_setopt($ch, CURLOPT_REFERER, $refer);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_info);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_MAXREDIRS, 10);

		//this function is called by curl for each header received - https://stackoverflow.com/questions/9183178/can-php-curl-retrieve-response-headers-and-body-in-a-single-request
		curl_setopt($ch, CURLOPT_HEADERFUNCTION,
			function($curl, $header) use (&$formatted_headers_array)
			{
				$len=strlen($header);
				$header=explode(":", $header, 2);
				if (count($header)<2) //ignore invalid headers
					return $len;

				$name=strtolower(trim($header[0]));
				$formatted_headers_array[$name]=trim($header[1]);

				return $len;
			}
		);

		$result=curl_exec($ch);
		$curl_error=curl_error($ch); //returns a human readable error (if any)
		curl_close($ch);

		$server_response_array['headers']=$formatted_headers_array;
		$server_response_array['error']=$curl_error;
		$server_response_array['body']=$result;
	}

	return $server_response_array;
}


//get raw domain (returns (sub.)domain.com from url like http://www.(sub.)domain.com/something.php?xx=yy)
function optionProWithDiscountUpdaterGetRawDomain($url)
{
	$raw_domain="";

	if (!empty($url))
	{
		$url_array=parse_url($url);
		if (empty($url_array['scheme'])) //in case no scheme was provided in url, it will be parsed incorrectly. add http:// and re-parse
		{
			$url="http://".$url;
			$url_array=parse_url($url);
		}

		if (!empty($url_array['host']))
		{
			$raw_domain=$url_array['host'];

			$raw_domain=trim(str_ireplace("www.", "", filter_var($raw_domain, FILTER_SANITIZE_URL)));
		}
	}

	return $raw_domain;
}


//generate signature to be submitted to PHP Auto Update Script server
function optionProWithDiscountUpdaterGenerateScriptSignature()
{
	$script_signature="";
	$root_ips_array=gethostbynamel(optionProWithDiscountUpdaterGetRawDomain(OPTIONPRO_WITH_DISCOUNT_UPDATER_ROOT_URL));

	if (!empty($root_ips_array)) //IP(s) resolved successfully
	{
		$script_signature=hash("sha256", gmdate("Y-m-d").OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_ID.OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_KEY.implode("", $root_ips_array));
	}

	return $script_signature;
}


//verify signature received from PHP Auto Update Script server
function optionProWithDiscountUpdaterVerifyServerSignature($notification_server_signature)
{
	$result=false;
	$root_ips_array=gethostbynamel(optionProWithDiscountUpdaterGetRawDomain(OPTIONPRO_WITH_DISCOUNT_UPDATER_ROOT_URL));

	if (!empty($notification_server_signature) && !empty($root_ips_array) && hash("sha256", implode("", $root_ips_array).OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_KEY.OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_ID.gmdate("Y-m-d"))==$notification_server_signature) //server signature valid
	{
		$result=true;
	}

	return $result;
}


//check PHP Auto Update Script core configuration and return an array with error messages if something wrong
function optionProWithDiscountUpdaterCheckSettings()
{
	$notifications_array=array();

	if (!filter_var(OPTIONPRO_WITH_DISCOUNT_UPDATER_ROOT_URL, FILTER_VALIDATE_URL) || !ctype_alnum(substr(OPTIONPRO_WITH_DISCOUNT_UPDATER_ROOT_URL, -1))) //invalid AUS installation URL
	{
		$notifications_array[]=OPTIONPRO_WITH_DISCOUNT_UPDATER_CORE_NOTIFICATION_INVALID_ROOT_URL;
	}

	if (!optionProWithDiscountUpdaterValidateIntegerValue(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_ID)) //invalid AUS product ID
	{
		$notifications_array[]=OPTIONPRO_WITH_DISCOUNT_UPDATER_CORE_NOTIFICATION_INVALID_PRODUCT_ID;
	}

	if (empty(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_KEY) || OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_KEY=="some_random_key") //invalid AUS product key
	{
		$notifications_array[]=OPTIONPRO_WITH_DISCOUNT_UPDATER_CORE_NOTIFICATION_INVALID_PRODUCT_KEY;
	}

	if (!@is_writable(OPTIONPRO_WITH_DISCOUNT_UPDATER_DIRECTORY)) //invalid permissions
	{
		$notifications_array[]=OPTIONPRO_WITH_DISCOUNT_CORE_NOTIFICATION_INVALID_PERMISSIONS;
	}

	return $notifications_array;
}


//get specified version details
function optionProWithDiscountUpdaterGetVersion($version_number="")
{
	$notifications_array=array();
	$optionProWithDiscountUpdater_core_notifications=optionProWithDiscountUpdaterCheckSettings(); //check core settings

	if (empty($optionProWithDiscountUpdater_core_notifications)) //only continue if script is properly configured
	{
		$post_info="product_id=".rawurlencode(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_ID)."&product_key=".rawurlencode(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_KEY)."&version_number=".rawurlencode($version_number)."&user_local_path=".rawurlencode(dirname(OPTIONPRO_WITH_DISCOUNT_UPDATER_DIRECTORY))."&script_signature=".rawurlencode(optionProWithDiscountUpdaterGenerateScriptSignature());

		$content_array=optionProWithDiscountUpdaterCustomPost(OPTIONPRO_WITH_DISCOUNT_UPDATER_ROOT_URL."/aus_callbacks/get_version.php", $post_info);
		if (!empty($content_array['headers']['notification_server_signature']) && optionProWithDiscountUpdaterVerifyServerSignature($content_array['headers']['notification_server_signature'])) //proper response received
		{
			$notifications_array['notification_case']=$content_array['headers']['notification_case'];
			$notifications_array['notification_text']=$content_array['headers']['notification_text'];
			if (!empty($content_array['headers']['notification_data'])) //additional data returned
			{
				$notifications_array['notification_data']=json_decode($content_array['headers']['notification_data'], true);
			}
		}
		else //no proper response received
		{
			$notifications_array['notification_case']="notification_no_connection";
			$notifications_array['notification_text']=OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_NO_CONNECTION;
		}
	}
	else //script is not properly configured
	{
		$notifications_array['notification_case']="notification_script_corrupted";
		$notifications_array['notification_text']=implode("; ", $optionProWithDiscountUpdater_core_notifications);
	}

	return $notifications_array;
}


//get details of all available versions
function optionProWithDiscountUpdaterGetAllVersions()
{
	$notifications_array=array();
	$optionProWithDiscountUpdater_core_notifications=optionProWithDiscountUpdaterCheckSettings(); //check core settings

	if (empty($optionProWithDiscountUpdater_core_notifications)) //only continue if script is properly configured
	{
		$post_info="product_id=".rawurlencode(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_ID)."&product_key=".rawurlencode(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_KEY)."&user_local_path=".rawurlencode(dirname(OPTIONPRO_WITH_DISCOUNT_UPDATER_DIRECTORY))."&script_signature=".rawurlencode(optionProWithDiscountUpdaterGenerateScriptSignature());

		$content_array=optionProWithDiscountUpdaterCustomPost(OPTIONPRO_WITH_DISCOUNT_UPDATER_ROOT_URL."/aus_callbacks/get_all_versions.php", $post_info);
		if (!empty($content_array['headers']['notification_server_signature']) && optionProWithDiscountUpdaterVerifyServerSignature($content_array['headers']['notification_server_signature'])) //proper response received
		{
			$notifications_array['notification_case']=$content_array['headers']['notification_case'];
			$notifications_array['notification_text']=$content_array['headers']['notification_text'];
			if (!empty($content_array['headers']['notification_data'])) //additional data returned
			{
				$notifications_array['notification_data']=json_decode($content_array['headers']['notification_data'], true);
			}
		}
		else //no proper response received
		{
			$notifications_array['notification_case']="notification_no_connection";
			$notifications_array['notification_text']=OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_NO_CONNECTION;
		}
	}
	else //script is not properly configured
	{
		$notifications_array['notification_case']="notification_script_corrupted";
		$notifications_array['notification_text']=implode("; ", $optionProWithDiscountUpdater_core_notifications);
	}

	return $notifications_array;
}

//download and extract archive with files of a specified version
function optionProWithDiscountUpdaterDownloadFile($file_type="version_upgrade_file", $version_number="")
{
	$notifications_array=array();
	$optionProWithDiscountUpdater_core_notifications=optionProWithDiscountUpdaterCheckSettings(); //check core settings

	if (empty($optionProWithDiscountUpdater_core_notifications)) //only continue if script is properly configured
	{
		if (class_exists("ZipArchive")) //proceed to download only if ZipArchive is installed on server
		{
			$post_info="product_id=".rawurlencode(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_ID)."&product_key=".rawurlencode(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_KEY)."&version_number=".rawurlencode($version_number)."&user_local_path=".rawurlencode(dirname(OPTIONPRO_WITH_DISCOUNT_UPDATER_DIRECTORY))."&file_type=".rawurlencode($file_type)."&script_signature=".rawurlencode(optionProWithDiscountUpdaterGenerateScriptSignature());

			$content_array=optionProWithDiscountUpdaterCustomPost(OPTIONPRO_WITH_DISCOUNT_UPDATER_ROOT_URL."/aus_callbacks/download_file.php", $post_info);

            if (!empty($content_array['headers']['notification_server_signature']) && optionProWithDiscountUpdaterVerifyServerSignature($content_array['headers']['notification_server_signature'])) //proper response received
			{
				$notifications_array['notification_case']=$content_array['headers']['notification_case'];
				$notifications_array['notification_text']=$content_array['headers']['notification_text'];
				if (!empty($content_array['headers']['notification_data'])) //additional data returned
				{
					$notifications_array['notification_data']=json_decode($content_array['headers']['notification_data'], true);
				}
               if (!empty($content_array['body'])) //file downloaded
				{
					if (!empty($content_array['headers']['content-disposition'])) //get name of ZIP archive
					{
						$zip_file_name=str_ireplace("filename=", "", stristr($content_array['headers']['content-disposition'], "filename="));
					}

					if (empty($zip_file_name)) //name of ZIP archive could not be parsed, use some hardcoded name
					{
						$zip_file_name="$file_type.zip"; //$file_type is string like version_install_file
					}

					$script_root_directory=dirname(OPTIONPRO_WITH_DISCOUNT_UPDATER_DIRECTORY); //OPTIONPRO_WITH_DISCOUNT_UPDATER_DIRECTORY actually is USER_INSTALLATION_FULL_PATH/SCRIPT (where this file is located), go one level up to enter root directory of upgradable script
					$zip_archive_local_destination="$script_root_directory/$zip_file_name"; //download archive right to root directory

					$zip_file=@fopen($zip_archive_local_destination, "w+");
					$fwrite=@fwrite($zip_file, $content_array['body']);
					if (optionProWithDiscountUpdaterValidateIntegerValue($fwrite)) //zip archive saved, extract it
					{
						$zip_file=new ZipArchive;
						if ($zip_file->open("$script_root_directory/$zip_file_name")===true) //everything ok, extract zip archive
						{
                            $zip_file->extractTo($script_root_directory);
                            $notifications_array['extract_location'] = $script_root_directory.'/'.trim($zip_file->getNameIndex(0),'/');
                            $zip_file->close();

                            if (OPTIONPRO_WITH_DISCOUNT_UPDATER_DELETE_EXTRACTED=="YES") //delete zip archive after extracting
							{
								$removed_files_total=optionProWithDiscountUpdaterDeleteFileDirectory($script_root_directory, array($zip_file_name));
								if (!optionProWithDiscountUpdaterValidateIntegerValue($removed_files_total))
								{
									$notifications_array['notification_case']="notification_zip_delete_failed";
									$notifications_array['notification_text']=OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_ZIP_DELETE_ERROR;
								}
							}
						}
						else //zip archive can't be opened
						{
							$notifications_array['notification_case']="notification_zip_extract_failed";
							$notifications_array['notification_text']=OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_ZIP_EXTRACT_ERROR;
						}
					}
					else //saving zip archive failed
					{
						$notifications_array['notification_case']="notification_zip_extract_failed";
						$notifications_array['notification_text']=OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_ZIP_EXTRACT_ERROR;
					}
				}
			}
			else //no proper response received
			{
				$notifications_array['notification_case']="notification_no_connection";
				$notifications_array['notification_text']=OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_NO_CONNECTION;
			}
		}
		else
		{
			$notifications_array['notification_case']="notification_ziparchive_class_missing";
			$notifications_array['notification_text']=OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_ZIPARCHIVE_CLASS_MISSING;
		}
	}
	else //script is not properly configured
	{
		$notifications_array['notification_case']="notification_script_corrupted";
		$notifications_array['notification_text']=implode("; ", $optionProWithDiscountUpdater_core_notifications);
	}

	return $notifications_array;
}


//fetch MySQL query of a specified version
function optionProWithDiscountUpdaterFetchQuery($query_type="upgrade", $version_number="")
{
	$notifications_array=array();
	$optionProWithDiscountUpdater_core_notifications=optionProWithDiscountUpdaterCheckSettings(); //check core settings

	if (empty($optionProWithDiscountUpdater_core_notifications)) //only continue if script is properly configured
	{
		$post_info="product_id=".rawurlencode(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_ID)."&product_key=".rawurlencode(OPTIONPRO_WITH_DISCOUNT_UPDATER_PRODUCT_KEY)."&version_number=".rawurlencode($version_number)."&user_local_path=".rawurlencode(dirname(OPTIONPRO_WITH_DISCOUNT_UPDATER_DIRECTORY))."&query_type=".rawurlencode($query_type)."&script_signature=".rawurlencode(optionProWithDiscountUpdaterGenerateScriptSignature());

		$content_array=optionProWithDiscountUpdaterCustomPost(OPTIONPRO_WITH_DISCOUNT_UPDATER_ROOT_URL."/aus_callbacks/fetch_query.php", $post_info);
		if (!empty($content_array['headers']['notification_server_signature']) && optionProWithDiscountUpdaterVerifyServerSignature($content_array['headers']['notification_server_signature'])) //proper response received
		{
			$notifications_array['notification_case']=$content_array['headers']['notification_case'];
			$notifications_array['notification_text']=$content_array['headers']['notification_text'];
			$notifications_array['notification_data']=json_decode($content_array['body'], true);
		}
		else //no proper response received
		{
			$notifications_array['notification_case']="notification_no_connection";
			$notifications_array['notification_text']=OPTIONPRO_WITH_DISCOUNT_UPDATER_NOTIFICATION_NO_CONNECTION;
		}
	}
	else //script is not properly configured
	{
		$notifications_array['notification_case']="notification_script_corrupted";
		$notifications_array['notification_text']=implode("; ", $optionProWithDiscountUpdater_core_notifications);
	}

	return $notifications_array;
}


//delete files and directories from specified directory ($files_array is an array of files and/or sub-directories to be deleted from $root_directory)
function optionProWithDiscountUpdaterDeleteFileDirectory($root_directory, $files_array=array())
{
	$removed_records=0;

	if (!empty($root_directory) && is_dir($root_directory)) //specified directory exists
	{
		if (empty($files_array)) //get and delete all files from specified directory
		{
			$files_array=scandir($root_directory);
		}

		$files_array=array_filter($files_array); //remove empty files (if any) from $files_array to prevent parent directory from being deleted too
		$files_array=array_diff($files_array, array(".", "..", "")); //remove dot files (if any) from $files_array to prevent parent directory from being deleted too when $files_array contains "."
		$files_array=array_values($files_array); //re-index array to prevent errors of undefined array indices

		if (!empty($files_array)) //proceed deleting files/directories
		{
			foreach ($files_array as $file)
			{
				if (is_file("$root_directory/$file") && unlink("$root_directory/$file")) //this is a file, delete
				{
					$removed_records++;
				}

				if (is_dir("$root_directory/$file")) //this is a directory, enter it and delete all files inside first
				{
					foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator("$root_directory/$file", FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST) as $path)
					{
						$path->isDir() && !$path->isLink() ? rmdir($path->getPathname()) : unlink($path->getPathname());
					}

					if (rmdir("$root_directory/$file"))
					{
						$removed_records++;
					}
				}
			}
		}
	}

	return $removed_records;
}