<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelCatalogProductTotalSavings extends Model {

    /**
     * @param $data
     * @return void
     * @throws AException
     */
    public function addProductSavings($data) {
        $exist = $this->isExist($data['product_id']);
        $store_id = $this->getStoreId();
        $fields = ["show_product_total_savings", "show_other_page_product_total_savings"];
        if ($exist==='0') {
            $this->db->query("INSERT INTO " . $this->db->table("product_total_savings")." (`store_id`,`product_id`,`show_product_total_savings`,`show_other_page_product_total_savings`) 
                                 VALUES ('".$store_id."','".$data['product_id']."','".$data['show_product_total_savings']."','".$data['show_other_page_product_total_savings']."')");
        } else {
            $update = [];
            foreach ( $fields as $f ) {
                if ( isset( $data[ $f ] ) ) {
                    if ( $f == 'settings' ) {
                        $data[ $f ] = serialize( $data[ $f ] );
                    }
                    $update[] = $f . " = '" . $this->db->escape( $data[ $f ] ) . "'";
                }
            }
            if ( ! empty( $update ) ) {
                $this->db->query( "UPDATE " . $this->db->table( "product_total_savings" ) . "
								SET " . implode( ',', $update ) . "
								WHERE `product_id` = '" . (int) $data['product_id'] . "' AND `store_id`=".(int)$store_id );
            }
        }
    }

    /**
     * @param $product_id
     * @return mixed
     * @throws AException
     */
    public function getProductSavings($product_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table("product_total_savings")." WHERE `product_id`=".(int)$product_id);
        return $query->row;
    }

    /**
     * @param $product_id
     * @return mixed
     * @throws AException
     */
    public function isExist($product_id) {
        $query = $this->db->query("SELECT COUNT(*) as `exist` FROM ".$this->db->table("product_total_savings")." WHERE `product_id`=".(int)$product_id);
        return $query->row['exist'];
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

}