<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT . "option_price_pro" . DIR_EXT_CORE . "updater.php";

/**
 * Class ExtensionOptionPricePro
 * @property ModelOptionPriceProProduct $model_option_price_pro_product
 */

class ExtensionOptionPricePro extends Extension {

	public $data = [];
	private $calc_status = '';
	private $error = [];
    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "option_price_pro";

	public function __construct() {
		$this->registry = Registry::getInstance();
	}

	private function _is_enabled() {
		return $this->baseObject->config->get( 'option_price_pro_status' ) && $this->verify();
	}

	public function verify() {
		$that =& $this->baseObject;
        $that->load->model('extension/option_price_pro_license_info');
        $license_key = $that->config->get('option_price_pro_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_price_pro_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_option_price_pro_license_info->getStoreId();
                $license_key = $that->model_extension_option_price_pro_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_option_price_pro_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_option_price_pro_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $public_key = "";
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/option_price_pro_license_info');
                    $current_version = $that->model_extension_option_price_pro_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/option_price_pro_license_info');
                            $that->model_extension_option_price_pro_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
	}

    public function verifyAreaCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('area_calculator_status')==='1') {
            $that->load->model('extension/area_calculator_license_info');
            $license_key = $that->config->get('area_calculator_license_code');
            $shared_secret = 'area_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('area_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_area_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_area_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_area_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_area_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyLengthCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('length_calculator_status')==='1') {
            $that->load->model('extension/length_calculator_license_info');
            $license_key = $that->config->get('length_calculator_license_code');
            $shared_secret = 'length_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('length_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_length_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_length_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_length_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_length_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyVolumeCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('volume_calculator_status')==='1') {
            $that->load->model('extension/volume_calculator_license_info');
            $license_key = $that->config->get('volume_calculator_license_code');
            $shared_secret = 'volume_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('volume_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_volume_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_volume_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_volume_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_volume_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyWeightCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('weight_calculator_status')==='1') {
            $that->load->model('extension/weight_calculator_license_info');
            $license_key = $that->config->get('weight_calculator_license_code');
            $shared_secret = 'weight_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('weight_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_weight_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_weight_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_weight_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_weight_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyLiquidsCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('liquids_calculator_status')==='1') {
            $that->load->model('extension/liquids_calculator_license_info');
            $license_key = $that->config->get('liquids_calculator_license_code');
            $shared_secret = 'liquids_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('liquids_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_liquids_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_liquids_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_liquids_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_liquids_calculator_license_info->getLicensedStoreStatus();

                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_price_pro_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/option_price_pro_license_info');
                    $store_id = $that->model_extension_option_price_pro_license_info->getStoreId();
                    $license_info = $that->model_extension_option_price_pro_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_option_price_pro_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/option_price_pro_updater');
                        $current_version = $that->model_extension_option_price_pro_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 1209600;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/option_price_pro_license_info');
                                $that->model_extension_option_price_pro_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }
    
	public function onControllerPagesExtensionExtensions_InitData() {
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'edit' ) {
			$extension = $that->request->get['extension'];
			if ( $extension === 'option_price_pro' ) {
				if ( $that->request->is_POST() ) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['option_price_pro_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/option_price_pro_license_info');

                    $store_id = (int) $that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int) $that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['current_store_id']) {
                            $store_id = (int) $that->session->data['current_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_option_price_pro_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                        $that->model_extension_option_price_pro_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_option_price_pro_license_info->getLicenseCode($store_id);
                    $data['multi']=false;
                    $split_existing_license_key = explode('-',$existing_license_key);
                    $split_license_key = explode('-',$license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi']=true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/option_price_pro_updater');
                    $current_version = $that->model_extension_option_price_pro_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/option_price_pro_license_info');
                        $data['option_price_pro_licensed_store_id_'.$store_id] = 1;

                        $that->model_setting_setting->editSetting('option_price_pro', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT.'option_price_pro/core/helpers.php')) {
                                unlink(DIR_EXT.'option_price_pro/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/option_price_pro_license_info');
                            $that->model_extension_option_price_pro_license_info->saveLicenseData($data);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('option_price_pro/option_price_pro');
            if ( $extension === 'option_price_pro' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_option_price_pro_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/option_price_pro_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/option-pro';
                $data['manual_title'] = $that->language->get('option_price_pro_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/option_price_pro_manual.tpl'));
                $that->load->model('extension/option_price_pro_license_info');
                $license_key = $that->config->get('option_price_pro_license_code');
                if ($license_key) {
                    $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_price_pro_license_info') . "'");
                    if ($exist->num_rows === 1) {
                        $store_id = $that->model_extension_option_price_pro_license_info->getStoreId();
                        $license_key = $that->model_extension_option_price_pro_license_info->getLicenseCode($store_id);
                        $license_info = $that->model_extension_option_price_pro_license_info->getLicenseData($store_id);
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_info['license_data'], $ttl);
                        $message = '';
                        if ($validate['status']==='expired') {
                            $message = $that->language->get('option_price_pro_license_expired');
                        }
                        $that->view->assign('message',$message);
                    }
                }
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'option_price_pro') {
            return false;
        }
        if (isset($that->request->post['option_price_pro_license_code'])) {
            $that->request->post['option_price_pro_license_code'] = trim($that->request->post['option_price_pro_license_code']);
        }
    }

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('option_price_pro/option_price_pro');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('option_price_pro_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'option_price_pro_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion!=='') {
                                $update_now_url = $that->html->getSecureURL('extension/option_price_pro_updater','&version='.str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    .'<br>'
                                    .sprintf(
                                        $that->language->get('text_update_option_price_pro_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    .'</p>';
                                $that->data['response']->rows[$k]['cell'][$key] = $cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            if ($that->request->post['option_price_pro_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['option_price_pro_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/option_price_pro_license_info');

                $installed_store_id = $that->model_extension_option_price_pro_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_option_price_pro_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/option_price_pro_updater');
                $current_version = $that->model_extension_option_price_pro_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/option_price_pro_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/option_price_pro_license_info');
                        $that->model_extension_option_price_pro_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='option_price_pro') {
                $that->load->language('option_price_pro/option_price_pro');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    } else {
                        $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

	public function onControllerPagesCheckoutCart_InitData() {
		$that = $this->baseObject;

		if ( ! $this->_is_enabled() ) {
			return null;
		}

		if ( $this->baseObject_method === 'main' ) {
			if ( $that->request->is_POST() ) {
				$post = $that->request->post;

				$that->load->language( 'option_price_pro/option_price_pro' );
				if ( isset( $post['option'] ) ) {
					$options = $post['option'];
					$that->load->model( 'option_price_pro/product' );
					$that->load->model( 'catalog/product' );
					$text_errors = [];
					foreach ( $options as $option_id => $option ) {
						$options_info = $that->model_option_price_pro_product->getOptionType( $option_id );
						$option_type  = $options_info['element_type'];
						$option_name  = $options_info['name'];
						if ( $option_type === 'G' || $option_type === 'M' ) {
							$id            = $option_id;
							$settings      = [];
							$error         = false;
							$error_message = $default_message = '';
							$settings      = $that->model_option_price_pro_product->getSettings( $option_id );
							if ( ! is_null( $settings ) ) {
								$minimum = $settings['minimum'];
								$maximum = $settings['maximum'];
								$status  = $settings['maximum_status'];
								$total   = sizeof( $options[ $id ] );
								if ( $status === '1' ) {
									if ( $minimum !== '' && $total < $minimum ) {
										$searchArray     = [ '{min}', '{total}' ];
										$replaceArray    = [ $minimum, $total ];
										$error_message   = str_replace( $searchArray, $replaceArray, $that->config->get( 'option_price_pro_enter_minimum_warning' ) );
										$default_message = str_replace( '{total}', $total, $that->language->get( 'error_pro_minimum_warning' ) );
										$default_message = $minimum . ' ' . $default_message;
										$error           = true;
									} elseif ( $maximum !== '' && $total > $maximum ) {
										$searchArray         = [ '{max}', '{total}' ];
										$replaceArray        = [ $maximum, $total ];
										$error_message       = str_replace( $searchArray, $replaceArray, $that->config->get( 'option_price_pro_enter_maximum_warning' ) );
										$searchDefaultArray  = [ '{max}', '{total}' ];
										$replaceDefaultArray = [ $maximum, $total ];
										$default_message     = str_replace( $searchDefaultArray, $replaceDefaultArray, $that->language->get( 'error_pro_maximum_warning' ) );
										$error               = true;
									}
								} elseif ( $status === '0' ) {
									if ( $minimum !== '' && $total < $minimum ) {
										$searchArray     = [ '{min}', '{total}' ];
										$replaceArray    = [ $minimum, $total ];
										$error_message   = str_replace( $searchArray, $replaceArray, $that->config->get( 'option_price_pro_enter_minimum_warning' ) );
										$default_message = str_replace( '{total}', $total, $that->language->get( 'error_pro_minimum_warning' ) );
										$default_message = $minimum . ' ' . $default_message;
										$error           = true;
									}
								}
								if ( $error === true ) {
									if ( $error_message !== '' ) {
										$text_errors[] = $option_name . ": " . $error_message;
									} else {
										$text_errors[] = $option_name . ": " . $default_message;
									}
								}
							}
						}
					}
					if ( $text_errors ) {
						$product_rt                   = 'product/product';
						$that->session->data['error'] = $text_errors;
						//send options values back via _GET
						$url = '&' . http_build_query( ['option' => $post['option'] ] );
						redirect( $that->html->getSecureURL( $product_rt, '&product_id=' . $post['product_id'] . $url ) );
					}
				}
			}
		}
	}

    public function onControllerPagesProductProduct_UpdateData() {
        if ( ! $this->_is_enabled() ) {
            return null;
        }
        if ( $this->baseObject_method === 'main' ) {
            if ( $this->verifyAreaCalculator()===false
                && $this->verifyLengthCalculator()===false
                && $this->verifyWeightCalculator()===false
                && $this->verifyLiquidsCalculator()===false
                && $this->verifyVolumeCalculator()===false
            ) {
                $key = [];
                $that = $this->baseObject;
                $request = $that->request->get;
                $cart = new ACart($this->registry);

                $fast_checkout = $that->config->get('fast_checkout_status');

                if ($fast_checkout==='1' && $that->config->get('fast_checkout_buy_now_status')) {
                    $data= [];
                    $data['button_add_to_cart'] = $that->language->get('button_add_to_cart');
                    $data['text_buynow'] = $that->language->get('fast_checkout_buy_now');
                    $data['buynow_url'] = $that->html->getSecureURL('option_price_pro/fast_checkout/main','&single_checkout=1');
                    $data['add_to_cart'] = $that->language->get('button_add_to_cart');

                    /** @var AView $view */
                    $viewClass = get_class($that->view);

                    $view = new $viewClass(Registry::getInstance(),0);
                    $view->batchAssign($data);
                    $that->view->replaceHookVar('product_add_to_cart_html',
                        $view->fetch('pages/product/add_to_cart_buttons.tpl'));
                }

                //if ($calc_status === '0' || is_null($calc_status) || empty($calc_status)) {
                $key = [];
                $option_price = '';
                if (has_value($that->request->get['key'])) {
                    $key = explode(':', $that->request->get['key']);
                    $product_id = (int)$key[0];
                } elseif (has_value($that->request->get['product_id'])) {
                    $product_id = (int)$that->request->get['product_id'];
                } else {
                    $product_id = 0;
                }
                $that->loadModel('catalog/product');
                $that->loadModel('option_price_pro/product');
                $product_info = $that->model_catalog_product->getProduct($product_id);
                $product_price = '';

                $promotion = new APromotion();
                $discount = $promotion->getProductDiscount($product_id);

                //Need to round price after discounts and specials
                //round main price to currency decimal_place setting (most common 2, but still...)

                $currency = $that->currency->getCurrency();
                $decimal_place = (int) $currency['decimal_place'];
                $decimal_place = !$decimal_place ? 2 : $decimal_place;

                if ($discount) {
                    $product_price = round((float)$discount, $decimal_place);
                    $this->data['price_num'] = round($that->tax->calculate(
                        $discount,
                        $product_info['tax_class_id'],
                        (bool)$that->config->get('config_tax')
                    ),
                    $decimal_place);
                    $this->data['special'] = false;
                } else {
                    $product_price = round((float)$product_info['price'], $decimal_place);
                    $this->data['price_num'] = round($that->tax->calculate(
                        $product_info['price'],
                        $product_info['tax_class_id'],
                        (bool)$that->config->get('config_tax')
                    ),
                    $decimal_place);

                    $special = $promotion->getProductSpecial($product_id);
                    if ($special) {
                        $product_price = round($special, $decimal_place);
                        $this->data['special_num'] = round($that->tax->calculate(
                            $special,
                            $product_info['tax_class_id'],
                            (bool)$that->config->get('config_tax')
                        ),
                        $decimal_place);
                    } else {
                        $this->data['special'] = false;
                    }
                }

                $elements_with_options = HtmlElementFactory::getElementsWithOptions();
                $product_options = $that->model_catalog_product->getProductOptions($product_id);

                $options = [];
                $cart_product_info = [];
                if ($key) {
                    $cart_product_info = $cart->getProduct($that->request->get['key']);
                }

                foreach ($product_options as $option) {
                    $configs = $that->model_option_price_pro_product->getBasePrice($option['product_option_id']);
                    $calculate = $configs['calculate'];
                    $base_price = $configs['base_price'];
                    $values = [];
                    $disabled_values = [];
                    $name = $price = '';
                    $default_value = $cart_product_info['options'][$option['product_option_id']];
                    if ($option['element_type'] == 'R') {
                        $default_value = is_array($default_value) ? current($default_value) : (string)$default_value;
                    }
                    $preset_value = $default_value;
                    foreach ($option['option_value'] as $option_value) {
                        $default_value = $option_value['default'] ? $option_value['product_option_value_id'] : $default_value;
                        // for case when trying to add to cart withot required options. we get option-array back inside _GET
                        if (has_value($that->request->get['option'][$option['product_option_id']])) {
                            $default_value = $that->request->get['option'][$option['product_option_id']];
                        }
                        $option_price = $option_value['price'];
                        $name = $option_value['name'];
                        //check if we disable options based on out of stock setting
                        if ($option_value['subtract'] && $that->config->get('config_nostock_autodisable') && $option_value['quantity'] <= 0) {
                            continue;
                        }

                        //Apply option price modifier
                        if ($option_value['prefix'] == '%') {
                            if ($calculate === '0') {
                                $price = round($that->tax->calculate(
                                    ($product_price * $option_value['price'] / 100),
                                    $product_info['tax_class_id'],
                                    (bool)$that->config->get('config_tax')),$decimal_place);
                            } else {
                                $price = round($that->tax->calculate(
                                    $product_price + ($product_price * $option_value['price'] / 100),
                                    $product_info['tax_class_id'],
                                    (bool)$that->config->get('config_tax')),$decimal_place);
                            }
                            if ($price != 0) {
                                $price = $that->currency->format($price);
                            } else {
                                $price = '';
                            }
                        } else {
                            if ($calculate == '0') {
                                $price = round($that->tax->calculate($option_price, $product_info['tax_class_id'], (bool)$that->config->get('config_tax')),$decimal_place);
                            } else {
                                $price = round($that->tax->calculate($product_price + $option_price, $product_info['tax_class_id'], (bool)$that->config->get('config_tax')),$decimal_place);
                            }
                            if ($price != 0) {
                                $price = $that->currency->format($price);
                            } else {
                                $price = '';
                            }
                        }

                        $opt_stock_message = '';
                        //if options has stock tracking and not allowed to be purchased out of stock
                        if ($option_value['subtract'] && !$product_info['stock_checkout']) {
                            if ($option_value['quantity'] <= 0) {
                                //show out of stock message
                                $opt_stock_message = $that->language->get('text_out_of_stock');
                                $disabled_values[] = $option_value['product_option_value_id'];
                            } else {
                                if ($that->config->get('config_stock_display')) {
                                    if ($option_value['quantity'] > 0) {
                                        $opt_stock_message = $option_value['quantity'] . " " . $that->language->get('text_instock');
                                        $opt_stock_message = "($opt_stock_message)";
                                    }
                                }
                            }
                        } else {
                            if ($option_value['subtract'] && $product_info['stock_checkout']) {
                                if ($option_value['quantity'] <= 0) {
                                    $opt_stock_message = $product_info['stock_status'] ? "({$product_info['stock_status']})" : '';
                                }
                            }
                        }

                        $optionSeparator = $that->config->get('option_price_pro_name_separator');
                        $priceSeparator = $that->config->get('option_price_pro_price_separator');
                        if ($optionSeparator == '') {
                            $optionSymbol = '&nbsp;&nbsp;&nbsp;';
                        } else {
                            $optionSymbol = '&nbsp;' . $optionSeparator . '&nbsp;';
                        }
                        if ($opt_stock_message) {
                            if ($priceSeparator === '') {
                                $priceSymbol = '&nbsp;&nbsp;&nbsp;';
                            } else {
                                $priceSymbol = '&nbsp;' . $priceSeparator . '&nbsp;';
                            }
                        } else {
                            $priceSymbol = '';
                        }

                        if (!empty($opt_stock_message)) {
                            $stock_message = $priceSymbol . $opt_stock_message;
                        } else {
                            $stock_message = '';
                        }

                        if ($base_price === '1' && $price !== '') {
                            $values[$option_value['product_option_value_id']] = $name . $optionSymbol . $price . $stock_message;
                        } else {
                            if ($option_price != '0.0000' && $price !== '') {
                                $values[$option_value['product_option_value_id']] = $name . $optionSymbol . $price . $stock_message;
                            } else {
                                $values[$option_value['product_option_value_id']] = $name . $stock_message;
                            }
                        }

                        if ($option['element_type'] == 'B') {
                            $name = $default_value = preg_replace("/\r|\n/", " ", $option_value['name']);
                            if ($price) {
                                $default_value .= '</br>';
                                $name .= ' ';
                            }
                            if ($price) {
                                $default_value .= $price . ' ';
                                $name .= $price;
                            }
                            $option['required'] = false;
                        }
                    }

                    //if not values are build, nothing to show
                    if (sizeof($values)) {
                        $value = $attr = '';
                        //add price to option name if it is not element with options
                        if (!in_array($option['element_type'], $elements_with_options) && $option['element_type'] != 'B') {
                            if ($option_price === '0.0000') {
                                if ($opt_stock_message) {
                                    $option['name'] .= '<br />' . $opt_stock_message;
                                }
                            } else {
                                $option['name'] .= ' <small>' . $price . '</small>';
                                if ($opt_stock_message) {
                                    $option['name'] .= '<br />' . $opt_stock_message;
                                }
                            }
                            $value = $name;
                        } else {
                            if ($option['element_type'] == 'B') {
                                $value = $name;
                            }
                        }

                        //set default selection is nothing selected
                        if (!has_value($value)) {
                            if (has_value($default_value)) {
                                $value = $default_value;
                            }
                        }

                        if ($option['element_type'] == 'C') {
                            if ($value == '') {
                                $value = 1;
                            }
                            $attr = key($option['option_value']);
                        }

                        if ($option['element_type'] == 'C') {
                            if (!in_array($value, ['0', '1'])) {
                                $option_data['label_text'] = $value;
                            }
                            $option_data['checked'] = (bool) $preset_value;
                        }
                        $option_data['attr'] = ' data-attribute-value-id="' . $attr . '"';
                        $option_data['disabled_options'] = $disabled_values;

                        $option_data = [
                            'type' => $option['html_type'],
                            'name' =>
                                !in_array($option['element_type'], HtmlElementFactory::getMultivalueElements())
                                    ? 'option[' . $option['product_option_id'] . ']'
                                    : 'option[' . $option['product_option_id'] . '][]',
                            'attr' => ' data-attribute-value-id="' . $attr . '"',
                            'value' => $value,
                            'options' => $values,
                            'disabled_options' => $disabled_values,
                            'required' => $option['required'],
                            'placeholder' => $option['option_placeholder'],
                            'regexp_pattern' => $option['regexp_pattern'],
                            'error_text' => $option['error_text']
                        ];

                        $options[] = [
                            'name' => $option['name'],
                            'html' => $that->html->buildElement($option_data),  // not a string!!! it's object!
                        ];
                    }
                }
                $this->data['options'] = $options;
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

	public function onControllerResponsesProductProduct_UpdateData() {
		if ( ! $this->_is_enabled() ) {
			return null;
		}
		$that        = $this->baseObject;
		if ( $this->baseObject_method === 'load_option' ) {
            $type = $that->data['option_data']['element_type'];
            if ($type!=='LQ' && $type!=='V' && $type!=='W' && $type!=='X' && $type!=='Y') {
                $that->loadLanguage('option_price_pro/option_price_pro');

                $this->data['fields'] = [
                    'entry_status' => 'status',
                    'entry_option_name' => 'option_name',
                    'entry_option_placeholder' => 'option_placeholder',
                    'entry_sort_order' => 'option_sort_order',
                    'entry_required' => 'required',
                    'entry_calculate' => 'calculate',
                    'entry_base_price' => 'base_price',
                    'entry_maximum_status' => 'maximum_status',
                    'entry_minimum' => 'minimum',
                    'entry_maximum' => 'maximum',
                    'entry_allowed_extensions' => 'extensions',
                    'entry_min_size' => 'min_size',
                    'entry_max_size' => 'max_size',
                    'entry_upload_dir' => 'directory',
                    'entry_regexp_pattern' => 'option_regexp_pattern',
                    'entry_error_text' => 'option_error_text'
                ];
                $this->data['calculate'] = $that->html->buildElement([
                    'type' => 'checkbox',
                    'name' => 'calculate',
                    'value' => $that->data['option_data']['calculate'],
                    'style' => 'btn_switch btn-group-xs',
                ]);
                $this->data['base_price'] = $that->html->buildElement([
                    'type' => 'checkbox',
                    'name' => 'base_price',
                    'value' => $that->data['option_data']['base_price'],
                    'style' => 'btn_switch btn-group-xs',
                ]);

                $type = $that->data['option_data']['element_type'];
                $option_id  = (int) $that->request->get['option_id'];
                $that->load->model( 'option_price_pro/options' );
                $option_settings = $that->model_option_price_pro_options->getSettings( $option_id );

                if ($type === 'G' || $type === 'M') {
                    $this->data['entry_maximum_status'] = $that->language->get('text_pro_maximum_status');
                    $this->data['maximum_status'] = $that->html->buildElement([
                        'type' => 'checkbox',
                        'name' => 'maximum_status',
                        'value' => $option_settings['maximum_status'],
                        'style' => 'btn_switch btn-group-xs',
                    ]);
                    $this->data['entry_minimum'] = $that->language->get('enter_pro_minimum');
                    $this->data['minimum'] = $that->html->buildElement([
                        'type' => 'input',
                        'name' => 'minimum',
                        'value' => $option_settings['minimum'],
                        'style' => 'tiny-field'
                    ]);
                    $this->data['entry_maximum'] = $that->language->get('enter_pro_maximum');
                    $this->data['maximum'] = $that->html->buildElement([
                        'type' => 'input',
                        'name' => 'maximum',
                        'value' => $option_settings['maximum'],
                        'style' => 'tiny-field'
                    ]);
                }

                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        } elseif ($this->baseObject_method==='update_option_values') {
            $that->load->model('option_price_pro/options');
            $that->model_option_price_pro_options->updateProductOptionValues($that->request->get['product_id'], $that->request->get['option_id'], $that->request->post);
        }  elseif ($this->baseObject_method==='update_option') {
            $that->load->model('option_price_pro/options');
            $data['minimum']=$that->request->get['minimum'];
            $data['maximum']=$that->request->get['maximum'];
            $data['maximum_status']=$that->request->get['maximum_status'];
            $that->model_option_price_pro_options->updateProductOption( $that->request->get['option_id'], $that->request->get);
            $that->model_option_price_pro_options->addSettings($that->request->get['option_id'],$data);
        }
	}

    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('option_price_pro/option_price_pro');
                    $that->load->model('extension/option_price_pro_updater');
                    $total = $that->model_extension_option_price_pro_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_option_price_pro_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_option_price_pro_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_option_price_pro_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_option_price_pro_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_option_price_pro_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('option_price_pro_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_price_pro_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/option_price_pro_license_info');
                $store_id = $that->model_extension_option_price_pro_license_info->getStoreId();

                $license_key = $that->model_extension_option_price_pro_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_option_price_pro_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('option_price_pro/option_price_pro');
                $getVersions = optionProUpdaterGetAllVersions();
                $that->load->model('extension/option_price_pro_updater');
                $current_version = $that->model_extension_option_price_pro_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_option_price_pro_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_option_price_pro_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }
}