<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'src/Ctct/autoload.php';

use Ctct\ConstantContact;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\Contacts\EmailAddress;
use Ctct\Exceptions\CtctException;

class ModelExtensionConstantContactIntegration extends Model{
    public $data = array ();
    private $error = array ();
    private $api='9u2zpz9pyxwreaqrhg9bu7ng';

    public function syncNewsletter($newsletter,$email) {
      $this->db->query("UPDATE " . $this->db->table("customers") . " SET newsletter = '" . (int)$newsletter . "' WHERE email = '" . $email . "'");
    }

    public function getContent($position)
    {
        $sql="SELECT * FROM " . DB_PREFIX . "constantcontact_integration_content where positions='" . $position . "'";
        $results=$this->db->query($sql);
        return $results->row;
    }

    public function updateContent($position,$data)
    {
        $fields=array(
            'content'
        );

        $update=array();
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                $update[] = "$f = '" . $this->db->escape($data[$f]) . "'";
            }
        }

        if (!empty($update)) {
            if ($this->db->query("UPDATE `" . DB_PREFIX . "constantcontact_integration_content` SET " . implode(',', $update) . " WHERE positions = '" . $position . "'")){
                return true;
            };
        }
    }

    public function getCustomerByEmail($email)
    {
        $sql="SELECT * FROM " . $this->db->table("customers") . " WHERE email='" . $email . "'";
        $results=$this->db->query($sql);
        return $results->row;
    }


    public function getSubscribersCustomerGroupId() {
        $query = $this->db->query("SELECT customer_group_id	FROM `" . $this->db->table("customer_groups") . "` WHERE `name` = 'Newsletter Subscribers' LIMIT 0,1");
        $result = !$query->row['customer_group_id'] ? (int)$this->config->get('config_customer_group_id') :  $query->row['customer_group_id'];
        return $result;
    }

    public function addCustomer($data) {
        $key_sql = '';
        if ( $this->dcrypt->active ) {
            $data = $this->dcrypt->encrypt_data($data, 'customers');
            $key_sql = ", key_id = '" . (int)$data['key_id'] . "'";
        }

        if (VERSION > '1.2.7') {
            $salt_key = genToken(8);
            $password= $this->db->escape(sha1($salt_key.sha1($salt_key.sha1($data['password']))));
            $salt="salt = '" . $this->db->escape($salt_key) . "',";
        } else {
            $password=$this->db->escape(AEncryption::getHash($data['password']));
            $salt='';
        }

        $sql = "INSERT INTO " . $this->db->table("customers") . "
			  SET	store_id = '" . (int)$this->config->get('config_store_id') . "',
					loginname = '" . $this->db->escape($data['loginname']) . "',
					firstname = '" . $this->db->escape($data['firstname']) . "',
					lastname = '" . $this->db->escape($data['lastname']) . "',
					email = '" . $this->db->escape($data['email']) . "',
					password = '" . $password . "',
					newsletter = '" . (int)$data['newsletter'] . "',
					customer_group_id = '" .(int)$data['customer_group_id'] . "',
					".$salt."
					approved = '".(int)$data['approved']."',
					status = '".(int)$data['status']."'". $key_sql . ",
					date_added = NOW()";
        $this->db->query($sql);
        $customer_id = $this->db->getLastId();

        if (VERSION > '1.2.5') {
            //enable notification setting for newsletter via email
            if($data['newsletter']){
                $this->saveCustomerNotificationSettings($customer_id, array('newsletter'=>array('email'=>1)));
            }

            $this->editCustomerNotifications($customer_id, $data);
        }

        return $customer_id;
    }

    public function editCustomerNotifications($customer_id, $data){
        if(!$data || !$customer_id){
            return false;
        }

        $upd = array();
        //get only active IM drivers
        $im_protocols = $this->im->getProtocols();
        foreach ($im_protocols as $protocol){
            if(isset($data[$protocol])){
                $upd[$protocol] = "`".$this->db->escape($protocol)."` = '".$this->db->escape($data[$protocol])."'";
            }
        }

        //get all columns
        $sql = "SELECT COLUMN_NAME
				FROM INFORMATION_SCHEMA.COLUMNS
				WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '" . $this->db->table("customers") . "'";
        $result = $this->db->query($sql);
        $columns = array();
        foreach($result->rows as $row){
            $columns[] = $row['COLUMN_NAME'];
        }

        //remove not IM data
        $diff = array_diff($im_protocols,$columns);
        foreach($diff as $k){
            unset($data[$k]);
        }

        $key_sql = '';
        if ( $this->dcrypt->active ) {
            $data = $this->dcrypt->encrypt_data($data, 'customers');
            $key_sql = ", key_id = '" . (int)$data['key_id'] . "'";
        }

        $sql = "UPDATE ".$this->db->table('customers')."
				SET ".implode(', ',$upd)."\n"
            . $key_sql .
            " WHERE customer_id = '" . (int)$customer_id . "'";
        $this->db->query($sql);
        return true;
    }


    public function saveCustomerNotificationSettings($customer_id, $settings=array()){

        if(!$customer_id){
            return null;
        }

        $sendpoints = array_keys($this->im->sendpoints);
        $im_protocols = $this->im->getProtocols();

        $update = array();
        foreach($settings as $sendpoint=>$row){
            if(!in_array($sendpoint, $sendpoints)){
                continue;
            }
            foreach($im_protocols as $protocol){
                $update[$sendpoint][$protocol] = (int)$settings[$sendpoint][$protocol];
            }
        }

        if($update){
            foreach($update as $sendpoint=>$row){
                foreach($row as $protocol=>$status){

                    $sql = "DELETE FROM ".$this->db->table('customer_notifications')."
							WHERE customer_id = ".$customer_id."
								AND sendpoint = '" . $this->db->escape($sendpoint) . "'
								AND protocol = '" . $this->db->escape($protocol) . "'";
                    $this->db->query($sql);

                    $sql = "INSERT INTO " . $this->db->table('customer_notifications') . "
							(customer_id, sendpoint,protocol,status, date_added)
						VALUES
						('" . $customer_id . "',
						'" . $this->db->escape($sendpoint) . "',
						'" . $this->db->escape($protocol) . "',
						'" . (int)$status . "',
						NOW());";
                    $this->db->query($sql);
                }
            }
        }
        return true;
    }

    /**
     * @param $email
     * @param $first_name
     * @param $last_name
     * @param $action - subscribe for new, resubscribe for existing
     * @param string $id
     * @param string $opt_in
     */

    public function Subscribe($email,$first_name,$last_name,$action,$id='',$opt_in='') {
        $cc = new ConstantContact($this->api);
        $token=$this->config->get('constantcontact_integration_access_token');
        $list_id=$this->config->get('constantcontact_integration_list');

        $contact = new Contact();
        if ($opt_in==='ACTION_BY_VISITOR') {
            $contact->id=$id;
            $emailAddress = new EmailAddress();
            $emailAddress->opt_in_source='ACTION_BY_VISITOR';
            $emailAddress->email_address=$email;
            $contact->addEmail($emailAddress);
        } else {
            $contact->addEmail($email);
        }
        
        $contact->addList($list_id);
        $contact->first_name = $first_name;
        $contact->last_name = $last_name;
        if ($action==0) {
            try {
                $cc->addContact($token, $contact, true);
            } catch (CtctException $ex) {
                $rpt = $ex->getErrors();
                $this->log->write('Constant Contact Error '.$rpt[0]['error_message']);
            }
        } elseif ($action==1) {
            try{
                $cc->updateContact($token, $contact, true);
            } catch(CtctException $ex) {
                $rpt = $ex->getErrors();
                $this->log->write('Constant Contact Error this one'.$rpt[0]['error_message']);
            }
        }
    }

    /**
     * @param string $email
     */
    public function Unsubscribe($email) {
        $cc = new ConstantContact($this->api);
        $token=$this->config->get('constantcontact_integration_access_token');
        try {
            $acc = $cc->getContactByEmail($token, $email);
            $id=$acc->results[0]->id;
            if ($id) {
                $cc->deleteContact($token, $id);
            }
        } catch(CtctException $ex) {
            $err=$ex->getErrors();
            $this->log->write('Constant Contact Error '.$err[0]['error_message']);
        }
    }

    /**
     * @param $email
     * @return array
     */
    public function getContact($email) {
        $cc = new ConstantContact($this->api);
        $token=$this->config->get('constantcontact_integration_access_token');
        $contacts=$cc->getContactByEmail($token, $email)->results;
        return $contacts;
    }
}