<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}
require DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'src/Ctct/autoload.php';

use Ctct\ConstantContact;
use Ctct\Components\Activities\AddContacts;
use Ctct\Components\Activities\AddContactsImportData;
use Ctct\Exceptions\CtctException;
require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionConstantContactIntegration
 * @property ModelExtensionConstantContactIntegration $model_extension_constantcontact_integration
 */

class ControllerPagesExtensionConstantContactIntegration extends AController {

    private $api='9u2zpz9pyxwreaqrhg9bu7ng';
    public $data=[];

    public function verify() {
        $this->load->model('extension/constantcontact_integration_license_info');
        $license_key = $this->config->get('constantcontact_integration_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('constantcontact_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_constantcontact_integration_license_info->getStoreId();
                $license_key = $this->model_extension_constantcontact_integration_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_constantcontact_integration_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'constantcontact_integration');
                $ttl = 604800;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_constantcontact_integration_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }

    public function verifyEditor() {
        if ( $this->config->get( 'editor_status' ) === '1' ) {
            $this->load->model('extension/editor_license_info');
            $license_key = $this->config->get('editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'editor');
                    $ttl = 604800;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main() {
        $this->loadLanguage('constantcontact_integration/constantcontact_integration');
        $this->loadLanguage('extension/extensions');
        $this->view->assign('heading_title',$this->language->get('constantcontact_integration_name'));
        $this->view->assign('text_sync_description',$this->language->get('text_sync_description'));
        $cc = new ConstantContact($this->api);
        $token=$this->config->get('constantcontact_integration_access_token');
        $this->loadModel('extension/constantcontact_integration');
        $this->loadModel('setting/setting');
        $this->data['addition_note']=$this->language->get('constantcontact_integration_addition_note');
        $this->data['ext_man']=  $this->language->get('constantcontact_integration_name').' Manual';
        $this->data['tools']=$this->language->get('constantcontact_integration_tools');
        $this->data['contact_title']=$this->language->get('constantcontact_integration_name');
        $this->data['content']=$this->language->get('constantcontact_integration_content');
        $this->data['textTopContent']=$this->language->get('constantcontact_integration_top_content');
        $this->data['textBottomContent']=$this->language->get('constantcontact_integration_bottom_content');
        $this->data['topContentUrl']=$this->html->getSecureURL('r/extension/constantcontact_integration/addTop');
        $this->data['bottomContentUrl']=$this->html->getSecureURL('r/extension/constantcontact_integration/addBottom');
        $this->data['help_url']='https://why2central.net/v1/ctct';
        $this->data['license_status'] = $this->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_ctct_unauthorized');
        $topContent=$this->model_extension_constantcontact_integration->getContent('top');
        $bottomContent=$this->model_extension_constantcontact_integration->getContent('bottom');
        $this->data['topContent'] = $topContent['content'];
        $this->data['bottomContent'] = $bottomContent['content'];
        $this->data['text_help'] = $this->language->get('text_help');
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->request->post['export']=='export') {
            $this->loadModel('sale/customer');
            $list_id=$this->config->get('constantcontact_integration_list');
            $results = $this->model_sale_customer->getCustomersByNewsletter();
            if ($results) {
                foreach ($results as $rst) {
                    $contact = new AddContactsImportData();
                    $contact->first_name = $rst['firstname'];
                    $contact->last_name = $rst['lastname'];
                    $contact->addEmail($rst['email']);
                    $data[] = $contact;
                }
                $addContacts = new AddContacts($data, [$list_id]);

                try {
                    $cc->addCreateContactsActivity($token, $addContacts);
                } catch (CtctException $ex) {
                    $err = $ex->getErrors();
                    $this->log->write('Constant Contact Error' . $err[0]['error_message']);
                }

                $this->session->data['success'] = $this->language->get('text_export_success');
            } else {
                $this->session->data['warning'] = $this->language->get('text_export_empty');
            }
            $this->redirect($this->html->getSecureURL('extension/constantcontact_integration','&extension=constantcontact_integration'));
        } elseif ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->request->post['sync']=='sync'){
                $contacts=$this->getAllContacts();
                $admin_email = $this->config->get('constantcontact_integration_admin_email');
                foreach ($contacts as $ct) {
                    set_time_limit(0);
                    $email = $ct->email_addresses[0]->email_address;
                    if ($email === $admin_email) {
                        continue;
                    }
                    $exist = $this->model_extension_constantcontact_integration->getCustomerByEmail($email);
                    $newsletter=$exist['newsletter'];
                    if (!($exist)) {
                        $request_data['firstname']=$ct->first_name;
                        $request_data['lastname']=$ct->last_name;
                        $request_data['email']=$email;
                        $request_data['password'] = md5(mt_rand(0,10000)); //random password
                        $request_data['loginname'] = uniqid("", true); // loginname must be unique!
                        $request_data['newsletter'] = 1; // sign of subscriber
                        $request_data['status'] = $request_data['approved'] = 0; //disable login ability for subscribers
                        $request_data['customer_group_id'] = $this->model_extension_constantcontact_integration->getSubscribersCustomerGroupId();
                        $this->model_extension_constantcontact_integration->addCustomer($request_data);
                    } elseif ($newsletter==0) {
                        $this->model_extension_constantcontact_integration->syncNewsletter('1',$email);
                    }
                    $stat=$ct->status;
                    if ( $stat=='REMOVED' || $stat=='OPTOUT' || $stat=='UNCONFIRMED' ) {
                        $this->model_extension_constantcontact_integration->syncNewsletter('0',$email);
                    }
                }

                $this->session->data[ 'success' ] = $this->language->get('text_sync_success');
                $this->redirect($this->html->getSecureURL('extension/constantcontact_integration','&extension=constantcontact_integration'));
        }

        $this->document->setTitle($this->language->get('constantcontact_integration_name'));

        $this->document->initBreadcrumb([
            'href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => FALSE
        ]);

        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ]);

        $this->document->addBreadcrumb([
            'href' => $this->html->getSecureURL('extension/constantcontact_integration'),
            'text' => $this->language->get('constantcontact_integration_name'),
            'separator' => ' :: '
        ]);

        $this->view->assign('error_warning', $this->session->data[ 'warning' ]);
        $this->view->assign('success', $this->session->data[ 'success' ]);
        $this->view->assign( 'heading_title', $this->language->get('constantcontact_integration_name'));
        if (isset($this->session->data[ 'success' ])) {
            unset($this->session->data[ 'success' ]);
        }
        if (isset($this->session->data[ 'warning' ])) {

            unset($this->session->data[ 'warning' ]);

        }
        $form = new AForm ( 'ST' );
        $this->data ['action'] = $this->html->getSecureURL ( 'extension/constantcontact_integration' );
        $this->data ['update'] = '';
        $form->setForm ( ['form_name' => 'syncForm', 'update' => $this->data ['update'] ] );
        $this->data['form']['form_open'] = $form->getFieldHtml ( ['type' => 'form', 'name' => 'syncForm', 'action' => $this->data ['action'] ] );
        $this->data['form']['submit'] = $form->getFieldHtml ( ['type' => 'button', 'name' => 'submit', 'text' => $this->language->get ( 'button_go' ), 'style' => 'button1' ] );
        $this->data['form']['cancel'] = $form->getFieldHtml ( ['type' => 'button', 'name' => 'cancel', 'text' => $this->language->get ( 'button_cancel' ), 'style' => 'button2' ] );
        $this->view->assign('text_export',$this->language->get ( 'text_export' ));
        $this->view->assign('text_sync',$this->language->get ( 'text_sync' ));
        $this->view->assign('token',$token);
		$this->data['editor_status'] = $this->verifyEditor();
        $this->data['editor']=$this->config->get('editor_status');
        $this->data['groups'][] = 'additional_settings';
        $this->data['link_additional_settings'] = $this->html->getSecureURL('extension/constantcontact_integration','&extension=constantcontact_integration');
        $this->data['active_group'] = 'additional_settings';

        $tabs_obj = $this->dispatch('pages/extension/extension_tabs', [$this->data] );
        $this->data['tabs'] = $tabs_obj->dispatchGetOutput();
        unset($tabs_obj);

        $obj = $this->dispatch('pages/extension/extension_summary', [$this->data] );
        $this->data['extension_summary'] = $obj->dispatchGetOutput();
        unset($obj);
        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/extension/constantcontact_integration.tpl');
    }

    private function getAllContacts() {
        $cc = new ConstantContact($this->api);
        $token=$this->config->get('constantcontact_integration_access_token');
        $params = ["limit" => "500"];
        $result = $cc->getContacts($token,$params);
        $contacts=$result->results;
        while ($result->next != null) {
            $params = ["limit" => "500"];
            $params = ["next" => $result->next];
            $result = $cc->getContacts($token,$params);
            $contacts=(object)array_merge((array)$contacts,$result->results);
        }
        return $contacts;
    }
}