<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionUpsVerify extends Model {

	public function verifyTaxId() {
		if ( $this->config->get( 'taxid_option_status' ) ) {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'taxid_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = taxidOptionVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyAdvancedReportsStatus() {
		if ( $this->config->get( 'advanced_reports_status' ) === '1' ) {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'advanced_reports_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = advancedReportsVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyPricingCalc() {
		if ($this->config->get('pricing_calculator_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'pricing_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = pricingCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyOptionLink() {
		if ($this->config->get('option_price_link_pro_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'option_link_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = optionLinkVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyAreaCalc() {
		if ( $this->config->get( 'area_calculator_status' ) === '1' ) {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'area_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = areaCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyLengthCalc() {
		if ($this->config->get('length_calculator_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'length_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = lengthCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyLiquidsCalc() {
		if ($this->config->get('liquids_calculator_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'liquids_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = liquidsCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyWeightCalc() {
		if ( $this->config->get( 'weight_calculator_status' ) === '1' ) {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'weight_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = weightCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyVolumeCalc() {
		if ( $this->config->get( 'volume_calculator_status' ) === '1' ) {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'volume_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = volumeCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyBuildAGift() {
		if ($this->config->get('build_a_gift_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'build_a_gift_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = buildAGiftVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
}