<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2017 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

class ModelExtensionEnhancedAdmin extends Model
{

    public $data = [];
    private $error = [];

    public function getRssFeed() {
    	$total=0;
        $output = [];
        $result =$this->db->query("SELECT COUNT(id) as count
									FROM " . $this->db->table("rss_feed") . "
									WHERE `viewed` < 1 AND `deleted` = 0");
        foreach ($result->rows as $row) {
            $output['count'][$row['status']] = ( int )$row['count'];
            $total += ( int )$row['count'];
        }

        $output['total'] = $total;

        //get last couple of messages for each type
        $result = $this->db->query(
            "(SELECT id, title, link, description, viewed, date_created
				FROM " . $this->db->table('rss_feed') . " WHERE `deleted` <> 1
					ORDER BY date_created DESC
					LIMIT 0,3)");
        $output['shortlist'] = $result->rows;

        return $output;
    }

    public function getFeed($id) {
        $this->markAsRead($id);
        $query = $this->db->query("SELECT * FROM " . $this->db->table("rss_feed") . " WHERE id = " . (int)$id);
        $row = $query->row;
        if ($row) {
            // replace html-links in message
            $row['description'] = $this->html->convertLinks($row['description'], 'description');
        }
        return $row;
    }

    /**
     * @param int $start
     * @param int $limit
     * @param string $sort
     * @param string $order
     * @return array
     */
    public function getFeeds($start = 0, $limit = 0, $sort = '', $order = 'DESC') {
        $sort = !$sort ? 'viewed' : $this->db->escape($sort);
        $limit_str = '';
        if ($limit > 0) {
            $limit_str = "LIMIT " . (int)$start . ", " . (int)$limit;
        }
        $sql = "SELECT * FROM " . $this->db->table("rss_feed") . " WHERE `deleted` <> 1 ORDER BY " . $sort . " " . $order . ", date_created DESC, id DESC " . $limit_str;
        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @return int
     */
    public function getTotalFeeds() {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . $this->db->table("rss_feed") . " WHERE `deleted` <> 1 ");
        return (int)$query->row['total'];
    }

    /**
     * @param int $msg_id
     */
    public function deleteFeed($id) {
        $this->db->query("UPDATE " . $this->db->table("rss_feed") . " set `deleted` = 1 WHERE `id` = " . (int)$id);
    }

    /**
     * @param int $msg_id
     * @return bool
     */
    public function markAsRead($id) {
        $this->db->query("UPDATE " . $this->db->table("rss_feed") . " SET viewed = viewed + 1 WHERE `id` = '" . (int)$id . "'");
        return true;
    }

    /**
     * @param $resource_id
     * @param $title
     * @return int
     */
    public function addRmProject($resource_id,$title) {
        $sql = "INSERT INTO `" . DB_PREFIX . "enhanced_admin_tmp`
				(`id`,`title`)
				VALUES ('" . $resource_id . "',
				        '" . $title . "')";
        $this->db->query($sql);
        $project_id=$this->db->getLastId();
        return $project_id;
    }

    /**
     * @param $block
     * @param $key
     * @param $value
     * @return int
     */
    public function updateLang($block,$key,$value) {
        $language_id = $this->language->getLanguageID();
        $sql = "UPDATE ".$this->db->table("language_definitions")." SET language_value='".addslashes(html_entity_decode($value))."' WHERE `block`='".$block."' AND `language_key`='".$key."' AND `language_id`=".(int)$language_id." AND `section`=0";
        $this->db->query($sql);
        $this->cache->remove('localization');
        return $this->db->getLastId();
    }

    /**
     * @param $block
     * @param $key
     * @return mixed
     */
    public function getLang($block,$key) {
        $sql = "SELECT language_value FROM ".$this->db->table("language_definitions")." WHERE `block`='".$block."' AND `language_key`='".$key."'";
        $result = $this->db->query($sql);
        return $result->row['language_value'];
    }

    /**
     * @param $block
     * @param $key
     * @return mixed
     */
    public function getDefaultLang($block,$key) {
        $sql = "SELECT language_value FROM ".$this->db->table("enhanced_admin_language_backup")." WHERE `block`='".$block."' AND `language_key`='".$key."'";
        $result = $this->db->query($sql);
        return $result->row['language_value'];
    }

}