<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2017 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}


/**
 * Class ControllerPagesExtensionEnhancedAdmin
 * @property ModelExtensionEnhancedAdmin $model_extension_enhanced_admin
 */

class ControllerPagesExtensionEnhancedAdmin extends AController {
    private $error = [];
    private $errors = ['user_id', 'postcode'];
    public $data = [];
    private $fields = [
        'enhanced_admin_project_url',
        'enhanced_admin_doc_url',
        'enhanced_admin_support_url',
    ];

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this,__FUNCTION__);
        $this->request->get['extension'] = 'enhanced_admin';
        $this->loadLanguage('enhanced_admin/enhanced_admin');
        $this->loadLanguage('extension/extensions');
        $this->document->setTitle( $this->language->get('text_additional_settings') );
        $this->load->model('setting/setting');
        $this->loadModel('extension/enhanced_admin');

        if ( $this->request->is_POST() && $this->_validate()) {
            $this->model_extension_enhanced_admin->updateLang('account_success','text_message',$this->request->post['text_message']);
            $this->model_extension_enhanced_admin->updateLang('account_success','text_approval',$this->request->post['text_approval']);
            $this->model_extension_enhanced_admin->updateLang('account_success','text_activate',$this->request->post['text_activate']);
            $this->model_setting_setting->editSetting('enhanced_admin', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->redirect($this->html->getSecureURL('extension/enhanced_admin'));
        }

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }
        $this->data['success'] = $this->session->data['success'];
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb( [
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ]);
        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('extension/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ]);
        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('extension/enhanced_admin'),
            'text'      => $this->language->get('enhanced_admin_name'),
            'separator' => ' :: ',
            'current'   => true
        ]);

        $this->view->assign('addition_note',$this->language->get('enhanced_admin_addition_note'));

        foreach ( $this->fields as $f ) {
            if (isset ( $this->request->post [$f] )) {
                $this->data [$f] = $this->request->post [$f];
            } else {
                $this->data [$f] = $this->config->get($f);
            }
        }

        $this->data ['action'] = $this->html->getSecureURL ( 'extension/enhanced_admin', '&extension=enhanced_admin' );
        $this->data['cancel'] = $this->html->getSecureURL('extension/enhanced_admin');
        $this->data ['heading_title'] = $this->language->get ( 'text_additional_settings' );
        $this->data ['form_title'] = $this->language->get ( 'enhanced_admin_name' );
        $this->data ['update'] = $this->html->getSecureURL ( 'r/extension/enhanced_admin_save/update' );

        $form = new AForm ( 'HS' );
        $form->setForm ( ['form_name' => 'editFrm', 'update' => $this->data ['update'] ]);

        $this->data['form']['form_open'] = $form->getFieldHtml ( [
            'type' => 'form',
            'name' => 'editFrm',
            'action' => $this->data ['action'],
            'attr' => 'data-confirm-exit="true" class="aform form-horizontal"'
        ]);
        $this->data['form']['submit'] = $form->getFieldHtml ( [
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get ( 'button_save' )
        ]);

        $this->data['form']['cancel'] = $form->getFieldHtml ( [
            'type' => 'button',
            'name' => 'cancel',
            'text' => $this->language->get ( 'button_cancel' )
        ]);
        $this->data['form']['restore'] = $form->getFieldHtml ( [
            'type' => 'button',
            'name' => 'restore',
            'text' => $this->language->get ( 'button_restore' )
        ]);
        $master_id=$this->user->getUserGroupId();
        if ($master_id==1) {
            $this->data['form']['fields']['feed_url'] = $form->getFieldHtml([
                'type' => 'input',
                'name' => 'enhanced_admin_feed_url',
                'value' => $this->config->get('enhanced_admin_feed_url'),
                'style' => 'large-field',
            ]);
        }
        $this->data['form']['fields']['bottom_sf'] = $form->getFieldHtml([
            'type' => 'textarea',
            'name' => 'enhanced_admin_bottom_sf',
            'value' => $this->config->get('enhanced_admin_bottom_sf'),
            'style'  => 'xl-field',
        ]);
        $this->data['form']['fields']['copyright_year'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'enhanced_admin_copyright_year',
            'value' => $this->config->get('enhanced_admin_copyright_year'),
            'style'  => 'large-field',
        ]);

        $text_message = $this->model_extension_enhanced_admin->getLang('account_success','text_message');
        $text_approval = $this->model_extension_enhanced_admin->getLang('account_success','text_approval');
        $text_activate = $this->model_extension_enhanced_admin->getLang('account_success','text_activate');

        $this->data['form']['fields']['text_message'] = $form->getFieldHtml([
            'type' => 'texteditor',
            'name' => 'text_message',
            'value' => $text_message,
        ]);

        $this->data['text_message_url'] = $this->html->getSecureURL('extension/enhanced_admin/restore','&method=restore&key=text_message');

        $this->data['form']['fields']['text_approval'] = $form->getFieldHtml([
            'type' => 'texteditor',
            'name' => 'text_approval',
            'value' => $text_approval,
        ]);

        $this->data['text_approval_url'] = $this->html->getSecureURL('extension/enhanced_admin/restore','&method=restore&key=text_approval');

        $this->data['form']['fields']['text_activate'] = $form->getFieldHtml([
            'type' => 'texteditor',
            'name' => 'text_activate',
            'value' => $text_activate,
        ]);

        $this->data['button_restore'] = $this->language->get('button_restore');

        $this->data['text_activate_url'] = $this->html->getSecureURL('extension/enhanced_admin/restore','&method=restore&key=text_activate');

        $this->data['text_info'] = $this->language->get('text_info');

        $this->addChild(
            'responses/common/resource_library/get_resources_html', 'resources_html',
            'responses/common/resource_library_scripts.tpl'
        );
        $resources_scripts = $this->dispatch(
            'responses/common/resource_library/get_resources_scripts',
            [
                'object_name' => '',
                'object_id'   => '',
                'types'       => ['image'],
            ]
        );
        $this->data['resources_scripts'] = $resources_scripts->dispatchGetOutput();
        $this->data['rl'] = $this->html->getSecureURL(
            'common/resource_library',
            '&action=list_library&object_name=&object_id&type=image&mode=single'
        );

        //load tabs controller

        $this->data['groups'][] = 'additional_settings';
        $this->data['link_additional_settings'] = '';
        $this->data['active_group'] = 'additional_settings';
        //$this->data['button_restore']=$this->language->get('fs_button_restore');
        $tabs_obj = $this->dispatch('pages/extension/extension_tabs', [$this->data]);
        $this->data['tabs'] = $tabs_obj->dispatchGetOutput();
        unset($tabs_obj);

        $obj = $this->dispatch('pages/extension/extension_summary', [$this->data]);
        $this->data['extension_summary'] = $obj->dispatchGetOutput();
        unset($obj);

        $this->view->batchAssign( $this->data );

        $this->processTemplate('pages/extension/enhanced_admin.tpl');

        //update controller data
        $this->extensions->hk_UpdateData($this,__FUNCTION__);
    }

    public function restore() {
        $this->load->model('extension/enhanced_admin');
        $data = $this->request->get;
        $method = $data['method'];
        $key = $data['key'];
        if ($method==='restore') {
            $default_lang = $this->model_extension_enhanced_admin->getDefaultLang('account_success',$key);
            $this->model_extension_enhanced_admin->updateLang('account_success',$key,$default_lang);
            redirect($this->html->getSecureURL('extension/enhanced_admin'));
        }
    }


    public function delete() {
        $id = $this->request->get ['id'];
        $this->load->model('extension/enhanced_admin');
        if ( $id ) {
            $this->model_extension_enhanced_admin->deleteFeed($id);
        }
    }

    private function _validate() {
        if (!$this->user->canModify('extension/enhanced_admin')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

}