<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$describe="DESCRIBE ".$this->db->table('email_editor_templates')." section";
$results=$this->db->query($describe);
if (strtolower($results->row['Type'])==='varchar(32)') {
    $alter = "ALTER table " . $this->db->table( 'email_editor_templates' ) . " MODIFY COLUMN `section` VARCHAR(256) NOT NULL";
    $this->db->query( $alter );
}

$account_approved_subject='Welcome, {store_name} ';
$account_approved_content='Welcome and thank you for registering at {store_name}<br><br>';
$account_approved_content.='Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:<br/>
            <a href="{login_url}">{login_url}</a><br/><br/>
            Once you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.';
$account_approved_content.='Thank you.<br/>{store_name}';

$account_approved = $this->db->query("SELECT COUNT(*) as exist FROM ".$this->db->table('email_editor_templates')." WHERE `section` = 'account_approved'");
$exist = $account_approved->row['exist'];

if ($exist === 0) {
    $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`email_template_id`=14,
`sender_name`='',`sender_email`='',`section` = 'account_approved', 
`subject`='" . $this->db->escape($account_approved_subject) . "', 
`default_subject`='" . $this->db->escape($account_approved_subject) . "' , 
`content` = '" . $this->db->escape($account_approved_content) . "', 
`default_content` = '" . $this->db->escape($account_approved_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

    $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_account_approved_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

    $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_account_approved_subject','Account Approved Email Subject:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

    $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_account_approved_content','Account Approved Email Content:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");
}

if (file_exists(DIR_EXT.'quick_checkout') && $this->config->get('quick_checkout_status')==='1') {
    $query = $this->db->query("SELECT COUNT(*) as exist FROM " . $this->db->table('email_editor_templates') . " WHERE section='quick_checkout_account_create'");
    $exist = $query->row['exist'];

    if ($exist === 0) {
        $quick_checkout_account_create_subject = 'Welcome, {store_name} ';
        $quick_checkout_account_create_content = 'Welcome and thank you for registering at {store_name}<br><br>';
        $quick_checkout_account_create_content .= 'Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:<br/>
            <a href="{login_url}">{login_url}</a><br/>
            Once you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.<br>';
        $quick_checkout_account_create_content .= "Your Login Name: {login} <br/>
                               Your Password: {password} <br/><br/>";
        $quick_checkout_account_create_content .= 'Thank you.<br/>{store_name}';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
                    `email_template_id`=15,
                    `sender_name`='',`sender_email`='',`section` = 'quick_checkout_account_create', 
                    `subject`='" . $this->db->escape($quick_checkout_account_create_subject) . "', 
                    `default_subject`='" . $this->db->escape($quick_checkout_account_create_subject) . "' , 
                    `content` = '" . $this->db->escape($quick_checkout_account_create_content) . "', 
                    `default_content` = '" . $this->db->escape($quick_checkout_account_create_content) . "',`email_signature_id` = 0,
                    `notify_admin`=0
                    ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }
}

if (file_exists(DIR_EXT.'customer_group_auto_assigned') && $this->config->get('customer_group_auto_assigned_status')) {
    $sql2='CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_customer_group') . ' (
`email_editor_customer_group_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`email_template_id` int(11),
`customer_group_id` int(11),
`section_name` VARCHAR(256)
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

    $this->db->query($sql2);

    $query_customer_groups = $this->db->query("SELECT * FROM ".$this->db->table("customer_groups"));
    $customer_groups = $query_customer_groups->rows;
    $email_id = 16;
    foreach ($customer_groups as $cust_group) {
        $search = [" ","'",];
        $replace = "_";
        $section = str_replace($search,$replace,strtolower($cust_group['name']));

        $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_create'");
        if ($account_activated_exist->row['total']==='0') {
            $account_activated = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_create'");
            $account_activated_info = $account_activated->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `email_template_id`=".$email_id.", `section` = '".$section."_account_create', 
                          `sender_name`='".$account_activated_info['sender_name']."',`sender_email`='".$account_activated_info['sender_email']."',`subject`='".$account_activated_info['subject']."', 
                          `default_subject`='".$account_activated_info['default_subject']."',
                          `content` = '".$account_activated_info['content']."', 
                          `default_content` = '".$account_activated_info['default_content']."',`email_signature_id` = '".$account_activated_info['email_signature_id']."',
                          `notify_admin`='".$account_activated_info['notify_admin']."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$email_id.",`customer_group_id`=".$cust_group['customer_group_id'].",`section_name`='".$section."'");
        }

        $email_id ++;
        $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_approval'");
        if ($account_approval_exist->row['total']==='0') {
            $account_approval = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_approval'");
            $account_approval_info = $account_approval->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `email_template_id`=".$email_id.", `section` = '".$section."_account_approval', 
                          `sender_name`='".$account_approval_info['sender_name']."',`sender_email`='".$account_approval_info['sender_email']."',`subject`='".$account_approval_info['subject']."', 
                          `default_subject`='".$account_approval_info['default_subject']."',
                          `content` = '".$account_approval_info['content']."', 
                          `default_content` = '".$account_approval_info['default_content']."',`email_signature_id` = '".$account_approval_info['email_signature_id']."',
                          `notify_admin`='".$account_approval_info['notify_admin']."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$email_id.",`customer_group_id`=".$cust_group['customer_group_id'].",`section_name`='".$section."'");
        }
        $email_id ++;
        $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_activation'");
        if ($account_activation_exist->row['total']==='0') {

            $account_activation = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_activation'");
            $account_activation_info = $account_activation->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `email_template_id`=".$email_id.", `section` = '".$section."_account_activation', 
                          `sender_name`='".$account_activation_info['sender_name']."',`sender_email`='".$account_activation_info['sender_email']."',`subject`='".$account_activation_info['subject']."', 
                          `default_subject`='".$account_activation_info['default_subject']."',
                          `content` = '".$account_activation_info['content']."', 
                          `default_content` = '".$account_activation_info['default_content']."',`email_signature_id` = '".$account_activation_info['email_signature_id']."',
                          `notify_admin`='".$account_activation_info['notify_admin']."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$email_id.",`customer_group_id`=".$cust_group['customer_group_id'].",`section_name`='".$section."'");
        }

        $email_id ++;
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_create_info'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_create_subject'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_create_content'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_activation_info'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_activation_subject'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_activation_content'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_approval_info'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_approval_subject'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_approval_content'");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_create_subject','Account Create Email Subject:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_create_content','Account Create Email Content:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_activation_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {activate_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_activation_subject','Account Activation Email Subject:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_activation_content','Account Activation Email Content:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_approval_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_approval_subject','Account Needs Approval Email Subject:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_approval_content','Account Needs Approval Email Content:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

    }
}

$sql = "UPDATE ".$this->db->table('language_definitions')." set language_value='
        This is a WHY2 extension.  All support and updates are managed from WHY2. <br>
        Read about WHY2\'s 12 months support <a href=\"https://why2central.net/knowledgebase/why2-support-and-updates-policy/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> and how WHY2 updates are delivered <a href=\"https://why2central.net/knowledgebase/extension-updater/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br>
        You can safely ignore Support expired notification within the Admin Dashboard.<br><br>
        Need help with this extension- please submit a support ticket <a href=\"https://wehearyou2.com/clientarea/client/login/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br><br>
        This extension gives you :<br>
        1.&nbsp;The ability to modify email content without the need to edit the language definition or position. Allows you to use more than one email address for sending of different email notifications, eg  orders@mystore,  info@mystore. Also, you can select to receive an exact copy of the email that was sent to your customer.<br>
        2.&nbsp;Add package tracking information in <a href=\"#admin#rt=sale/order\">admin -> sales -> orders -> order details</a>.<br>
        <strong>Currently our extension automatically convert the following shipper company tracking URL into clickable link:<br>
        A.&nbsp;Australia Post.<br>
        B.&nbsp;Canada Post.<br>
        C.&nbsp;FedEx.<br>
        D.&nbsp;Purolator.<br>
        E.&nbsp;Parcel Force.<br>
        F.&nbsp;Royal Mail.<br>
        G.&nbsp;UPS.<br>
        H.&nbsp;USPS.<br>
        Want us to support a new courier? <a href=\"https://wehearyou2.com/clientarea/client/login/\" target=\"_blank\" style=\"font-weight:bold;\">Contact us</a><br><br>
        Notes: There are two ways to obtain the license code. <br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Use this <a href=\"https://wehearyou2.com/clientarea/reg/register.php\" target=\"_blank\" style=\"font-weight:bold;\">form</a> to register to our Support system and generate your license code.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Already registered -  click <a href=\"https://wehearyou2.com/clientarea/reg/index.php\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to log into your account to obtain license code.<br>
        Refer to our <a href=\"https://why2central.net/faq/license-code/\" target=\"_BLANK\">F.A.Q</a> for more information on how to obtain the license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. If you already have an account in our support system and you are using multiple extensions from WHY2,  you do NOT need to create another account in the support system.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Updating extension in same location does NOT require a new key.<br>Refer to our <a href=\"https://why2central.net/faq/license-code/\" target=\"_BLANK\">F.A.Q</a> for more information on how to Update extension in same location.</strong><br><br>
        1.&nbsp;Enter your WHY2 license code here.<br>
        2.&nbsp;Append Comments: Turn ON to append comments in order history.<br>
        3.&nbsp;Notify Customer: Turn ON if you want to notify your customer when you add tracking details.' WHERE language_key='email_editor_note';";
$this->db->query($sql);

$sql1 = "UPDATE ".$this->db->table('language_definitions')." set language_value='Enter your WHY2 license code:' WHERE language_key='email_editor_license_code';";
$this->db->query($sql1);

$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("email_editor_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_new_email_editor_version_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_new_email_editor_version_description'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_update_success'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_update_failed'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='button_start_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='button_cancel_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_update_email_editor_note'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_email_editor_updater_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_changelog'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_no_updates'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='button_go_back'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_new_email_editor_version_title','New version (v[new_version]) of Email Editor Extension',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_new_email_editor_version_description','There is a new version of Email Editor Extension. Please open -->#admin#rt=extension/email_editor_updater&version=[version_number] to update the extension. <br><br>
                        The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.<br><br>
                        Do not delete this message until you have updated.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_update_success','The Email Editor extension has been successfully updated.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_update_failed','We are unable to update the Email Editor extension, please check <a target=\"_BLANK\" href=\"#admin#rt=tool/error_log\">error log</a> for more information.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','button_start_update','Start Update',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','button_cancel_update','Cancel Update',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_update_email_editor_note','Note:<br>We are going to update Email Editor extension. The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_email_editor_updater_heading_title', 'Email Editor Updater',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_changelog','Changelog:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_no_updates','There are no new updates for this extension.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','button_go_back','Go Back',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");


$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_quick_checkout_account_create_subject'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_quick_checkout_account_create_content'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_quick_checkout_account_create_info'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_quick_checkout_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}, {login} and {password}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_quick_checkout_account_create_subject','Quick Checkout Account Create Email Subject:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_quick_checkout_account_create_content','Quick Checkout Account Create Email Content:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

$this->db->query("UPDATE ".$this->db->table("language_definitions")." SET `language_value`='Cancel' WHERE `language_key`='button_cancel' AND `block`='email_editor_email_editor'");

if (file_exists(DIR_EXT.'delivery_scheduler') && $this->config->get('delivery_scheduler_status')==='1') {
    $order_status_update = $this->db->query("SELECT `content` FROM ". $this->db->table('email_editor_templates')." WHERE `section`='order_status_update'");
    $order_status_update_content = $order_status_update->row['content'];
    $new_order_status_update_content = str_replace('[The comments for your order are:]','[The comments or special delivery instructions for your order are:]',$order_status_update_content);
    $this->db->query("UPDATE ". $this->db->table('email_editor_templates')." SET `content` ='".$new_order_status_update_content."' WHERE `section`='order_status_update'");

    $order_confirmation_ = $this->db->query("SELECT `content` FROM ". $this->db->table('email_editor_templates')." WHERE `section`='order_confirmation'");
    $order_confirmation_content = $order_confirmation_->row['content'];
    $new_order_confirmation_content = str_replace('[The comments for your order are:]','[The comments or special delivery instructions for your order are:]',$order_status_update_content);
    $this->db->query("UPDATE ". $this->db->table('email_editor_templates')." SET `content` ='".$new_order_confirmation_content."' WHERE `section`='order_confirmation'");
}

if (file_exists(DIR_EXT.'customer_group_auto_assigned') && $this->config->get('customer_group_auto_assigned_status')) {
    $sql2='CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_customer_group') . ' (
`email_editor_customer_group_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`email_template_id` int(11),
`customer_group_id` int(11),
`section_name` VARCHAR(256)
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

    $this->db->query($sql2);

    $query_customer_groups = $this->db->query("SELECT * FROM ".$this->db->table("customer_groups"));
    $customer_groups = $query_customer_groups->rows;
    $email_id = 16;
    foreach ($customer_groups as $cust_group) {
        $search = [" ","'",];
        $replace = "_";
        $section = str_replace($search,$replace,strtolower($cust_group['name']));

        $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_create'");
        if ($account_activated_exist->row['total']==='0') {
            $account_activated = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_create'");
            $account_activated_info = $account_activated->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `email_template_id`=".$email_id.", `section` = '".$section."_account_create', 
                          `sender_name`='".$account_activated_info['sender_name']."',`sender_email`='".$account_activated_info['sender_email']."',`subject`='".$account_activated_info['subject']."', 
                          `default_subject`='".$account_activated_info['default_subject']."',
                          `content` = '".$account_activated_info['content']."', 
                          `default_content` = '".$account_activated_info['default_content']."',`email_signature_id` = '".$account_activated_info['email_signature_id']."',
                          `notify_admin`='".$account_activated_info['notify_admin']."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$email_id.",`customer_group_id`=".$cust_group['customer_group_id'].",`section_name`='".$section."'");
        }

        $email_id ++;
        $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_approval'");
        if ($account_approval_exist->row['total']==='0') {
            $account_approval = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_approval'");
            $account_approval_info = $account_approval->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `email_template_id`=".$email_id.", `section` = '".$section."_account_approval', 
                          `sender_name`='".$account_approval_info['sender_name']."',`sender_email`='".$account_approval_info['sender_email']."',`subject`='".$account_approval_info['subject']."', 
                          `default_subject`='".$account_approval_info['default_subject']."',
                          `content` = '".$account_approval_info['content']."', 
                          `default_content` = '".$account_approval_info['default_content']."',`email_signature_id` = '".$account_approval_info['email_signature_id']."',
                          `notify_admin`='".$account_approval_info['notify_admin']."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$email_id.",`customer_group_id`=".$cust_group['customer_group_id'].",`section_name`='".$section."'");
        }
        $email_id ++;
        $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_activation'");
        if ($account_activation_exist->row['total']==='0') {

            $account_activation = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_activation'");
            $account_activation_info = $account_activation->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `email_template_id`=".$email_id.", `section` = '".$section."_account_activation', 
                          `sender_name`='".$account_activation_info['sender_name']."',`sender_email`='".$account_activation_info['sender_email']."',`subject`='".$account_activation_info['subject']."', 
                          `default_subject`='".$account_activation_info['default_subject']."',
                          `content` = '".$account_activation_info['content']."', 
                          `default_content` = '".$account_activation_info['default_content']."',`email_signature_id` = '".$account_activation_info['email_signature_id']."',
                          `notify_admin`='".$account_activation_info['notify_admin']."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$email_id.",`customer_group_id`=".$cust_group['customer_group_id'].",`section_name`='".$section."'");
        }

        $email_id ++;
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_create_info'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_create_subject'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_create_content'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_activation_info'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_activation_subject'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_activation_content'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_approval_info'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_approval_subject'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_approval_content'");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_create_subject','Account Create Email Subject:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_create_content','Account Create Email Content:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_activation_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {activate_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_activation_subject','Account Activation Email Subject:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_activation_content','Account Activation Email Content:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_approval_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_approval_subject','Account Needs Approval Email Subject:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_approval_content','Account Needs Approval Email Content:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

    }
}

if (HTTPS===true) {
    $domain = HTTPS_SERVER;
} else {
    $domain = HTTP_SERVER;
}

$message = "Extension updated - notification: Email Editor extension in ".$domain.' was updated to v 1.3.1.';
$mail = new AMail($this->config);
$mail->setTo('installs@wehearyou2.net');
$mail->setFrom('installs@wehearyou2.net');
$mail->setSubject('Extension Updated');
$mail->setSender('Information');
$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
$mail->send();