<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT. "email_editor" . DIR_EXT_CORE ."helpers.php";

/**
 * Class ControllerPagesExtensionEmailTemplates
 * @property ModelExtensionEmailTemplates $model_extension_email_templates
 * @property ModelExtensionEmailSignatures $model_extension_email_signatures
 */


class ControllerPagesExtensionEmailTemplates extends AController {
    public $data=[];
    public $error=[];

    public function verify() {
    	$validation = emailEditorVerifyLicense();
    	if ($validation['notification_case']==='notification_license_ok') {
    		return true;
    	} elseif($validation['notification_case']==='notification_license_corrupted') {
    		return false;
    	}
    }

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->load->language('email_editor/email_editor');

        $this->document->setTitle( $this->language->get('heading_email_template_list') );

        $this->document->initBreadcrumb( [
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ]);
        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('extension/email_templates'),
            'text'      => $this->language->get('heading_email_template_list'),
            'separator' => ' :: ',
            'current' => true,
        ]);

        $grid_settings = ['table_id' => 'email_templates_grid',
            'url' => $this->html->getSecureURL('listing_grid/email_templates_list'),
            'editurl' => '',
            'update_field' => $this->html->getSecureURL('listing_grid/email_templates_list/update_field'),
            'sortname' => 'date_modified',
            'sortorder' => 'desc',
            'columns_search' => false,
            'actions' => [
                'edit' => [
                    'text' => $this->language->get('text_edit'),
                    'href' => $this->html->getSecureURL('extension/email_templates/edit', '&id=%ID%')
                ],
            ],
        ];

        $form = new AForm ();
        $form->setForm(['form_name' => 'email_templates_grid_grid_search']);

        $grid_settings['colNames'] = [$this->language->get('column_email_template_id'),
            $this->language->get('column_email_template_section')];
        $grid_settings['multiselect'] = "false";
        $grid_settings['multiaction'] = "false";

        $grid_settings['colModel'] = [
            ['name' => 'id',
            'index' => 'id',
            'width' => 20,
            'align' => 'center',
            'search' => false],
            ['name' => 'editor_section',
                'index' => 'section',
                'width' => 110,
                'align' => 'center',
            ]
        ];

        $grid = $this->dispatch('common/listing_grid', [$grid_settings]);
        $this->data['listing_grid'] = $grid->dispatchGetOutput();

        if (isset ($this->session->data['warning'])) {
            $this->data['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data ['error_warning'] = '';
        }

        if (isset ($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];
            $this->session->data['success'] = '';
        } else {
            $this->data ['success'] = '';
        }

	    $this->data['license_status'] = $this->verify();
	    //$this->data['license_status'] = true;
	    $this->data['text_unauthorized'] = $this->language->get('text_email_editor_unauthorized');

        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->processTemplate('pages/extension/email_templates.tpl');
    }

    public function edit() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadModel('extension/email_templates');
        $this->loadModel('extension/email_signatures');
        $this->loadLanguage('email_editor/email_editor');
        $this->document->setTitle($this->language->get('heading_edit_template_name'));
        $this->data['heading_title'] = $this->language->get('heading_edit_template_name');
        $email_id = (int)$this->request->get['id'];
        if (isset($this->request->get['reset'])) {
            $reset = true;
        } else {
            $reset = false;
        }
        // saving

        if ($this->request->is_POST() && $this->_validateEditForm() && $email_id) {
            $this->loadModel('extension/email_templates');
            $dir = HTTPS ? HTTPS_SERVER : HTTP_SERVER;
            $content = html_entity_decode($this->request->post['content']);
            $search = ['<img src="resources'];
            $replace = ['<img src="'.$dir.'resources'];
            $this->request->post['content'] = htmlentities(str_replace($search,$replace,$content));

            $this->model_extension_email_templates->updateTemplate($email_id, $this->request->post);
            $this->session->data ['success'] = $this->language->get('text_email_template_update_success');
            $this->redirect($this->html->getSecureURL('extension/email_templates/edit', '&id=' . $email_id));
        }
        $this->data['error'] = $this->error;
        $info = $this->model_extension_email_templates->getTemplate($email_id,$reset);
        foreach ($info as $k => $v) {
            $this->data[$k] = $v;
        }
        $this->_getForm($info['section']);
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function _getForm($type) {
        if (isset ($this->session->data['warning'])) {
            $this->data ['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data ['error_warning'] = '';
        }
        $this->view->assign('success', $this->session->data['success']);

        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb(['href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => FALSE]);

        $this->document->addBreadcrumb(['href' => $this->html->getSecureURL('extension/email_templates'),
            'text' => $this->language->get('email_editor_name'),
            'separator' => ' :: ']);

        $this->data ['cancel'] = $this->html->getSecureURL('extension/email_templates');
        $this->data ['reset'] = $this->html->getSecureURL('extension/email_templates/edit', '&id=' . $this->request->get ['id'].'&reset=true');
        $this->data ['action'] = $this->html->getSecureURL('extension/email_templates/edit', '&id=' . $this->request->get ['id']);
        $this->data ['form_title'] = $this->language->get('text_edit_email_template') . ' ' . $this->data['section'];
        $this->data ['update'] = $this->html->getSecureURL('listing_grid/email_templates_list/update_field', '&id=' . $this->request->get ['id']);
        $form = new AForm ('HS');

        $this->document->addBreadcrumb(
            ['href' => $this->data['action'],
                'text' => $this->data ['form_title'],
                'separator' => ' :: ',
                'current' => true
            ]);

        $form->setForm(['form_name' => 'EmailEditorFrm', 'update' => $this->data ['update']]);

        $this->data['form']['form_open'] = $form->getFieldHtml(
            ['type' => 'form',
                'name' => 'EmailEditorFrm',
                'attr' => 'data-confirm-exit="true" class="aform form-horizontal"',
                'action' => $this->data ['action']]);

        $this->data['form']['submit'] = $form->getFieldHtml(
            ['type' => 'button',
                'name' => 'submit',
                'text' => $this->language->get('button_save')]
        );

        $this->data['form']['reset'] = $form->getFieldHtml(
            ['type' => 'button',
                'name' => 'reset',
                'text' => $this->language->get('button_reset')]
        );

	    if ( $type !== 'shipping_info' && $type!=='local_shipping_info' && $type!=='store_pickup_info') {
		    $this->data['form']['preview'] = $form->getFieldHtml(
			    [
				    'type' => 'button',
				    'name' => 'preview',
				    'text' => $this->language->get( 'button_preview' )
			    ] );
	    }

        $this->data['form']['cancel'] = $form->getFieldHtml(
            ['type' => 'button',
                'name' => 'cancel',
                'text' => $this->language->get('button_cancel')
            ]
        );

	    if ($type==='order_confirmation') {
	        $this->data['admin_order_note'] = $this->language->get('text_admin_order_note');
        } else {
	        $this->data['admin_order_note'] = '';
        }

	    if ( $type !== 'shipping_info' && $type!=='local_shipping_info' && $type!=='store_pickup_info') {
	        if ($type!=='quick_checkout_account_create') {
                $this->data['form']['fields']['notify_admin'] = $form->getFieldHtml([
                    'type' => 'checkbox',
                    'name' => 'notify_admin',
                    'value' => $this->data['notify_admin'],
                    'style' => 'btn_switch',
                ]);

                $this->data['form']['text']['notify_admin'] = $this->language->get('text_notify_admin');
            }

		    $this->data['form']['fields']['sender_name'] = $form->getFieldHtml( [
			    'type'     => 'input',
			    'name'     => 'sender_name',
			    'value'    => $this->data['sender_name'],
			    'required' => false
		    ] );
		    $this->data['form']['text']['sender_name']   = $this->language->get( 'text_sender_name' );

		    $this->data['form']['fields']['sender_email'] = $form->getFieldHtml( [
			    'type'     => 'input',
			    'name'     => 'sender_email',
			    'value'    => $this->data['sender_email'],
			    'required' => false
		    ] );
		    $this->data['form']['text']['sender_email']   = $this->language->get( 'text_sender_email' );

		    $this->data['form']['fields']['subject'] = $form->getFieldHtml( [
			    'type'     => 'input',
			    'name'     => 'subject',
			    'value'    => $this->data['subject'],
			    'required' => true
		    ]
            );
		    $this->data['form']['text']['subject']   = $this->language->get( 'text_' . $type . '_subject' );
	    }

        $this->data['form']['fields']['content'] = $form->getFieldHtml([
            'type' => 'texteditor',
            'name' => 'content',
            'value' => $this->data['content'],
            'required' => true]
        );
        $this->data['form']['text']['content'] = $this->language->get('text_'.$type.'_content');

	    if ( $type !== 'shipping_info' && $type!=='local_shipping_info' && $type!=='store_pickup_info') {
		    $email_sigs   = $this->model_extension_email_signatures->getAvailableSignatures();
		    $options['0'] = "NONE";
		    foreach ( $email_sigs as $sigs ) {
			    $options[ $sigs['email_signature_id'] ] = $sigs['title'];
		    }

		    $this->data['form']['fields']['email_signature'] = $form->getFieldHtml( [
			    'type'     => 'selectbox',
			    'name'     => 'email_signature',
			    'options'  => $options,
			    'value'    => $this->data['email_signature_id'],
			    'required' => true
		    ] );
		    $this->data['form']['text']['email_signature']   = $this->language->get( 'text_select_email_signatures' );

		    $this->data['getSignature'] = $this->html->getSecureURL( 'r/extension/email_editor/getSignatureById' );

		    $logo               = $this->dispatch( 'pages/extension/preview_email_logo', [] );
		    $this->data['logo'] = html_entity_decode( $logo->dispatchGetOutput() );
	    }

	    $this->data['tags'] = $this->language->get( 'text_' . $type . '_info' );
		$this->data['type'] = $type;
	    $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);

        $this->addChild('responses/common/resource_library/get_resources_html', 'resources_html',
            'responses/common/resource_library_scripts.tpl');
        $resources_scripts = $this->dispatch(
            'responses/common/resource_library/get_resources_scripts',
            [
                'object_name' => '',
                'object_id'   => '',
                'types'       => ['image'],
            ]
        );
        $this->data['resources_scripts'] = $resources_scripts->dispatchGetOutput();
        $this->data['rl'] = $this->html->getSecureURL('common/resource_library',
            '&action=list_library&object_name=&object_id&type=image&mode=single');

        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);
        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->assign('language_code', $this->session->data['language']);
        $this->processTemplate('pages/extension/email_templates_form.tpl');
    }

    private function _validateEditForm() {
        if (!$this->user->canModify('extension/email_templates')) {
            $this->session->data['warning'] = $this->error ['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post) {
            $required = ['subject', 'content'];
            foreach ($this->request->post as $name => $value) {
                if (in_array($name, $required) && empty($value)) {
                    $this->error ['warning'] = $this->language->get('error_empty');
                    $this->session->data['warning'] = $this->language->get('error_empty');
                    break;
                }
            }
        }
        $this->extensions->hk_ValidateData($this);
        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
}