<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

class ModelOptionPriceProOptions extends Model {
	/**
	 * @param $product_option_id
	 * @param $data
	 *
	 * @return bool
	 */
	public function updateProductOption( $product_option_id, $data ) {
		$fields = array( "sort_order", "status", "required", "calculate", "base_price", "regexp_pattern", "settings" );
		$update = array();
		foreach ( $fields as $f ) {
			if ( isset( $data[ $f ] ) ) {
				if ( $f == 'settings' ) {
					$data[ $f ] = serialize( $data[ $f ] );
				}
				$update[] = $f . " = '" . $this->db->escape( $data[ $f ] ) . "'";
			}
		}
		if ( ! empty( $update ) ) {
			$this->db->query( "UPDATE " . $this->db->table( "product_options" ) . "
								SET " . implode( ',', $update ) . "
								WHERE product_option_id = '" . (int) $product_option_id . "'" );
		}

		if ( ! empty( $data['name'] ) ) {

			$language_id = $this->language->getContentLanguageID();

			$this->language->replaceDescriptions( 'product_option_descriptions',
				array( 'product_option_id' => (int) $product_option_id ),
				array(
					(int) $language_id => array(
						'name'               => $data['name'],
						'error_text'         => $data['error_text'],
						'option_placeholder' => $data['option_placeholder'],
					)
				) );
		}

		$this->cache->remove( 'product' );

		return true;
	}

	/**
	 * @param $option_id
	 * @param array $data
	 */
	public function addSettings( $option_id, $data ) {
		$this->deleteSettings( $option_id );
		$sql = "INSERT INTO " . $this->db->table( 'option_validation' ) . " 
              SET product_option_id=" . (int) $option_id . ",
              minimum=" . (int) $data['minimum'] . ",
              maximum=" . (int) $data['maximum'] . ",
              maximum_status=" . (int) $data['maximum_status'];
		$this->db->query( $sql );
	}

	/**
	 * @param $option_id
	 */
	public function deleteSettings( $option_id ) {
		$sql = "DELETE FROM " . $this->db->table( 'option_validation' ) . " WHERE product_option_id=" . $option_id;
		$this->db->query( $sql );
	}

	/**
	 * @param $option_id
	 *
	 * @return mixed
	 */
	public function getSettings( $option_id ) {
		$sql    = "SELECT `minimum`, `maximum`, `maximum_status` FROM " . $this->db->table( 'option_validation' ) . " WHERE product_option_id=" . $option_id;
		$result = $this->db->query( $sql );

		return $result->row;
	}

	/**
	 * @param $option_id
	 * @param $minimum
	 */
	public function updateMinimumSelection( $option_id, $minimum ) {
		$sql = "UPDATE " . $this->db->table( 'option_validation' ) . " 
              SET minimum=" . (int) $minimum . " WHERE product_option_id=" . (int) $option_id;
		$this->db->query( $sql );
	}

	/**
	 * @param $option_id
	 *
	 * @return mixed
	 */
	public function getOptionType( $option_id ) {
		$sql     = "SELECT element_type FROM " . $this->db->table( 'product_options' ) . " 
              WHERE product_option_id=" . (int) $option_id;
		$results = $this->db->query( $sql );
		$result  = $results->row;

		return $result['element_type'];
	}
}