<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'src/Ctct/autoload.php';

use Ctct\ConstantContact;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\Contacts\EmailAddress;
use Ctct\Exceptions\CtctException;

/**
 * Class ControllerPagesExtensionConstantContactIntegration
 * @property ModelExtensionCtct $model_extension_ctct
 */
class ControllerResponsesBlocksCtct extends AController
{
    public $data = [];
    private $api='9u2zpz9pyxwreaqrhg9bu7ng';
    public function addContact() {
        $token=$this->config->get('constantcontact_integration_access_token');
        $cc = new ConstantContact($this->api);
        $data=$this->_prepareData();
        $check=$cc->getContactByEmail($token,$data['email'])->results;
        $checks=$cc->getContactByEmail($token,$data['email']);
        $this->loadModel('account/customer');
        $this->loadModel('extension/ctct');
        $exist=$this->model_account_customer->getCustomerByEmail($data['email']);
        $this->loadLanguage('blocks/constantcontact_integration');
        $ccStatus=$checks->results[0]->status;
        $status=$this->model_extension_ctct->getNewsletterStatus($data['email']);
        $list_id=$this->config->get('constantcontact_integration_list');
        if (!empty($check) && $exist) {
            if($ccStatus=='ACTIVE' && $status['newsletter']== '1' ) {
                $this->data['status']='Error';
                $this->data['err']=$this->language->get('newsletter_email_exist');
            } else {
                try {
                    $this->model_extension_ctct->updateNewsletter('1',$data['email']);
                    $this->data['status']='Success';
                    $this->data['sccs']=$this->language->get('newsletter_success');
                    $contact = new Contact();
                    $contact->addEmail($data['email']);
                    $contact->addList($list_id);
                    $contact->id = $checks->results[0]->id;
                    $update_contact = $cc->updateContact($token,$contact,true);
                    $this->log->write('Constant Contact Via Sign Up Block Existing Subscriber Response: '.var_export($update_contact,true));
                    $this->log->write('Constant Contact Via Sign Up Block Existing Subscriber Post Data: '.$data['email']);
                }
                catch (CtctException $ex) {
                    $err=$ex->getErrors();
                    $this->log->write('Constant Contact Via Sign Up Block Existing Subscriber Errors: '.var_export($err,true));
                    $this->data['status']='Error';
                    $this->data['err']=$err[0]['error_message'];
                    //$this->log->write('Constant Contact Error: '.$err[0]['error_message']);
                }
            }
        } else{
            try {
                $contact = new Contact();
                $contact->addEmail($data['email']);
                $contact->first_name = $data['firstname'];
                $contact->last_name = $data['lastname'];
                $contact->addList($list_id);
                $add_contact = $cc->addContact($token,$contact,true);
                $this->log->write('Constant Contact Via Sign Up Block New Subscriber Add Contact Response: '.var_export($add_contact,true));
                $request_data['firstname']=$data['firstname'];
                $request_data['lastname']=$data['lastname'];
                $request_data['email']=$data['email'];
                $request_data['password'] = md5(mt_rand(0,10000)); //random password
                $request_data['loginname'] =uniqid("", true); // loginname must be unique!
                $request_data['newsletter'] = 1; // sign of subscriber
                $request_data['status'] = $request_data['approved'] = 0; //disable login ability for subscribers
                $request_data['customer_group_id'] = $this->model_account_customer->getSubscribersCustomerGroupId();
                $request_data['ip'] = $this->request->server['REMOTE_ADDR'];
                $this->model_account_customer->addCustomer($request_data);
                $this->data['status']='Success';
                $this->data['sccs']=$this->language->get('newsletter_success');
            } catch (CtctException $ex) {
                $err=$ex->getErrors();
                $this->log->write('Constant Contact Via Sign Up Block New Subscriber Errors: '.var_export($err,true));
                $this->data['status']='Error';
                $this->data['err']=$err[0]['error_message'];
                //$this->log->write('Constant Contact Error 1:'.$err[0]['error_message']);
            }
        }
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data));
    }

    private function _prepareData() {
        if (isset($this->request->post['data'])) {
            $this->load->library('json');
            $obj = AJson::decode(html_entity_decode($this->request->post['data']));
            $data['firstname']=$obj->firstname;
            $data['email']=$obj->email;
            $data['lastname']=$obj->lastname;
            return $data;
        }
    }
}