<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

   Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerPagesExtensionFeedViewer extends AController {
	
	public function main() {
		//init controller data
		$this->extensions->hk_InitData($this,__FUNCTION__);
		$this->loadLanguage('enhanced_admin/enhanced_admin');
		
		$this->document->setTitle ( $this->language->get ( 'heading_title' ) );
		
		$this->document->initBreadcrumb ();
		$this->document->addBreadcrumb ( [
												'href' => $this->html->getSecureURL ( 'index/home' ),
												'text' => $this->language->get ( 'text_home' ),
												'separator' => FALSE ] );
		$this->document->addBreadcrumb ( [
												'href' => $this->html->getSecureURL ( 'extension/feed_viewer' ),
												'text' => $this->language->get ( 'heading_title' ),
												'separator' => ' :: ',
												'current' => true ] );

		$grid_settings = [
								//id of grid
								'table_id' => 'feed_grid',
								// url to load data from
								'url' => $this->html->getSecureURL ( 'listing_grid/enhanced_admin' ),
								// url to send data for edit / delete
								'editurl' => $this->html->getSecureURL ( 'listing_grid/enhanced_admin/edit' ),
								// url to update one field
								'update_field' => $this->html->getSecureURL ( 'listing_grid/enhanced_admin/update_field' ),
								// default sort column
								'sortname' => 'date_added',
								// actions
								'actions' => [
									'view' => [
										'text' => $this->language->get('text_view'),
										'href' => $this->html->getSecureURL ( 'listing_grid/enhanced_admin/update','&oper=show&id=%ID%')
									],
									'delete' => [
										'text' => $this->language->get('text_delete'),
										'href' => $this->html->getSecureURL ( 'extension/feed_viewer/delete','&id=%ID%')
									],
								],
								'columns_search' => false,
								'sortable' => true,
								'grid_ready' => 'grid_ready();'];

		$grid_settings ['colNames'] = [
											$this->language->get ( 'column_title' ),
											$this->language->get ( 'column_create_date' )];
		$grid_settings ['colModel'] = [
											[
													'name' => 'title',
													'index' => 'title',
													'width' => 350,
													'align' => 'left',
													'sorttype' => 'string' ],
											[
													'name' => 'date_created',
													'index' => 'date_created',
													'width' => 70,
													'align' => 'center',
													'sorttype' => 'string' ] ];

        $grid_settings['multiaction_options']['delete'] = $this->language->get('text_delete_selected');

        $grid = $this->dispatch ( 'common/listing_grid', [$grid_settings] );
		$this->view->assign ( 'listing_grid', $grid->dispatchGetOutput () );

		$this->view->assign ( 'notifier', $this->html->getSecureURL ( 'listing_grid/enhanced_admin/getNotifies' ) );

		$this->view->batchAssign (  $this->language->getASet () );
		$this->view->assign('help_url', $this->gen_help_url() );

        //update controller data
        $this->extensions->hk_UpdateData($this,__FUNCTION__);

		$this->processTemplate ( 'pages/extension/feed_viewer.tpl' );
	}

	public function delete() {
        $id = $this->request->get ['id'];
        $this->load->model('extension/enhanced_admin');
        if ( $id ) {
            $this->model_extension_enhanced_admin->deleteFeed($id);
            $this->redirect($this->html->getSecureURL('extension/feed_viewer'));
        }
    }


}