<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com
  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)
------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT. "telephone_option" . DIR_EXT_CORE ."helpers.php";
require_once DIR_EXT. "telephone_option" . DIR_EXT_CORE ."updater.php";

/**
 * Class ExtensionTelephoneOption
 * @property AController baseObject
 * @property ModelAccountTelephone $model_account_telephone
 */
class ExtensionTelephoneOption extends Extension {
    public $data = array();
    public $errors = array();
    private $error=array();
    protected $registry;

    private $address_fields = array(
        'firstname' => array(
            'type' => 'input',
            'required' => true
        ),
        'lastname' => array(
            'type' => 'input',
            'required' => true
        ),
        'company' => array(
            'type' => 'input',
            'required' => false
        ),
        'address_1' => array(
            'type' => 'input',
            'required' => true
        ),
        'address_2' => array(
            'type' => 'input',
            'required' => false
        ),
        'city' => array(
            'type' => 'input',
            'required' => true
        ),
        'postcode' => array(
            'type' => 'input',
            'required' => false
        ),
        //note! this field is pair of country_id and zone_id
        'country_id' => array(
            'type' => 'zones',
            'required' => true)
    );

    public function  __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get('telephone_option_status') ? $this->verify() : false;
    }

	public function verify() {
		$that =& $this->baseObject;
		$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('telephone_license')."'");
		if ($exist->num_rows === 1) {
			$validation = telephoneVerifyLicense();
			if ( $validation['notification_case'] === 'notification_license_ok' ) {
				return true;
			} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
				return false;
			}
		} else {
			return false;
		}
	}

    public function verifyUpsPlus() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'ups_integration_plus_status' ) === '1' ) {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'ups_integration_plus_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = upsIntegrationPlusVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyOptionPriceLink() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'option_price_link_pro_status' ) === '1' ) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_link_license') . "'");
            if ($exist->num_rows === 1) {
                $validation = optionLinkVerifyLicense();
                if ($validation['notification_case'] === 'notification_license_ok') {
                    return true;
                } elseif ($validation['notification_case'] === 'notification_license_corrupted') {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyAdvancedReports() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'advanced_reports_status' ) === '1' ) {
            $exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('advanced_reports_license')."'");
            if ($exist->num_rows === 1) {
                $validation = advancedReportsVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

	public function onControllerPagesExtensionExtensions_InitData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'edit') {
			$extension=$that->request->get['extension'];
			if ($extension==='telephone_option') {
				if ($that->request->is_POST() ) {
					$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('telephone_license')."'");
					if ($exist->num_rows === 1) {
						if ($this->verify()===true) {
							telephoneUninstallLicense();
						} else {
							$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('telephone_license'));
						}
						telephoneInstallLicense( $that->request->post['telephone_option_license_code'] );
					} else {
						$license = telephoneInstallLicense( $that->request->post['telephone_option_license_code'] );
						if ( $license['notification_case'] !== 'notification_license_ok' ) {
							$that->session->data['error'] = $license['notification_text'];
						} else {
							$that->session->data['success'] = "The license key is valid";
						}
					}
				}
			}
		}
	}

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method==='update') {
			if ($that->request->post['telephone_option_license_code']) {
				$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('telephone_license')."'");
				if ($exist->num_rows === 1) {
					if ($this->verify()===true) {
						telephoneUninstallLicense();
					} else {
						$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('telephone_license'));
					}
					telephoneInstallLicense( $that->request->post['telephone_option_license_code'] );
				} else {
					$license = telephoneInstallLicense( $that->request->post['telephone_option_license_code'] );
					if ( $license['notification_case'] !== 'notification_license_ok' ) {
						$that->session->data['error'] = $license['notification_text'];
					} else {
						$that->session->data['success'] = "The license key is valid";
					}
				}
			}
		}
	}
	
    //Hook Guest Step 1 Validation
    public function onControllerPagesCheckoutGuestStep1_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        $that->loadLanguage( 'checkout/guest_step_1' );
		    $that->loadLanguage( 'account/telephone' );
		    $telephone        = $that->request->post['telephone'];
		    $fax              = $that->request->post['fax'];
		    $company          = $that->request->post['company'];
		    $shipping_company = $that->request->post['shipping_company'];
		    if ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) {
			    if ( empty( $telephone ) || ( mb_strlen( $telephone ) < 3 ) || ( mb_strlen( $telephone ) > 32 ) ) {
				    $that->error['telephone'] = $that->language->get( 'telephone_error' );
			    }
		    }
		    if ( $that->config->get( 'fax_option_mandatory_status' ) === '1'
		         && $that->config->get( 'fax_option_show' ) === '1' ) {
			    if ( empty( $fax ) || ( ( mb_strlen( $fax ) < 3 || mb_strlen( $fax ) > 32 ) && strtolower( $fax ) != 'na' && strtolower( $fax ) != 'none' ) ) {
				    $that->error['fax'] = $that->language->get( 'fax_error' );
			    }
		    }
		    if ( $that->config->get( 'company_option_mandatory_status' ) == '1' ) {
			    if ( $company == '' ) {
				    $that->error['company'] = $that->language->get( 'company_error' );
			    }
			    if ( $that->request->post['shipping_indicator'] ) {
				    if ( $shipping_company == '' ) {
					    $that->error['shipping_company'] = $that->language->get( 'company_error' );
				    }
			    }
		    }
		    if ( count( $that->error ) ) {
			    $that->view->assign( 'error_warning', $that->language->get( 'gen_data_entry_error' ) );
		    }
    }

    public function onControllerPagesCheckoutGuestStep1_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        $form = new AForm();
		    $form->setForm( array( 'form_name' => 'guestFrm' ) );
		    $that->loadLanguage( 'account/telephone' );
		    $field_errors = $that->error;
		    if ( $field_errors ) {
			    foreach ( $field_errors as $key => $field_error ) {
				    $that->view->assign( 'error_' . $key, $field_error );
			    }
		    }

		    $this->data['form']['form_open'] = $form->getFieldHtml(
			    array(
				    'type'   => 'form',
				    'name'   => 'guestFrm',
				    'action' => $that->html->getSecureURL( 'checkout/guest_step_1' ),
				    'csrf'   => true
			    )
		    );

		    if ( isset( $that->request->post['firstname'] ) ) {
			    $firstname = $that->request->post['firstname'];
		    } elseif ( isset( $that->session->data['guest']['firstname'] ) ) {
			    $firstname = $that->session->data['guest']['firstname'];
		    } else {
			    $firstname = '';
		    }

		    $this->data['form']['fields']['general']['firstname'] = $form->getFieldHtml( array(
			    'type'     => 'input',
			    'name'     => 'firstname',
			    'value'    => $firstname,
			    'required' => true
		    ) );


		    if ( isset( $that->request->post['lastname'] ) ) {
			    $lastname = $that->request->post['lastname'];
		    } elseif ( isset( $that->session->data['guest']['lastname'] ) ) {
			    $lastname = $that->session->data['guest']['lastname'];
		    } else {
			    $lastname = '';
		    }
		    $this->data['form']['fields']['general']['lastname'] = $form->getFieldHtml( array(
			    'type'     => 'input',
			    'name'     => 'lastname',
			    'value'    => $lastname,
			    'required' => true
		    ) );
		    if ( isset( $that->request->post['email'] ) ) {
			    $email = $that->request->post['email'];
		    } elseif ( isset( $that->session->data['guest']['email'] ) ) {
			    $email = $that->session->data['guest']['email'];
		    } else {
			    $email = '';
		    }

		    $this->data['form']['fields']['general']['email'] = $form->getFieldHtml( array(
			    'type'     => 'input',
			    'name'     => 'email',
			    'value'    => $email,
			    'required' => true
		    ) );

		    if ( isset( $that->request->post['telephone'] ) ) {
			    $telephone = $that->request->post['telephone'];
		    } elseif ( isset( $that->session->data['guest']['telephone'] ) ) {
			    $telephone = $that->session->data['guest']['telephone'];
		    } else {
			    $telephone = '';
		    }
		    $this->data['form']['fields']['general']['telephone'] = $form->getFieldHtml(
			    array(
				    'type'     => 'input',
				    'name'     => 'telephone',
				    'value'    => $telephone,
				    'required' => $that->config->get( 'telephone_option_mandatory_status' )
			    ) );

		    $show_fax = $that->config->get( 'fax_option_show' );
		    if ( $show_fax === '1' ) {
			    if ( isset( $that->request->post['fax'] ) ) {
				    $fax = $that->request->post['fax'];
			    } elseif ( isset( $that->session->data['guest']['fax'] ) ) {
				    $fax = $that->session->data['guest']['fax'];
			    } else {
				    $fax = '';
			    }

			    $this->data['form']['fields']['general']['fax'] = $form->getFieldHtml(
				    array(
					    'type'        => 'input',
					    'name'        => 'fax',
					    'value'       => $fax,
					    'placeholder' => $that->config->get( 'fax_option_placeholder' ),
					    'required'    => $that->config->get( 'fax_option_mandatory_status' )
				    ) );
		    }
		    //get only active IM drivers
		    $im_drivers = $that->im->getIMDriverObjects();
		    if ( $im_drivers ) {
			    foreach ( $im_drivers as $protocol => $driver_obj ) {
				    if ( ! is_object( $driver_obj ) || $protocol == 'email' ) {
					    continue;
				    }
				    if ( isset( $that->request->post[ $protocol ] ) ) {
					    $uri = $that->request->post[ $protocol ];
				    } elseif ( isset( $that->session->data['guest'][ $protocol ] ) ) {
					    $uri = $that->session->data['guest'][ $protocol ];
				    } else {
					    $uri = '';
				    }

				    $fld                                                  = $driver_obj->getURIField( $form, $uri );
				    $this->data['form']['fields']['general'][ $protocol ] = $fld;
				    $this->data[ 'entry_' . $protocol ]                   = $fld->label_text;
			    }
		    }

		    if ( isset( $that->request->post['company'] ) ) {
			    $company = $that->request->post['company'];
		    } elseif ( isset( $that->session->data['guest']['company'] ) ) {
			    $company = $that->session->data['guest']['company'];
		    } else {
			    $company = '';
		    }

		    $this->data['form']['fields']['address']['company'] = $form->getFieldHtml(
			    array(
				    'type'        => 'input',
				    'name'        => 'company',
				    'value'       => $company,
				    'required'    => false,
				    'placeholder' => $that->config->get( 'company_option_placeholder' ),
				    'required'    => $that->config->get( 'company_option_mandatory_status' )
			    ) );

		    if ( isset( $that->request->post['address_1'] ) ) {
			    $address_1 = $that->request->post['address_1'];
		    } elseif ( isset( $that->session->data['guest']['address_1'] ) ) {
			    $address_1 = $that->session->data['guest']['address_1'];
		    } else {
			    $address_1 = '';
		    }
		    $this->data['form']['fields']['address']['address_1'] = $form->getFieldHtml( array(
			    'type'     => 'input',
			    'name'     => 'address_1',
			    'value'    => $address_1,
			    'required' => true
		    ) );


		    if ( isset( $that->request->post['address_2'] ) ) {
			    $address_2 = $that->request->post['address_2'];
		    } elseif ( isset( $that->session->data['guest']['address_2'] ) ) {
			    $address_2 = $that->session->data['guest']['address_2'];
		    } else {
			    $address_2 = '';
		    }
		    $this->data['form']['fields']['address']['address_2'] = $form->getFieldHtml( array(
			    'type'     => 'input',
			    'name'     => 'address_2',
			    'value'    => $address_2,
			    'required' => false
		    ) );

		    if ( isset( $that->request->post['city'] ) ) {
			    $city = $that->request->post['city'];
		    } elseif ( isset( $that->session->data['guest']['city'] ) ) {
			    $city = $that->session->data['guest']['city'];
		    } else {
			    $city = '';
		    }

		    $this->data['form']['fields']['address']['city'] = $form->getFieldHtml( array(
			    'type'     => 'input',
			    'name'     => 'city',
			    'value'    => $city,
			    'required' => true
		    ) );

		    if ( isset( $that->request->post['zone_id'] ) ) {
			    $zone_id = $that->request->post['zone_id'];
		    } elseif ( isset( $that->session->data['guest']['zone_id'] ) ) {
			    $zone_id = $that->session->data['guest']['zone_id'];
		    } else {
			    $zone_id = 'false';
		    }
		    $that->view->assign( 'zone_id', $zone_id );

		    $this->data['form']['fields']['address']['zone'] = $form->getFieldHtml( array(
			    'type'     => 'selectbox',
			    'name'     => 'zone_id',
			    'required' => true
		    ) );

		    if ( isset( $that->request->post['postcode'] ) ) {
			    $postcode = $that->request->post['postcode'];
		    } elseif ( isset( $that->session->data['guest']['postcode'] ) ) {
			    $postcode = $that->session->data['guest']['postcode'];
		    } else {
			    $postcode = '';
		    }
		    $this->data['form']['fields']['address']['postcode'] = $form->getFieldHtml( array(
			    'type'     => 'input',
			    'name'     => 'postcode',
			    'value'    => $postcode,
			    'required' => true
		    ) );


		    if ( isset( $that->request->post['country_id'] ) ) {
			    $country_id = $that->request->post['country_id'];
		    } elseif ( isset( $that->session->data['guest']['country_id'] ) ) {
			    $country_id = $that->session->data['guest']['country_id'];
		    } else {
			    $country_id = $that->config->get( 'config_country_id' );
		    }

		    $that->loadModel( 'localisation/country' );
		    $countries = $that->model_localisation_country->getCountries();
		    $options   = array( "false" => $that->language->get( 'text_select' ) );
		    foreach ( $countries as $item ) {
			    $options[ $item['country_id'] ] = $item['name'];
		    }
		    $this->data['form']['fields']['address']['country'] = $form->getFieldHtml( array(
			    'type'     => 'selectbox',
			    'name'     => 'country_id',
			    'options'  => $options,
			    'value'    => $country_id,
			    'required' => true
		    ) );


		    $this->data['form']['shipping_indicator'] = $form->getFieldHtml( array(
			    'type'       => 'checkbox',
			    'name'       => 'shipping_indicator',
			    'value'      => 1,
			    'checked'    => ( isset( $that->request->post['shipping_indicator'] )
				    ? (bool) $that->request->post['shipping_indicator']
				    : false ),
			    'label_text' => $that->language->get( 'text_indicator' ),
		    ) );

		    if ( isset( $that->request->post['shipping_firstname'] ) ) {
			    $shipping_firstname = $that->request->post['shipping_firstname'];
		    } elseif ( isset( $that->session->data['guest']['shipping']['firstname'] ) ) {
			    $shipping_firstname = $that->session->data['guest']['shipping']['firstname'];
		    } else {
			    $shipping_firstname = '';
		    }
		    $this->data['form']['fields']['shipping']['shipping_firstname'] = $form->getFieldHtml( array(
			    'type'     => 'input',
			    'name'     => 'shipping_firstname',
			    'value'    => $shipping_firstname,
			    'required' => true
		    ) );

		    if ( isset( $that->request->post['shipping_lastname'] ) ) {
			    $shipping_lastname = $that->request->post['shipping_lastname'];
		    } elseif ( isset( $that->session->data['guest']['shipping']['lastname'] ) ) {
			    $shipping_lastname = $that->session->data['guest']['shipping']['lastname'];
		    } else {
			    $shipping_lastname = '';
		    }
		    $this->data['form']['fields']['shipping']['shipping_lastname'] = $form->getFieldHtml(
			    array(
				    'type'     => 'input',
				    'name'     => 'shipping_lastname',
				    'value'    => $shipping_lastname,
				    'required' => true
			    ) );
		    if ( isset( $that->request->post['shipping_company'] ) ) {
			    $shipping_company = $that->request->post['shipping_company'];
		    } elseif ( isset( $that->session->data['guest']['shipping']['company'] ) ) {
			    $shipping_company = $that->session->data['guest']['shipping']['company'];
		    } else {
			    $shipping_company = '';
		    }
		    $this->data['form']['fields']['shipping']['shipping_company'] = $form->getFieldHtml(
			    array(
				    'type'        => 'input',
				    'name'        => 'shipping_company',
				    'value'       => $shipping_company,
				    'placeholder' => $that->config->get( 'company_option_placeholder' ),
				    'required'    => ( $that->config->get( 'company_option_mandatory_status' ) == '1' ) ? true : false
			    ) );
		    if ( isset( $that->request->post['shipping_address_1'] ) ) {
			    $shipping_address_1 = $that->request->post['shipping_address_1'];
		    } elseif ( isset( $that->session->data['guest']['shipping']['address_1'] ) ) {
			    $shipping_address_1 = $that->session->data['guest']['shipping']['address_1'];
		    } else {
			    $shipping_address_1 = '';
		    }
		    $this->data['form']['fields']['shipping']['shipping_address_1'] = $form->getFieldHtml(
			    array(
				    'type'     => 'input',
				    'name'     => 'shipping_address_1',
				    'value'    => $shipping_address_1,
				    'required' => true
			    ) );
		    if ( isset( $that->request->post['shipping_address_2'] ) ) {
			    $shipping_address_2 = $that->request->post['shipping_address_2'];
		    } elseif ( isset( $that->session->data['guest']['shipping']['address_2'] ) ) {
			    $shipping_address_2 = $that->session->data['guest']['shipping']['address_2'];
		    } else {
			    $shipping_address_2 = '';
		    }
		    $this->data['form']['fields']['shipping']['shipping_address_2'] = $form->getFieldHtml(
			    array(
				    'type'     => 'input',
				    'name'     => 'shipping_address_2',
				    'value'    => $shipping_address_2,
				    'required' => false
			    ) );
		    if ( isset( $that->request->post['shipping_city'] ) ) {
			    $shipping_city = $that->request->post['shipping_city'];
		    } elseif ( isset( $that->session->data['guest']['shipping']['city'] ) ) {
			    $shipping_city = $that->session->data['guest']['shipping']['city'];
		    } else {
			    $shipping_city = '';
		    }
		    $this->data['form']['fields']['shipping']['shipping_city'] = $form->getFieldHtml(
			    array(
				    'type'     => 'input',
				    'name'     => 'shipping_city',
				    'value'    => $shipping_city,
				    'required' => true
			    ) );

		    if ( isset( $that->request->post['shipping_zone_id'] ) ) {
			    $shipping_zone_id = $that->request->post['shipping_zone_id'];
		    } elseif ( isset( $that->session->data['guest']['shipping']['zone_id'] ) ) {
			    $shipping_zone_id = $that->session->data['guest']['shipping']['zone_id'];
		    } else {
			    $shipping_zone_id = 'false';
		    }
		    $that->view->assign( 'shipping_zone_id', $shipping_zone_id );
		    $this->data['form']['fields']['shipping']['shipping_zone'] = $form->getFieldHtml(
			    array(
				    'type'     => 'selectbox',
				    'name'     => 'shipping_zone_id',
				    'required' => true
			    ) );

		    if ( isset( $that->request->post['shipping_postcode'] ) ) {
			    $shipping_postcode = $that->request->post['shipping_postcode'];
		    } elseif ( isset( $that->session->data['guest']['shipping']['postcode'] ) ) {
			    $shipping_postcode = $that->session->data['guest']['shipping']['postcode'];
		    } else {
			    $shipping_postcode = '';
		    }
		    $this->data['form']['fields']['shipping']['shipping_postcode'] = $form->getFieldHtml(
			    array(
				    'type'     => 'input',
				    'name'     => 'shipping_postcode',
				    'value'    => $shipping_postcode,
				    'required' => true
			    ) );

		    $options = array( "false" => $that->language->get( 'text_select' ) );
		    foreach ( $countries as $item ) {
			    $options[ $item['country_id'] ] = $item['name'];
		    }
		    if ( isset( $that->request->post['shipping_country_id'] ) ) {
			    $shipping_country_id = $that->request->post['shipping_country_id'];
		    } elseif ( isset( $that->session->data['guest']['shipping']['country_id'] ) ) {
			    $shipping_country_id = $that->session->data['guest']['shipping']['country_id'];
		    } else {
			    $shipping_country_id = $that->config->get( 'config_country_id' );
		    }
		    $this->data['form']['fields']['shipping']['shipping_country'] = $form->getFieldHtml(
			    array(
				    'type'     => 'selectbox',
				    'name'     => 'shipping_country_id',
				    'options'  => $options,
				    'value'    => $shipping_country_id,
				    'required' => true
			    ) );

		    if ( isset( $that->request->post['shipping_indicator'] ) ) {
			    $that->view->assign( 'shipping_addr', true );
		    } elseif ( isset( $that->session->data['guest']['shipping'] ) ) {
			    $that->view->assign( 'shipping_addr', true );
		    } else {
			    $that->view->assign( 'shipping_addr', false );
		    }

		    $that->view->assign( 'shipping', $that->cart->hasShipping() );
		    $that->loadModel( 'localisation/country' );
		    $that->view->assign( 'countries', $that->model_localisation_country->getCountries() );

		    //TODO: REMOVE THIS IN 2.0!!!
		    // backward compatibility code
		    $deprecated = $this->data['form']['fields'];
		    foreach ( $deprecated as $section => $fields ) {
			    foreach ( $fields as $name => $fld ) {
				    if ( in_array( $name, array( 'country', 'zone' ) ) ) {
					    $name .= '_id';
				    }
				    $this->data['form'][ $name ] = $fld;
			    }
		    }
		    //end of trick

		    $cart_rt = 'checkout/cart';
		    if ( $that->config->get( 'embed_mode' ) == true ) {
			    $cart_rt = 'r/checkout/cart/embed';
		    }
		    $that->view->assign( 'back', $that->html->getURL( $cart_rt ) );

		    $this->data['form']['back'] = $form->getFieldHtml(
			    array(
				    'type'  => 'button',
				    'name'  => 'back',
				    'text'  => $that->language->get( 'button_back' ),
				    'style' => 'button'
			    ) );

		    $this->data['form']['continue'] = $form->getFieldHtml(
			    array(
				    'type' => 'submit',
				    'name' => $that->language->get( 'button_continue' )
			    ) );

		    $that->view->batchAssign( $this->data );

		    $data['text_additional_fields'] = $that->language->get( 'text_additional_fields' );

		    $that->view->batchAssign( $this->data );
		    $that->processTemplate( 'pages/checkout/guest_step_1.tpl' );
    }

    public function onControllerPagesCheckoutConfirm_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	       if ( $this->baseObject_method === 'main' ) {
			    if ( file_exists( DIR_EXT . 'option_price_link_pro' ) && $this->verifyOptionPriceLink() ) {
				    include_once DIR_EXT . 'option_price_link_pro' . DIR_EXT_CORE . 'lib/order.php';
				    $order = new AOptionOrder( $this->registry );
			    } elseif ( file_exists( DIR_EXT . 'advanced_reports' ) && $this->verifyAdvancedReports() ) {
				    include_once DIR_EXT . 'advanced_reports' . DIR_EXT_CORE . 'lib/order.php';
				    $order = new AEnhancedOrder( $this->registry );
			    } else {
				    $order = new AOrder( $this->registry );
			    }
			    $display_totals = $that->cart->buildTotalDisplay();
			    $this->data     = $order->buildOrderData( $that->session->data );
			    $order_id       = $order->saveOrder();
			    $that->loadModel( 'account/telephone' );
			    if ( $order_id === false ) {
				    $this->redirect( $that->html->getSecureURL( 'checkout/success' ) );
			    }
			    $that->session->data['order_id'] = $order_id;

			    $resource    = new AResource( 'image' );
			    $product_ids = array();
			    foreach ( $that->data['products'] as $result ) {
				    $product_ids[] = (int) $result['product_id'];
			    }
			    $thumbnails = $resource->getMainThumbList(
				    'products',
				    $product_ids,
				    $that->config->get( 'config_image_cart_width' ),
				    $that->config->get( 'config_image_cart_height' )
			    );

			    for ( $i = 0; $i < sizeof( $this->data['products'] ); $i ++ ) {
				    $product_id = $this->data['products'][ $i ]['product_id'];
				    $opts = $this->data['products'][$i]['option'];
				    $options = array();

				    $thumbnail = $thumbnails[$product_id];

				    foreach ($opts as $option) {
					    //hide hidden options
					    if ($option['element_type'] == 'H') {
						    continue;
					    }
					    $title = '';
					    $value = $option['value'];
					    // hide binary value for checkbox
					    if ($option['element_type'] == 'C' && in_array($value, array(0, 1))) {
						    $value = '';
					    }
					    // strip long textarea value
					    if ($option['element_type'] == 'T') {
						    $title = strip_tags($value);
						    $title = str_replace('\r\n', "\n", $title);
						    $value = str_replace('\r\n', "\n", $value);
						    if (mb_strlen($value) > 64) {
							    $value = mb_substr($value, 0, 64).'...';
						    }
					    }
					    $options[] = array(
						    'name'  => $option['name'],
						    'value' => $value,
						    'title' => $title,
					    );
					    // product image by option value
					    $mSizes = array(
						    'main'  =>
							    array(
								    'width' => $that->config->get('config_image_cart_width'),
								    'height' => $that->config->get('config_image_cart_height')
							    ),
						    'thumb' => array(
							    'width' =>  $that->config->get('config_image_cart_width'),
							    'height' => $that->config->get('config_image_cart_height')
						    ),
					    );
					    $main_image =
						    $resource->getResourceAllObjects('product_option_value', $option['product_option_value_id'], $mSizes, 1, false);
					    if (!empty($main_image)) {
						    $thumbnail['origin'] = $main_image['origin'];
						    $thumbnail['title'] = $main_image['title'];
						    $thumbnail['description'] = $main_image['description'];
						    $thumbnail['thumb_html'] = $main_image['thumb_html'];
						    $thumbnail['thumb_url'] = $main_image['thumb_url'];
					    }
				    }

				    $this->data['products'][$i]['option'] = $options;

				    $tax      = $that->tax->calcTotalTaxAmount( $this->data['products'][ $i ]['total'], $this->data['products'][ $i ]['tax_class_id'] );
				    $price    = $this->data['products'][ $i ]['price'];
				    $quantity = $this->data['products'][ $i ]['quantity'];
				    $total    = $that->currency->format_total( $price, $quantity );

				    $this->data['products'][ $i ] = array_merge(
					    $this->data['products'][ $i ],
					    array(
						    'thumb' => $thumbnail,
						    'tax'   => $that->currency->format( $tax ),
						    'price' => $price,
						    'total' => $total,
						    'href'  => $that->html->getSEOURL( 'product/product', '&product_id=' . $product_id, true )
					    ) );
			    }

			    if ( file_exists( DIR_EXT . 'ss_image' ) && $that->config->get( 'ss_image_status' == '1' ) ) {
				    $that->view->assign( 'free_shipping', $that->config->get( 'ss_image_ss_text' ) );
				    $that->view->assign( 'download', $that->config->get( 'ss_image_ss_dl_text' ) );
				    $that->view->assign( 'ship_individual', $that->config->get( 'ss_image_ss_sl_text' ) );
			    }

			    $ups_plus_status = $this->verifyUpsPlus();
			    $shipping_id     = $that->session->data['shipping_method']['id'];
			    $exist           = strpos( $shipping_id, '_ap' );
			    if ( $exist && $ups_plus_status === '1' ) {
				    $this->data['shipping_firstname'] = $that->session->data['apName'] ? $that->session->data['apName'] : $that->session->data['APName'];
				    $this->data['shipping_lastname']  = '';
				    $this->data['shipping_telephone'] = $that->session->data['apTelephone'] !== '' ? $that->session->data['apTelephone'] : $that->session->data['APTelephone'];
				    $this->data['telephone']          = $that->customer->getTelephone();
				    $this->data['shipping_address_1'] = $that->session->data['apAddr'] ? $that->session->data['apAddr'] : $that->session->data['APAddr'];
				    $this->data['shipping_address_2'] = '';
				    $this->data['shipping_city']      = $that->session->data['apCity'] ? $that->session->data['apCity'] : $that->session->data['APCity'];
				    $this->data['shipping_postcode']  = $that->session->data['apCode'] ? $that->session->data['apCode'] : $that->session->data['APCode'];
				    $that->load->model( 'extension/ups_integration_plus_address' );
				    $zones                          = $that->model_extension_ups_integration_plus_address->getZonesByCode( $that->session->data['apZone'], $that->session->data['apCountryCode'] );
				    $this->data['shipping_zone']    = $zones['zone_name'];
				    $this->data['shipping_zone_id'] = $zones['zone_id'];
				    $this->data['shipping_country'] = $that->session->data['apCountry'] ? $that->session->data['apCountry'] : $that->session->data['APCountry'];
				    $this->data['ap']               = true;
			    } else {
				    $this->data['ap']                 = false;
				    $this->data['telephone']          = $that->customer->getTelephone();
				    $this->data['shipping_telephone'] = $that->customer->getTelephone();
			    }

			    $this->data['totals'] = $display_totals['total_data'];
			    $payment_address      = $that->model_account_address->getAddress( $that->session->data['payment_address_id'] );
			    if ( $payment_address ) {
				    $this->data['payment_address'] = $this->getFormattedAddress( $payment_address );
			    } else {
				    $this->data['payment_address'] = '';
			    }
			    $that->view->batchAssign( $this->data );
			    $that->processTemplate();
		    }
    }

    //Hook Create new shipping address, new payment address,create new address, edit address validation
    public function onModelAccountAddress_ValidateData(){
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        $that->load->language( 'account/address' );
		    $that->load->language( 'account/telephone' );
		    $that->load->language( 'checkout/guest_step_1' );
		    $rt = $that->request->get['rt'];
		    if ( $that->config->get( 'company_option_mandatory_status' ) == '1' ) {
			    if ( ( mb_strlen( $that->request->post['company'] ) == '' ) ) {
				    if ( $rt === 'checkout/address/shipping' || $rt === 'checkout/address/payment' ) {
					    $that->session->data['error_company'] = $that->language->get( 'company_error' );
				    }
				    $that->error['company'] = $that->language->get( 'company_error' );
			    }
		    }
		    if ( count( $that->error ) ) {
			    $that->error( 'error_warning', $that->language->get( 'gen_data_entry_error' ) );
		    }
    }

    public function onControllerPagesCheckoutAddress_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	        if ( $this->baseObject_method == 'shipping' ) {
			    $this->_getCheckoutAddressForm( 'shipping' );
		    } elseif ( $this->baseObject_method == 'payment' ) {
			    $this->_getCheckoutAddressForm( 'payment' );
		    }
    }

    public function onControllerPagesCheckoutGuestStep3_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'main' ) {
			    if ( file_exists( DIR_EXT . 'option_price_link_pro' ) && $this->verifyOptionPriceLink()) {
				    include_once DIR_EXT . 'option_price_link_pro' . DIR_EXT_CORE . 'lib/order.php';
				    $order = new AOptionOrder( $this->registry );
			    } elseif ( file_exists( DIR_EXT . 'advanced_reports' ) && $this->verifyAdvancedReports() ) {
                    include_once DIR_EXT . 'advanced_reports' . DIR_EXT_CORE . 'lib/order.php';
                    $order = new AEnhancedOrder( $this->registry );
                } else {
				    $order = new AOrder( $this->registry );
			    }

			    $display_totals = $that->cart->buildTotalDisplay();
			    $this->data     = $order->buildOrderData( $that->session->data );
			    $order_id       = $order->saveOrder();
			    if ( $order_id === false ) {
				    $this->redirect( $that->html->getSecureURL( 'checkout/success' ) );
			    }
			    $that->session->data['order_id'] = $order_id;

			    $resource    = new AResource( 'image' );
			    $product_ids = array();
			    foreach ( $that->data['products'] as $result ) {
				    $product_ids[] = (int) $result['product_id'];
			    }
			    $thumbnails = $resource->getMainThumbList(
				    'products',
				    $product_ids,
				    $that->config->get( 'config_image_cart_width' ),
				    $that->config->get( 'config_image_cart_height' )
			    );

			    $mSizes = array(
				    'main'  =>
					    array(
						    'width' => $that->config->get('config_image_cart_width'),
						    'height' => $that->config->get('config_image_cart_height')
					    ),
				    'thumb' => array(
					    'width' =>  $that->config->get('config_image_cart_width'),
					    'height' => $that->config->get('config_image_cart_height')
				    ),
			    );

			    foreach ($this->data['products'] as $product) {
				    if (isset($product['option']) && !empty($product['option'])) {
					    foreach ($product['option'] as $option) {
						    $main_image =
							    $resource->getResourceAllObjects('product_option_value', $option['product_option_value_id'], $mSizes, 1, false);
						    if (!empty($main_image)) {
							    $thumbnails[$product['key']] = $main_image;
						    }
					    }
				    }
			    }

			    for ( $i = 0; $i < sizeof( $this->data['products'] ); $i ++ ) {
				    $product_id = $this->data['products'][ $i ]['product_id'];

				    if ($thumbnails[$this->data['products'][$i]['key']]) {
					    $thumbnail = $thumbnails[$this->data['products'][$i]['key']];
				    } else {
					    $thumbnail = $thumbnails[$product_id];
				    }

				    $tax      = $that->tax->calcTotalTaxAmount( $this->data['products'][ $i ]['total'], $this->data['products'][ $i ]['tax_class_id'] );
				    $price    = $this->data['products'][ $i ]['price'];
				    $quantity = $this->data['products'][ $i ]['quantity'];
				    $total    = $that->currency->format_total( $price, $quantity );

				    $this->data['products'][ $i ] = array_merge(
					    $this->data['products'][ $i ],
					    array(
						    'thumb' => $thumbnail,
						    'tax'   => $that->currency->format( $tax ),
						    'price' => $price,
						    'total' => $total,
						    'href'  => $that->html->getSEOURL( 'product/product', '&product_id=' . $product_id, true )
					    ) );
			    }

			    $this->data['totals'] = $display_totals['total_data'];

			    $payment_address = $that->session->data['guest'];
			    if ( $payment_address ) {
				    $that->data['payment_address'] = $this->getFormattedAddress( $payment_address );
			    } else {
				    $that->data['payment_address'] = '';
			    }

			    $ups_plus_status = $this->verifyUpsPlus();
			    $shipping_id     = $that->session->data['shipping_method']['id'];
			    $exist           = strpos( $shipping_id, '_ap' );
			    if ( $exist && $ups_plus_status === '1' ) {
				    $this->data['shipping_firstname'] = $that->session->data['apName'] ? $that->session->data['apName'] : $that->session->data['APName'];
				    $this->data['shipping_lastname']  = '';
				    $this->data['shipping_telephone'] = $that->session->data['apTelephone'] !== '' ? $that->session->data['apTelephone'] : $that->session->data['APTelephone'];
				    $this->data['telephone']          = $that->session->data['guest']['telephone'];
				    $this->data['shipping_address_1'] = $that->session->data['apAddr'] ? $that->session->data['apAddr'] : $that->session->data['APAddr'];
				    $this->data['shipping_address_2'] = '';
				    $this->data['shipping_city']      = $that->session->data['apCity'] ? $that->session->data['apCity'] : $that->session->data['APCity'];
				    $this->data['shipping_postcode']  = $that->session->data['apCode'] ? $that->session->data['apCode'] : $that->session->data['APCode'];
				    $that->load->model( 'extension/ups_integration_plus_address' );
				    $zones                          = $that->model_extension_ups_integration_plus_address->getZonesByCode( $that->session->data['apZone'], $that->session->data['apCountryCode'] );
				    $this->data['shipping_zone']    = $zones['zone_name'];
				    $this->data['shipping_zone_id'] = $zones['zone_id'];
				    $this->data['shipping_country'] = $that->session->data['apCountry'] ? $that->session->data['apCountry'] : $that->session->data['APCountry'];
				    $this->data['ap']               = true;
			    } else {
				    $this->data['ap']                 = false;
				    $this->data['telephone']          = $that->session->data['guest']['telephone'];
				    $this->data['shipping_telephone'] = $that->session->data['guest']['telephone'];
			    }

			    $that->view->batchAssign( $this->data );
			    $that->processTemplate( '' );
		    }
    }

    //Hook Create new account,edit account validation
    public function onModelAccountCustomer_ValidateData(){
        if (!$this->_is_enabled()) {
            return null;
        }
	        $that      =& $this->baseObject;
		    $telephone = $that->request->post['telephone'];
		    $fax       = $that->request->post['fax'];
		    $company   = $that->request->post['company'];
		    $that->load->language( 'account/create' );
		    $that->load->language( 'checkout/guest_step_1' );
		    $that->load->language( 'account/telephone' );
		    $rt = $that->request->get['rt'];
		    if ( $rt === 'account/create' ) {
			    if ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) {
				    if ( empty( $telephone ) || ( mb_strlen( $telephone ) < 3 ) || ( mb_strlen( $telephone ) > 32 ) ) {
					    $that->error['telephone'] = $that->language->get( 'telephone_error' );
				    }
			    }
			    if ( $that->config->get( 'fax_option_mandatory_status' ) === '1'
			         && $that->config->get( 'fax_option_show' ) === '1' ) {
				    if ( empty( $fax ) || ( ( mb_strlen( $fax ) < 3 || mb_strlen( $fax ) > 32 ) && strtolower( $fax ) != 'na' && strtolower( $fax ) != 'none' ) ) {
					    $that->error['fax'] = $that->language->get( 'fax_error' );
				    }
			    }
			    if ( $that->config->get( 'company_option_mandatory_status' ) === '1' ) {
				    if ( empty($company) && strtolower( $fax ) != 'na' && strtolower( $fax ) != 'none') {
					    $that->error['company'] = $that->language->get( 'company_error' );
				    }
			    }
		    } elseif ( $rt === 'account/edit' ) {
		        if ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) {
				    if ( empty( $telephone ) || ( mb_strlen( $telephone ) < 3 ) || ( mb_strlen( $telephone ) > 32 ) ) {
					    $that->error['telephone'] = $that->language->get( 'telephone_error' );
				    }
			    }
			    if ( $that->config->get( 'fax_option_mandatory_status' ) === '1'
			         && $that->config->get( 'fax_option_show' ) === '1' ) {
				    if ( empty( $fax ) || ( ( mb_strlen( $fax ) < 3 || mb_strlen( $fax ) > 32 ) && strtolower( $fax ) != 'na' && strtolower( $fax ) != 'none' ) ) {
					    $that->error['fax'] = $that->language->get( 'fax_error' );
				    }
			    }
                if ( count( $that->error ) ) {
                    $that->error['warning'] = $that->language->get( 'gen_data_entry_error' );
                }
		    }
    }

    public function onControllerPagesAccountCreate_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'main' ) {
			    $data = array();
			    $form = new AForm();
			    $form->setForm( array( 'form_name' => 'AccountFrm' ) );
			    $that->loadModel( 'account/telephone' );
			    $that->load->language( 'account/telephone' );

			    $this->data['error_telephone'] = $that->errors['telephone'];
			    $this->data['error_fax']       = $that->errors['fax'];
			    $this->data['error_company']   = $that->errors['company'];

			    $form = new AForm();
			    $form->setForm( array( 'form_name' => 'AccountFrm' ) );
			    $this->data['form']['form_open'] = $form->getFieldHtml(
				    array(
					    'type'   => 'form',
					    'name'   => 'AccountFrm',
					    'action' => $that->html->getSecureURL( 'account/create' ),
					    'csrf'   => true
				    )
			    );

			    if ( $that->config->get( 'prevent_email_as_login' ) ) { // require login name
				    $this->data['form']['fields']['general']['loginname'] = $form->getFieldHtml(
					    array(
						    'type'     => 'input',
						    'name'     => 'loginname',
						    'value'    => $that->request->post['loginname'],
						    'required' => true
					    ) );
			    }
			    $this->data['form']['fields']['general']['firstname'] = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'firstname',
					    'value'    => $that->request->post['firstname'],
					    'required' => true
				    ) );
			    $this->data['form']['fields']['general']['lastname']  = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'lastname',
					    'value'    => $that->request->post['lastname'],
					    'required' => true
				    ) );
			    $this->data['form']['fields']['general']['email']     = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'email',
					    'value'    => $that->request->get_or_post( 'email' ),
					    'required' => true
				    ) );
			    $this->data['form']['fields']['general']['telephone'] = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'telephone',
					    'value'    => $that->request->post['telephone'],
					    'required' => ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) ? true : false
				    ) );
			    $show_fax                                             = $that->config->get( 'fax_option_show' );
			    if ( $show_fax === '1' ) {
				    $this->data['form']['fields']['general']['fax'] = $form->getFieldHtml(
					    array(
						    'type'        => 'input',
						    'name'        => 'fax',
						    'value'       => $that->request->post['fax'],
						    'placeholder' => $that->config->get( 'fax_option_placeholder' ),
						    'required'    => ( $that->config->get( 'fax_option_mandatory_status' ) == '1' ) ? true : false
					    ) );
			    }

			    //get only active IM drivers
			    $im_drivers = $that->im->getIMDriverObjects();

			    if ( $im_drivers ) {
				    foreach ( $im_drivers as $protocol => $driver_obj ) {
					    if ( ! is_object( $driver_obj ) || $protocol == 'email' ) {
						    continue;
					    }
					    $fld                                                  = $driver_obj->getURIField( $form, $that->request->post[ $protocol ] );
					    $this->data['form']['fields']['general'][ $protocol ] = $fld;
					    $this->data[ 'entry_' . $protocol ]                   = $fld->label_text;
				    }
			    }

			    $this->data['form']['fields']['address']['company']   = $form->getFieldHtml(
				    array(
					    'type'        => 'input',
					    'name'        => 'company',
					    'value'       => $that->request->post['company'],
					    'placeholder' => $that->config->get( 'company_option_placeholder' ),
					    'required'    => ( $that->config->get( 'company_option_mandatory_status' ) == '1' ) ? true : false
				    ) );
			    $this->data['form']['fields']['address']['address_1'] = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'address_1',
					    'value'    => $that->request->post['address_1'],
					    'required' => true
				    ) );
			    $this->data['form']['fields']['address']['address_2'] = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'address_2',
					    'value'    => $that->request->post['address_2'],
					    'required' => false
				    ) );
			    $this->data['form']['fields']['address']['city']      = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'city',
					    'value'    => $that->request->post['city'],
					    'required' => true
				    ) );

			    $that->view->assign( 'zone_id', $that->request->post['zone_id'], 'false' );
			    $this->data['form']['fields']['address']['zone'] = $form->getFieldHtml(
				    array(
					    'type'     => 'selectbox',
					    'name'     => 'zone_id',
					    'required' => true
				    ) );

			    $this->data['form']['fields']['address']['postcode'] = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'postcode',
					    'value'    => $that->request->post['postcode'],
					    'required' => true
				    ) );

			    $that->loadModel( 'localisation/country' );
			    $countries = $that->model_localisation_country->getCountries();
			    $options   = array( "false" => $that->language->get( 'text_select' ) );
			    foreach ( $countries as $item ) {
				    $options[ $item['country_id'] ] = $item['name'];
			    }
			    $this->data['form']['fields']['address']['country'] = $form->getFieldHtml(
				    array(
					    'type'     => 'selectbox',
					    'name'     => 'country_id',
					    'options'  => $options,
					    'value'    => ( isset( $that->request->post['country_id'] ) ? $that->request->post['country_id'] : $that->config->get( 'config_country_id' ) ),
					    'required' => true
				    ) );

			    $this->data['form']['fields']['password']['password'] = $form->getFieldHtml(
				    array(
					    'type'     => 'password',
					    'name'     => 'password',
					    'value'    => $that->request->post['password'],
					    'required' => true
				    ) );
			    $this->data['form']['fields']['password']['confirm']  = $form->getFieldHtml(
				    array(
					    'type'     => 'password',
					    'name'     => 'confirm',
					    'value'    => $that->request->post['confirm'],
					    'required' => true
				    ) );

			    $this->data['form']['fields']['newsletter']['newsletter'] = $form->getFieldHtml(
				    array(
					    'type'    => 'radio',
					    'name'    => 'newsletter',
					    'value'   => ( ! is_null( $that->request->get_or_post( 'newsletter' ) ) ? $that->request->get_or_post( 'newsletter' ) : - 1 ),
					    'options' => array(
						    '1' => $that->language->get( 'text_yes' ),
						    '0' => $that->language->get( 'text_no' ),
					    )
				    ) );

			    //If captcha enabled, validate
			    if ( $that->config->get( 'config_account_create_captcha' ) ) {
				    if ( $that->config->get( 'config_recaptcha_site_key' ) ) {
					    $this->data['form']['fields']['newsletter']['captcha'] = $form->getFieldHtml(
						    array(
							    'type'               => 'recaptcha',
							    'name'               => 'recaptcha',
							    'recaptcha_site_key' => $that->config->get( 'config_recaptcha_site_key' ),
							    'language_code'      => $that->language->getLanguageCode()
						    ) );

				    } else {
					    $this->data['form']['fields']['newsletter']['captcha'] = $form->getFieldHtml(
						    array(
							    'type' => 'captcha',
							    'name' => 'captcha',
							    'attr' => ''
						    ) );
				    }
			    }

			    //TODO: REMOVE THIS IN 1.3!!!
			    // backward compatibility code
			    $deprecated = $this->data['form']['fields'];
			    foreach ( $deprecated as $section => $fields ) {
				    foreach ( $fields as $name => $fld ) {
					    if ( in_array( $name, array( 'country', 'zone' ) ) ) {
						    $name .= '_id';
					    }
					    $this->data['form'][ $name ] = $fld;
				    }
			    }
			    //end of trick

			    $agree                       = isset( $that->request->post['agree'] ) ? $that->request->post['agree'] : false;
			    $this->data['form']['agree'] = $form->getFieldHtml(
				    array(
					    'type'    => 'checkbox',
					    'name'    => 'agree',
					    'value'   => 1,
					    'checked' => $agree
				    ) );

			    $this->data['form']['continue'] = $form->getFieldHtml(
				    array(
					    'type' => 'submit',
					    'name' => $that->language->get( 'button_continue' )
				    ) );

			    $this->data['action']     = $that->html->getSecureURL( 'account/create' );
			    $this->data['newsletter'] = $that->request->post['newsletter'];

			    if ( $that->config->get( 'config_account_id' ) ) {

				    $that->loadModel( 'catalog/content' );
				    $content_info = $that->model_catalog_content->getContent( $that->config->get( 'config_account_id' ) );

				    if ( $content_info ) {
					    $text_agree                         = $that->language->get( 'text_agree' );
					    $this->data['text_agree_href']      = $that->html->getURL( 'r/content/content/loadInfo', '&content_id=' . $that->config->get( 'config_account_id' ) );
					    $this->data['text_agree_href_text'] = $content_info['title'];
				    } else {
					    $text_agree = '';
				    }
			    } else {
				    $text_agree = '';
			    }
			    $this->data['text_agree'] = $text_agree;

			    $text_account_already               = sprintf( $that->language->get( 'text_account_already' ), $that->html->getSecureURL( 'account/login' ) );
			    $this->data['text_account_already'] = $text_account_already;

			    $that->view->batchAssign( $this->data );
			    $that->processTemplate( 'pages/account/create.tpl' );
		    }
    }

    public function onControllerPagesAccountEdit_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'main' ) {
			    $that->loadModel( 'account/telephone' );
			    $that->loadLanguage( 'account/telephone' );

			    $this->data['error_telephone'] = $that->error['telephone'];
			    $this->data['error_fax']       = $that->error['fax'];

			    if ( $that->request->is_GET() ) {
				    $customer_info                    = $that->model_account_customer->getCustomer( $that->customer->getId() );
				    $that->session->data['loginname'] = $customer_info['loginname'];
			    }

			    $request_data = $that->request->post;

			    $form = new AForm();
			    $form->setForm( array( 'form_name' => 'AccountFrm' ) );
			    $this->data['form']['form_open'] = $form->getFieldHtml(
				    array(
					    'type'   => 'form',
					    'name'   => 'AccountFrm',
					    'action' => $that->html->getSecureURL( 'account/edit' ),
					    'csrf'   => true,
				    )
			    );

			    //check if existing customer has loginname = email. Redirect if not allowed
			    $reset_loginname = false;
			    if ( $that->config->get( 'prevent_email_as_login' ) && $that->customer->isLoginnameAsEmail() ) {
				    $that->error['warning'] = $that->language->get( 'loginname_update_required' );
				    $reset_loginname        = true;
			    }

			    $this->data['reset_loginname'] = $reset_loginname;

			    if ( isset( $request_data['loginname'] ) ) {
				    $loginname = $request_data['loginname'];
			    } elseif ( isset( $customer_info ) ) {
				    $loginname = $customer_info['loginname'];
			    } else {
				    $loginname = $that->session->data['loginname'];
				    unset( $that->session->data['loginname'] );
			    }

			    if ( $reset_loginname ) {
				    $this->data['form']['fields']['loginname'] = $form->getFieldHtml(
					    array(
						    'type'     => 'input',
						    'name'     => 'loginname',
						    'value'    => $loginname,
						    'style'    => 'highlight',
						    'required' => true
					    ) );
			    } else {
				    $this->data['form']['fields']['loginname'] = $loginname;
			    }

			    if ( isset( $request_data['firstname'] ) ) {
				    $firstname = $request_data['firstname'];
			    } elseif ( isset( $customer_info ) ) {
				    $firstname = $customer_info['firstname'];
			    } elseif ( $request_data['firstname'] == '' ) {
				    $firstname = '';
			    }

			    $this->data['form']['fields']['firstname'] = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'firstname',
					    'value'    => $firstname,
					    'required' => true
				    ) );

			    if ( isset( $request_data['lastname'] ) ) {
				    $lastname = $request_data['lastname'];
			    } elseif ( isset( $customer_info ) ) {
				    $lastname = $customer_info['lastname'];
			    } elseif ( $request_data['lastname'] == '' ) {
				    $lastname = '';
			    }

			    $this->data['form']['fields']['lastname'] = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'lastname',
					    'value'    => $lastname,
					    'required' => true
				    ) );

			    if ( isset( $request_data['email'] ) ) {
				    $email = $request_data['email'];
			    } elseif ( isset( $customer_info ) ) {
				    $email = $customer_info['email'];
			    } elseif ( $request_data['email'] == '' ) {
				    $email = '';
			    }

			    $this->data['form']['fields']['email'] = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'email',
					    'value'    => $email,
					    'required' => true
				    ) );

			    if ( isset( $request_data['telephone'] ) ) {
				    $telephone = $request_data['telephone'];
			    } elseif ( isset( $customer_info ) ) {
				    $telephone = $customer_info['telephone'];
			    } elseif ( $request_data['telephone'] == '' ) {
				    $telephone = '';
			    }

			    $this->data['form']['fields']['telephone'] = $form->getFieldHtml(
				    array(
					    'type'     => 'input',
					    'name'     => 'telephone',
					    'value'    => $telephone,
					    'required' => ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) ? true : false
				    ) );

			    $show_fax = $that->config->get( 'fax_option_show' );
			    if ( $show_fax === '1' ) {

				    if ( isset( $request_data['fax'] ) ) {
					    $fax = $request_data['fax'];
				    } elseif ( isset( $customer_info ) ) {
					    $fax = $customer_info['fax'];
				    } elseif ( $request_data['fax'] == '' ) {
					    $fax = '';
				    }

				    $this->data['form']['fields']['fax'] = $form->getFieldHtml(
					    array(
						    'type'        => 'input',
						    'name'        => 'fax',
						    'value'       => $fax,
						    'placeholder' => $that->config->get( 'fax_option_placeholder' ),
						    'required'    => ( $that->config->get( 'fax_option_mandatory_status' ) == '1' ) ? true : false
					    ) );
			    }

			    //get only active IM drivers
			    $im_drivers = $that->im->getIMDriverObjects();
			    if ( $im_drivers ) {
				    foreach ( $im_drivers as $protocol => $driver_obj ) {
					    if ( ! is_object( $driver_obj ) || $protocol == 'email' ) {
						    continue;
					    }

					    if ( isset( $request_data[ $protocol ] ) ) {
						    $value = $request_data[ $protocol ];
					    } elseif ( isset( $customer_info ) ) {
						    $value = $customer_info[ $protocol ];
					    }

					    $fld                                       = $driver_obj->getURIField( $form, $value );
					    $this->data['form']['fields'][ $protocol ] = $fld;
					    $this->data[ 'entry_' . $protocol ]        = $fld->label_text;
					    $this->data[ 'error_' . $protocol ]        = $this->error[ $protocol ];
				    }
			    }

			    //TODO: REMOVE THIS IN 1.3!!!
			    // backward compatibility code
			    $deprecated = array_keys( $this->data['form']['fields'] );
			    foreach ( $deprecated as $name ) {
				    $this->data['form'][ $name ] = $this->data['form']['fields'][ $name ];
			    }
			    //end of trick


			    $this->data['form']['continue'] = $form->getFieldHtml(
				    array(
					    'type' => 'submit',
					    'icon' => 'fa fa-check',
					    'name' => $that->language->get( 'button_continue' )
				    ) );
			    $this->data['form']['back']     = $form->getFieldHtml(
				    array(
					    'type'  => 'button',
					    'name'  => 'back',
					    'style' => 'button',
					    'icon'  => 'fa fa-arrow-left',
					    'text'  => $that->language->get( 'button_back' )
				    ) );
			    $this->data['back']             = $that->html->getSecureURL( 'account/account' );
			    $that->view->batchAssign( $this->data );
			    $that->processTemplate( 'pages/account/edit.tpl' );
		    }
    }

    public function onControllerPagesAccountAddress_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	        if ( $this->baseObject_method == 'main' ) {
			    $this->getList();
		    } elseif ( $this->baseObject_method == 'insert' ) {
			    $this->_getStorefrontAddressForm();
		    } elseif ( $this->baseObject_method == 'update' ) {
			    $this->_getStorefrontAddressForm();
		    }
    }

    public function onControllerResponsesCommonViewPort_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'modal') {
            $page_rt = $that->request->get['viewport_rt'];
            if ($page_rt) {
                $that->session->data['viewport_mode']='modal';
            }
        }
    }

    //Hook Sale Customer Validation
    public function onControllerPagesSaleCustomer_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        $rt   = $that->request->get['rt'];
		    $that->loadLanguage( 'telephone_option/telephone_option' );
		    $telephone = $that->request->post['telephone'];
		    $fax       = $that->request->post['fax'];
		    $company   = $that->request->post['company'];
		    if ( $rt === 'sale/customer/insert_address' || $rt === 'sale/customer/update_address' ) {
			    if ( $that->config->get( 'company_option_mandatory_status' ) == '1' ) {
				    if ( $company == '' ) {
					    $that->error['company'] = $that->language->get( 'company_error' );
				    }
			    }
		    } else {
			    if ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) {
				    if ( empty( $telephone ) || mb_strlen( $telephone ) < 3 || mb_strlen( $telephone ) > 32 ) {
					    $that->error['telephone'] = $that->language->get( 'telephone_error' );
				    }
			    }

			    if ( $that->config->get( 'fax_option_mandatory_status' ) == '1' ) {
				    if ( empty( $fax ) || ( ( mb_strlen( $fax ) < 3 || mb_strlen( $fax ) > 32 ) && strtolower( $fax ) != 'na' && strtolower( $fax ) != 'none' ) ) {
					    $that->error['fax'] = $that->language->get( 'fax_error' );
				    }
			    }
		    }
    }

    public function onControllerPagesSaleCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'insert' ) {
			    $this->_getForm();
		    } elseif ( $this->baseObject_method === 'update' ) {
			    $this->_getForm( $that->session->data['viewport_mode'] );
		    } elseif ( $this->baseObject_method === 'insert_address' ) {
			    $this->_getAdressForm();
		    } elseif ( $this->baseObject_method === 'update_address' ) {
			    $this->_getAdressForm();
		    }
    }

    private function _getForm($viewport_mode='') {
        $that =& $this->baseObject;
        $this->data['error'] = $that->error;
        $customer_id = $that->request->get['customer_id'];

        $this->data['token'] = $that->session->data['token'];

        $that->document->initBreadcrumb(array(
            'href' => $that->html->getHomeURL(),
            'text' => $that->language->get('text_home'),
            'separator' => false
        ));

        $that->document->addBreadcrumb(array(
            'href' => $that->html->getSecureURL('sale/customer'),
            'text' => $that->language->get('heading_title'),
            'separator' => ' :: '
        ));

        $this->data['addresses'] = array();

        if (has_value($customer_id)) {
            $customer_info = $that->model_sale_customer->getCustomer($customer_id);
            $this->data['button_orders_count'] = $that->html->buildElement(
                array(
                    'type' => 'button',
                    'name' => 'view orders',
                    'text' => $that->language->get('text_order') . ': ' . $customer_info['orders_count'],
                    'style' => 'button2',
                    'href' => $that->html->getSecureURL('sale/order', '&customer_id=' . $customer_id),
                    'title' => $that->language->get('text_view') . ' ' . $that->language->get('tab_history')
                )
            );
            $this->data['addresses'] = $that->model_sale_customer->getAddressesByCustomerId($customer_id);
            if($customer_info['last_login'] && !in_array($customer_info['last_login'], array('0000-00-00 00:00:00', '1970-01-01 00:00:00'))){
                $date =  dateISO2Display($customer_info['last_login'],$that->language->get('date_format_short').' '.$that->language->get('time_format'));
            }else{
                $date = $that->language->get('text_never');
            }
            $this->data['last_login'] = $that->language->get('text_last_login').' '.$date;
        }

        foreach ($this->data['addresses'] as &$a) {
            $a['href'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id . '&address_id=' . $a['address_id']);
            $a['title'] = $a['address_1'] . ' ' . $a['address_2'];
            //mark default address
            if ($customer_info['address_id'] == $a['address_id']) {
                $a['default'] = 1;
            }
        }
        $this->data['add_address_url'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id);

        $this->data['fields'] = array_merge(array(
            'loginname' => 'required',
            'firstname' => 'required',
            'lastname'  => 'required',
            'email'     => 'required',
            'telephone' => 'required',
            'fax'       => 'required',
            'sms' => null,
            'newsletter' => null,
            'customer_group_id' => null,
            'status' => null,
            'approved' => null,
            'password'  => 'required'),
            (array)$this->data['fields']);

        $post=$that->request->post;
        $fields = array_keys($this->data['fields']);
        foreach ($fields as $f) {
            if (isset ($post [$f])) {
                $this->data [$f] = $post [$f];
            } elseif (isset($customer_info)) {
                $this->data[$f] = $customer_info[$f];
            } else {
                $this->data[$f] = '';
            }
        }

        if (!isset($this->data['customer_group_id']) || empty($this->data['customer_group_id'])) {
            $this->data['customer_group_id'] = $that->config->get('config_customer_group_id');
        }
        if (!isset($this->data['status']) || empty($this->data['status'])) {
            $this->data['status'] = 1;
        }
        if (!isset($this->data['password']) && isset($that->request->post['password'])) {
            $this->data['password'] = $that->request->post['password'];
        } else {
            $this->data['password'] = '';
        }

        //new customer or new address
        if (!isset($customer_id)) {
            $this->data['action'] = $that->html->getSecureURL('sale/customer/insert');
            $this->data['heading_title'] = $that->language->get('text_insert') . $that->language->get('text_customer');
            $this->data['update'] = '';
            $form = new AForm('ST');
        } else {
            $this->data['customer_id'] = $customer_id;
            $this->data['action'] = $that->html->getSecureURL('sale/customer/update', '&customer_id=' . $customer_id);
            $this->data['heading_title'] = $that->language->get('text_edit') . $that->language->get('text_customer') . ' - ' . $this->data['firstname'] . ' ' . $this->data['lastname'];
            $this->data['update'] = $that->html->getSecureURL('listing_grid/telephone/update_field', '&id=' . $customer_id);
            $form = new AForm('HS');
        }

        $that->document->addBreadcrumb(array(
            'href' => $this->data['action'],
            'text' => $this->data['heading_title'],
            'separator' => ' :: ',
            'current' => true
        ));

        $this->data['tabs']['general'] = array(
            'href' => $that->html->getSecureURL('sale/customer/update', '&customer_id=' . $customer_id),
            'text' => $that->language->get('tab_customer_details'),
            'active' => true
        );
        if (has_value($customer_id)) {
            $this->data['tabs'][] = array(
                'href' => $that->html->getSecureURL('sale/customer_transaction', '&customer_id=' . $customer_id),
                'text' => $that->language->get('tab_transactions')
            );
        }

        $that->load->model('setting/store');
        if (!$that->model_setting_store->isDefaultStore()) {
            $this->data['warning_actonbehalf'] = htmlspecialchars($that->language->get('warning_actonbehalf_additional_store'), ENT_QUOTES, 'UTF-8');
        }

        $this->data['actas'] = $that->html->buildElement(array(
            'type' => 'button',
            'text' => $that->language->get('button_actas'),
            'href' => $that->html->getSecureURL('sale/customer/actonbehalf', '&customer_id=' . $customer_id),
            'target' => 'new'
        ));

        $form->setForm(array(
            'form_name' => 'cgFrm',
            'update' => $this->data['update'],
        ));

        $this->data['form']['id'] = 'cgFrm';
        $this->data['form']['form_open'] = $form->getFieldHtml(array(
            'type' => 'form',
            'name' => 'cgFrm',
            'attr' => 'data-confirm-exit="true" class="form-horizontal"',
            'action' => $this->data['action'],
        ));
        $this->data['form']['submit'] = $form->getFieldHtml(array(
            'type' => 'button',
            'name' => 'submit',
            'text' => $that->language->get('button_save')
        ));
        $this->data['form']['reset'] = $form->getFieldHtml(array(
            'type' => 'button',
            'name' => 'reset',
            'text' => $that->language->get('button_reset')
        ));

        $this->data['form']['fields']['details']['status'] = $form->getFieldHtml(array(
            'type' => 'checkbox',
            'name' => 'status',
            'value' => $this->data['status'],
            'style' => 'btn_switch',
        ));
        $this->data['form']['fields']['details']['approved'] = $form->getFieldHtml(array(
            'type' => 'checkbox',
            'name' => 'approved',
            'value' => $this->data['approved'],
            'style' => 'btn_switch',
        ));

        $required_input = array();
        foreach($this->data['fields'] as $field_name=>$required){
            if($required){
                $required_input[] = $field_name;
            }
        }

        foreach ($required_input as $f) {
            if($viewport_mode=='modal' && in_array($f, array('password'))){
                continue;
            }
            if ($f==='telephone') {
                $this->data['form']['fields']['details'][$f] = $form->getFieldHtml(array(
                    'type' => ($f == 'password' ? 'passwordset' : 'input'),
                    'name' => $f,
                    'value' => $this->data[$f],
                    'placeholder' => '',
                    'required' => ($that->config->get('telephone_option_mandatory_status')==='1') ? true : false,
                    'style' => ($f == 'password' ? 'small-field' : '')
                ));
            } elseif($f==='fax') {
                $this->data['form']['fields']['details'][$f] = $form->getFieldHtml(array(
                    'type' => ($f == 'password' ? 'passwordset' : 'input'),
                    'name' => $f,
                    'value' => $this->data[$f],
                    'placeholder' => $that->config->get('fax_option_placeholder'),
                    'required' => ($that->config->get('fax_option_mandatory_status')==='1') ? true : false,
                    'style' => ($f == 'password' ? 'small-field' : '')
                ));
            } else {
                $this->data['form']['fields']['details'][$f] = $form->getFieldHtml(array(
                    'type' => ($f == 'password' ? 'passwordset' : 'input'),
                    'name' => $f,
                    'value' => $this->data[$f],
                    'placeholder' => '',
                    'required' => (in_array($f, array('password')) ? false : true),
                    'style' => ($f == 'password' ? 'small-field' : '')
                ));
            }
        }

        //get only active IM drivers
        $im_drivers = $that->im->getIMDriverObjects();
        if ($im_drivers){
            foreach ($im_drivers as $protocol => $driver_obj){
                /**
                 * @var AMailIM $driver_obj
                 */
                if (!is_object($driver_obj) || $protocol == 'email'){
                    continue;
                }
                $fld = $driver_obj->getURIField($form, $this->data[$protocol]);
                $this->data['form']['fields']['details'][$protocol] = $fld;
                $this->data['entry_' . $protocol] = $fld->label_text;
                $this->data['error_' . $protocol] = $this->error[$protocol];
            }
        }

        $this->data['form']['fields']['details']['newsletter'] = $form->getFieldHtml(array(
            'type' => 'selectbox',
            'name' => 'newsletter',
            'value' => $this->data['newsletter'],
            'options' => array(
                1 => $that->language->get('text_enabled'),
                0 => $that->language->get('text_disabled'),
            ),
        ));

        $that->loadModel('sale/customer_group');
        $results = $that->model_sale_customer_group->getCustomerGroups();
        $groups = array('' => $that->language->get('text_select_group'),);
        foreach ($results as $item) {
            $groups[$item['customer_group_id']] = $item['name'];
        }

        $this->data['form']['fields']['details']['customer_group'] = $form->getFieldHtml(array(
            'type' => 'selectbox',
            'name' => 'customer_group_id',
            'value' => $this->data['customer_group_id'],
            'options' => $groups,
        ));

        $this->data['section'] = 'details';
        $this->data['tabs']['general']['active'] = true;

        $saved_list_data = json_decode(html_entity_decode($that->request->cookie['grid_params']));
        if($saved_list_data->table_id == 'customer_grid') {
            $this->data['list_url'] = $that->html->getSecureURL('sale/customer', '&saved_list=customer_grid');
        }

        $that->view->assign('help_url', $that->gen_help_url('customer_edit'));
        $that->loadModel('sale/customer_transaction');
        $balance = $that->model_sale_customer_transaction->getBalance($customer_id);
        $currency = $that->currency->getCurrency($that->config->get('config_currency'));
        $this->data['balance'] = $that->language->get('text_balance') . ' ' . $that->currency->format($balance,$that->config->get('config_currency'));
        $that->view->batchAssign($this->data);

        if ($viewport_mode == 'modal') {
            unset($that->session->data['viewport_mode']);
            $tpl = 'responses/viewport/modal/sale/customer_form.tpl';
        } else {
            $tpl = 'pages/sale/customer_form.tpl';
        }

        $that->processTemplate($tpl);
    }

    public function onControllerPagesAccountInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'main' ) {
			    if ( isset( $that->request->get['order_id'] ) ) {
				    $order_id = (int) $that->request->get['order_id'];
			    } else {
				    $order_id = 0;
			    }
			    $that->loadModel( 'account/customer' );
			    $that->load->model( 'account/order' );
			    $enc   = new AEncryption( $that->config->get( 'encryption_key' ) );
			    $guest = false;

			    $ups_plus_status = $this->verifyUpsPlus();
			    if ( $ups_plus_status === '1' ) {
				    $that->load->model( 'extension/ups_integration_plus_order' );
			    }

			    if ( isset( $that->request->get['ot'] ) && $that->config->get( 'config_guest_checkout' ) ) {
				    //try to decrypt order token
				    $order_token = $that->request->get['ot'];
				    if ( $order_token ) {
					    list( $order_id, $email ) = $that->model_account_customer->parseOrderToken( $order_token );
					    if ( $order_id && $email ) {
						    $guest = true;
						    if ( $ups_plus_status === '1' ) {
							    $order_info = $that->model_extension_ups_integration_plus_order->getOrder( $order_id );
						    } else {
							    $order_info = $that->model_account_order->getOrder( $order_id, '', 'view' );
						    }
					    }
				    }
			    }

			    if ( $that->request->is_POST() && $this->_validate() ) {
				    $guest = true;

				    $order_id    = $that->request->post['order_id'];
				    $email       = $that->request->post['email'];
				    $order_token = $enc->encrypt( $order_id . '::' . $email );
				    if ( $ups_plus_status === '1' ) {
					    $order_info = $that->model_extension_ups_integration_plus_order->getOrder( $order_id );
				    } else {
					    $order_info = $that->model_account_order->getOrder( $order_id, '', 'view' );
				    }

				    //compare emails
				    if ( $order_info['email'] != $email ) {
					    unset( $order_info, $order_id, $email );
				    }
			    }

			    if ( ! $that->customer->isLogged() && ! $guest ) {
				    $that->session->data['redirect'] = $that->html->getSecureURL( 'account/invoice', '&order_id=' . $order_id );
				    $this->getInvoiceForm();

				    return null;
			    }

			    if ( ! $order_id && $that->customer->isLogged() ) {
				    $this->redirect( $that->html->getSecureURL( 'account/history' ) );
			    }

			    //get info for registered customers
			    if ( ! $order_info ) {
				    if ( $ups_plus_status === '1' ) {
					    $order_info = $that->model_extension_ups_integration_plus_order->getOrder( $order_id );
				    } else {
					    $order_info = $that->model_account_order->getOrder( $order_id, '', 'view' );
				    }
			    }

			    if ( $order_info ) {
				    $this->data['order_id']   = $order_id;
				    $this->data['invoice_id'] = $order_info['invoice_id'] ? $order_info['invoice_prefix'] . $order_info['invoice_id'] : '';

				    $this->data['email']     = $order_info['email'];
				    $this->data['telephone'] = $order_info['telephone'];

				    $this->data['mobile_phone'] = $that->im->getCustomerURI( 'sms', (int) $order_info['customer_id'], $order_id );

				    $this->data['fax'] = $order_info['fax'];

				    $this->data['status'] = $that->model_account_order->getOrderStatus( $order_id );
				    if ( $ups_plus_status === '1' ) {
					    $shipping_data = array(
						    'firstname'      => $order_info['shipping_firstname'],
						    'lastname'       => $order_info['shipping_lastname'],
						    'company'        => $order_info['shipping_company'],
						    'address_1'      => $order_info['shipping_address_1'],
						    'address_2'      => $order_info['shipping_address_2'],
						    'city'           => $order_info['shipping_city'],
						    'postcode'       => $order_info['shipping_postcode'],
						    'zone'           => $order_info['shipping_zone'],
						    'zone_code'      => $order_info['shipping_zone_code'],
						    'country'        => $order_info['shipping_country'],
						    'location_phone' => $order_info['location_phone']
					    );
				    } else {
					    $shipping_data = array(
						    'firstname' => $order_info['shipping_firstname'],
						    'lastname'  => $order_info['shipping_lastname'],
						    'company'   => $order_info['shipping_company'],
						    'address_1' => $order_info['shipping_address_1'],
						    'address_2' => $order_info['shipping_address_2'],
						    'city'      => $order_info['shipping_city'],
						    'postcode'  => $order_info['shipping_postcode'],
						    'zone'      => $order_info['shipping_zone'],
						    'zone_code' => $order_info['shipping_zone_code'],
						    'country'   => $order_info['shipping_country']
					    );
				    }

				    $this->data['shipping_address'] = $this->getFormattedAddress( $shipping_data );
				    $this->data['shipping_method']  = $order_info['shipping_method'];

				    $payment_data = array(
					    'firstname' => $order_info['payment_firstname'],
					    'lastname'  => $order_info['payment_lastname'],
					    'company'   => $order_info['payment_company'],
					    'address_1' => $order_info['payment_address_1'],
					    'address_2' => $order_info['payment_address_2'],
					    'city'      => $order_info['payment_city'],
					    'postcode'  => $order_info['payment_postcode'],
					    'zone'      => $order_info['payment_zone'],
					    'zone_code' => $order_info['payment_zone_code'],
					    'country'   => $order_info['payment_country']
				    );

				    $this->data['payment_address'] = $this->getFormattedAddress( $payment_data );
				    $this->data['payment_method']  = $order_info['payment_method'];

				    $products       = array();
				    $order_products = $that->model_account_order->getOrderProducts( $order_id );

				    $product_ids = array();
				    foreach ( $order_products as $product ) {
					    $product_ids[] = (int) $product['product_id'];
				    }

				    //get thumbnails by one pass
				    $resource   = new AResource( 'image' );
				    $thumbnails = $resource->getMainThumbList(
					    'products',
					    $product_ids,
					    $that->config->get( 'config_image_cart_width' ),
					    $that->config->get( 'config_image_cart_height' ),
					    false
				    );

				    foreach ( $order_products as $product ) {
					    $options     = $that->model_account_order->getOrderOptions( $order_id, $product['order_product_id'] );
					    $thumbnail   = $thumbnails[ $product['product_id'] ];
					    $option_data = array();
					    foreach ( $options as $option ) {
						    if ( $option['element_type'] == 'H' ) {
							    continue;
						    } //hide hidden options

						    $value = $option['value'];
						    $title = '';
						    // hide binary value for checkbox
						    if ( $option['element_type'] == 'C' && in_array( $value, array( 0, 1 ) ) ) {
							    $value = '';
						    }
						    // strip long textarea value
						    if ( $option['element_type'] == 'T' ) {
							    $title = strip_tags( $value );
							    $title = str_replace( '\r\n', "\n", $title );

							    $value = str_replace( '\r\n', "\n", $value );
							    if ( mb_strlen( $value ) > 64 ) {
								    $value = mb_substr( $value, 0, 64 ) . '...';
							    }
						    }
						    $link_status = $this->verifyOptionPriceLink();
						    if ( $option['link'] !== '' && $link_status === '1' ) {
							    $that->load->model( 'option_price_link_pro/util' );
							    $option_data[] = array(
								    'value' => $value,
								    'title' => $title,
								    'link'  => $that->model_option_price_link_pro_util->autolink( $option['link'], array( "target" => "_blank" ) )
							    );
						    } else {
							    $option_data[] = array(
								    'value' => $value,
								    'title' => $title
							    );
						    }

						    // product image by option value
						    $mSizes     = array(
							    'main'  =>
								    array(
									    'width'  => $that->config->get( 'config_image_cart_width' ),
									    'height' => $that->config->get( 'config_image_cart_height' )
								    ),
							    'thumb' => array(
								    'width'  => $that->config->get( 'config_image_cart_width' ),
								    'height' => $that->config->get( 'config_image_cart_height' )
							    ),
						    );
						    $main_image =
							    $resource->getResourceAllObjects( 'product_option_value', $option['product_option_value_id'], $mSizes, 1, false );
						    if ( ! empty( $main_image ) ) {
							    $thumbnail['origin']      = $main_image['origin'];
							    $thumbnail['title']       = $main_image['title'];
							    $thumbnail['description'] = $main_image['description'];
							    $thumbnail['thumb_html']  = $main_image['thumb_html'];
							    $thumbnail['thumb_url']   = $main_image['thumb_url'];
						    }
					    }
					    $products[] = array(
						    'id'        => $product['product_id'],
						    'thumbnail' => $thumbnail,
						    'name'      => $product['name'],
						    'model'     => $product['model'],
						    'option'    => $option_data,
						    'quantity'  => $product['quantity'],
						    'price'     => $that->currency->format( $product['price'], $order_info['currency'], $order_info['value'] ),
						    'total'     => $that->currency->format_total( $product['price'], $product['quantity'], $order_info['currency'], $order_info['value'] )
					    );
				    }
				    $this->data['products']     = $products;
				    $this->data['totals']       = $that->model_account_order->getOrderTotals( $order_id );
				    $this->data['comment']      = $order_info['comment'];
				    $this->data['product_link'] = $that->html->getSecureURL( 'product/product', '&product_id=%ID%' );

				    $histories = array();
				    $results   = $that->model_account_order->getOrderHistories( $order_id );
				    foreach ( $results as $result ) {
					    $histories[] = array(
						    'date_added' => dateISO2Display( $result['date_added'], $that->language->get( 'date_format_short' ) . ' ' . $that->language->get( 'time_format' ) ),
						    'status'     => $result['status'],
						    'comment'    => nl2br( $result['comment'] )
					    );
				    }
				    $this->data['historys'] = $histories;

				    if ( $guest ) {
					    $this->data['continue'] = $that->html->getHomeURL();
				    } else {
					    $this->data['continue'] = $that->html->getSecureURL( 'account/history' );
				    }

				    $this->data['button_print'] = $that->html->buildElement(
					    array(
						    'type'  => 'button',
						    'name'  => 'print_button',
						    'text'  => $that->language->get( 'button_print' ),
						    'icon'  => 'fa fa-print',
						    'style' => 'button'
					    ) );

				    //button for order cancelation
				    if ( $that->config->get( 'config_customer_cancelation_order_status_id' ) ) {
					    $order_cancel_ids = unserialize( $that->config->get( 'config_customer_cancelation_order_status_id' ) );
					    if ( in_array( $order_info['order_status_id'], $order_cancel_ids ) ) {
						    $this->data['button_order_cancel'] = $that->html->buildElement(
							    array(
								    'type'  => 'button',
								    'name'  => 'button_order_cancelation',
								    'text'  => $that->language->get( 'text_order_cancelation' ),
								    'icon'  => 'fa fa-ban',
								    'style' => 'button'
							    ) );
						    if ( ! $guest ) {
							    $this->data['order_cancelation_url'] = $that->html->getSecureURL( 'account/invoice/CancelOrder', '&order_id=' . $order_id );
						    } else {
							    $this->data['order_cancelation_url'] = $that->html->getSecureURL( 'account/invoice/CancelOrder', '&ot=' . $order_token );
						    }
					    }
				    }
				    if ( $guest && $that->download->getTotalOrderDownloads( $order_id, 0 ) ) {
					    $this->data['button_download'] = $that->html->buildElement(
						    array(
							    'type'  => 'button',
							    'name'  => 'download_button',
							    'href'  => $that->html->getSecureURL( 'account/download', '&ot=' . $order_token ),
							    'text'  => $that->language->get( 'text_downloads', 'account/download' ),
							    'icon'  => 'fa fa-download fa-fw',
							    'style' => 'button'
						    ) );
				    }

				    $that->view->setTemplate( 'pages/account/invoice.tpl' );
			    } else {
				    if ( $guest ) {
					    $this->data['continue'] = $that->html->getHomeURL();
				    } else {
					    $this->data['continue'] = $that->html->getSecureURL( 'account/account' );
				    }
				    $that->view->setTemplate( 'pages/error/not_found.tpl' );
			    }
			    $that->view->batchAssign( $this->data );
			    $that->processTemplate();
		    }
    }


    public function onControllerPagesCheckoutShipping_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'main' ) {
			    $address_rt = 'checkout/address/shipping';
			    $that->loadModel( 'account/address' );
			    $shipping_address = $that->model_account_address->getAddress( $that->session->data['shipping_address_id'] );

			    //something wrong with shipping address go to address selection page
			    if ( ! $shipping_address ) {
				    $this->redirect( $that->html->getSecureURL( $address_rt ) );
			    }

			    $that->view->assign( 'address', $this->getFormattedAddress( $shipping_address ) );
		    }
    }

    public function onControllerPagesCheckoutPayment_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'main' ) {
			    $address_rt = 'checkout/address/payment';
			    $that->loadModel( 'account/address' );
			    $payment_address = $that->model_account_address->getAddress( $that->session->data['payment_address_id'] );
			    if ( ! $payment_address ) {
				    $this->redirect( $that->html->getSecureURL( $address_rt ) );
			    }
			    $that->view->assign( 'address', $this->getFormattedAddress( $payment_address ) );
		    }
    }

    private function getInvoiceForm(){
        $that =& $this->baseObject;
        $that->document->resetBreadcrumbs();

        $that->document->addBreadcrumb(array (
            'href'      => $that->html->getURL('index/home'),
            'text'      => $that->language->get('text_home'),
            'separator' => false
        ));

        $that->document->addBreadcrumb(array (
            'href'      => $that->html->getURL('account/account'),
            'text'      => $that->language->get('text_account'),
            'separator' => $that->language->get('text_separator')
        ));

        $that->document->addBreadcrumb(array (
            'href'      => $that->html->getURL('account/invoice'),
            'text'      => $that->language->get('heading_title'),
            'separator' => $that->language->get('text_separator')
        ));

        $this->data['back'] = $that->html->getHomeURL();

        $form = new AForm();
        $form->setForm(array ('form_name' => 'CheckOrderFrm'));

        $this->data['form']['form_open'] = $form->getFieldHtml(
            array (
                'type'   => 'form',
                'name'   => 'CheckOrderFrm',
                'action' => $that->html->getSecureURL('account/invoice'),
                'csrf' => true,
            ));

        $order_id = (int)$that->request->post_or_get('order_id') ? (int)$that->request->post_or_get('order_id') : '';
        $this->data['form']['order_id'] = $form->getFieldHtml(
            array (
                'type'     => 'input',
                'name'     => 'order_id',
                'value'    => $order_id,
                'required' => true));

        $this->data['entry_order_id'] = $that->language->get('text_order_id');


        $this->data['form']['email'] = $form->getFieldHtml(
            array (
                'type'     => 'input',
                'name'     => 'email',
                'value'    => $that->request->post['email'],
                'required' => true));

        $this->data['entry_email'] = $that->language->get('text_email');

        $this->data['form']['back'] = $form->getFieldHtml(
            array (
                'type'  => 'button',
                'name'  => 'back',
                'text'  => $that->language->get('button_back'),
                'icon'  => 'fa fa-arrow-left',
                'style' => 'button'));

        $this->data['form']['submit'] = $form->getFieldHtml(
            array (
                'type' => 'submit',
                'icon' => 'fa fa-check',
                'name' => $that->language->get('button_continue')
            ));

        $that->view->batchAssign($this->data);
        $that->processTemplate('pages/account/order.tpl');
    }

    public function onControllerPagesAccountOrderDetails_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $fax=$that->data['fax'];
            if (strtolower($fax)=='na' || strtolower($fax)=='none') {
                $that->view->assign('fax','');
            }
            $shipping_address=$that->data['shipping_address'];
            $find_shipping_address=array("na<br />","none<br />","NA<br />","None<br />","NONE<br />");
            $replace_shipping_address=array("","","","","");
            $that->view->assign('shipping_address',str_replace($find_shipping_address,$replace_shipping_address,$shipping_address));

            $payment_address=$that->data['payment_address'];
            $find_shipping_address=array("na<br />","none<br />","NA<br />","None<br />","NONE<br />");
            $replace_payment_address=array("","","","","");
            $that->view->assign('payment_address',str_replace($find_shipping_address,$replace_payment_address,$payment_address));
        }
    }

    public function onModelCheckoutOrder_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='sf_order_confirm_mail') {
            $ups_plus_status = $this->verifyUpsPlus();
            $order_id=$that->data['mail_template_data']['order_id'];
            if ( $ups_plus_status === '1' ) {
                $order_query = $that->db->query( "SELECT o.*,
												l.filename AS filename,
												l.directory AS directory,
												ap.location_phone
										 FROM `" . $that->db->table( "orders" ) . "` o
										 LEFT JOIN " . $that->db->table( "languages" ) . " l ON (o.language_id = l.language_id)
										 LEFT JOIN " . $that->db->table( "ap_address_phone" ) . " ap ON ap.order_id=o.order_id
										 WHERE o.order_id = '" . (int) $order_id . "'
										        AND o.order_status_id = '0'" );
            } else {
                $order_query = $that->db->query( "SELECT *,
												l.filename AS filename,
												l.directory AS directory
										 FROM `" . $that->db->table( "orders" ) . "` o
										 LEFT JOIN " . $that->db->table( "languages" ) . " l ON (o.language_id = l.language_id)
										 WHERE o.order_id = '" . (int) $order_id . "'
										        AND o.order_status_id = '0'" );
            }

            if ( ! $order_query->num_rows ) {
                return false;
            }
            $order_row = $that->dcrypt->decrypt_data( $order_query->row, 'orders' );
            $that->load->model('localisation/zone');

            $shipping_zone_row = $that->model_localisation_zone->getZone($order_row['shipping_zone_id']);
            if ($shipping_zone_row) {
                $shipping_zone_code = $shipping_zone_row['code'];
            } else {
                $shipping_zone_code = '';
            }
            $shipping_data = array(
                'firstname' => $order_row['shipping_firstname'],
                'lastname'  => $order_row['shipping_lastname'],
                'company'   => strtolower($order_row['shipping_company'])==='na' || strtolower($order_row['shipping_company'])==='none' ? "" : $order_row['shipping_company'],
                'address_1' => $order_row['shipping_address_1'],
                'address_2' => $order_row['shipping_address_2'],
                'city'      => $order_row['shipping_city'],
                'postcode'  => $order_row['shipping_postcode'],
                'zone'      => $order_row['shipping_zone'],
                'zone_code' => $shipping_zone_code,
                'country'   => $order_row['shipping_country'],
            );

            $that->data['mail_template_data']['shipping_data'] = $shipping_data;
            $that->data['mail_template_data']['shipping_address'] = $this->getFormattedAddress( $shipping_data, '' );

            $payment_zone_row = $that->model_localisation_zone->getZone($order_row['payment_zone_id']);
            if ($payment_zone_row) {
                $payment_zone_code = $payment_zone_row['code'];
            } else {
                $payment_zone_code = '';
            }

            $payment_data = array(
                'firstname' => $order_row['payment_firstname'],
                'lastname' => $order_row['payment_lastname'],
                'company' => strtolower($order_row['payment_company']) === 'na' || strtolower($order_row['payment_company']) === 'none' ? "" : $order_row['payment_company'],
                'address_1' => $order_row['payment_address_1'],
                'address_2' => $order_row['payment_address_2'],
                'city' => $order_row['payment_city'],
                'postcode' => $order_row['payment_postcode'],
                'zone' => $order_row['payment_zone'],
                'zone_code' => $payment_zone_code,
                'country' => $order_row['payment_country'],
            );

            if ( $that->config->get( 'taxid_show_seller_info' ) === '1' ) {
                $that->data['mail_template_data']['seller_info']  = html_entity_decode( nl2br( $that->config->get( 'taxid_seller_info' ) ) );
            } else {
                $that->data['mail_template_data']['seller_info']  = "";
            }

            $that->data['mail_template_data']['customer_fax'] = $order_row['fax']==='na' || $order_row['fax']==='none' ? '' : $order_row['fax'];
            $that->data['mail_template_data']['payment_data'] = $payment_data;
            $that->data['mail_template_data']['payment_address'] = $this->getFormattedAddress( $payment_data, '' );
        }
    }

    private function _getStorefrontAddressForm() {
        $that =& $this->baseObject;
        $that->document->resetBreadcrumbs();

        $that->document->addBreadcrumb(array(
            'href' => $that->html->getHomeURL(),
            'text' => $that->language->get('text_home'),
            'separator' => false
        ));

        $that->document->addBreadcrumb(array(
            'href' => $that->html->getSecureURL('account/account'),
            'text' => $that->language->get('text_account'),
            'separator' => $that->language->get('text_separator')
        ));

        $that->document->addBreadcrumb(array(
            'href' => $that->html->getSecureURL('account/address'),
            'text' => $that->language->get('heading_title'),
            'separator' => $that->language->get('text_separator')
        ));

        if (!isset($that->request->get['address_id'])) {
            $that->document->addBreadcrumb(array(
                'href' => $that->html->getSecureURL('account/address/insert'),
                'text' => $that->language->get('text_edit_address'),
                'separator' => $that->language->get('text_separator')
            ));
        } else {
            $that->document->addBreadcrumb(array(
                'href' => $that->html->getSecureURL('account/address/update', 'address_id=' . $that->request->get['address_id']),
                'text' => $that->language->get('text_edit_address'),
                'separator' => $that->language->get('text_separator')
            ));
        }

        $that->view->assign('error_warning', $that->error['warning']);
        $that->view->assign('error_firstname', $that->error['firstname']);
        $that->view->assign('error_lastname', $that->error['lastname']);
        $that->view->assign('error_company', $that->error['company']);
        $that->view->assign('error_address_1', $that->error['address_1']);
        $that->view->assign('error_city', $that->error['city']);
        $that->view->assign('error_postcode', $that->error['postcode']);
        $that->view->assign('error_country', $that->error['country']);
        $that->view->assign('error_zone', $that->error['zone']);

        unset($that->session->data['field_errors']);

        if (isset($that->request->get['address_id']) && $that->request->is_GET()) {
            $address_info = $that->model_account_address->getAddress($that->request->get['address_id']);
        }

        $this->data['back'] = $that->html->getSecureURL('account/address');

        $form = new AForm();
        $form->setForm(array('form_name' => 'AddressFrm'));

        if (!isset($that->request->get['address_id'])) {
            $action = $that->html->getSecureURL('account/address/insert');
        } else {
            $action = $that->html->getSecureURL('account/address/update', '&address_id=' . $that->request->get['address_id']);
        }
        $this->data['form']['form_open'] = $form->getFieldHtml(
            array (
                'type'   => 'form',
                'name'   => 'AddressFrm',
                'action' => $action,
                'csrf' => true,
            )
        );

        if (isset($that->request->post['firstname'])) {
            $firstname = $that->request->post['firstname'];
        } elseif (isset($address_info)) {
            $firstname = $address_info['firstname'];
        } else {
            $firstname = '';
        }
        $this->data['form']['fields']['firstname'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'firstname',
            'value' => $firstname,
            'required' => true));

        if (isset($that->request->post['lastname'])) {
            $lastname = $that->request->post['lastname'];
        } elseif (isset($address_info)) {
            $lastname = $address_info['lastname'];
        } else {
            $lastname = '';
        }
        $this->data['form']['fields']['lastname'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'lastname',
            'value' => $lastname,
            'required' => true));

        if (isset($that->request->post['company'])) {
            $company = $that->request->post['company'];
        } elseif (isset($address_info)) {
            $company = $address_info['company'];
        } else {
            $company = '';
        }
        $this->data['form']['fields']['company'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'company',
            'value' => $company,
            'placeholder' => $that->config->get('company_option_placeholder'),
            'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false));

        if (isset($that->request->post['address_1'])) {
            $address_1 = $that->request->post['address_1'];
        } elseif (isset($address_info)) {
            $address_1 = $address_info['address_1'];
        } else {
            $address_1 = '';
        }
        $this->data['form']['fields']['address_1'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'address_1',
            'value' => $address_1,
            'required' => true));

        if (isset($that->request->post['address_2'])) {
            $address_2 = $that->request->post['address_2'];
        } elseif (isset($address_info)) {
            $address_2 = $address_info['address_2'];
        } else {
            $address_2 = '';
        }
        $this->data['form']['fields']['address_2'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'address_2',
            'value' => $address_2,
            'required' => false));

        if (isset($that->request->post['city'])) {
            $city = $that->request->post['city'];
        } elseif (isset($address_info)) {
            $city = $address_info['city'];
        } else {
            $city = '';
        }
        $this->data['form']['fields']['city'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'city',
            'value' => $city,
            'required' => true));

        if (isset($that->request->post['zone_id'])) {
            $this->data['zone_id'] = $that->request->post['zone_id'];
        } elseif (isset($address_info)) {
            $this->data['zone_id'] = $address_info['zone_id'];
        } else {
            $this->data['zone_id'] = 'false';
        }

        $this->data['form']['fields']['zone'] = $form->getFieldHtml(array(
            'type' => 'selectbox',
            'name' => 'zone_id',
            'value' => $this->data['zone_id'],
            'required' => true));

        if (isset($that->request->post['postcode'])) {
            $postcode = $that->request->post['postcode'];
        } elseif (isset($address_info)) {
            $postcode = $address_info['postcode'];
        } else {
            $postcode = '';
        }
        $this->data['form']['fields']['postcode'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'postcode',
            'value' => $postcode,
            'required' => true));
        if (isset($that->request->post['country_id'])) {
            $country_id = $that->request->post['country_id'];
        } elseif (isset($address_info)) {
            $country_id = $address_info['country_id'];
        } else {
            $country_id = $that->config->get('config_country_id');
        }

        $that->loadModel('localisation/country');
        $countries = $that->model_localisation_country->getCountries();
        $options = array("false" => $that->language->get('text_select'));
        foreach ($countries as $item) {
            $options[$item['country_id']] = $item['name'];
        }
        $this->data['form']['fields']['country'] = $form->getFieldHtml(array(
            'type' => 'selectbox',
            'name' => 'country_id',
            'options' => $options,
            'value' => $country_id,
            'required' => true));
        if (isset($that->request->post['default'])) {
            $default = $that->request->post['default'];
        } elseif (isset($that->request->get['address_id'])) {
            $default = $that->customer->getAddressId() == $that->request->get['address_id'];
        } else {
            $default = false;
        }
        $this->data['form']['default'] = $form->getFieldHtml(array(
            'type' => 'radio',
            'name' => 'default',
            'value' => $default,
            'options' => array(
                '1' => $that->language->get('text_yes'),
                '0' => $that->language->get('text_no'),
            )));
        $this->data['form']['back'] = $form->getFieldHtml(array(
            'type' => 'button',
            'name' => 'back',
            'text' => $that->language->get('button_back'),
            'icon' => 'fa fa-arrow-left',
            'style' => 'button'));
        $this->data['form']['submit'] = $form->getFieldHtml(array(
            'type' => 'submit',
            'icon' => 'fa fa-check',
            'name' => $that->language->get('button_continue')
        ));

        $that->view->batchAssign($this->data);
        $that->processTemplate('pages/account/address.tpl');
    }

    private function _getCheckoutAddressForm($type) {
        $that =& $this->baseObject;

        $this->data['default'] = $that->session->data[$type . '_address_id'];
        $this->data['error_company']=$that->session->data['error_company'];
        unset($that->session->data['error_company']);
        $form = new AForm();
        $form->setForm(array('form_name' => 'address_1'));
        $this->data['form0']['form_open'] = $form->getFieldHtml(
            array (
                'type'   => 'form',
                'name'   => 'address_1',
                'action' => $that->html->getSecureURL('checkout/address/' . $type),
                'csrf' => true
            )
        );

        $addresses = array();
        $results = $that->model_account_address->getAddresses();

        foreach ($results as $result) {
            $addresses[] = array(
                'address_id' => $result['address_id'],
                'address' => $result['firstname'] . ' ' . $result['lastname'] . ', ' . $result['address_1'] . ', ' . $result['city'] . ', ' . (($result['zone']) ? $result['zone'] . ', ' : false) . (($result['postcode']) ? $result['postcode'] . ', ' : false) . $result['country'],
                'href' => $that->html->getSecureURL('account/address/' . $type, 'address_id=' . $result['address_id']),
                'radio' => $form->getFieldHtml(array('type' => 'radio',
                    'id' => 'a_' . $result['address_id'],
                    'name' => 'address_id',
                    'options' => array($result['address_id'] => ''),
                    'value' => ($result['address_id'] == $this->data['default'] ? $result['address_id'] : ''),
                )),
            );
        }
        $this->data['addresses'] = $addresses;

        $this->data['form0']['continue'] = $form->getFieldHtml(array(
            'type' => 'submit',
            'name' => $that->language->get('button_continue')));

        $form = new AForm();
        $form->setForm(array('form_name' => 'Address2Frm'));
        $this->data['form']['form_open'] = $form->getFieldHtml(
            array (
                'type'   => 'form',
                'name'   => 'Address2Frm',
                'action' => $that->html->getSecureURL('checkout/address/' . $type),
                'csrf' => true
            )
        );

        $this->data['form']['firstname'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'firstname',
            'value' => $that->request->post['firstname'],
            'required' => true));
        $this->data['form']['lastname'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'lastname',
            'value' => $that->request->post['lastname'],
            'required' => true));
        $this->data['form']['company'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'company',
            'value' => $that->request->post['company'],
            'placeholder' => $that->config->get('company_option_placeholder'),
            'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false));
        $this->data['form']['address_1'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'address_1',
            'value' => $that->request->post['address_1'],
            'required' => true));
        $this->data['form']['address_2'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'address_2',
            'value' => $that->request->post['address_2'],
            'required' => false));
        $this->data['form']['city'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'city',
            'value' => $that->request->post['city'],
            'required' => true));
        $this->data['form']['postcode'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'postcode',
            'value' => $that->request->post['postcode'],
            'required' => true));
        $that->loadModel('localisation/country');
        $countries = $that->model_localisation_country->getCountries();
        $options = array("false" => $that->language->get('text_select'));
        foreach ($countries as $item) {
            $options[$item['country_id']] = $item['name'];
        }
        $this->data['form']['country_id'] = $form->getFieldHtml(array(
            'type' => 'selectbox',
            'name' => 'country_id',
            'options' => $options,
            'value' => (isset($that->request->post['country_id']) ? $that->request->post['country_id'] : $that->config->get('config_country_id')),
            'required' => true));

        $this->data['form']['zone'] = $form->getFieldHtml(array(
            'type' => 'selectbox',
            'name' => 'zone_id',
            'required' => true));

        $this->data['form']['continue'] = $form->getFieldHtml(array(
            'type' => 'submit',
            'name' => $that->language->get('button_continue')));


        $this->data['zone_id'] = isset($that->request->post['zone_id']) ? $that->request->post['zone_id'] : 'false';

        $that->loadModel('localisation/country');
        $this->data['countries'] = $that->model_localisation_country->getCountries();

        $that->view->batchAssign($this->data);
        if ($that->config->get('embed_mode') == true) {
            //load special headers
            $that->addChild('responses/embed/head', 'head');
            $that->addChild('responses/embed/footer', 'footer');
            $that->processTemplate('embed/checkout/address.tpl');
        } else {
            $that->processTemplate('pages/checkout/address.tpl');
        }
    }

    private function _getAdressForm() {
        $that =& $this->baseObject;
        $address_id = $that->request->get['address_id'];
        $customer_id = $that->request->get['customer_id'];
        $this->data['token'] = $that->session->data['token'];
        $this->data['error'] = $that->error;

        $that->document->initBreadcrumb(array(
            'href' => $that->html->getHomeURL(),
            'text' => $that->language->get('text_home'),
            'separator' => false
        ));

        $that->document->addBreadcrumb(array(
            'href' => $that->html->getSecureURL('sale/customer'),
            'text' => $that->language->get('heading_title'),
            'current' => true
        ));

        $this->data['addresses'] = array();

        if (has_value($customer_id)) {
            $customer_info = $that->model_sale_customer->getCustomer($customer_id);
            $this->data['button_orders_count'] = $that->html->buildElement(
                array(
                    'type' => 'button',
                    'name' => 'view orders',
                    'text' => $that->language->get('text_total_order') . ': ' . $customer_info['orders_count'],
                    'style' => 'button2',
                    'href' => $that->html->getSecureURL('sale/order', '&customer_id=' . $customer_id),
                    'title' => $that->language->get('text_view') . ' ' . $that->language->get('tab_history')
                )
            );
            $this->data['addresses'] = $that->model_sale_customer->getAddressesByCustomerId($customer_id);
        }

        //current edited address
        $current_address = array();
        if ($this->data['addresses']) {
            foreach ($this->data['addresses'] as &$a) {
                $a['href'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id . '&address_id=' . $a['address_id']);
                $a['title'] = $a['address_1'] . ' ' . $a['address_2'];
                //mark default address
                if ($customer_info['address_id'] == $a['address_id']) {
                    $a['default'] = 1;
                }
                if ($address_id == $a['address_id']) {
                    $current_address = $a;
                    $this->data['current_address'] = $a['title'];
                }
            }
        }
        if ($that->request->post) {
            $current_address = $that->request->post;
        }

        $that->loadModel('localisation/country');
        $this->data['countries'] = $that->model_localisation_country->getCountries();
        $this->data['customer_id'] = $customer_id;

        $this->data['add_address_url'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id);
        $this->data['category_products'] = $that->html->getSecureURL('product/product/category');
        $this->data['common_zone'] = $that->html->getSecureURL('common/zone');

        if (!has_value($address_id)) {
            //new address
            $this->data['action'] = $that->html->getSecureURL('sale/customer/insert_address', '&customer_id=' . $customer_id);
            $this->data['tab_customer_address'] = $that->language->get('text_add_address');
            $this->data['heading_title'] = $that->language->get('text_insert') . $that->language->get('text_customer');
            $this->data['update'] = '';
            $form = new AForm('ST');
        } else {
            //edit address
            $this->data['heading_title'] = $that->language->get('text_edit_address');
            $this->data['action'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id . '&address_id=' . $address_id);
            $this->data['update'] = $that->html->getSecureURL('listing_grid/telephone/update_field', '&id=' . $customer_id . '&address_id=' . $address_id);
            $this->data['tab_customer_address'] = $that->language->get('text_edit_address');
            $form = new AForm('HS');
        }

        $that->document->addBreadcrumb(array(
            'href' => $this->data['action'],
            'text' => $this->data['heading_title'],
            'current' => true
        ));

        $this->data['tabs']['general'] = array(
            'href' => $that->html->getSecureURL('sale/customer/update', '&customer_id=' . $customer_id),
            'text' => $that->language->get('tab_customer_details'),
            'active' => true
        );

        if (has_value($customer_id)) {
            $this->data['tabs'][] = array(
                'href' => $that->html->getSecureURL('sale/customer_transaction', '&customer_id=' . $customer_id),
                'text' => $that->language->get('tab_transactions')
            );
        }

        $this->data['actas'] = $that->html->buildElement(array(
            'type' => 'button',
            'text' => $that->language->get('button_actas'),
            'href' => $that->html->getSecureURL('sale/customer/actonbehalf', '&customer_id=' . $customer_id),
            'target' => 'new'
        ));

        $form->setForm(array(
            'form_name' => 'cgFrm',
            'update' => $this->data['update'],
        ));

        $this->data['form']['id'] = 'cgFrm';
        $this->data['form']['form_open'] = $form->getFieldHtml(array(
            'type' => 'form',
            'name' => 'cgFrm',
            'attr' => 'data-confirm-exit="true" class="form-horizontal"',
            'action' => $this->data['action'],
        ));
        $this->data['form']['submit'] = $form->getFieldHtml(array(
            'type' => 'button',
            'name' => 'submit',
            'text' => $that->language->get('button_save')
        ));
        $this->data['form']['reset'] = $form->getFieldHtml(array(
            'type' => 'button',
            'name' => 'reset',
            'text' => $that->language->get('button_reset')
        ));

        foreach ($current_address as $name => $value) {
            $this->data['address'][$name] = $value;
        }

        $this->data['section'] = 'address';

        $that->view->assign('help_url', $that->gen_help_url('customer_edit'));
        $that->loadModel('sale/customer_transaction');
        $balance = $that->model_sale_customer_transaction->getBalance($customer_id);
        $this->data['balance'] = $that->language->get('text_balance') . ' ' . $that->currency->format($balance,$that->config->get('config_currency'));

        //note: Only allow to delete or change if not default
        if (!$current_address['default']) {
            if (has_value($address_id)) {
                $this->data['form']['delete'] = $form->getFieldHtml(array(
                    'type' => 'button',
                    'name' => 'delete',
                    'href' => $that->html->getSecureURL('sale/customer/delete_address',
                        '&customer_id=' . $customer_id . '&address_id=' . $address_id),
                    'text' => $that->language->get('button_delete')
                ));
            }

            $this->data['form']['fields']['address']['default'] = $form->getFieldHtml(array('type' => 'checkbox',
                'name' => 'default',
                'value' => $current_address['default'],
                'style' => 'btn_switch'));
        }
        foreach ($this->address_fields as $name => $desc) {
            if ($name == 'company') {
                $fld_array = array(
                    'type' => $desc['type'],
                    'name' => $name,
                    'value' => $this->data['address'][$name],
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                );
            } else {
                $fld_array = array(
                    'type' => $desc['type'],
                    'name' => $name,
                    'value' => $this->data['address'][$name],
                    'required' => $desc['required']
                );
            }
            if ($desc['type'] == 'zones') {
                $fld_array['submit_mode'] = 'id';
                $fld_array['zone_name'] = $this->data['address']['zone'];
                $fld_array['zone_value'] = $this->data['address']['zone_id'];
            }
            $this->data['form']['fields']['address'][$name] = $form->getFieldHtml($fld_array);
        }

        $that->view->batchAssign($this->data);
        $that->processTemplate('pages/sale/customer_form.tpl');
    }

    /**
     * @param $data_array
     * @param string $type
     * @param array $locate
     * @return mixed
     */
    private function getFormattedAddress($data_array,$locate = array()) {
        $that =& $this->baseObject;
        $format = '';
        $data_array = (array)$data_array;
        $ups_plus_status=$this->verifyUpsPlus();
        if ($ups_plus_status==='1') {
            $that->load->language('ups_integration_plus/ups_integration_plus');
        }
        if (strtolower($data_array['company']) != 'none' && strtolower($data_array['company']) != 'na' && $data_array['company'] != '') {
            $company = ' {company} ';
        }
        // Set default format
        if ($data_array['location_phone'] !== '' && !empty($data_array['location_phone'])) {
            $format = '{firstname} {lastname}' . "\n" . $company . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}' . "\n" .$that->language->get('text_ups_plus_telephone') . ' {location_phone}';
        } else {
            $format = '{firstname} {lastname}' . "\n" . $company . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
        }
        //Set default variable to be set for address based on the data
        if (count($locate) <= 0) {
            $locate = array();
            foreach ($data_array as $key => $value) {
                $locate[] = "{" . $key . "}";
            }
        }

        return str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($locate, $data_array, $format))));
    }

    private function _validate(){
        $that =& $this->baseObject;
        if (!(int)$that->request->post['order_id']){
            $this->error['order_id'] = $that->language->get('error_order_id');
        }

        if (mb_strlen($that->request->post['email']) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $that->request->post['email'])){
            $this->error['email'] = $that->language->get('error_email');
        }

        $that->extensions->hk_ValidateData($this);

        return !$this->error ? true : false;

    }

    // Redirect to new page
    private function redirect($url) {
        header('Location: ' . str_replace('&amp;', '&', $url));
        die();
    }

    private function getList() {
        $that =& $this->baseObject;
        $that->document->addBreadcrumb(array(
            'href' => $that->html->getURL('index/home'),
            'text' => $that->language->get('text_home'),
            'separator' => FALSE
        ));

        $that->document->addBreadcrumb(array(
            'href' => $that->html->getURL('account/account'),
            'text' => $that->language->get('text_account'),
            'separator' => $that->language->get('text_separator')
        ));

        $that->document->addBreadcrumb(array(
            'href' => $that->html->getURL('account/address'),
            'text' => $that->language->get('heading_title'),
            'separator' => $that->language->get('text_separator')
        ));

        $that->view->assign('error_warning', $this->error['warning']);
        $that->view->assign('success', $that->session->data['success']);

        $addresses = array();

        $results = $that->model_account_address->getAddresses();

        foreach ($results as $result) {
            $formated_address = $this->getFormattedAddress($result);

            $edit = HtmlElementFactory::create(array(
                'type' => 'button',
                'text' => $that->language->get('button_edit'),
                'style' => 'button btn-primary',
                'icon' => 'fa-edit fa',
                'attr' => 'onclick="location = \'' . $that->html->getSecureURL('account/address/update', '&address_id=' . $result['address_id']) . '\'" '));
            $delete = HtmlElementFactory::create(array(
                'type' => 'button',
                'text' => $that->language->get('button_delete'),
                'style' => '',
                'icon' => 'fa fa-remove',
                'attr' => 'onclick="location = \'' . $that->html->getSecureURL('account/address/delete', '&address_id=' . $result['address_id']) . '\'" '));

            $addresses[] = array(
                'address_id' => $result['address_id'],
                'address' => $formated_address,
                'button_edit' => $edit,
                'button_delete' => $delete,
                'default' => $that->customer->getAddressId() == $result['address_id'] ? true : false,
            );
        }

        $that->view->assign('addresses', $addresses);

        $that->view->assign('insert', $that->html->getSecureURL('account/address/insert'));

        $insert = HtmlElementFactory::create(array(
            'type' => 'button',
            'name' => 'insert',
            'text' => $that->language->get('button_new_address'),
            'icon' => 'fa fa-plus',
            'style' => 'button'));
        $that->view->assign('button_insert', $insert);

        $back = HtmlElementFactory::create(array(
            'type' => 'button',
            'name' => 'back',
            'text' => $that->language->get('button_back'),
            'icon' => 'fa fa-arrow-left',
            'style' => 'button'));
        $that->view->assign('button_back', $back);
        $that->view->assign('back', $that->html->getSecureURL('account/account'));

        $that->processTemplate('pages/account/addresses.tpl');
    }

    /**
     * @param $that
     * @param $order_product_id
     * @param $product_id
     * @param $product_option_value_id
     * @param $order_quantity
     *
     * @return bool
     */
    private function saveOrderProductStocks( $that, $order_product_id, $product_id, $product_option_value_id, $order_quantity ) {
        if ( ! $order_quantity ) {
            return false;
        }
        $stock_locations = $this->getProductStockLocations( $that, $product_id, $product_option_value_id );
        if ( ! $stock_locations ) {
            return false;
        }
        $remains            = $order_quantity;
        $available_quantity = array_sum( array_column( $stock_locations, 'quantity' ) );

        //do not save when zero stock on all locations
        if ( ! $available_quantity ) {
            return false;
        }

        foreach ( $stock_locations as $row ) {
            //skip zero stock locations or non-trackable
            if (
                ( $available_quantity && ! $row['quantity'] )
                || ( ! $product_option_value_id && ! $row['product_subtract'] )
                || ( $product_option_value_id && ! $row['product_option_value_subtract'] )
            ) {
                continue;
            }

            if ( $row['quantity'] >= $remains ) {
                $new_qnty = $row['quantity'] - $remains;
                $quantity = $remains;
                $remains  = 0;
            } else {
                $new_qnty = 0;
                $quantity = $row['quantity'];
                $remains  -= $row['quantity'];
            }
            //update stocks
            $sql = "UPDATE " . $that->db->table( "product_stock_locations" ) . " 
                    SET quantity = " . (int) $new_qnty . "
                    WHERE location_id= " . (int) $row['location_id'] . "
                     AND product_id = " . (int) $product_id
                . ( (int) $product_option_value_id
                    ? " AND product_option_value_id='" . (int) $product_option_value_id . "' "
                    : " AND product_option_value_id IS NULL" );
            $that->db->query( $sql );
            //save stocks into order details
            $that->db->query(
                "INSERT INTO " . $that->db->table( "order_product_stock_locations" ) . "
                    (order_product_id, product_id, product_option_value_id, location_id, location_name, quantity, sort_order)
                VALUES( 
                    " . (int) $order_product_id . ",
                    " . (int) $product_id . ", 
                    " . ( (int) $product_option_value_id
                    ? (int) $product_option_value_id
                    : 'NULL' ) . ", 
                    " . (int) $row['location_id'] . ", 
                    '" . $that->db->escape( $row['location_name'] ) . "',
                    " . (int) $quantity . ", 
                    " . (int) $row['sort_order'] . "
                );"
            );

            if ( ! $remains ) {
                break;
            }
        }

        return true;
    }

    /**
     * @param $that
     * @param $product_id
     * @param int $product_option_value_id
     *
     * @return mixed
     *
     */
    private function getProductStockLocations( $that, $product_id, $product_option_value_id = 0 ) {

        $sql = "SELECT psl.*,
                        CONCAT(l.name,' ', l.description) as location_name, 
                        p.subtract as product_subtract";

        if ( $product_option_value_id ) {
            $sql .= ", pov.subtract as product_option_value_subtract";
        }
        $sql .= " FROM " . $that->db->table( 'product_stock_locations' ) . " psl
                LEFT JOIN " . $that->db->table( 'products' ) . " p
                                    ON p.product_id = psl.product_id ";

        if ( $product_option_value_id ) {
            $sql .= " LEFT JOIN " . $that->db->table( 'product_option_values' ) . " pov
                          ON pov.product_option_value_id = psl.product_option_value_id";
        }
        $sql .= " LEFT JOIN " . $that->db->table( 'locations' ) . " l
                    ON l.location_id = psl.location_id
                WHERE psl.product_id=" . (int) $product_id;
        if ( $product_option_value_id ) {
            $sql .= " AND psl.product_option_value_id = " . (int) $product_option_value_id;
        } else {
            $sql .= " AND psl.product_option_value_id IS NULL";
        }
        $sql .= " ORDER BY psl.sort_order ASC";

        $result = $that->db->query( $sql );

        return $result->rows;
    }
    
    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $support = telephoneVerifySupport();
                if ($support['notification_case'] === 'notification_license_ok') {
                    $that->load->language('telephone_option/telephone_option');
                    $getVersions = telephoneUpdaterGetAllVersions();
                    $that->load->model('extension/telephone_option_updater');
                    $current_version = $that->model_extension_telephone_option_updater->getCurrentVersion();
                    if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                        $versions = $getVersions['notification_data']['product_versions'];
                        $total = $that->model_extension_telephone_option_updater->getTotalMsgIds();
                        if ($total > '0') {
                            $msg_ids = $that->model_extension_telephone_option_updater->getMsgIdsByCartVersions();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_telephone_option_updater->deleteMsgID($msg_id['msg_id']);
                            }
                        }
                        foreach ($versions as $version) {
                            if (version_compare($current_version, $version['version_number'], '<') === true &&
                                version_compare(VERSION, '1.2.17', '<') === true && version_compare($version['version_number'], '1.2.17', '<') === true
                                || version_compare($current_version, $version['version_number'], '<') === true && version_compare(VERSION, '1.2.17', '=') === true
                                && version_compare($version['version_number'], '1.2.17', '>=') === true) {
                                $msg_title = str_replace('[new_version]', $version['version_number'], $that->language->get('text_new_telephone_option_version_title'));
                                $that->messages->saveNotice($msg_title, $that->language->get('text_new_telephone_option_version_description'));
                                $msg_info = $that->messages->getLikeMessage($msg_title);
                                $that->model_extension_telephone_option_updater->saveMessageId($msg_info['msg_id'], $version['version_number']);
                            }
                        }
                    }
                }
            }
        }
    }
}