<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

/**
 * Class ModelSaleTaxidOption
 */
/** @noinspection PhpUndefinedClassInspection */
class ModelSaleTelephoneOption extends Model {

	/**
	 * @param $data
	 * @return array
	 */
	public function validateAdditionalValuesForCreate($data) {
		$data = $data;
		$errors = array();
		foreach ($data as $k=>$v) {
			if ($k == 'telephone' ) {
				if ($this->config->get($k.'_option_mandatory_status') == '1') {
					if (empty($v) || (mb_strlen($v) < 3) || (mb_strlen($v) > 32)) {
						$errors[$k] = $this->language->get($k . '_error');
					}
				}
			} elseif ($k == 'fax') {
				if ($this->config->get($k.'_option_mandatory_status') == '1') {
					if (empty($data[$v]) || ((mb_strlen($data[$v]) > 32) && strtolower($data[$v]) != 'na' && strtolower($data[$v]) != 'none')) {
						$errors[$k] = $this->language->get($k . '_error');
					}
				}
			} elseif ($this->config->get($k.'_option_mandatory_status') == '1') {
				if (empty($v)) {
					$errors[$k] = $this->language->get($k . '_error');
				}
			}
		}
		if (count($errors)) {
			$errors['warning'] = implode('<br>', $errors);
		}

		return $errors;
	}

	/**
	 * @param array $data
	 * @return array
	 */
	public function validateAdditionalValuesForEdit($data) {
		$data = $data;
		$errors = array();
		foreach ($data as $k=>$v) {
			if ($k == 'telephone') {
				if ($this->config->get($k.'_option_mandatory_status') == '1') {
					if (empty($v) || (mb_strlen($v) < 3) || (mb_strlen($v) > 32)) {
						$errors[$k] = $this->language->get($k . '_error');
					}
				}
			} elseif ($k == 'fax') {
				if ($this->config->get($k.'_option_mandatory_status') == '1') {
					if (empty($data[$v]) || ((mb_strlen($data[$v]) > 32) && strtolower($data[$v]) != 'na' && strtolower($data[$v]) != 'none')) {
						$errors[$k] = $this->language->get($k . '_error');
					}
				}
			} elseif ($this->config->get($k.'_option_mandatory_status') == '1') {
				if (empty($v)) {
					$errors[$k] = $this->language->get($k . '_error');
				}
			}
		}
		$errors['warning']=implode('<br>',$errors);
		return $errors;
	}

	/**
	 * @param int $customer_id
	 * @param array $data
	 * @return bool
	 */
	public function updateCustomerAdditionalValues($customer_id, $data) {
		if (!has_value($data)) {
			return false;
		}

		foreach ($data as $key => $item) {
			$this->db->query("UPDATE  " . $this->db->table('customer_additional_values') . "
								  SET email='" . $this->db->escape($data['email']) . "',
								  	  telephone='" . $this->db->escape($data['telephone']) . "',
								      fax='" . $this->db->escape($data['fax']) . "',
								      company='" . $this->db->escape($data['company']) . "',
								      taxid='" . $this->db->escape($data['taxid']) . "',
								      registration='" . $this->db->escape($data['registration']) . "',
								      bank_name='" . $this->db->escape($data['bank_name']) . "',
								      bank_address='" . $this->db->escape($data['bank_address']) . "',
								      iban='" . $this->db->escape($data['iban']) . "',
								      swift='" . $this->db->escape($data['swift']) . "' WHERE customer_id='".$customer_id."'");
		}
		return true;
	}

	/**
	 * @param $customer_id
	 * @return mixed
	 */
	public function getCustomerId($customer_id) {
		$sql='SELECT customer_id FROM '. $this->db->table('customer_additional_values') . "
				WHERE customer_id = " . (int)$customer_id;
		$query = $this->db->query($sql);

		return $query->row['customer_id'];
	}

	/**
	 * @param $customer_id
	 * @return bool|stdClass
	 */
	public function deleteCustomer($customer_id){
		$sql='DELETE FROM '. $this->db->table('customer_additional_values') . " WHERE customer_id = " . (int)$customer_id;
		$query = $this->db->query($sql);
		return $query;
	}
}