<?php
/**
 * SubscriptionFileManifest
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\QuantumView
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Quantum View
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\QuantumView\QuantumView;

use \ArrayAccess;
use \UPS\QuantumView\ObjectSerializer;

/**
 * SubscriptionFileManifest Class Doc Comment
 *
 * @category Class
 * @package  UPS\QuantumView
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SubscriptionFileManifest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'SubscriptionFile_Manifest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'shipper' => '\UPS\QuantumView\QuantumView\ManifestShipper',
        'ship_to' => '\UPS\QuantumView\QuantumView\ManifestShipTo',
        'reference_number' => '\UPS\QuantumView\QuantumView\ManifestReferenceNumber[]',
        'service' => '\UPS\QuantumView\QuantumView\ManifestService',
        'pickup_date' => 'string',
        'scheduled_delivery_date' => 'string',
        'scheduled_delivery_time' => 'string',
        'documents_only' => 'string',
        'package' => '\UPS\QuantumView\QuantumView\ManifestPackage[]',
        'shipment_service_options' => '\UPS\QuantumView\QuantumView\ManifestShipmentServiceOptions',
        'manufacture_country' => 'string',
        'harmonized_code' => 'string',
        'customs_value' => '\UPS\QuantumView\QuantumView\ManifestCustomsValue',
        'special_instructions' => 'string',
        'shipment_charge_type' => 'string',
        'bill_to_account' => '\UPS\QuantumView\QuantumView\ManifestBillToAccount',
        'consignee_bill_indicator' => 'string',
        'collect_bill_indicator' => 'string',
        'location_assured' => 'string',
        'import_control' => 'string',
        'label_delivery_method' => 'string',
        'commercial_invoice_removal' => 'string',
        'postal_service_tracking_id' => 'string',
        'returns_flexible_access' => 'string',
        'up_scarbonneutral' => 'string',
        'product' => 'string',
        'ups_returns_exchange' => 'string',
        'lift_gate_on_delivery' => 'string',
        'lift_gate_on_pick_up' => 'string',
        'pickup_preference' => 'string',
        'delivery_preference' => 'string',
        'hold_for_pickup_at_ups_access_point' => 'string',
        'uap_address' => '\UPS\QuantumView\QuantumView\ManifestUAPAddress',
        'deliver_to_addressee_only_indicator' => 'string',
        'ups_access_point_cod_indicator' => 'string',
        'clinical_trial_indicator' => 'string',
        'clinical_trial_indication_number' => 'string',
        'category_a_hazardous_indicator' => 'string',
        'direct_delivery_indicator' => 'string',
        'package_release_code_indicator' => 'string',
        'proactive_response_indicator' => 'string',
        'white_glove_delivery_indicator' => 'string',
        'room_of_choice_indicator' => 'string',
        'installation_delivery_indicator' => 'string',
        'item_disposal_indicator' => 'string',
        'lead_shipment_tracking_number' => 'string',
        'saturday_non_premium_commercial_delivery_indicator' => 'string',
        'sunday_non_premium_commercial_delivery_indicator' => 'string',
        'ups_premier_accessorial_indicator' => 'string',
        'ups_premier_category_code' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'shipper' => null,
        'ship_to' => null,
        'reference_number' => null,
        'service' => null,
        'pickup_date' => null,
        'scheduled_delivery_date' => null,
        'scheduled_delivery_time' => null,
        'documents_only' => null,
        'package' => null,
        'shipment_service_options' => null,
        'manufacture_country' => null,
        'harmonized_code' => null,
        'customs_value' => null,
        'special_instructions' => null,
        'shipment_charge_type' => null,
        'bill_to_account' => null,
        'consignee_bill_indicator' => null,
        'collect_bill_indicator' => null,
        'location_assured' => null,
        'import_control' => null,
        'label_delivery_method' => null,
        'commercial_invoice_removal' => null,
        'postal_service_tracking_id' => null,
        'returns_flexible_access' => null,
        'up_scarbonneutral' => null,
        'product' => null,
        'ups_returns_exchange' => null,
        'lift_gate_on_delivery' => null,
        'lift_gate_on_pick_up' => null,
        'pickup_preference' => null,
        'delivery_preference' => null,
        'hold_for_pickup_at_ups_access_point' => null,
        'uap_address' => null,
        'deliver_to_addressee_only_indicator' => null,
        'ups_access_point_cod_indicator' => null,
        'clinical_trial_indicator' => null,
        'clinical_trial_indication_number' => null,
        'category_a_hazardous_indicator' => null,
        'direct_delivery_indicator' => null,
        'package_release_code_indicator' => null,
        'proactive_response_indicator' => null,
        'white_glove_delivery_indicator' => null,
        'room_of_choice_indicator' => null,
        'installation_delivery_indicator' => null,
        'item_disposal_indicator' => null,
        'lead_shipment_tracking_number' => null,
        'saturday_non_premium_commercial_delivery_indicator' => null,
        'sunday_non_premium_commercial_delivery_indicator' => null,
        'ups_premier_accessorial_indicator' => null,
        'ups_premier_category_code' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shipper' => 'Shipper',
        'ship_to' => 'ShipTo',
        'reference_number' => 'ReferenceNumber',
        'service' => 'Service',
        'pickup_date' => 'PickupDate',
        'scheduled_delivery_date' => 'ScheduledDeliveryDate',
        'scheduled_delivery_time' => 'ScheduledDeliveryTime',
        'documents_only' => 'DocumentsOnly',
        'package' => 'Package',
        'shipment_service_options' => 'ShipmentServiceOptions',
        'manufacture_country' => 'ManufactureCountry',
        'harmonized_code' => 'HarmonizedCode',
        'customs_value' => 'CustomsValue',
        'special_instructions' => 'SpecialInstructions',
        'shipment_charge_type' => 'ShipmentChargeType',
        'bill_to_account' => 'BillToAccount',
        'consignee_bill_indicator' => 'ConsigneeBillIndicator',
        'collect_bill_indicator' => 'CollectBillIndicator',
        'location_assured' => 'LocationAssured',
        'import_control' => 'ImportControl',
        'label_delivery_method' => 'LabelDeliveryMethod',
        'commercial_invoice_removal' => 'CommercialInvoiceRemoval',
        'postal_service_tracking_id' => 'PostalServiceTrackingID',
        'returns_flexible_access' => 'ReturnsFlexibleAccess',
        'up_scarbonneutral' => 'UPScarbonneutral',
        'product' => 'Product',
        'ups_returns_exchange' => 'UPSReturnsExchange',
        'lift_gate_on_delivery' => 'LiftGateOnDelivery',
        'lift_gate_on_pick_up' => 'LiftGateOnPickUp',
        'pickup_preference' => 'PickupPreference',
        'delivery_preference' => 'DeliveryPreference',
        'hold_for_pickup_at_ups_access_point' => 'HoldForPickupAtUPSAccessPoint',
        'uap_address' => 'UAPAddress',
        'deliver_to_addressee_only_indicator' => 'DeliverToAddresseeOnlyIndicator',
        'ups_access_point_cod_indicator' => 'UPSAccessPointCODIndicator',
        'clinical_trial_indicator' => 'ClinicalTrialIndicator',
        'clinical_trial_indication_number' => 'ClinicalTrialIndicationNumber',
        'category_a_hazardous_indicator' => 'CategoryAHazardousIndicator',
        'direct_delivery_indicator' => 'DirectDeliveryIndicator',
        'package_release_code_indicator' => 'PackageReleaseCodeIndicator',
        'proactive_response_indicator' => 'ProactiveResponseIndicator',
        'white_glove_delivery_indicator' => 'WhiteGloveDeliveryIndicator',
        'room_of_choice_indicator' => 'RoomOfChoiceIndicator',
        'installation_delivery_indicator' => 'InstallationDeliveryIndicator',
        'item_disposal_indicator' => 'ItemDisposalIndicator',
        'lead_shipment_tracking_number' => 'LeadShipmentTrackingNumber',
        'saturday_non_premium_commercial_delivery_indicator' => 'SaturdayNonPremiumCommercialDeliveryIndicator',
        'sunday_non_premium_commercial_delivery_indicator' => 'SundayNonPremiumCommercialDeliveryIndicator',
        'ups_premier_accessorial_indicator' => 'UPSPremierAccessorialIndicator',
        'ups_premier_category_code' => 'UPSPremierCategoryCode'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shipper' => 'setShipper',
        'ship_to' => 'setShipTo',
        'reference_number' => 'setReferenceNumber',
        'service' => 'setService',
        'pickup_date' => 'setPickupDate',
        'scheduled_delivery_date' => 'setScheduledDeliveryDate',
        'scheduled_delivery_time' => 'setScheduledDeliveryTime',
        'documents_only' => 'setDocumentsOnly',
        'package' => 'setPackage',
        'shipment_service_options' => 'setShipmentServiceOptions',
        'manufacture_country' => 'setManufactureCountry',
        'harmonized_code' => 'setHarmonizedCode',
        'customs_value' => 'setCustomsValue',
        'special_instructions' => 'setSpecialInstructions',
        'shipment_charge_type' => 'setShipmentChargeType',
        'bill_to_account' => 'setBillToAccount',
        'consignee_bill_indicator' => 'setConsigneeBillIndicator',
        'collect_bill_indicator' => 'setCollectBillIndicator',
        'location_assured' => 'setLocationAssured',
        'import_control' => 'setImportControl',
        'label_delivery_method' => 'setLabelDeliveryMethod',
        'commercial_invoice_removal' => 'setCommercialInvoiceRemoval',
        'postal_service_tracking_id' => 'setPostalServiceTrackingId',
        'returns_flexible_access' => 'setReturnsFlexibleAccess',
        'up_scarbonneutral' => 'setUpScarbonneutral',
        'product' => 'setProduct',
        'ups_returns_exchange' => 'setUpsReturnsExchange',
        'lift_gate_on_delivery' => 'setLiftGateOnDelivery',
        'lift_gate_on_pick_up' => 'setLiftGateOnPickUp',
        'pickup_preference' => 'setPickupPreference',
        'delivery_preference' => 'setDeliveryPreference',
        'hold_for_pickup_at_ups_access_point' => 'setHoldForPickupAtUpsAccessPoint',
        'uap_address' => 'setUapAddress',
        'deliver_to_addressee_only_indicator' => 'setDeliverToAddresseeOnlyIndicator',
        'ups_access_point_cod_indicator' => 'setUpsAccessPointCodIndicator',
        'clinical_trial_indicator' => 'setClinicalTrialIndicator',
        'clinical_trial_indication_number' => 'setClinicalTrialIndicationNumber',
        'category_a_hazardous_indicator' => 'setCategoryAHazardousIndicator',
        'direct_delivery_indicator' => 'setDirectDeliveryIndicator',
        'package_release_code_indicator' => 'setPackageReleaseCodeIndicator',
        'proactive_response_indicator' => 'setProactiveResponseIndicator',
        'white_glove_delivery_indicator' => 'setWhiteGloveDeliveryIndicator',
        'room_of_choice_indicator' => 'setRoomOfChoiceIndicator',
        'installation_delivery_indicator' => 'setInstallationDeliveryIndicator',
        'item_disposal_indicator' => 'setItemDisposalIndicator',
        'lead_shipment_tracking_number' => 'setLeadShipmentTrackingNumber',
        'saturday_non_premium_commercial_delivery_indicator' => 'setSaturdayNonPremiumCommercialDeliveryIndicator',
        'sunday_non_premium_commercial_delivery_indicator' => 'setSundayNonPremiumCommercialDeliveryIndicator',
        'ups_premier_accessorial_indicator' => 'setUpsPremierAccessorialIndicator',
        'ups_premier_category_code' => 'setUpsPremierCategoryCode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shipper' => 'getShipper',
        'ship_to' => 'getShipTo',
        'reference_number' => 'getReferenceNumber',
        'service' => 'getService',
        'pickup_date' => 'getPickupDate',
        'scheduled_delivery_date' => 'getScheduledDeliveryDate',
        'scheduled_delivery_time' => 'getScheduledDeliveryTime',
        'documents_only' => 'getDocumentsOnly',
        'package' => 'getPackage',
        'shipment_service_options' => 'getShipmentServiceOptions',
        'manufacture_country' => 'getManufactureCountry',
        'harmonized_code' => 'getHarmonizedCode',
        'customs_value' => 'getCustomsValue',
        'special_instructions' => 'getSpecialInstructions',
        'shipment_charge_type' => 'getShipmentChargeType',
        'bill_to_account' => 'getBillToAccount',
        'consignee_bill_indicator' => 'getConsigneeBillIndicator',
        'collect_bill_indicator' => 'getCollectBillIndicator',
        'location_assured' => 'getLocationAssured',
        'import_control' => 'getImportControl',
        'label_delivery_method' => 'getLabelDeliveryMethod',
        'commercial_invoice_removal' => 'getCommercialInvoiceRemoval',
        'postal_service_tracking_id' => 'getPostalServiceTrackingId',
        'returns_flexible_access' => 'getReturnsFlexibleAccess',
        'up_scarbonneutral' => 'getUpScarbonneutral',
        'product' => 'getProduct',
        'ups_returns_exchange' => 'getUpsReturnsExchange',
        'lift_gate_on_delivery' => 'getLiftGateOnDelivery',
        'lift_gate_on_pick_up' => 'getLiftGateOnPickUp',
        'pickup_preference' => 'getPickupPreference',
        'delivery_preference' => 'getDeliveryPreference',
        'hold_for_pickup_at_ups_access_point' => 'getHoldForPickupAtUpsAccessPoint',
        'uap_address' => 'getUapAddress',
        'deliver_to_addressee_only_indicator' => 'getDeliverToAddresseeOnlyIndicator',
        'ups_access_point_cod_indicator' => 'getUpsAccessPointCodIndicator',
        'clinical_trial_indicator' => 'getClinicalTrialIndicator',
        'clinical_trial_indication_number' => 'getClinicalTrialIndicationNumber',
        'category_a_hazardous_indicator' => 'getCategoryAHazardousIndicator',
        'direct_delivery_indicator' => 'getDirectDeliveryIndicator',
        'package_release_code_indicator' => 'getPackageReleaseCodeIndicator',
        'proactive_response_indicator' => 'getProactiveResponseIndicator',
        'white_glove_delivery_indicator' => 'getWhiteGloveDeliveryIndicator',
        'room_of_choice_indicator' => 'getRoomOfChoiceIndicator',
        'installation_delivery_indicator' => 'getInstallationDeliveryIndicator',
        'item_disposal_indicator' => 'getItemDisposalIndicator',
        'lead_shipment_tracking_number' => 'getLeadShipmentTrackingNumber',
        'saturday_non_premium_commercial_delivery_indicator' => 'getSaturdayNonPremiumCommercialDeliveryIndicator',
        'sunday_non_premium_commercial_delivery_indicator' => 'getSundayNonPremiumCommercialDeliveryIndicator',
        'ups_premier_accessorial_indicator' => 'getUpsPremierAccessorialIndicator',
        'ups_premier_category_code' => 'getUpsPremierCategoryCode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['shipper'] = isset($data['shipper']) ? $data['shipper'] : null;
        $this->container['ship_to'] = isset($data['ship_to']) ? $data['ship_to'] : null;
        $this->container['reference_number'] = isset($data['reference_number']) ? $data['reference_number'] : null;
        $this->container['service'] = isset($data['service']) ? $data['service'] : null;
        $this->container['pickup_date'] = isset($data['pickup_date']) ? $data['pickup_date'] : null;
        $this->container['scheduled_delivery_date'] = isset($data['scheduled_delivery_date']) ? $data['scheduled_delivery_date'] : null;
        $this->container['scheduled_delivery_time'] = isset($data['scheduled_delivery_time']) ? $data['scheduled_delivery_time'] : null;
        $this->container['documents_only'] = isset($data['documents_only']) ? $data['documents_only'] : null;
        $this->container['package'] = isset($data['package']) ? $data['package'] : null;
        $this->container['shipment_service_options'] = isset($data['shipment_service_options']) ? $data['shipment_service_options'] : null;
        $this->container['manufacture_country'] = isset($data['manufacture_country']) ? $data['manufacture_country'] : null;
        $this->container['harmonized_code'] = isset($data['harmonized_code']) ? $data['harmonized_code'] : null;
        $this->container['customs_value'] = isset($data['customs_value']) ? $data['customs_value'] : null;
        $this->container['special_instructions'] = isset($data['special_instructions']) ? $data['special_instructions'] : null;
        $this->container['shipment_charge_type'] = isset($data['shipment_charge_type']) ? $data['shipment_charge_type'] : null;
        $this->container['bill_to_account'] = isset($data['bill_to_account']) ? $data['bill_to_account'] : null;
        $this->container['consignee_bill_indicator'] = isset($data['consignee_bill_indicator']) ? $data['consignee_bill_indicator'] : null;
        $this->container['collect_bill_indicator'] = isset($data['collect_bill_indicator']) ? $data['collect_bill_indicator'] : null;
        $this->container['location_assured'] = isset($data['location_assured']) ? $data['location_assured'] : null;
        $this->container['import_control'] = isset($data['import_control']) ? $data['import_control'] : null;
        $this->container['label_delivery_method'] = isset($data['label_delivery_method']) ? $data['label_delivery_method'] : null;
        $this->container['commercial_invoice_removal'] = isset($data['commercial_invoice_removal']) ? $data['commercial_invoice_removal'] : null;
        $this->container['postal_service_tracking_id'] = isset($data['postal_service_tracking_id']) ? $data['postal_service_tracking_id'] : null;
        $this->container['returns_flexible_access'] = isset($data['returns_flexible_access']) ? $data['returns_flexible_access'] : null;
        $this->container['up_scarbonneutral'] = isset($data['up_scarbonneutral']) ? $data['up_scarbonneutral'] : null;
        $this->container['product'] = isset($data['product']) ? $data['product'] : null;
        $this->container['ups_returns_exchange'] = isset($data['ups_returns_exchange']) ? $data['ups_returns_exchange'] : null;
        $this->container['lift_gate_on_delivery'] = isset($data['lift_gate_on_delivery']) ? $data['lift_gate_on_delivery'] : null;
        $this->container['lift_gate_on_pick_up'] = isset($data['lift_gate_on_pick_up']) ? $data['lift_gate_on_pick_up'] : null;
        $this->container['pickup_preference'] = isset($data['pickup_preference']) ? $data['pickup_preference'] : null;
        $this->container['delivery_preference'] = isset($data['delivery_preference']) ? $data['delivery_preference'] : null;
        $this->container['hold_for_pickup_at_ups_access_point'] = isset($data['hold_for_pickup_at_ups_access_point']) ? $data['hold_for_pickup_at_ups_access_point'] : null;
        $this->container['uap_address'] = isset($data['uap_address']) ? $data['uap_address'] : null;
        $this->container['deliver_to_addressee_only_indicator'] = isset($data['deliver_to_addressee_only_indicator']) ? $data['deliver_to_addressee_only_indicator'] : null;
        $this->container['ups_access_point_cod_indicator'] = isset($data['ups_access_point_cod_indicator']) ? $data['ups_access_point_cod_indicator'] : null;
        $this->container['clinical_trial_indicator'] = isset($data['clinical_trial_indicator']) ? $data['clinical_trial_indicator'] : null;
        $this->container['clinical_trial_indication_number'] = isset($data['clinical_trial_indication_number']) ? $data['clinical_trial_indication_number'] : null;
        $this->container['category_a_hazardous_indicator'] = isset($data['category_a_hazardous_indicator']) ? $data['category_a_hazardous_indicator'] : null;
        $this->container['direct_delivery_indicator'] = isset($data['direct_delivery_indicator']) ? $data['direct_delivery_indicator'] : null;
        $this->container['package_release_code_indicator'] = isset($data['package_release_code_indicator']) ? $data['package_release_code_indicator'] : null;
        $this->container['proactive_response_indicator'] = isset($data['proactive_response_indicator']) ? $data['proactive_response_indicator'] : null;
        $this->container['white_glove_delivery_indicator'] = isset($data['white_glove_delivery_indicator']) ? $data['white_glove_delivery_indicator'] : null;
        $this->container['room_of_choice_indicator'] = isset($data['room_of_choice_indicator']) ? $data['room_of_choice_indicator'] : null;
        $this->container['installation_delivery_indicator'] = isset($data['installation_delivery_indicator']) ? $data['installation_delivery_indicator'] : null;
        $this->container['item_disposal_indicator'] = isset($data['item_disposal_indicator']) ? $data['item_disposal_indicator'] : null;
        $this->container['lead_shipment_tracking_number'] = isset($data['lead_shipment_tracking_number']) ? $data['lead_shipment_tracking_number'] : null;
        $this->container['saturday_non_premium_commercial_delivery_indicator'] = isset($data['saturday_non_premium_commercial_delivery_indicator']) ? $data['saturday_non_premium_commercial_delivery_indicator'] : null;
        $this->container['sunday_non_premium_commercial_delivery_indicator'] = isset($data['sunday_non_premium_commercial_delivery_indicator']) ? $data['sunday_non_premium_commercial_delivery_indicator'] : null;
        $this->container['ups_premier_accessorial_indicator'] = isset($data['ups_premier_accessorial_indicator']) ? $data['ups_premier_accessorial_indicator'] : null;
        $this->container['ups_premier_category_code'] = isset($data['ups_premier_category_code']) ? $data['ups_premier_category_code'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['shipper'] === null) {
            $invalidProperties[] = "'shipper' can't be null";
        }
        if ($this->container['ship_to'] === null) {
            $invalidProperties[] = "'ship_to' can't be null";
        }
        if ($this->container['consignee_bill_indicator'] === null) {
            $invalidProperties[] = "'consignee_bill_indicator' can't be null";
        }
        if ($this->container['collect_bill_indicator'] === null) {
            $invalidProperties[] = "'collect_bill_indicator' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shipper
     *
     * @return \UPS\QuantumView\QuantumView\ManifestShipper
     */
    public function getShipper()
    {
        return $this->container['shipper'];
    }

    /**
     * Sets shipper
     *
     * @param \UPS\QuantumView\QuantumView\ManifestShipper $shipper shipper
     *
     * @return $this
     */
    public function setShipper($shipper)
    {
        $this->container['shipper'] = $shipper;

        return $this;
    }

    /**
     * Gets ship_to
     *
     * @return \UPS\QuantumView\QuantumView\ManifestShipTo
     */
    public function getShipTo()
    {
        return $this->container['ship_to'];
    }

    /**
     * Sets ship_to
     *
     * @param \UPS\QuantumView\QuantumView\ManifestShipTo $ship_to ship_to
     *
     * @return $this
     */
    public function setShipTo($ship_to)
    {
        $this->container['ship_to'] = $ship_to;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return \UPS\QuantumView\QuantumView\ManifestReferenceNumber[]
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param \UPS\QuantumView\QuantumView\ManifestReferenceNumber[] $reference_number Shipment-level reference numbers.  **NOTE:** For versions >= v2, this element will always be returned as an array. For requests using version = v1, this element will be returned as an array if there is more than one object and a single object if there is only 1.
     *
     * @return $this
     */
    public function setReferenceNumber($reference_number)
    {
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets service
     *
     * @return \UPS\QuantumView\QuantumView\ManifestService
     */
    public function getService()
    {
        return $this->container['service'];
    }

    /**
     * Sets service
     *
     * @param \UPS\QuantumView\QuantumView\ManifestService $service service
     *
     * @return $this
     */
    public function setService($service)
    {
        $this->container['service'] = $service;

        return $this;
    }

    /**
     * Gets pickup_date
     *
     * @return string
     */
    public function getPickupDate()
    {
        return $this->container['pickup_date'];
    }

    /**
     * Sets pickup_date
     *
     * @param string $pickup_date Should be set equal to the date on while the packages were picked up (may be prior days date if the transmission occurs after midnight). Formatted as YYYYMMDD.
     *
     * @return $this
     */
    public function setPickupDate($pickup_date)
    {
        $this->container['pickup_date'] = $pickup_date;

        return $this;
    }

    /**
     * Gets scheduled_delivery_date
     *
     * @return string
     */
    public function getScheduledDeliveryDate()
    {
        return $this->container['scheduled_delivery_date'];
    }

    /**
     * Sets scheduled_delivery_date
     *
     * @param string $scheduled_delivery_date The date the shipment originally was scheduled for delivery. Formatted as YYYYMMDD.
     *
     * @return $this
     */
    public function setScheduledDeliveryDate($scheduled_delivery_date)
    {
        $this->container['scheduled_delivery_date'] = $scheduled_delivery_date;

        return $this;
    }

    /**
     * Gets scheduled_delivery_time
     *
     * @return string
     */
    public function getScheduledDeliveryTime()
    {
        return $this->container['scheduled_delivery_time'];
    }

    /**
     * Sets scheduled_delivery_time
     *
     * @param string $scheduled_delivery_time Schedule delivery time. Time format is HHMMSS
     *
     * @return $this
     */
    public function setScheduledDeliveryTime($scheduled_delivery_time)
    {
        $this->container['scheduled_delivery_time'] = $scheduled_delivery_time;

        return $this;
    }

    /**
     * Gets documents_only
     *
     * @return string
     */
    public function getDocumentsOnly()
    {
        return $this->container['documents_only'];
    }

    /**
     * Sets documents_only
     *
     * @param string $documents_only If the tag is present then the shipment is a document, otherwise the shipment is a non-document. Valid values: - 1 = Letter - 2 = Document (Non-Letter Document) - 3 = Non-Document - 4 = Pallet
     *
     * @return $this
     */
    public function setDocumentsOnly($documents_only)
    {
        $this->container['documents_only'] = $documents_only;

        return $this;
    }

    /**
     * Gets package
     *
     * @return \UPS\QuantumView\QuantumView\ManifestPackage[]
     */
    public function getPackage()
    {
        return $this->container['package'];
    }

    /**
     * Sets package
     *
     * @param \UPS\QuantumView\QuantumView\ManifestPackage[] $package Defines a package.  **NOTE:** For versions >= v2, this element will always be returned as an array. For requests using version = v1, this element will be returned as an array if there is more than one object and a single object if there is only 1.
     *
     * @return $this
     */
    public function setPackage($package)
    {
        $this->container['package'] = $package;

        return $this;
    }

    /**
     * Gets shipment_service_options
     *
     * @return \UPS\QuantumView\QuantumView\ManifestShipmentServiceOptions
     */
    public function getShipmentServiceOptions()
    {
        return $this->container['shipment_service_options'];
    }

    /**
     * Sets shipment_service_options
     *
     * @param \UPS\QuantumView\QuantumView\ManifestShipmentServiceOptions $shipment_service_options shipment_service_options
     *
     * @return $this
     */
    public function setShipmentServiceOptions($shipment_service_options)
    {
        $this->container['shipment_service_options'] = $shipment_service_options;

        return $this;
    }

    /**
     * Gets manufacture_country
     *
     * @return string
     */
    public function getManufactureCountry()
    {
        return $this->container['manufacture_country'];
    }

    /**
     * Sets manufacture_country
     *
     * @param string $manufacture_country Country or Territory  of Manufacture of the contents of the package.
     *
     * @return $this
     */
    public function setManufactureCountry($manufacture_country)
    {
        $this->container['manufacture_country'] = $manufacture_country;

        return $this;
    }

    /**
     * Gets harmonized_code
     *
     * @return string
     */
    public function getHarmonizedCode()
    {
        return $this->container['harmonized_code'];
    }

    /**
     * Sets harmonized_code
     *
     * @param string $harmonized_code Harmonized code of the package.
     *
     * @return $this
     */
    public function setHarmonizedCode($harmonized_code)
    {
        $this->container['harmonized_code'] = $harmonized_code;

        return $this;
    }

    /**
     * Gets customs_value
     *
     * @return \UPS\QuantumView\QuantumView\ManifestCustomsValue
     */
    public function getCustomsValue()
    {
        return $this->container['customs_value'];
    }

    /**
     * Sets customs_value
     *
     * @param \UPS\QuantumView\QuantumView\ManifestCustomsValue $customs_value customs_value
     *
     * @return $this
     */
    public function setCustomsValue($customs_value)
    {
        $this->container['customs_value'] = $customs_value;

        return $this;
    }

    /**
     * Gets special_instructions
     *
     * @return string
     */
    public function getSpecialInstructions()
    {
        return $this->container['special_instructions'];
    }

    /**
     * Sets special_instructions
     *
     * @param string $special_instructions User-defined special instructions for delivery.
     *
     * @return $this
     */
    public function setSpecialInstructions($special_instructions)
    {
        $this->container['special_instructions'] = $special_instructions;

        return $this;
    }

    /**
     * Gets shipment_charge_type
     *
     * @return string
     */
    public function getShipmentChargeType()
    {
        return $this->container['shipment_charge_type'];
    }

    /**
     * Sets shipment_charge_type
     *
     * @param string $shipment_charge_type Shipment charge type. Valid values: C/F - Cost and Freight C/B - Consignee Billed Package F/C - Freight Collect DDP - Delivered Duty Paid VAT Unpaid FOB - Free On Board P/P - Prepaid F/D - Free Domicile T/P - Third Party Billing
     *
     * @return $this
     */
    public function setShipmentChargeType($shipment_charge_type)
    {
        $this->container['shipment_charge_type'] = $shipment_charge_type;

        return $this;
    }

    /**
     * Gets bill_to_account
     *
     * @return \UPS\QuantumView\QuantumView\ManifestBillToAccount
     */
    public function getBillToAccount()
    {
        return $this->container['bill_to_account'];
    }

    /**
     * Sets bill_to_account
     *
     * @param \UPS\QuantumView\QuantumView\ManifestBillToAccount $bill_to_account bill_to_account
     *
     * @return $this
     */
    public function setBillToAccount($bill_to_account)
    {
        $this->container['bill_to_account'] = $bill_to_account;

        return $this;
    }

    /**
     * Gets consignee_bill_indicator
     *
     * @return string
     */
    public function getConsigneeBillIndicator()
    {
        return $this->container['consignee_bill_indicator'];
    }

    /**
     * Sets consignee_bill_indicator
     *
     * @param string $consignee_bill_indicator Indicates if consignee will be billed the shipment.
     *
     * @return $this
     */
    public function setConsigneeBillIndicator($consignee_bill_indicator)
    {
        $this->container['consignee_bill_indicator'] = $consignee_bill_indicator;

        return $this;
    }

    /**
     * Gets collect_bill_indicator
     *
     * @return string
     */
    public function getCollectBillIndicator()
    {
        return $this->container['collect_bill_indicator'];
    }

    /**
     * Sets collect_bill_indicator
     *
     * @param string $collect_bill_indicator Indicates whether or not to collect bill at time of delivery.
     *
     * @return $this
     */
    public function setCollectBillIndicator($collect_bill_indicator)
    {
        $this->container['collect_bill_indicator'] = $collect_bill_indicator;

        return $this;
    }

    /**
     * Gets location_assured
     *
     * @return string
     */
    public function getLocationAssured()
    {
        return $this->container['location_assured'];
    }

    /**
     * Sets location_assured
     *
     * @param string $location_assured Indicates Location Assured Values: Y - Location Assured accessorial requested
     *
     * @return $this
     */
    public function setLocationAssured($location_assured)
    {
        $this->container['location_assured'] = $location_assured;

        return $this;
    }

    /**
     * Gets import_control
     *
     * @return string
     */
    public function getImportControl()
    {
        return $this->container['import_control'];
    }

    /**
     * Sets import_control
     *
     * @param string $import_control Import Control Indication is used to designate that the shipment is an Import Control shipment. If the shipment is an import control shipment then this element will have value. For no import shipment this will not be appear
     *
     * @return $this
     */
    public function setImportControl($import_control)
    {
        $this->container['import_control'] = $import_control;

        return $this;
    }

    /**
     * Gets label_delivery_method
     *
     * @return string
     */
    public function getLabelDeliveryMethod()
    {
        return $this->container['label_delivery_method'];
    }

    /**
     * Sets label_delivery_method
     *
     * @param string $label_delivery_method Indicates Label Delivery Method, Values are: LDE Electronic Label. LDO One Attempt. LDP Print Label. LDT Three Attempt. LPM Print and Mail Label.
     *
     * @return $this
     */
    public function setLabelDeliveryMethod($label_delivery_method)
    {
        $this->container['label_delivery_method'] = $label_delivery_method;

        return $this;
    }

    /**
     * Gets commercial_invoice_removal
     *
     * @return string
     */
    public function getCommercialInvoiceRemoval()
    {
        return $this->container['commercial_invoice_removal'];
    }

    /**
     * Sets commercial_invoice_removal
     *
     * @param string $commercial_invoice_removal Commercial Invoice Removal (CIR) is an accessorial or indication that will allow a shipper to dictate that UPS remove the Commercial Invoice from the user's shipment before the shipment is delivered to the ultimate consignee. If shipment is CIR then this element will have value. For no CIR this element will not be appear
     *
     * @return $this
     */
    public function setCommercialInvoiceRemoval($commercial_invoice_removal)
    {
        $this->container['commercial_invoice_removal'] = $commercial_invoice_removal;

        return $this;
    }

    /**
     * Gets postal_service_tracking_id
     *
     * @return string
     */
    public function getPostalServiceTrackingId()
    {
        return $this->container['postal_service_tracking_id'];
    }

    /**
     * Sets postal_service_tracking_id
     *
     * @param string $postal_service_tracking_id Postal Service Tracking ID transport company tracking number.
     *
     * @return $this
     */
    public function setPostalServiceTrackingId($postal_service_tracking_id)
    {
        $this->container['postal_service_tracking_id'] = $postal_service_tracking_id;

        return $this;
    }

    /**
     * Gets returns_flexible_access
     *
     * @return string
     */
    public function getReturnsFlexibleAccess()
    {
        return $this->container['returns_flexible_access'];
    }

    /**
     * Sets returns_flexible_access
     *
     * @param string $returns_flexible_access (RFA) UPS returns flexible access. This element will appear with value only when returns flexible access uploaded. For no returns flexible access this element will not be appear
     *
     * @return $this
     */
    public function setReturnsFlexibleAccess($returns_flexible_access)
    {
        $this->container['returns_flexible_access'] = $returns_flexible_access;

        return $this;
    }

    /**
     * Gets up_scarbonneutral
     *
     * @return string
     */
    public function getUpScarbonneutral()
    {
        return $this->container['up_scarbonneutral'];
    }

    /**
     * Sets up_scarbonneutral
     *
     * @param string $up_scarbonneutral UPS carbon neutral is a term used to reflect a generic term for the tagging to be included on any document, label, e-mail, etc. used to identify that the UPS carbon neutral fee is applied. This element will appear only when shipment is UPS carbon neutral with value. For non UPS carbon neutral shipping this element appear.
     *
     * @return $this
     */
    public function setUpScarbonneutral($up_scarbonneutral)
    {
        $this->container['up_scarbonneutral'] = $up_scarbonneutral;

        return $this;
    }

    /**
     * Gets product
     *
     * @return string
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product
     *
     * @param string $product This element will have value \"PAC\" for CAR shipments. For no CAR shipments this element will not be appeared.
     *
     * @return $this
     */
    public function setProduct($product)
    {
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets ups_returns_exchange
     *
     * @return string
     */
    public function getUpsReturnsExchange()
    {
        return $this->container['ups_returns_exchange'];
    }

    /**
     * Sets ups_returns_exchange
     *
     * @param string $ups_returns_exchange UPS Return and Exchange – This element will appear with value Y only when UPS Return and Exchange was requested. For no UPS Returns and Exchange then this element will not appear
     *
     * @return $this
     */
    public function setUpsReturnsExchange($ups_returns_exchange)
    {
        $this->container['ups_returns_exchange'] = $ups_returns_exchange;

        return $this;
    }

    /**
     * Gets lift_gate_on_delivery
     *
     * @return string
     */
    public function getLiftGateOnDelivery()
    {
        return $this->container['lift_gate_on_delivery'];
    }

    /**
     * Sets lift_gate_on_delivery
     *
     * @param string $lift_gate_on_delivery Lift Gate On Delivery - This element will appear only when Lift Gate For Delivery was requested for UPS World Wide Express Freight Shipments. If no Lift Gate for Delivery was requested, this element will not appear.
     *
     * @return $this
     */
    public function setLiftGateOnDelivery($lift_gate_on_delivery)
    {
        $this->container['lift_gate_on_delivery'] = $lift_gate_on_delivery;

        return $this;
    }

    /**
     * Gets lift_gate_on_pick_up
     *
     * @return string
     */
    public function getLiftGateOnPickUp()
    {
        return $this->container['lift_gate_on_pick_up'];
    }

    /**
     * Sets lift_gate_on_pick_up
     *
     * @param string $lift_gate_on_pick_up Lift Gate On PickUp - This element will appear only when Lift Gate For PickUp was requested for UPS World Wide Express Freight Shipments. If no Lift Gate for PickUp was requested, this element will not appear.
     *
     * @return $this
     */
    public function setLiftGateOnPickUp($lift_gate_on_pick_up)
    {
        $this->container['lift_gate_on_pick_up'] = $lift_gate_on_pick_up;

        return $this;
    }

    /**
     * Gets pickup_preference
     *
     * @return string
     */
    public function getPickupPreference()
    {
        return $this->container['pickup_preference'];
    }

    /**
     * Sets pickup_preference
     *
     * @param string $pickup_preference Pickup Preference -This element will appear only when Dropoff At UPS Facility was requested for UPS World Wide Express Freight Shipments. If no Dropoff At UPS Facility was requested, this element will not appear.
     *
     * @return $this
     */
    public function setPickupPreference($pickup_preference)
    {
        $this->container['pickup_preference'] = $pickup_preference;

        return $this;
    }

    /**
     * Gets delivery_preference
     *
     * @return string
     */
    public function getDeliveryPreference()
    {
        return $this->container['delivery_preference'];
    }

    /**
     * Sets delivery_preference
     *
     * @param string $delivery_preference Delivery Preference - This element will appear only when Hold for pick up was requested for UPS World Wide Express Freight Shipments. If no Hold for pick up was requested, this element will not appear.
     *
     * @return $this
     */
    public function setDeliveryPreference($delivery_preference)
    {
        $this->container['delivery_preference'] = $delivery_preference;

        return $this;
    }

    /**
     * Gets hold_for_pickup_at_ups_access_point
     *
     * @return string
     */
    public function getHoldForPickupAtUpsAccessPoint()
    {
        return $this->container['hold_for_pickup_at_ups_access_point'];
    }

    /**
     * Sets hold_for_pickup_at_ups_access_point
     *
     * @param string $hold_for_pickup_at_ups_access_point \"Y\" Indicates Shipment is Direct to Retail.
     *
     * @return $this
     */
    public function setHoldForPickupAtUpsAccessPoint($hold_for_pickup_at_ups_access_point)
    {
        $this->container['hold_for_pickup_at_ups_access_point'] = $hold_for_pickup_at_ups_access_point;

        return $this;
    }

    /**
     * Gets uap_address
     *
     * @return \UPS\QuantumView\QuantumView\ManifestUAPAddress
     */
    public function getUapAddress()
    {
        return $this->container['uap_address'];
    }

    /**
     * Sets uap_address
     *
     * @param \UPS\QuantumView\QuantumView\ManifestUAPAddress $uap_address uap_address
     *
     * @return $this
     */
    public function setUapAddress($uap_address)
    {
        $this->container['uap_address'] = $uap_address;

        return $this;
    }

    /**
     * Gets deliver_to_addressee_only_indicator
     *
     * @return string
     */
    public function getDeliverToAddresseeOnlyIndicator()
    {
        return $this->container['deliver_to_addressee_only_indicator'];
    }

    /**
     * Sets deliver_to_addressee_only_indicator
     *
     * @param string $deliver_to_addressee_only_indicator \"Y\" Indicates Shipment is Deliver to Addressee.
     *
     * @return $this
     */
    public function setDeliverToAddresseeOnlyIndicator($deliver_to_addressee_only_indicator)
    {
        $this->container['deliver_to_addressee_only_indicator'] = $deliver_to_addressee_only_indicator;

        return $this;
    }

    /**
     * Gets ups_access_point_cod_indicator
     *
     * @return string
     */
    public function getUpsAccessPointCodIndicator()
    {
        return $this->container['ups_access_point_cod_indicator'];
    }

    /**
     * Sets ups_access_point_cod_indicator
     *
     * @param string $ups_access_point_cod_indicator \"Y\" Indicates Shipment is Cash on Delivery in Direct to Retail
     *
     * @return $this
     */
    public function setUpsAccessPointCodIndicator($ups_access_point_cod_indicator)
    {
        $this->container['ups_access_point_cod_indicator'] = $ups_access_point_cod_indicator;

        return $this;
    }

    /**
     * Gets clinical_trial_indicator
     *
     * @return string
     */
    public function getClinicalTrialIndicator()
    {
        return $this->container['clinical_trial_indicator'];
    }

    /**
     * Sets clinical_trial_indicator
     *
     * @param string $clinical_trial_indicator An accessorial Indicator flag: Y = Clinical Trial accessorial provided in Manifest. Spaces = Clinical Trial accessorial not provided in Manifest.
     *
     * @return $this
     */
    public function setClinicalTrialIndicator($clinical_trial_indicator)
    {
        $this->container['clinical_trial_indicator'] = $clinical_trial_indicator;

        return $this;
    }

    /**
     * Gets clinical_trial_indication_number
     *
     * @return string
     */
    public function getClinicalTrialIndicationNumber()
    {
        return $this->container['clinical_trial_indication_number'];
    }

    /**
     * Sets clinical_trial_indication_number
     *
     * @param string $clinical_trial_indication_number An unique Clinical Trial associated with the shipment provided in Manifest.
     *
     * @return $this
     */
    public function setClinicalTrialIndicationNumber($clinical_trial_indication_number)
    {
        $this->container['clinical_trial_indication_number'] = $clinical_trial_indication_number;

        return $this;
    }

    /**
     * Gets category_a_hazardous_indicator
     *
     * @return string
     */
    public function getCategoryAHazardousIndicator()
    {
        return $this->container['category_a_hazardous_indicator'];
    }

    /**
     * Sets category_a_hazardous_indicator
     *
     * @param string $category_a_hazardous_indicator An accessorial Indicator flag: Y = Category A Hazardous materials accessorial provided in Manifest. Spaces = Category A Hazardous materials accessorial not provided in Manifest.
     *
     * @return $this
     */
    public function setCategoryAHazardousIndicator($category_a_hazardous_indicator)
    {
        $this->container['category_a_hazardous_indicator'] = $category_a_hazardous_indicator;

        return $this;
    }

    /**
     * Gets direct_delivery_indicator
     *
     * @return string
     */
    public function getDirectDeliveryIndicator()
    {
        return $this->container['direct_delivery_indicator'];
    }

    /**
     * Sets direct_delivery_indicator
     *
     * @param string $direct_delivery_indicator An accessorial Indicator flag: Y = Direct Delivery accessorisal provided in Manifest. Spaces = Direct Delivery accessorial not provided in Manifest.
     *
     * @return $this
     */
    public function setDirectDeliveryIndicator($direct_delivery_indicator)
    {
        $this->container['direct_delivery_indicator'] = $direct_delivery_indicator;

        return $this;
    }

    /**
     * Gets package_release_code_indicator
     *
     * @return string
     */
    public function getPackageReleaseCodeIndicator()
    {
        return $this->container['package_release_code_indicator'];
    }

    /**
     * Sets package_release_code_indicator
     *
     * @param string $package_release_code_indicator \"Y\" indicates Shipment has PackageReleaseCode Accessorial.
     *
     * @return $this
     */
    public function setPackageReleaseCodeIndicator($package_release_code_indicator)
    {
        $this->container['package_release_code_indicator'] = $package_release_code_indicator;

        return $this;
    }

    /**
     * Gets proactive_response_indicator
     *
     * @return string
     */
    public function getProactiveResponseIndicator()
    {
        return $this->container['proactive_response_indicator'];
    }

    /**
     * Sets proactive_response_indicator
     *
     * @param string $proactive_response_indicator \"Y\" indicates that a UPS Proactive Response Accessorial is provided.
     *
     * @return $this
     */
    public function setProactiveResponseIndicator($proactive_response_indicator)
    {
        $this->container['proactive_response_indicator'] = $proactive_response_indicator;

        return $this;
    }

    /**
     * Gets white_glove_delivery_indicator
     *
     * @return string
     */
    public function getWhiteGloveDeliveryIndicator()
    {
        return $this->container['white_glove_delivery_indicator'];
    }

    /**
     * Sets white_glove_delivery_indicator
     *
     * @param string $white_glove_delivery_indicator \"Y\" indicates that a Heavy Goods White Glove Delivery Accessorial is provided.
     *
     * @return $this
     */
    public function setWhiteGloveDeliveryIndicator($white_glove_delivery_indicator)
    {
        $this->container['white_glove_delivery_indicator'] = $white_glove_delivery_indicator;

        return $this;
    }

    /**
     * Gets room_of_choice_indicator
     *
     * @return string
     */
    public function getRoomOfChoiceIndicator()
    {
        return $this->container['room_of_choice_indicator'];
    }

    /**
     * Sets room_of_choice_indicator
     *
     * @param string $room_of_choice_indicator \"Y\" indicates that a Heavy Goods Room of Choice Accessorial is provided.
     *
     * @return $this
     */
    public function setRoomOfChoiceIndicator($room_of_choice_indicator)
    {
        $this->container['room_of_choice_indicator'] = $room_of_choice_indicator;

        return $this;
    }

    /**
     * Gets installation_delivery_indicator
     *
     * @return string
     */
    public function getInstallationDeliveryIndicator()
    {
        return $this->container['installation_delivery_indicator'];
    }

    /**
     * Sets installation_delivery_indicator
     *
     * @param string $installation_delivery_indicator \"Y\" indicates that a Heavy Goods Installation Delivery Accessorial is provided.
     *
     * @return $this
     */
    public function setInstallationDeliveryIndicator($installation_delivery_indicator)
    {
        $this->container['installation_delivery_indicator'] = $installation_delivery_indicator;

        return $this;
    }

    /**
     * Gets item_disposal_indicator
     *
     * @return string
     */
    public function getItemDisposalIndicator()
    {
        return $this->container['item_disposal_indicator'];
    }

    /**
     * Sets item_disposal_indicator
     *
     * @param string $item_disposal_indicator \"Y\" indicates that a Heavy Goods Item Disposal Accessorial is provided.
     *
     * @return $this
     */
    public function setItemDisposalIndicator($item_disposal_indicator)
    {
        $this->container['item_disposal_indicator'] = $item_disposal_indicator;

        return $this;
    }

    /**
     * Gets lead_shipment_tracking_number
     *
     * @return string
     */
    public function getLeadShipmentTrackingNumber()
    {
        return $this->container['lead_shipment_tracking_number'];
    }

    /**
     * Sets lead_shipment_tracking_number
     *
     * @param string $lead_shipment_tracking_number Lead Tracking Number in shipment
     *
     * @return $this
     */
    public function setLeadShipmentTrackingNumber($lead_shipment_tracking_number)
    {
        $this->container['lead_shipment_tracking_number'] = $lead_shipment_tracking_number;

        return $this;
    }

    /**
     * Gets saturday_non_premium_commercial_delivery_indicator
     *
     * @return string
     */
    public function getSaturdayNonPremiumCommercialDeliveryIndicator()
    {
        return $this->container['saturday_non_premium_commercial_delivery_indicator'];
    }

    /**
     * Sets saturday_non_premium_commercial_delivery_indicator
     *
     * @param string $saturday_non_premium_commercial_delivery_indicator \"Y\"  indicates that a SaturdayNonPremiumCommercialDeliveryIndicator is provided.
     *
     * @return $this
     */
    public function setSaturdayNonPremiumCommercialDeliveryIndicator($saturday_non_premium_commercial_delivery_indicator)
    {
        $this->container['saturday_non_premium_commercial_delivery_indicator'] = $saturday_non_premium_commercial_delivery_indicator;

        return $this;
    }

    /**
     * Gets sunday_non_premium_commercial_delivery_indicator
     *
     * @return string
     */
    public function getSundayNonPremiumCommercialDeliveryIndicator()
    {
        return $this->container['sunday_non_premium_commercial_delivery_indicator'];
    }

    /**
     * Sets sunday_non_premium_commercial_delivery_indicator
     *
     * @param string $sunday_non_premium_commercial_delivery_indicator \"Y\"  indicates that a SundayNonPremiumCommercialDeliveryIndicator is provided.
     *
     * @return $this
     */
    public function setSundayNonPremiumCommercialDeliveryIndicator($sunday_non_premium_commercial_delivery_indicator)
    {
        $this->container['sunday_non_premium_commercial_delivery_indicator'] = $sunday_non_premium_commercial_delivery_indicator;

        return $this;
    }

    /**
     * Gets ups_premier_accessorial_indicator
     *
     * @return string
     */
    public function getUpsPremierAccessorialIndicator()
    {
        return $this->container['ups_premier_accessorial_indicator'];
    }

    /**
     * Sets ups_premier_accessorial_indicator
     *
     * @param string $ups_premier_accessorial_indicator \"Y\" indicates that the UPS Premier accessorial is provided.
     *
     * @return $this
     */
    public function setUpsPremierAccessorialIndicator($ups_premier_accessorial_indicator)
    {
        $this->container['ups_premier_accessorial_indicator'] = $ups_premier_accessorial_indicator;

        return $this;
    }

    /**
     * Gets ups_premier_category_code
     *
     * @return string
     */
    public function getUpsPremierCategoryCode()
    {
        return $this->container['ups_premier_category_code'];
    }

    /**
     * Sets ups_premier_category_code
     *
     * @param string $ups_premier_category_code Indicates the UPS Premier category applied to the package Valid values: - 'PRS' – UPS Premier Silver - 'PRG' – UPS Premier Gold - 'PRP' - UPS Premier Platinum
     *
     * @return $this
     */
    public function setUpsPremierCategoryCode($ups_premier_category_code)
    {
        $this->container['ups_premier_category_code'] = $ups_premier_category_code;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
