<?php
/**
 * XAVRequestAddressKeyFormat
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\AddressValidation
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Address Validation - Street Level
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\AddressValidation\AddressValidation;

use \ArrayAccess;
use \UPS\AddressValidation\ObjectSerializer;

/**
 * XAVRequestAddressKeyFormat Class Doc Comment
 *
 * @category Class
 * @description AddressKeyFormat container. The Key format is based on addressing standards jointly developed by the Postal Service and mailing industry.  The information provided in the Address Key container will be returned in the same format.
 * @package  UPS\AddressValidation
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class XAVRequestAddressKeyFormat implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'XAVRequest_AddressKeyFormat';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'consignee_name' => 'string',
        'attention_name' => 'string',
        'address_line' => 'string[]',
        'region' => 'string',
        'political_division2' => 'string',
        'political_division1' => 'string',
        'postcode_primary_low' => 'string',
        'postcode_extended_low' => 'string',
        'urbanization' => 'string',
        'country_code' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'consignee_name' => null,
        'attention_name' => null,
        'address_line' => null,
        'region' => null,
        'political_division2' => null,
        'political_division1' => null,
        'postcode_primary_low' => null,
        'postcode_extended_low' => null,
        'urbanization' => null,
        'country_code' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'consignee_name' => 'ConsigneeName',
        'attention_name' => 'AttentionName',
        'address_line' => 'AddressLine',
        'region' => 'Region',
        'political_division2' => 'PoliticalDivision2',
        'political_division1' => 'PoliticalDivision1',
        'postcode_primary_low' => 'PostcodePrimaryLow',
        'postcode_extended_low' => 'PostcodeExtendedLow',
        'urbanization' => 'Urbanization',
        'country_code' => 'CountryCode'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'consignee_name' => 'setConsigneeName',
        'attention_name' => 'setAttentionName',
        'address_line' => 'setAddressLine',
        'region' => 'setRegion',
        'political_division2' => 'setPoliticalDivision2',
        'political_division1' => 'setPoliticalDivision1',
        'postcode_primary_low' => 'setPostcodePrimaryLow',
        'postcode_extended_low' => 'setPostcodeExtendedLow',
        'urbanization' => 'setUrbanization',
        'country_code' => 'setCountryCode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'consignee_name' => 'getConsigneeName',
        'attention_name' => 'getAttentionName',
        'address_line' => 'getAddressLine',
        'region' => 'getRegion',
        'political_division2' => 'getPoliticalDivision2',
        'political_division1' => 'getPoliticalDivision1',
        'postcode_primary_low' => 'getPostcodePrimaryLow',
        'postcode_extended_low' => 'getPostcodeExtendedLow',
        'urbanization' => 'getUrbanization',
        'country_code' => 'getCountryCode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['consignee_name'] = isset($data['consignee_name']) ? $data['consignee_name'] : null;
        $this->container['attention_name'] = isset($data['attention_name']) ? $data['attention_name'] : null;
        $this->container['address_line'] = isset($data['address_line']) ? $data['address_line'] : null;
        $this->container['region'] = isset($data['region']) ? $data['region'] : null;
        $this->container['political_division2'] = isset($data['political_division2']) ? $data['political_division2'] : null;
        $this->container['political_division1'] = isset($data['political_division1']) ? $data['political_division1'] : null;
        $this->container['postcode_primary_low'] = isset($data['postcode_primary_low']) ? $data['postcode_primary_low'] : null;
        $this->container['postcode_extended_low'] = isset($data['postcode_extended_low']) ? $data['postcode_extended_low'] : null;
        $this->container['urbanization'] = isset($data['urbanization']) ? $data['urbanization'] : null;
        $this->container['country_code'] = isset($data['country_code']) ? $data['country_code'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['country_code'] === null) {
            $invalidProperties[] = "'country_code' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets consignee_name
     *
     * @return string
     */
    public function getConsigneeName()
    {
        return $this->container['consignee_name'];
    }

    /**
     * Sets consignee_name
     *
     * @param string $consignee_name Name of business, company or person. Ignored if user selects the RegionalRequestIndicator.
     *
     * @return $this
     */
    public function setConsigneeName($consignee_name)
    {
        $this->container['consignee_name'] = $consignee_name;

        return $this;
    }

    /**
     * Gets attention_name
     *
     * @return string
     */
    public function getAttentionName()
    {
        return $this->container['attention_name'];
    }

    /**
     * Sets attention_name
     *
     * @param string $attention_name Name of the building. Ignored if user selects the RegionalRequestIndicator.
     *
     * @return $this
     */
    public function setAttentionName($attention_name)
    {
        $this->container['attention_name'] = $attention_name;

        return $this;
    }

    /**
     * Gets address_line
     *
     * @return string[]
     */
    public function getAddressLine()
    {
        return $this->container['address_line'];
    }

    /**
     * Sets address_line
     *
     * @param string[] $address_line Address line (street number, street name and street type) used for street level information. Additional secondary information (apartment, suite, floor, etc.). Applicable to US and PR only. Ignored if user selects the RegionalRequestIndicator.
     *
     * @return $this
     */
    public function setAddressLine($address_line)
    {
        $this->container['address_line'] = $address_line;

        return $this;
    }

    /**
     * Gets region
     *
     * @return string
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     *
     * @param string $region If this node is present the following tags will be ignored:  - Political Division 2 - Political Division 1 - PostcodePrimaryLow - PostcodeExtendedLow  Valid only for US or PR origins only.  Using this tag for non US/PR origins may cause address format errors.
     *
     * @return $this
     */
    public function setRegion($region)
    {
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets political_division2
     *
     * @return string
     */
    public function getPoliticalDivision2()
    {
        return $this->container['political_division2'];
    }

    /**
     * Sets political_division2
     *
     * @param string $political_division2 City or Town name.
     *
     * @return $this
     */
    public function setPoliticalDivision2($political_division2)
    {
        $this->container['political_division2'] = $political_division2;

        return $this;
    }

    /**
     * Gets political_division1
     *
     * @return string
     */
    public function getPoliticalDivision1()
    {
        return $this->container['political_division1'];
    }

    /**
     * Sets political_division1
     *
     * @param string $political_division1 State or Province/Territory name.
     *
     * @return $this
     */
    public function setPoliticalDivision1($political_division1)
    {
        $this->container['political_division1'] = $political_division1;

        return $this;
    }

    /**
     * Gets postcode_primary_low
     *
     * @return string
     */
    public function getPostcodePrimaryLow()
    {
        return $this->container['postcode_primary_low'];
    }

    /**
     * Sets postcode_primary_low
     *
     * @param string $postcode_primary_low Postal Code.
     *
     * @return $this
     */
    public function setPostcodePrimaryLow($postcode_primary_low)
    {
        $this->container['postcode_primary_low'] = $postcode_primary_low;

        return $this;
    }

    /**
     * Gets postcode_extended_low
     *
     * @return string
     */
    public function getPostcodeExtendedLow()
    {
        return $this->container['postcode_extended_low'];
    }

    /**
     * Sets postcode_extended_low
     *
     * @param string $postcode_extended_low 4 digit Postal Code extension. For US use only.
     *
     * @return $this
     */
    public function setPostcodeExtendedLow($postcode_extended_low)
    {
        $this->container['postcode_extended_low'] = $postcode_extended_low;

        return $this;
    }

    /**
     * Gets urbanization
     *
     * @return string
     */
    public function getUrbanization()
    {
        return $this->container['urbanization'];
    }

    /**
     * Sets urbanization
     *
     * @param string $urbanization Puerto Rico Political Division 3. Only Valid for Puerto Rico.
     *
     * @return $this
     */
    public function setUrbanization($urbanization)
    {
        $this->container['urbanization'] = $urbanization;

        return $this;
    }

    /**
     * Gets country_code
     *
     * @return string
     */
    public function getCountryCode()
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code
     *
     * @param string $country_code Country or Territory Code. For a list of valid values, refer to the Address Validation API Supported Countries or Territories table in the Appendix.
     *
     * @return $this
     */
    public function setCountryCode($country_code)
    {
        $this->container['country_code'] = $country_code;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
