<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionInfoBanner
 * @property ModelExtensionInfoBanner $model_extension_info_banner
 * @property ModelExtensionBrandsInfoLicenseInfo
 */

class ControllerPagesExtensionInfoBanner extends AController {
    public $data=[];
    public $error=[];
    private $shared_secret = "info_banner";

    public function verify() {
        $this->load->model('extension/info_banner_license_info');
        $license_key = $this->config->get('info_banner_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('info_banner_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_info_banner_license_info->getStoreId();
                $license_key = $this->model_extension_info_banner_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_info_banner_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_info_banner_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyEditor() {
        if ( $this->config->get( 'editor_status' ) === '1' ) {
            $this->load->model('extension/editor_license_info');
            $license_key = $this->config->get('editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main() {
        $this->extensions->hk_InitData( $this, __FUNCTION__ );
        $this->load->language('catalog/product');
        $this->load->language('info_banner/info_banner');
        $this->document->setTitle($this->language->get('info_banner_title'));
        $store_id = $this->getStoreId();
        $this->view->assign('error_warning', $this->session->data['warning']);
        if (isset($this->session->data['warning'])) {
            unset($this->session->data['warning']);
        }
        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb([
            'href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => false,
        ]);
        $this->document->addBreadcrumb([
            'href' => $this->html->getSecureURL('extension/info_banner'),
            'text' => $this->language->get('info_banner_title'),
            'separator' => ' :: ',
            'current' => true,
        ]);

        $grid_settings = [
            'table_id' => 'info_banner_grid',
            'url'              => $this->html->getSecureURL('listing_grid/info_banner'),
            'editurl'          => $this->html->getSecureURL('listing_grid/info_banner/update'),
            'update_field'     => $this->html->getSecureURL('listing_grid/info_banner/update_field'),
            'update_field' => '',
            //NOTE: set default sorting by date_modified, but column not present in the grid
            'sortname' => 'date_modified',
            'sortorder' => 'desc',
            'actions' => [
                'edit' => [
                    'text' => $this->language->get('text_edit'),
                    'href' => $this->html->getSecureURL('extension/info_banner/update', '&id=%ID%'),
                ],
                'delete' => [
                    'text' => $this->language->get('button_delete'),
                    'href' => $this->html->getSecureURL('extension/info_banner/delete', '&id=%ID%')
                ]
            ],
        ];

        $grid_settings['colNames'] = [
            $this->language->get('column_id'),
            $this->language->get('column_title'),
            $this->language->get('column_status'),
            $this->language->get('column_sort_order'),
            $this->language->get('column_layouts'),
            $this->language->get('column_customer_groups'),
        ];
        $grid_settings['colModel'] = [
            [
                'name' => 'id',
                'index' => 'id',
                'align' => 'center',
                'width' => 50,
                'search' => false,
            ],
            [
                'name' => 'title',
                'index' => 'title',
                'align' => 'center',
                'width' => 200,
                'search' => false,
            ],
            [
                'name' => 'status',
                'index' => 'status',
                'align' => 'center',
                'width' => 100,
                'search' => false,
            ],
            [
                'name' => 'sort_order',
                'index' => 'sort_order',
                'align' => 'center',
                'width' => 100,
                'search' => false,
                'sortable' => false,
            ],
            [
                'name' => 'layouts',
                'index' => 'layouts',
                'align' => 'center',
                'width' => 300,
                'search' => false,
                'sortable' => false,
            ],
            [
                'name' => 'customer_groups',
                'index' => 'customer_groups',
                'align' => 'center',
                'width' => 300,
                'search' => false,
                'sortable' => false,
            ],
        ];

        $form = new AForm();
        $form->setForm([
            'form_name' => 'info_banner_grid_search',
        ]);

        //get search filter from cookie if required
        $search_params = [];
        if ($this->request->get['saved_list']) {
            $grid_search_form = json_decode(html_entity_decode($this->request->cookie['grid_search_form']));
            if ($grid_search_form->table_id == $grid_settings['table_id']) {
                parse_str($grid_search_form->params, $search_params);
            }
        }

        $grid_search_form = [];
        $grid_search_form['id'] = 'info_banner_grid_search';
        $grid_search_form['form_open'] = $form->getFieldHtml([
            'type' => 'form',
            'name' => 'info_banner_grid_search',
            'action' => '',
        ]);
        $grid_search_form['submit'] = $form->getFieldHtml([
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get('button_filter'),
            'style' => 'button1',
        ]);
        $grid_search_form['reset'] = $form->getFieldHtml([
            'type' => 'button',
            'name' => 'reset',
            'text' => $this->language->get('button_reset'),
            'style' => 'button2',
        ]);

        if ($this->request->get['title']) {
            $search_params['title'] = $this->request->get['title'];
        }

        $grid_search_form['fields']['title'] = $form->getFieldHtml(
            [
                'type' => 'input',
                'name' => 'title',
                'value' => $search_params['title'],
                'placeholder' => $this->language->get('text_search_title'),
            ]);

        $grid_settings['search_form'] = true;
        $grid_settings['multiaction_options'] = ['delete' => $this->language->get('text_delete_selected')];
        $grid = $this->dispatch('common/listing_grid', [$grid_settings]);
        $this->data['listing_grid'] = $grid->dispatchGetOutput();
        $this->data['search_form'] = $grid_search_form;
        $this->data['insert'] = $this->html->getSecureURL('extension/info_banner/insert');
        $this->view->batchAssign($this->language->getASet());
        $this->load->language('info_banner/info_banner');
        $this->data['license_status'] = $this->verify();
        $this->data['text_unauthorized'] = $this->language->get('text_info_banner_unauthorized');
        $this->data['form_store_switch']= $this->html->getStoreSwitcher();
        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->assign('language_code', $this->session->data['language']);
        
        $this->view->batchAssign( $this->data );
        //update controller data
        $this->extensions->hk_UpdateData( $this, __FUNCTION__ );
        $this->processTemplate( 'pages/extension/info_banner.tpl' );
    }

    public function insert() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('info_banner/info_banner');
        $this->document->setTitle($this->language->get('heading_insert'));
        $this->data['heading_title'] = $this->language->get('heading_insert');
        if ($this->request->is_POST() && $this->_validateInsertForm()) {
            $this->_prepareData();
            $this->loadModel('extension/info_banner');
            $info_banner_id = $this->model_extension_info_banner->addInfoBanner($this->request->post);
            $this->session->data ['success'] = $this->language->get('text_create_info_banner_success');
            redirect($this->html->getSecureURL('extension/info_banner/update', '&id=' . $info_banner_id));
        }

        foreach ($this->request->post as $k => $v) {
            $this->data[$k] = $v;
        }
        $this->_getForm('create');
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function update() {
        //init controller data
        $this->loadModel('extension/info_banner');
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('info_banner/info_banner');
        $this->document->setTitle($this->language->get('heading_edit'));
        $this->data['heading_title'] = $this->language->get('heading_edit');
        $info_banner_id = (int)$this->request->get['id'];
        if ($this->request->is_POST() && $this->_validateEditForm() && $info_banner_id) {
            $this->_prepareData();
            $this->loadModel('extension/info_banner');
            $this->model_extension_info_banner->updateInfoBanner($info_banner_id, $this->request->post);
            $this->session->data ['success'] = $this->language->get('text_update_info_banner_success');
            redirect($this->html->getSecureURL('extension/info_banner/update', '&id=' . $info_banner_id));
        }
        $this->data['error'] = $this->error;
        $info = $this->model_extension_info_banner->getInfoBanner($info_banner_id);
        foreach ($info as $k => $v) {
            $this->data[$k] = $v;
        }
        $this->_getForm('update');
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

    }

    public function delete() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $info_banner_id = (int)$this->request->get['id'];
        $this->loadModel('extension/info_banner');

        $this->model_extension_info_banner->deleteInfoBanner($info_banner_id);
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        redirect($this->html->getSecureURL('extension/info_banner'));
    }

    private function _getForm($page='') {
        $this->load->language('info_banner/info_banner');
        $this->load->model('extension/info_banner');
        $this->load->model('sale/customer_group');
        $this->load->model('setting/store');
        $store_id = $this->getStoreId();
        $id = null;

        $content_language_id = $this->language->getContentLanguageID();

        $this->document->addScript($this->view->templateResource('/javascript/bootstrap-colorpicker.min.js'));
        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/bootstrap-colorpicker.min.css'),
                'rel' => 'stylesheet',
            ]
        );

        if (isset($this->request->get['id'])) {
            $id = $this->request->get['id'];
            $info_banner = $this->model_extension_info_banner->getInfoBanner($id);
        }

        $fields=[
            'status',
            'sticky',
            'bg_color',
            'color',
            'close_button',
            'opacity',
            'hide_session',
            'layouts',
            'customer_groups',
            'custom_css',
            'store_id'
        ];

      foreach ($fields as $f) {
            if (isset ($this->request->post [$f])) {
                $this->data[$f] = $this->request->post [$f];
            } elseif (isset($info_banner)) {
                if($f==='layouts' || $f==='customer_groups') {
                    $this->data[$f] = unserialize($info_banner[$f]);
                } else {
                    $this->data[$f] = $info_banner[$f];
                }
            }
        }

        if (isset ($this->session->data['warning'])) {
            $this->data ['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data ['error_warning'] = '';
        }
        $this->view->assign('success', $this->session->data['success']);

        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        if ($page==='create') {
            $this->data['form_title'] = $this->language->get('heading_insert');
            $this->data['heading_title'] = $this->language->get('heading_insert');
            $this->document->setTitle($this->language->get('heading_insert'));
        } else {
            $this->data['form_title'] = $this->language->get('heading_edit');
            $this->data['heading_title'] = $this->language->get('heading_edit');
            $this->document->setTitle($this->language->get('heading_edit'));
        }
        
        $this->document->initBreadcrumb(['href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => FALSE]);

        $this->document->addBreadcrumb(['href' => $this->html->getSecureURL('extension/info_banner'),
            'text' => $this->language->get('info_banner_title'),
            'separator' => ' :: ']);

        $this->data ['cancel'] = $this->html->getSecureURL('extension/info_banner');

        if (!isset($this->request->get['id'])) {
            $this->data ['form_action'] = $this->html->getSecureURL('extension/info_banner/insert');
            $this->data ['form_title'] = $this->language->get('text_create');
            $form = new AForm ('ST');
        } else {
            $this->data ['form_action'] = $this->html->getSecureURL('extension/info_banner/update', '&id=' . $this->request->get ['id']);
            $this->data ['form_title'] = $this->language->get('text_edit') ;
            $form = new AForm ('HS');
        }

        if (isset($this->request->post['info_banner_description'])) {
            $this->data['info_banner_description'] = $this->request->post['info_banner_description'];
        } elseif (isset($info_banner)) {
            $this->data['info_banner_description'] = $this->model_extension_info_banner->getInfoBannerDescription(
                $id,
                $content_language_id
            );
        } else {
            $this->data['info_banner_description'] = [];
        }

        $this->document->addBreadcrumb(
            ['href' => $this->data['action'],
                'text' => $this->data ['form_title'],
                'separator' => ' :: ',
                'current' => true
            ]
        );

        $form->setForm(['form_name' => 'infoBannerFrm', 'update' => $this->data ['update']]);

        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type' => 'form',
                'name' => 'infoBannerFrm',
                'attr' => 'data-confirm-exit="true" class="aform form-horizontal"',
                'action' => $this->data ['action']
            ]
        );

        if ($page==='create') {
            $this->data['form']['submit'] = $form->getFieldHtml(
                [
                    'type' => 'button',
                    'name' => 'submit',
                    'text' => $this->language->get('button_save')
                ]
            );
        } elseif ($page==='update') {
            $this->data['form']['submit'] = $form->getFieldHtml(
                [
                    'type' => 'button',
                    'name' => 'submit',
                    'text' => $this->language->get('button_update')
                ]
            );
        }

        $this->data['form']['cancel'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'cancel',
                'text' => $this->language->get('button_cancel')
            ]
        );

        $templates = $this->extensions->getInstalled('template');
        $templates[] = 'default';
        $layouts = [];
        foreach ($templates as $template) {
            $layout = new ALayoutManager($template);
            $pages = $layout->getPages();
            foreach ($pages as $page) {
                $layout_name = $this->addDetails($page['layout_name']);
                $layouts[$page['layout_id']] = $template.' - '.$layout_name;
            }
        }

        $this->data['layouts'] = $form->getFieldHtml([
            'type'    => 'checkboxgroup',
            'name'    => 'layouts[]',
            'value'   => $this->data['layouts'],
            'options' => $layouts,
        ]);

        $this->data['entry_layouts'] = $this->language->get('entry_layouts');

        $status = [
            '0' => $this->language->get('text_off'),
            '1' =>  $this->language->get('text_on')
        ];

        $options = [
          '0' => $this->language->get('text_no'),
          '1' =>  $this->language->get('text_yes')
        ];

        $this->data['status'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'status',
            'value'   => $this->data['status'],
            'options' => $status
        ]);

        $this->data['entry_status'] = $this->language->get('entry_status');

        $this->data['close_button'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'close_button',
            'value'   => $this->data['close_button'],
            'options' => $options
        ]);

        $this->data['entry_close_button'] = $this->language->get('entry_close_button');

        $this->data['sort_order'] = $form->getFieldHtml([
            'type'    => 'input',
            'name'    => 'sort_order',
            'value'   => $this->data['sort_order'],
        ]);

        $this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

        $this->data['sticky'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'sticky',
            'value'   => $this->data['sticky'],
            'options' => $options,
        ]);

        $this->data['entry_sticky'] = $this->language->get('entry_sticky');

        $this->data['title'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'info_banner_description[title]',
            'value' => $this->data['info_banner_description']['title'],
            'style' => 'col-sm-3',
            'multilingual' => true,
        ]);

        $this->data['entry_title'] = $this->language->get('entry_title');

        $this->data['content'] = $form->getFieldHtml([
            'type'        => 'texteditor',
            'name'        => 'info_banner_description[content]',
            'value'       => $this->data['info_banner_description']['content'],
            'multilingual' => true,
        ]);

        $this->data['entry_content'] = $this->language->get('entry_content');

        $this->data['bg_color'] = $form->getFieldHtml([
            'element_id' => 'bg_color',
            'type' => 'input',
            'name' => 'bg_color',
            'value' => $this->data['bg_color'],
            'style' => 'col-sm-3',
            'placeholder' => $this->language->get('text_color_placeholder')
        ]);

        $this->data['entry_bg_color'] = $this->language->get('entry_bg_color');

        $this->data['color'] = $form->getFieldHtml([
            'element_id' => 'color',
            'type' => 'input',
            'name' => 'color',
            'value' => $this->data['color'],
            'style' => 'col-sm-3',
            'placeholder' => $this->language->get('text_color_placeholder')
        ]);

        $this->data['entry_color'] = $this->language->get('entry_color');

        $this->data['opacity'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'opacity',
            'value' => $this->data['opacity'] ? $this->data['opacity'] : 0.8,
            'style' => 'col-sm-3',
        ]);

        $this->data['entry_opacity'] = $this->language->get('entry_opacity');

        $this->data['hide_banner'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'hide_banner',
            'value'   => $this->data['hide_banner'],
            'options' => $options,
        ]);

        $this->data['entry_hide_banner'] = $this->language->get('entry_hide_banner');

        $this->data['start_date'] = $form->getFieldHtml(
            [
                'type'       => 'date',
                'name'       => 'start_date',
                'value'      => dateISO2Display($this->data['start_date']),
                'default'    => '',
                'dateformat' => format4Datepicker($this->language->get('date_format_short')),
                'highlight'  => 'future',
                'style'      => 'small-field',
            ]
        );
        $this->data['entry_start_date'] = $this->language->get('entry_info_banner_start_date');

        $this->data['end_date'] = $form->getFieldHtml(
            [
                'type'       => 'date',
                'name'       => 'end_date',
                'value'      => dateISO2Display($this->data['end_date']),
                'default'    => '',
                'dateformat' => format4Datepicker($this->language->get('date_format_short')),
                'highlight'  => 'past',
                'style'      => 'small-field',
            ]
        );

        $this->data['entry_end_date'] = $this->language->get('entry_info_banner_end_date');
        
        $customer_groups = $this->model_sale_customer_group->getCustomerGroups();
        $cust_group = [];
        foreach ($customer_groups as $group) {
            $cust_group[$group['customer_group_id']] = $group['name'];
        }

        $this->data['customer_groups'] = $form->getFieldHtml([
            'type'    => 'checkboxgroup',
            'name'    => 'customer_groups[]',
            'value'   => $this->data['customer_groups'],
            'options' => $cust_group,
        ]);

        $this->data['entry_customer_groups'] = $this->language->get('entry_customer_groups');

        $this->data['custom_css'] = $form->getFieldHtml([
            'type' => 'textarea',
            'name' => 'custom_css',
            'value' => $this->data['custom_css'],
            'attr' => 'rows=20 colspan=20'
        ]);

        $this->data['entry_custom_css'] = $this->language->get('entry_custom_css');

        if (isset($this->request->get['id'])) {
            $info_banner_id = $this->request->get['id'];
            $search = ['[id_selector_1]','[id_selector_2]','[id_selector_3]'];
            $replace = ['"#infobanner_'.$info_banner_id.' .alert-notify"','"#infobanner_'.$info_banner_id.' .alert-notify p"','"#infobanner_'.$info_banner_id.' .alert-notify close"'];
            $this->data['text_custom_css_note'] = str_replace($search,$replace,$this->language->get('text_custom_css_note'));
            $this->data['text_additional_custom_css_note'] = '';
        } else {
            $search = ['[id_selector_1]','[id_selector_2]','[id_selector_3]'];
            $replace = ['"#infobanner_id .alert-notify"','"#infobanner_id .alert-notify p"','"#infobanner_id .alert-notify close"'];
            $this->data['text_custom_css_note'] = str_replace($search,$replace,$this->language->get('text_custom_css_note'));
            $this->data['text_additional_custom_css_note'] = $this->language->get('text_additional_custom_css_note');
        }

        $store_info = $this->model_setting_store->getStore($this->getStoreId());
        $this->data['text_current_store'] = $this->language->get('text_current_store').' '.$store_info['name'];

        $this->data['editor'] = $this->verifyEditor();

        $this->view->batchAssign($this->language->getASet());
        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->assign('language_code', $this->session->data['language']);

        $this->addChild(
            'responses/common/resource_library/get_resources_html', 'resources_html',
            'responses/common/resource_library_scripts.tpl'
        );
        $resources_scripts = $this->dispatch(
            'responses/common/resource_library/get_resources_scripts',
            [
                'object_name' => '',
                'object_id'   => '',
                'types'       => ['image'],
            ]
        );
        $this->data['resources_scripts'] = $resources_scripts->dispatchGetOutput();
        $this->data['rl'] = $this->html->getSecureURL(
            'common/resource_library',
            '&action=list_library&object_name=&object_id&type=image&mode=single'
        );
        $this->view->batchAssign($this->data);

        $this->processTemplate('pages/extension/info_banner_form.tpl');
    }

    private function _validateInsertForm() {
        if (!$this->user->canModify('extension/info_banner')) {
            $this->session->data['warning'] = $this->error ['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post) {
            $required = ['content'];
            foreach ($this->request->post as $name => $value) {
                if (in_array($name, $required) && empty($value)) {
                    $this->error['content'] = $this->language->get('error_content');
                    $this->session->data['warning'] = $this->language->get('error_content');
                    break;
                }
            }
        }
        $this->extensions->hk_ValidateData($this);
        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    private function _validateEditForm() {
        if (!$this->user->canModify('extension/info_banner')) {
            $this->session->data['warning'] = $this->error ['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post) {
            $required = ['content'];
            foreach ($this->request->post as $name => $value) {
                if (in_array($name, $required) && empty($value)) {
                    $this->error['content'] = $this->language->get('error_content');
                    $this->session->data['warning'] = $this->language->get('error_content');
                    break;
                }
            }
        }
        $this->extensions->hk_ValidateData($this);
        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function addDetails($layout_name) {
        $layoutName = '';
        switch ($layout_name) {
            case 'Checkout Pages':
                $layoutName = 'Checkout Pages (All pages for checkout process)';
                break;
            case 'Cart Page':
                $layoutName = 'Cart Page (Basket or Shopping cart page)';
                break;
            case 'Product Listing Page':
                $layoutName = 'Product Listing Page (Categories Pages)';
                break;
            case 'Default Page Layout':
                $layoutName = 'Default Page Layout (All others pages)';
                break;
            default:
                $layoutName = $layout_name;
                break;
        }
        return $layoutName;
    }

    protected function _prepareData() {
        if (isset($this->request->post['start_date']) && $this->request->post['start_date']) {
            $this->request->post['start_date'] = dateDisplay2ISO($this->request->post['start_date']);
        }
        if (isset($this->request->post['end_date']) && $this->request->post['end_date']) {
            $this->request->post['end_date'] = dateDisplay2ISO($this->request->post['end_date']);
        }
    }

    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}