<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesOptionPriceProFastCheckout
 * @property ModelCatalogProduct $model_catalog_product
 * @property ModelOptionPriceProProduct $model_option_price_pro_product
 */

class ControllerPagesOptionPriceProFastCheckout extends AController {
    public $data=[];

    public function main() {
        $this->loadLanguage('fast_checkout/fast_checkout');
        if ($this->request->is_POST() && $this->request->get['single_checkout']) {
            $this->session->data['fc']['cart_key'] = randomWord(5);
        } elseif (!$this->session->data['fc']['cart_key']) {
            $this->session->data['fc']['cart_key'] = randomWord(5);
        }

        $this->load->model( 'option_price_pro/product' );
        $this->load->language('option_price_pro/option_price_pro');
        //set sign for commonHead controller.
        // Needed to change url in the tpl. See addToCart method inside js
        $this->registry->set('fast_checkout', true);
        //short name
        $fcSession =& $this->session->data['fc'];

        $cartClassName = get_class($this->cart);

        //create new cart with single product (onclick buy-now button)
        if ($this->request->get['single_checkout'] && $this->request->is_POST()) {
            $post = $this->request->post;
            $fcSession['single_checkout'] = $this->data['single_checkout'] = true;
            $fcSession['cart'] = [];
            $this->registry->set(
                'cart',
                new $cartClassName($this->registry, $fcSession)
            );
            if (isset($this->request->post['product_id'])) {
                $this->loadModel('catalog/product', 'storefront');
                $productId = $post['product_id'];

                if (isset($post['option'])) {
                    $options = $post['option'];
                } else {
                    $options = [];
                }

                //for FILE-attributes
                if (has_value($this->request->files['option']['name'])) {
                    $fm = new AFile();
                    foreach ($this->request->files['option']['name'] as $id => $name) {
                        $attributeData = $this->model_catalog_product->getProductOption($productId, $id);
                        $attributeData['settings'] = unserialize($attributeData['settings']);
                        $filePathInfo = $fm->getUploadFilePath($attributeData['settings']['directory'], $name);

                        $options[$id] = $filePathInfo['name'];

                        if (!has_value($name)) {
                            continue;
                        }

                        if ($attributeData['required'] && !$this->request->files['option']['size'][$id]) {
                            $this->session->data['error'] = $this->language->get('error_required_options');
                            redirect($_SERVER['HTTP_REFERER']);
                        }

                        $fileData = [
                            'option_id' => $id,
                            'name'      => $filePathInfo['name'],
                            'path'      => $filePathInfo['path'],
                            'type'      => $this->request->files['option']['type'][$id],
                            'tmp_name'  => $this->request->files['option']['tmp_name'][$id],
                            'error'     => $this->request->files['option']['error'][$id],
                            'size'      => $this->request->files['option']['size'][$id],
                        ];

                        $fileErrors = $fm->validateFileOption($attributeData['settings'], $fileData);

                        if (has_value($fileErrors)) {
                            $this->session->data['error'] = implode('<br/>', $fileErrors);
                            redirect($_SERVER['HTTP_REFERER']);
                        } else {
                            $result = move_uploaded_file($fileData['tmp_name'], $filePathInfo['path']);

                            if (!$result || $this->request->files['package_file']['error']) {
                                $this->session->data['error'] .= '<br>Error: '.getTextUploadError(
                                        $this->request->files['option']['error'][$id]
                                    );
                                redirect($_SERVER['HTTP_REFERER']);
                            }
                        }

                        $dataset = new ADataset('file_uploads', 'admin');
                        $dataset->addRows(
                            [
                                'date_added' => date("Y-m-d H:i:s", time()),
                                'name'       => $filePathInfo['name'],
                                'type'       => $fileData['type'],
                                'section'    => 'product_option',
                                'section_id' => $attributeData['attribute_id'],
                                'path'       => $filePathInfo['path'],
                            ]
                        );
                    }
                }

                foreach ( $options as $option_id => $option ) {
                    $options_info = $this->model_option_price_pro_product->getOptionType( $option_id );
                    $option_type  = $options_info['element_type'];
                    $option_name  = $options_info['name'];
                    if ( $option_type === 'G' || $option_type === 'M' ) {
                        $id            = $option_id;
                        $settings      = [];
                        $error         = false;
                        $error_message = $default_message = '';
                        $settings      = $this->model_option_price_pro_product->getSettings( $option_id );
                        if ( ! is_null( $settings ) ) {
                            $minimum = $settings['minimum'];
                            $maximum = $settings['maximum'];
                            $status  = $settings['maximum_status'];
                            $total   = sizeof( $options[ $id ] );
                            if ( $status === '1' ) {
                                if ( $minimum !== '' && $total < $minimum ) {
                                    $searchArray     = [ '{min}', '{total}' ];
                                    $replaceArray    = [ $minimum, $total ];
                                    $error_message   = str_replace( $searchArray, $replaceArray, $this->config->get( 'option_price_pro_enter_minimum_warning' ) );
                                    $default_message = str_replace( '{total}', $total, $this->language->get( 'error_pro_minimum_warning' ) );
                                    $default_message = $minimum . ' ' . $default_message;
                                    $error           = true;
                                } elseif ( $maximum !== '' && $total > $maximum ) {
                                    $searchArray         = [ '{max}', '{total}' ];
                                    $replaceArray        = [ $maximum, $total ];
                                    $error_message       = str_replace( $searchArray, $replaceArray, $this->config->get( 'option_price_pro_enter_maximum_warning' ) );
                                    $searchDefaultArray  = [ '{max}', '{total}' ];
                                    $replaceDefaultArray = [ $maximum, $total ];
                                    $default_message     = str_replace( $searchDefaultArray, $replaceDefaultArray, $this->language->get( 'error_pro_maximum_warning' ) );
                                    $error               = true;
                                }
                            } elseif ( $status === '0' ) {
                                if ( $minimum !== '' && $total < $minimum ) {
                                    $searchArray     = [ '{min}', '{total}' ];
                                    $replaceArray    = [ $minimum, $total ];
                                    $error_message   = str_replace( $searchArray, $replaceArray, $this->config->get( 'option_price_pro_enter_minimum_warning' ) );
                                    $default_message = str_replace( '{total}', $total, $this->language->get( 'error_pro_minimum_warning' ) );
                                    $default_message = $minimum . ' ' . $default_message;
                                    $error           = true;
                                }
                            }
                            if ( $error === true ) {
                                if ( $error_message !== '' ) {
                                    $errors[] = $option_name . ": " . $error_message;
                                } else {
                                    $errors[] = $option_name . ": " . $default_message;
                                }
                            }
                        }
                    }
                }

                if ($errors) {
                    $this->session->data['error'] = $errors;
                    //send options values back via _GET
                    $url = '&'.http_build_query(['option' => $post['option']]);
                    redirect(
                        $this->html->getSecureURL(
                            'product/product',
                            '&product_id='.$post['product_id'].$url
                        )
                    );
                } elseif ($textErrors = $this->model_catalog_product->validateProductOptions($productId, $options)) {
                    $this->session->data['error'] = $textErrors;
                    //send options values back via _GET
                    $url = '&'.http_build_query(['option' => $post['option']]);
                    redirect(
                        $this->html->getSecureURL(
                            'product/product',
                            '&product_id='.$post['product_id'].$url
                        )
                    );
                }

                $this->cart->add($post['product_id'], $post['quantity'], $options);
                $productCartKey = !$options ? $productId : $productId.':'.md5(serialize($options));
                if (!$this->cart->hasProducts() || (!$this->cart->hasStock() && !$this->config->get('config_stock_checkout'))) {
                    $this->session->data['error'] = $this->language->get('fast_checkout_text_not_enough_stock');
                    //send options values back via _GET
                    $url = '&'.http_build_query(['option' => $post['option']]);
                    redirect(
                        $this->html->getSecureURL(
                            'product/product',
                            '&product_id='.$post['product_id'].$url
                        )
                    );
                }
            }
            //if we added single product via POST request - do redirect to self
            redirect($this->html->getSecureURL('checkout/fast_checkout', '&product_key='.$productCartKey));
        } //do clone of default cart
        else {
            if (!$fcSession['single_checkout']) {
                $fcSession['single_checkout'] = false;
            }
            $fcSession['cart'] = $fcSession['cart'] ? : $this->session->data['cart'];
            $this->removeNoStockProducts();
            if (isset($this->session->data['coupon'])) {
                $fcSession['coupon'] = $this->session->data['coupon'];
            }
            $this->registry->set(
                'cart',
                new $cartClassName($this->registry, $fcSession)
            );
        }

        if ($this->request->get['single_checkout']) {
            $this->data['single_checkout'] = true;
        }
        //save cart_key into cookie to check on js-side
        // if another fc changed it
        setCookieOrParams(
            'fc_cart_key',
            $fcSession['cart_key'],
            [
                'path'     => dirname($this->request->server['PHP_SELF']),
                'domain'   => null,
                'secure'   => (defined('HTTPS') && HTTPS),
                'httponly' => false,
                'samesite' => ((defined('HTTPS') && HTTPS) ? 'None' : 'lax')
            ]
        );

        //check if two single-checkout tabs opened
        if (isset($this->request->get['product_key'])) {
            $cartProducts = $this->cart->getProducts();

            //warning about min/max qty exceeding
            if($fcSession['error']) {
                $this->data['error'] = $fcSession['error'];
                unset($this->session->data['fc']['error']);
            }

            $cartSingleProduct = $cartProducts[$this->request->get['product_key']];
            if (count($cartProducts) > 1 && $cartSingleProduct) {
                redirect(
                    $this->html->getSEOURL(
                        'product/product',
                        '&product_id='.$cartSingleProduct['product_id']
                    )
                );
            } elseif (!$cartSingleProduct) {
                //if product not found in the cart - just redirect to home
                redirect($this->html->getHomeURL());
            }
        }
    }

    protected function removeNoStockProducts() {
        $cartProducts = $this->cart->getProducts();
        foreach ($cartProducts as $key => $cartProduct) {
            if (!$cartProduct['stock'] && !$this->config->get('config_stock_checkout')) {
                unset(
                    $this->session->data['fc']['cart'][$key]
                );
            }
        }
    }
}