<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

/**
 * Class ExtensionOptionPricePro
 * @property ModelOptionPriceProProduct $model_option_price_pro_product
 */

require_once DIR_EXT . "option_price_pro" . DIR_EXT_CORE . "helpers.php";
require_once DIR_EXT . "option_price_pro" . DIR_EXT_CORE . "updater.php";

class ExtensionOptionPricePro extends Extension {

	public $data = [];
	private $calc_status = '';
	private $error = [];

	public function __construct() {
		$this->registry = Registry::getInstance();
	}

	private function _is_enabled() {
		return $this->baseObject->config->get( 'option_price_pro_status' ) ? $this->verify() : false;
	}

	public function verify() {
		$that =& $this->baseObject;
		$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('option_pro_license')."'");
		if ($exist->num_rows === 1) {
			$validation = optionProVerifyLicense();
			if ( $validation['notification_case'] === 'notification_license_ok' ) {
				return true;
			} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
				return false;
			}
		} else {
			return false;
		}
	}

    public function verifyAreaCalculator() {
        $that  =& $this->baseObject;
        if ($this->baseObject->config->get('area_calculator_status')==='1') {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'area_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = areaCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyLengthCalculator() {
        $that  =& $this->baseObject;
        if ($this->baseObject->config->get('length_calculator_status')==='1') {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'length_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = lengthCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyVolumeCalculator() {
        $that  =& $this->baseObject;
        if ($this->baseObject->config->get('volume_calculator_status')==='1') {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'volume_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = volumeCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyWeightCalculator() {
        $that  =& $this->baseObject;
        if ($this->baseObject->config->get('weight_calculator_status')==='1') {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'weight_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = weightCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyLiquidsCalculator() {
        $that  =& $this->baseObject;
        if ($this->baseObject->config->get('liquids_calculator_status')==='1') {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'liquids_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = liquidsCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

	public function onControllerPagesExtensionExtensions_InitData() {
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'edit' ) {
			$extension = $that->request->get['extension'];
			if ( $extension === 'option_price_pro' ) {
				if ( $that->request->is_POST() ) {
					$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('option_pro_license')."'");
					if ($exist->num_rows === 1) {
						if ($this->verify()===true) {
							optionProUninstallLicense();
						} else {
							$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('option_pro_license'));
						}
						optionProInstallLicense( $that->request->post['option_price_pro_license_code'] );
					} else {
						$license = optionProInstallLicense( $that->request->post['option_price_pro_license_code'] );
						if ( $license['notification_case'] !== 'notification_license_ok' ) {
							$that->session->data['error'] = $license['notification_text'];
						} else {
							$that->session->data['success'] = "The license key is valid";
						}
					}
				}
			}
		}
	}

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method==='update') {
			if ($that->request->post['option_price_pro_license_code']) {
				$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('option_pro_license')."'");
				if ($exist->num_rows === 1) {
					if ($this->verify()===true) {
						optionProUninstallLicense();
					} else {
						$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('option_pro_license'));
					}
					optionProInstallLicense( $that->request->post['option_price_pro_license_code'] );
				} else {
					$license = optionProInstallLicense( $that->request->post['option_price_pro_license_code'] );
					if ( $license['notification_case'] !== 'notification_license_ok' ) {
						$that->session->data['error'] = $license['notification_text'];
					} else {
						$that->session->data['success'] = "The license key is valid";
					}
				}
			}
		}
	}

	public function onControllerPagesCheckoutCart_InitData() {
		$that = $this->baseObject;

		if ( ! $this->_is_enabled() ) {
			return null;
		}

		if ( $this->baseObject_method === 'main' ) {
			if ( $that->request->is_POST() ) {
				$post = $that->request->post;

				$that->load->language( 'option_price_pro/option_price_pro' );
				if ( isset( $post['option'] ) ) {
					$options = $post['option'];
					$that->load->model( 'option_price_pro/product' );
					$that->load->model( 'catalog/product' );
					$text_errors = [];
					foreach ( $options as $option_id => $option ) {
						$options_info = $that->model_option_price_pro_product->getOptionType( $option_id );
						$option_type  = $options_info['element_type'];
						$option_name  = $options_info['name'];
						if ( $option_type === 'G' || $option_type === 'M' ) {
							$id            = $option_id;
							$settings      = [];
							$error         = false;
							$error_message = $default_message = '';
							$settings      = $that->model_option_price_pro_product->getSettings( $option_id );
							if ( ! is_null( $settings ) ) {
								$minimum = $settings['minimum'];
								$maximum = $settings['maximum'];
								$status  = $settings['maximum_status'];
								$total   = sizeof( $options[ $id ] );
								if ( $status === '1' ) {
									if ( $minimum !== '' && $total < $minimum ) {
										$searchArray     = [ '{min}', '{total}' ];
										$replaceArray    = [ $minimum, $total ];
										$error_message   = str_replace( $searchArray, $replaceArray, $that->config->get( 'option_price_pro_enter_minimum_warning' ) );
										$default_message = str_replace( '{total}', $total, $that->language->get( 'error_pro_minimum_warning' ) );
										$default_message = $minimum . ' ' . $default_message;
										$error           = true;
									} elseif ( $maximum !== '' && $total > $maximum ) {
										$searchArray         = [ '{max}', '{total}' ];
										$replaceArray        = [ $maximum, $total ];
										$error_message       = str_replace( $searchArray, $replaceArray, $that->config->get( 'option_price_pro_enter_maximum_warning' ) );
										$searchDefaultArray  = [ '{max}', '{total}' ];
										$replaceDefaultArray = [ $maximum, $total ];
										$default_message     = str_replace( $searchDefaultArray, $replaceDefaultArray, $that->language->get( 'error_pro_maximum_warning' ) );
										$error               = true;
									}
								} elseif ( $status === '0' ) {
									if ( $minimum !== '' && $total < $minimum ) {
										$searchArray     = [ '{min}', '{total}' ];
										$replaceArray    = [ $minimum, $total ];
										$error_message   = str_replace( $searchArray, $replaceArray, $that->config->get( 'option_price_pro_enter_minimum_warning' ) );
										$default_message = str_replace( '{total}', $total, $that->language->get( 'error_pro_minimum_warning' ) );
										$default_message = $minimum . ' ' . $default_message;
										$error           = true;
									}
								}
								if ( $error === true ) {
									if ( $error_message !== '' ) {
										$text_errors[] = $option_name . ": " . $error_message;
									} else {
										$text_errors[] = $option_name . ": " . $default_message;
									}
								}
							}
						}
					}
					if ( $text_errors ) {
						$product_rt                   = 'product/product';
						$that->session->data['error'] = $text_errors;
						//send options values back via _GET
						$url = '&' . http_build_query( ['option' => $post['option'] ] );
						redirect( $that->html->getSecureURL( $product_rt, '&product_id=' . $post['product_id'] . $url ) );
					}
				}
			}
		}
	}

    public function onControllerPagesProductProduct_UpdateData() {
        if ( ! $this->_is_enabled() ) {
            return null;
        }
        if ( $this->baseObject_method === 'main' ) {
            if ($this->verifyAreaCalculator()===false
                && $this->verifyLengthCalculator()===false
                && $this->verifyWeightCalculator()===false
                && $this->verifyLiquidsCalculator()===false
                && $this->verifyVolumeCalculator()===false
            ) {
                $key = [];
                $that = $this->baseObject;
                $request = $that->request->get;
                $cart = new ACart($this->registry);

                $fast_checkout = $that->config->get('fast_checkout_status');
                if ($fast_checkout==='1') {
                    $data= [];
                    $data['button_add_to_cart'] = $that->language->get('button_add_to_cart');
                    $data['text_buynow'] = $that->language->get('fast_checkout_buy_now');
                    $data['buynow_url'] = $that->html->getSecureURL('option_price_pro/fast_checkout/main','&single_checkout=1');
                    $data['add_to_cart'] = $that->language->get('button_add_to_cart');

                    /** @var AView $view */
                    $viewClass = get_class($that->view);

                    $view = new $viewClass(Registry::getInstance(),0);
                    $view->batchAssign($data);
                    $that->view->replaceHookVar('product_add_to_cart_html',
                        $view->fetch('pages/product/add_to_cart_buttons.tpl'));
                }

                //if ($calc_status === '0' || is_null($calc_status) || empty($calc_status)) {
                $key = [];
                $option_price = '';
                if (has_value($that->request->get['key'])) {
                    $key = explode(':', $that->request->get['key']);
                    $product_id = (int)$key[0];
                } elseif (has_value($that->request->get['product_id'])) {
                    $product_id = (int)$that->request->get['product_id'];
                } else {
                    $product_id = 0;
                }
                $that->loadModel('catalog/product');
                $that->loadModel('option_price_pro/product');
                $product_info = $that->model_catalog_product->getProduct($product_id);
                $product_price = '';

                $promotion = new APromotion();
                $discount = $promotion->getProductDiscount($product_id);

                //Need to round price after discounts and specials
                //round main price to currency decimal_place setting (most common 2, but still...)

                $currency = $that->currency->getCurrency();
                $decimal_place = (int) $currency['decimal_place'];
                $decimal_place = !$decimal_place ? 2 : $decimal_place;

                if ($discount) {
                    $product_price = round((float)$discount, $decimal_place);
                    $this->data['price_num'] = round($that->tax->calculate(
                        $discount,
                        $product_info['tax_class_id'],
                        (bool)$that->config->get('config_tax')
                    ),
                    $decimal_place);
                    $this->data['special'] = false;
                } else {
                    $product_price = round((float)$product_info['price'], $decimal_place);
                    $this->data['price_num'] = round($that->tax->calculate(
                        $product_info['price'],
                        $product_info['tax_class_id'],
                        (bool)$that->config->get('config_tax')
                    ),
                    $decimal_place);

                    $special = $promotion->getProductSpecial($product_id);
                    if ($special) {
                        $product_price = round($special, $decimal_place);
                        $this->data['special_num'] = round($that->tax->calculate(
                            $special,
                            $product_info['tax_class_id'],
                            (bool)$that->config->get('config_tax')
                        ),
                        $decimal_place);
                    } else {
                        $this->data['special'] = false;
                    }
                }

                $elements_with_options = HtmlElementFactory::getElementsWithOptions();
                $product_options = $that->model_catalog_product->getProductOptions($product_id);

                $options = [];
                $cart_product_info = [];
                if ($key) {
                    $cart_product_info = $cart->getProduct($that->request->get['key']);
                }

                foreach ($product_options as $option) {
                    $configs = $that->model_option_price_pro_product->getBasePrice($option['product_option_id']);
                    $calculate = $configs['calculate'];
                    $base_price = $configs['base_price'];
                    $values = [];
                    $disabled_values = [];
                    $name = $price = '';
                    $default_value = $cart_product_info['options'][$option['product_option_id']];
                    if ($option['element_type'] == 'R') {
                        $default_value = is_array($default_value) ? current($default_value) : (string)$default_value;
                    }
                    $preset_value = $default_value;
                    foreach ($option['option_value'] as $option_value) {
                        $default_value = $option_value['default'] ? $option_value['product_option_value_id'] : $default_value;
                        // for case when trying to add to cart withot required options. we get option-array back inside _GET
                        if (has_value($that->request->get['option'][$option['product_option_id']])) {
                            $default_value = $that->request->get['option'][$option['product_option_id']];
                        }
                        $option_price = $option_value['price'];
                        $name = $option_value['name'];
                        //check if we disable options based on out of stock setting
                        if ($option_value['subtract'] && $that->config->get('config_nostock_autodisable') && $option_value['quantity'] <= 0) {
                            continue;
                        }

                        //Apply option price modifier
                        if ($option_value['prefix'] == '%') {
                            if ($calculate === '0') {
                                $price = round($that->tax->calculate(
                                    ($product_price * $option_value['price'] / 100),
                                    $product_info['tax_class_id'],
                                    (bool)$that->config->get('config_tax')),$decimal_place);
                            } else {
                                $price = round($that->tax->calculate(
                                    $product_price + ($product_price * $option_value['price'] / 100),
                                    $product_info['tax_class_id'],
                                    (bool)$that->config->get('config_tax')),$decimal_place);
                            }
                            if ($price != 0) {
                                $price = $that->currency->format($price);
                            } else {
                                $price = '';
                            }
                        } else {
                            if ($calculate == '0') {
                                $price = round($that->tax->calculate($option_price, $product_info['tax_class_id'], (bool)$that->config->get('config_tax')),$decimal_place);
                            } else {
                                $price = round($that->tax->calculate($product_price + $option_price, $product_info['tax_class_id'], (bool)$that->config->get('config_tax')),$decimal_place);
                            }
                            if ($price != 0) {
                                $price = $that->currency->format($price);
                            } else {
                                $price = '';
                            }
                        }

                        $opt_stock_message = '';
                        //if options has stock tracking and not allowed to be purchased out of stock
                        if ($option_value['subtract'] && !$product_info['stock_checkout']) {
                            if ($option_value['quantity'] <= 0) {
                                //show out of stock message
                                $opt_stock_message = $that->language->get('text_out_of_stock');
                                $disabled_values[] = $option_value['product_option_value_id'];
                            } else {
                                if ($that->config->get('config_stock_display')) {
                                    if ($option_value['quantity'] > 0) {
                                        $opt_stock_message = $option_value['quantity'] . " " . $that->language->get('text_instock');
                                        $opt_stock_message = "({$opt_stock_message})";
                                    }
                                }
                            }
                        } else {
                            if ($option_value['subtract'] && $product_info['stock_checkout']) {
                                if ($option_value['quantity'] <= 0) {
                                    $opt_stock_message = $product_info['stock_status'] ? "({$product_info['stock_status']})" : '';
                                }
                            }
                        }

                        $optionSeparator = $that->config->get('option_price_pro_name_separator');
                        $priceSeparator = $that->config->get('option_price_pro_price_separator');
                        if ($optionSeparator == '') {
                            $optionSymbol = '&nbsp;&nbsp;&nbsp;';
                        } else {
                            $optionSymbol = '&nbsp;' . $optionSeparator . '&nbsp;';
                        }
                        if ($opt_stock_message) {
                            if ($priceSeparator === '') {
                                $priceSymbol = '&nbsp;&nbsp;&nbsp;';
                            } else {
                                $priceSymbol = '&nbsp;' . $priceSeparator . '&nbsp;';
                            }
                        } else {
                            $priceSymbol = '';
                        }

                        if (!empty($opt_stock_message)) {
                            $stock_message = $priceSymbol . $opt_stock_message;
                        } else {
                            $stock_message = '';
                        }

                        if ($base_price === '1' && $price !== '') {
                            $values[$option_value['product_option_value_id']] = $name . $optionSymbol . $price . $stock_message;
                        } else {
                            if ($option_price != '0.0000' && $price !== '') {
                                $values[$option_value['product_option_value_id']] = $name . $optionSymbol . $price . $stock_message;
                            } else {
                                $values[$option_value['product_option_value_id']] = $name . $stock_message;
                            }
                        }

                        if ($option['element_type'] == 'B') {
                            $name = $default_value = preg_replace("/\r|\n/", " ", $option_value['name']);
                            if ($price) {
                                $default_value .= '</br>';
                                $name .= ' ';
                            }
                            if ($price) {
                                $default_value .= $price . ' ';
                                $name .= $price;
                            }
                            $option['required'] = false;
                        }
                    }

                    //if not values are build, nothing to show
                    if (sizeof($values)) {
                        $value = $attr = '';
                        //add price to option name if it is not element with options
                        if (!in_array($option['element_type'], $elements_with_options) && $option['element_type'] != 'B') {
                            if ($option_price === '0.0000') {
                                if ($opt_stock_message) {
                                    $option['name'] .= '<br />' . $opt_stock_message;
                                }
                            } else {
                                $option['name'] .= ' <small>' . $price . '</small>';
                                if ($opt_stock_message) {
                                    $option['name'] .= '<br />' . $opt_stock_message;
                                }
                            }
                            $value = $name;
                        } else {
                            if ($option['element_type'] == 'B') {
                                $value = $name;
                            }
                        }

                        //set default selection is nothing selected
                        if (!has_value($value)) {
                            if (has_value($default_value)) {
                                $value = $default_value;
                            }
                        }

                        if ($option['element_type'] == 'C') {
                            if ($value == '') {
                                $value = 1;
                            }
                            $attr = key($option['option_value']);
                        }

                        if ($option['element_type'] == 'C') {
                            if (!in_array($value, ['0', '1'])) {
                                $option_data['label_text'] = $value;
                            }
                            $option_data['checked'] = $preset_value ? true : false;
                        }
                        $option_data['attr'] = ' data-attribute-value-id="' . $attr . '"';
                        $option_data['disabled_options'] = $disabled_values;

                        $option_data = [
                            'type' => $option['html_type'],
                            'name' =>
                                !in_array($option['element_type'], HtmlElementFactory::getMultivalueElements())
                                    ? 'option[' . $option['product_option_id'] . ']'
                                    : 'option[' . $option['product_option_id'] . '][]',
                            'attr' => ' data-attribute-value-id="' . $attr . '"',
                            'value' => $value,
                            'options' => $values,
                            'disabled_options' => $disabled_values,
                            'required' => $option['required'],
                            'placeholder' => $option['option_placeholder'],
                            'regexp_pattern' => $option['regexp_pattern'],
                            'error_text' => $option['error_text']
                        ];

                        $options[] = [
                            'name' => $option['name'],
                            'html' => $that->html->buildElement($option_data),  // not a string!!! it's object!
                        ];
                    }
                }
                $this->data['options'] = $options;
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

	public function onControllerResponsesProductProduct_UpdateData() {
		if ( ! $this->_is_enabled() ) {
			return null;
		}
		$that        = $this->baseObject;
		if ( $this->baseObject_method === 'load_option' ) {
            $type = $that->data['option_data']['element_type'];
            if ($type!=='LQ' && $type!=='V' && $type!=='W' && $type!=='X' && $type!=='Y') {
                $that->loadLanguage('option_price_pro/option_price_pro');

                $this->data['fields'] = [
                    'entry_status' => 'status',
                    'entry_option_name' => 'option_name',
                    'entry_option_placeholder' => 'option_placeholder',
                    'entry_sort_order' => 'option_sort_order',
                    'entry_required' => 'required',
                    'entry_calculate' => 'calculate',
                    'entry_base_price' => 'base_price',
                    'entry_maximum_status' => 'maximum_status',
                    'entry_minimum' => 'minimum',
                    'entry_maximum' => 'maximum',
                    'entry_allowed_extensions' => 'extensions',
                    'entry_min_size' => 'min_size',
                    'entry_max_size' => 'max_size',
                    'entry_upload_dir' => 'directory',
                    'entry_regexp_pattern' => 'option_regexp_pattern',
                    'entry_error_text' => 'option_error_text'
                ];
                $this->data['calculate'] = $that->html->buildElement([
                    'type' => 'checkbox',
                    'name' => 'calculate',
                    'value' => $that->data['option_data']['calculate'],
                    'style' => 'btn_switch btn-group-xs',
                ]);
                $this->data['base_price'] = $that->html->buildElement([
                    'type' => 'checkbox',
                    'name' => 'base_price',
                    'value' => $that->data['option_data']['base_price'],
                    'style' => 'btn_switch btn-group-xs',
                ]);

                $type = $that->data['option_data']['element_type'];
                $option_id  = (int) $that->request->get['option_id'];
                $that->load->model( 'option_price_pro/options' );
                $option_settings = $that->model_option_price_pro_options->getSettings( $option_id );

                if ($type === 'G' || $type === 'M') {
                    $this->data['entry_maximum_status'] = $that->language->get('text_pro_maximum_status');
                    $this->data['maximum_status'] = $that->html->buildElement([
                        'type' => 'checkbox',
                        'name' => 'maximum_status',
                        'value' => $option_settings['maximum_status'],
                        'style' => 'btn_switch btn-group-xs',
                    ]);
                    $this->data['entry_minimum'] = $that->language->get('enter_pro_minimum');
                    $this->data['minimum'] = $that->html->buildElement([
                        'type' => 'input',
                        'name' => 'minimum',
                        'value' => $option_settings['minimum'],
                        'style' => 'tiny-field'
                    ]);
                    $this->data['entry_maximum'] = $that->language->get('enter_pro_maximum');
                    $this->data['maximum'] = $that->html->buildElement([
                        'type' => 'input',
                        'name' => 'maximum',
                        'value' => $option_settings['maximum'],
                        'style' => 'tiny-field'
                    ]);
                }

                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        } elseif ($this->baseObject_method==='update_option_values') {
            $that->load->model('option_price_pro/options');
            $that->model_option_price_pro_options->updateProductOptionValues($that->request->get['product_id'], $that->request->get['option_id'], $that->request->post);
        }  elseif ($this->baseObject_method==='update_option') {
            $that->load->model('option_price_pro/options');
            $data['minimum']=$that->request->get['minimum'];
            $data['maximum']=$that->request->get['maximum'];
            $data['maximum_status']=$that->request->get['maximum_status'];
            $that->model_option_price_pro_options->updateProductOption( $that->request->get['option_id'], $that->request->get);
            $that->model_option_price_pro_options->addSettings($that->request->get['option_id'],$data);
        }
	}

    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $support = optionProVerifySupport();
                if ($support['notification_case'] === 'notification_license_ok') {
                    $that->load->language('option_price_pro/option_price_pro');
                    $getVersions = optionProUpdaterGetAllVersions();
                    $that->load->model('extension/option_price_pro_updater');
                    $current_version = $that->model_extension_option_price_pro_updater->getCurrentVersion();
                    if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                        $versions = $getVersions['notification_data']['product_versions'];
                        $total = $that->model_extension_option_price_pro_updater->getTotalMsgIds();
                        if ($total > '0') {
                            $msg_ids = $that->model_extension_option_price_pro_updater->getMsgIdsByCartVersions();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_option_price_pro_updater->deleteMsgID($msg_id['msg_id']);
                            }
                        }
                        if ($versions) {
                            $latestVersions=[];
                            foreach ($versions as $version) {
                                if (strpos($version['version_number'],VERSION)!==false) {
                                    $latestVersions[]=$version['version_number'];
                                }
                            }
                            usort($latestVersions,'version_compare');
                            $latestVersion=end($latestVersions);
                            if (version_compare($current_version, $latestVersion, '<') === true) {
                                $msg_ids = $that->model_extension_option_price_pro_updater->getMsgIdsByCurrentCartVersion();
                                foreach ($msg_ids as $msg_id) {
                                    $that->messages->deleteMessage($msg_id['msg_id']);
                                    $that->model_extension_option_price_pro_updater->deleteMsgID($msg_id['msg_id']);
                                }
                                $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_option_price_pro_version_title'));
                                $msg=str_replace('[version_number]',str_replace('.','-',$latestVersion),$that->language->get('text_new_option_price_pro_version_description'));
                                $that->messages->saveNotice($msg_title, $msg);
                                $msg_info = $that->messages->getLikeMessage($msg_title);
                                $that->model_extension_option_price_pro_updater->saveMessageId($msg_info['msg_id'],$latestVersion);
                            }
                        }
                    }
                }
            }
        }
    }
}