<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ModelExtensionEmailTemplates extends Model {

    public function getTemplates() {
        $sql = "SELECT * FROM " . $this->db->table('email_editor_templates');
        $result = $this->db->query($sql);
        return $result->rows;
    }

    /**
     * @param $filter
     * @param string $mode
     * @return array
     */
    public function getAllTemplates($filter, $mode = '') {
        if ($mode == 'total_only') {
            $sql = "SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates');
        } else {
            $sql = "SELECT * FROM " . $this->db->table('email_editor_templates'). " ORDER BY email_template_id ASC";
        }

        if (isset($filter['start']) || isset($filter['limit'])) {
            if ($filter['start'] < 0) {
                $filter['start'] = 0;
            }
            if ($filter['limit'] < 1) {
                $filter['limit'] = 20;
            }
            $sql .= $mode != 'total_only' ? " LIMIT " . (int)$filter['start'] . "," . (int)$filter['limit'] : '';
        }
        $result = $this->db->query($sql);
        $output = array();
        if ($mode == 'total_only') {
            $output = $result->row['total'];
        } else {
            foreach ($result->rows as $row) {
                if ($row['section']) {
                    $output[] = $row;
                } else {
                    $output[] = $this->getTemplate($row['email_template_id']);
                }
            }
        }
        return $output;
    }

    /**
     * @param $template_id
     * @param null $reset
     * @return mixed
     */
    public function getTemplate($template_id,$reset=Null) {
        $template_id = (int)$template_id;

        if ($reset===true) {
            $reset="UPDATE " . $this->db->table('email_editor_templates') . " SET subject=default_subject,content=default_content WHERE email_template_id=" . (int)$template_id;
            $this->db->query($reset);
        }

        $sql = "SELECT * FROM " . $this->db->table('email_editor_templates'). " WHERE email_template_id=" . (int)$template_id;
        $result = $this->db->query($sql);
        return $result->row;
    }

    public function updateTemplate($template_id,$data) {
        $fields=array(
            'sender_name',
            'sender_email',
            'subject',
            'content',
            'email_signature_id',
            'notify_admin'
        );

        $update=array();
        foreach ($fields as $f) {
            if (isset($data['email_signature']) && $f==='email_signature_id') {
                $update[] = "$f = '" . $this->db->escape($data['email_signature']) . "'";
            } elseif (isset($data[$f])) {
                $update[] = "$f = '" . $this->db->escape($data[$f]) . "'";
            }
        }

        if (!empty($update)) {
            return $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . " SET " . implode(',', $update) . " WHERE email_template_id = '" . (int)$template_id . "'");
        }
    }
}