<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelExtensionEmailOrder
 * @property ModelExtensionEmailTemplates $model_extension_email_templates
 * @property ModelExtensionShipperTrackingUrl $model_extension_shipper_tracking_url
 */

class ModelExtensionEmailOrder extends Model {

    public $data=array();

    /**
     * @param int   $order_id
     * @param array $data
     *
     * @throws AException
     */
    public function addOrderHistory($order_id, $data) {
        $this->load->model('extension/email_templates');
        $this->db->query("UPDATE `".$this->db->table("orders")."`
							SET order_status_id = '".(int)$data['order_status_id']."',
								date_modified = NOW()
							WHERE order_id = '".(int)$order_id."'");

        if ($data['append']) {
            $this->db->query("INSERT INTO ".$this->db->table("order_history")."
      		                    SET order_id = '".(int)$order_id."',
      		                        order_status_id = '".(int)$data['order_status_id']."',
      		                        notify = '".(isset($data['notify']) ? (int)$data['notify'] : 0)."',
      		                        comment = '".$this->db->escape($data['comment'])."',
      		                        date_added = NOW()");
        }

        /*
         * Send Email with merchant comment.
         * Note IM-notification not needed here.
         * */
        if ($data['notify']) {
            $order_query = $this->db->query("SELECT *, os.name AS status
        	                                FROM `".$this->db->table("orders")."` o
        	                                LEFT JOIN ".$this->db->table("order_statuses")." os ON (o.order_status_id = os.order_status_id AND os.language_id = o.language_id)
        	                                LEFT JOIN ".$this->db->table("languages")." l ON (o.language_id = l.language_id)
        	                                WHERE o.order_id = '".(int)$order_id."'");

            if ($order_query->num_rows) {
                //load language specific for the order in admin section
                $language = new ALanguage(Registry::getInstance(), $order_query->row['code'], 1);
                $language->load($order_query->row['filename']);
                $language->load('mail/order');

                $this->load->model('setting/store');

                $details=$this->getDetails('order_status_update');

                //send link to order only for registered customers
                $invoice_url='';
                if ($order_query->row['customer_id']) {
                    $invoice_url .= html_entity_decode($order_query->row['store_url'].'index.php?rt=account/invoice&order_id='.$order_id, ENT_QUOTES, 'UTF-8')."\n\n";
                } //give link on order page for quest
                elseif ($this->config->get('config_guest_checkout') && $order_query->row['email']) {
                    $enc = new AEncryption($this->config->get('encryption_key'));
                    $order_token = $enc->encrypt($order_id.'::'.$order_query->row['email']);
                    $invoice_url .= html_entity_decode($order_query->row['store_url'].'index.php?rt=account/invoice&ot='.$order_token, ENT_QUOTES, 'UTF-8')."\n\n";
                }
                $order_status=$order_query->row['status'];
                if ($this->dcrypt->active) {
                    $customer_email = $this->dcrypt->decrypt_field($order_query->row['email'], $order_query->row['key_id']);
                } else {
                    $customer_email = $order_query->row['email'];
                }

                $sender_name=$details['sender_name'] ? $details['sender_name']:$this->config->get('store_name');
                $sender_email=$details['sender_email'] ? $details['sender_email']:$this->config->get('store_main_email');
                $signature=html_entity_decode($details['signature']);

                $searchSubject=array('{store_name}','{order_id}');
                $replaceSubject=array($this->config->get('store_name'),$order_id);

                $subject = str_replace($searchSubject, $replaceSubject, $details['subject']);
                $logos = $this->dispatch('pages/extension/email_logo',array());
                $logo=$logos->dispatchGetOutput();

                $order_date=dateISO2Display($order_query->row['date_added'], $language->get('date_format_short'));
                $invoice_url='<a href="'.$invoice_url.'" target="_BLANK">'.$invoice_url.'</a>';

                $content=html_entity_decode($details['content']);
                preg_match("^\[(.*?)\]^",html_entity_decode($content),$fields);

                if ($data['comment']!=='') {
                    $searchComment=array($fields[0],'{order_comment}');
                    $replaceComment=array(
                        $fields[1],
                        $data['comment']);
                    $content=str_replace($searchComment,$replaceComment,$content);
                } else {
                    $searchComment=array('<br /><br />'.$fields[0].'<br /><br />','{order_comment}');
                    $replaceComment=array('','');
                    $content=str_replace($searchComment,$replaceComment,$content);
                }

                $search=array('{order_id}','{order_date}','{order_status}','{invoice_url}');
                $replace=array($order_id,$order_date,$order_status,$invoice_url);
                $content=html_entity_decode(str_replace($search,$replace,$content));
                $notify_admin=$details['notify_admin'];
                //build HTML message with the template

                $this->data['mail_template_data']['logo']=html_entity_decode($logo);
                $this->data['mail_template_data']['content']=$content;
                $this->data['mail_template_data']['signature']=$signature;
                $this->data['mail_template'] = DIR_EXT.'email_editor'.DIR_EXT_CORE.'lib/order_update.tpl';

                $view = new AView($this->registry, 0);
                $view->batchAssign($this->data['mail_template_data']);
                $html_body = $view->fetch($this->data['mail_template']);
                $config_mail_logo = $this->config->get('config_mail_logo');
                $config_mail_logo = !$config_mail_logo ? $this->config->get('config_logo') : $config_mail_logo;
                $this->_send_email($customer_email,
                    array(
                        'subject'          => $subject,
                        'sender_email'     => $sender_email,
                        'sender_name'      => $sender_name,
                        'html_body'        => $html_body,
                        'config_mail_logo' => $config_mail_logo,
                        'notify_admin'     => $notify_admin
                    )
                );

                //send IMs except emails.
                //TODO: add notifications for guest checkout
                $language->load('common/im');
                $invoice_url = $order_query->row['store_url'].'index.php?rt=account/invoice&order_id='.$order_id;
                //disable email protocol to prevent duplicates emails
                $this->im->removeProtocol('email');

                if ($order_query->row['customer_id']) {
                    $message_arr = array(
                        0 => array(
                            'message' => sprintf($language->get('im_order_update_text_to_customer'),
                                $invoice_url,
                                $order_id,
                                html_entity_decode($order_query->row['store_url'].'index.php?rt=account/account')),
                        ),
                    );
                    $this->im->sendToCustomer($order_query->row['customer_id'], 'order_update', $message_arr);
                } else {
                    $message_arr = array(
                        0 => array(
                            'message' => sprintf($language->get('im_order_update_text_to_guest'),
                                $invoice_url,
                                $order_id,
                                html_entity_decode($invoice_url)),
                        ),
                    );
                    $this->im->sendToGuest($order_id, $message_arr);
                }
                //turn email-protocol back
                $this->im->addProtocol('email');
            }
        }
    }

    /**
     * @param array $data
     *
     * @return bool|int
     * @throws AException
     */
    public function addCustomerTransaction($data = array()) {
        if ((!(float)$data['credit'] && !(float)$data['debit']) || !(int)$data['customer_id']) {
            return false;
        }
        $sql = "INSERT INTO ".$this->db->table("customer_transactions")."
                    (`customer_id`,`order_id`,`created_by`,`credit`,`debit`,`section`, `transaction_type`,`comment`,`description`,`date_added`)
                VALUES (
                        '".(int)$data['customer_id']."',
                        '".(int)$data['order_id']."',
                        '".$this->user->getId()."',
                        '".(float)$data['credit']."',
                        '".(float)$data['debit']."',
                        '1',
                        '".$this->db->escape($data['transaction_type'])."',
                        '".$this->db->escape($data['comment'])."',
                        '".$this->db->escape($data['description'])."',
                        NOW()
                        )";
        $this->db->query($sql);
        $transaction_id = $this->db->getLastId();

        if ($data['notify']) {

            $this->load->model('sale/customer');
            $customer_info = $this->model_sale_customer->getCustomer($data['customer_id']);

            if ($customer_info) {
                //detect customer's language
                $sql = "SELECT language_id
                        FROM ".$this->db->table('orders')."
                        WHERE customer_id = '".(int)$data['customer_id']."'
                        ORDER BY date_added DESC";
                $result = $this->db->query($sql);
                $language_code = '';
                if ($result->row['language_id']) {
                    $lang = $this->language->getLanguageDetailsByID($result->row['language_id']);
                    $language_code = $lang['code'];
                }

                if (!$language_code) {
                    $language_code = $this->language->getDefaultLanguageCode();
                }

                //load language specific for the order in admin section
                $language = new ALanguage(Registry::getInstance(), $language_code, 1);
                $language->load('sale/customer');

                $this->load->model('setting/store');

                $store_info = $this->model_setting_store->getStore((int)$this->session->data['current_store_id']);

                $details=$this->getDetails('customer_transaction');
                $sender_name=$details['sender_name'] ? $details['sender_name']:$this->config->get('store_name');
                $sender_email=$details['sender_email'] ? $details['sender_email']:$this->config->get('store_main_email');
                $signature=html_entity_decode($details['signature']);

                $store_name=$this->config->get('store_name');

                $subject = str_replace('{store_name}', $store_name, $details['subject']);
                $logos = $this->dispatch('pages/extension/email_logo',array());
                $logo=$logos->dispatchGetOutput();

                $url = html_entity_decode($store_info['config_url'].'index.php?rt=account/transactions', ENT_QUOTES, 'UTF-8');
                $url='<a href="'.$url.'" target="_BLANK">'.$url.'</a>';
                $amount = $this->currency->format($data['credit'] - $data['debit']);

                $content=html_entity_decode($details['content']);
                if ($data['description']) {
                    $content=str_replace('{comment}',$data['description'],$content);
                } else {
                    $content=str_replace('<br /><br />{comment}','',$content);
                }

                $search=array('{store_name}','{amount}','{transaction_url}','{comment}');
                $comment=$data['description'] ? $data['description'] : '';
                $replace=array($store_name,$amount,$url,$comment);
                $content=str_replace($search,$replace,$content);
                $notify_admin=$details['notify_admin'];
                //build HTML message with the template

                $this->data['mail_template_data']['logo']=html_entity_decode($logo);
                $this->data['mail_template_data']['content']=$content;
                $this->data['mail_template_data']['signature']=$signature;
                $this->data['mail_template'] = DIR_EXT.'email_editor'.DIR_EXT_CORE.'lib/customer_transactions.tpl';

                $view = new AView($this->registry, 0);
                $view->batchAssign($this->data['mail_template_data']);
                $html_body = $view->fetch($this->data['mail_template']);
                $config_mail_logo = $this->config->get('config_mail_logo');
                $config_mail_logo = !$config_mail_logo ? $this->config->get('config_logo') : $config_mail_logo;
                $this->_send_email($customer_info['email'],
                    array(
                        'subject'          => $subject,
                        'sender_email'     => $sender_email,
                        'sender_name'      => $sender_name,
                        'html_body'        => $html_body,
                        'config_mail_logo' => $config_mail_logo,
                        'notify_admin'     => $notify_admin
                    )
                );

                //notify customer
                //$language->load('common/im');
                //$message_arr = array(
                //    0 => array('message' => sprintf($language->get('im_customer_account_update_text_to_customer'), $store_info['store_name'], $amount, $store_info['store_name'])),
                //);
                //$this->im->sendToCustomer($data['customer_id'], 'customer_account_update', $message_arr);
            }
        }

        return $transaction_id;
    }

    public function sendActivatedEmail($customer_id) {
        $customer_info = $this->getCustomer($customer_id);
        if ($customer_info && !$customer_info['approved']) {
            //build welcome email in text format
            $login_url = $this->html->getSecureURL('account/login');
            $this->load->language('mail/customer');

            $details = $this->getDetails('account_activated');

            $sender_name = $details['sender_name'] ? $details['sender_name'] : $this->config->get('store_name');
            $sender_email = $details['sender_email'] ? $details['sender_email'] : $this->config->get('store_main_email');
            $signature = html_entity_decode($details['signature']);

            $subject = str_replace('{store_name}', $this->config->get('store_name'), $details['subject']);
            $search = array('{store_name}', '{login_url}');
            $login_url = '<a href="' . $login_url . '" target="_BLANK">' . $login_url . '</a>';
            $replace = array($this->config->get('store_name'), $login_url);
            $content = html_entity_decode(str_replace($search, $replace, $details['content']));

            $notify_admin = $details['notify_admin'];
            $logos = $this->dispatch('pages/extension/email_logo', array());
            $logo = $logos->dispatchGetOutput();

            $this->data['mail_template_data']['logo'] = html_entity_decode($logo);
            $this->data['mail_template_data']['content'] = $content;
            $this->data['mail_template_data']['signature'] = $signature;

            $this->data['mail_template'] = DIR_EXT . 'email_editor' . DIR_EXT_CORE . 'lib/account_create.tpl';

            //allow to change email data from extensions
            $this->extensions->hk_ProcessData($this, 'sf_account_welcome_mail');

            $view = new AView($this->registry, 0);
            $view->batchAssign($this->data['mail_template_data']);
            $html_body = $view->fetch($this->data['mail_template']);
            $config_mail_logo = $this->config->get('config_mail_logo');
            $this->_send_email($customer_info['email'], array(
                    'subject' => $subject,
                    'sender_email' => $sender_email,
                    'sender_name' => $sender_name,
                    'txt_body' => $this->data['mail_plain_text'],
                    'html_body' => $html_body,
                    'config_mail_logo' => $config_mail_logo,
                    'notify_admin' => $notify_admin
                )
            );

            return true;
        }
    }

    /**
     * @param int $customer_id - customer_id
     *
     * @throws AException
     */
    public function sendApproveMail($customer_id) {

        // send email to customer
        $customer_info = $this->getCustomer($customer_id);
        if ($customer_info && !$customer_info['approved']) {
            $this->load->language('mail/customer');
            $this->load->model('setting/store');
            $login_url = $this->html->getSecureURL('account/login');
            $details = $this->getDetails('account_approved');
            $sender_name = $details['sender_name'] ? $details['sender_name'] : $this->config->get('store_name');
            $sender_email = $details['sender_email'] ? $details['sender_email'] : $this->config->get('store_main_email');
            $signature = html_entity_decode($details['signature']);

            $subject = str_replace('{store_name}', $this->config->get('store_name'), $details['subject']);
            $search = array('{store_name}', '{login_url}');
            $replace = array($this->config->get('store_name'), $login_url);
            $content = html_entity_decode(str_replace($search, $replace, $details['content']));

            $notify_admin = $details['notify_admin'];
            $logos = $this->dispatch('pages/extension/email_logo', array());
            $logo = $logos->dispatchGetOutput();

            $this->data['mail_template_data']['logo'] = html_entity_decode($logo);
            $this->data['mail_template_data']['content'] = $content;
            $this->data['mail_template_data']['signature'] = $signature;

            $this->data['mail_template'] = DIR_EXT . 'email_editor' . DIR_EXT_CORE . 'lib/account_approved.tpl';

            $view = new AView($this->registry, 0);
            $view->batchAssign($this->data['mail_template_data']);
            $html_body = $view->fetch($this->data['mail_template']);
            $config_mail_logo = $this->config->get('config_mail_logo');
            $config_mail_logo = !$config_mail_logo ? $this->config->get('config_logo') : $config_mail_logo;
            $this->_send_email($customer_info['email'], array(
                    'subject' => $subject,
                    'sender_email' => $sender_email,
                    'sender_name' => $sender_name,
                    'txt_body' => $this->data['mail_plain_text'],
                    'html_body' => $html_body,
                    'config_mail_logo' => $config_mail_logo,
                    'notify_admin' => $notify_admin
                )
            );
        }
    }


    /**
     * @param int $customer_id
     *
     * @return array
     */
    public function getCustomer($customer_id) {
        $query = $this->db->query("SELECT DISTINCT *,
									(SELECT COUNT(order_id)
										FROM ".$this->db->table("orders")."
										WHERE customer_id = '".(int)$customer_id."'
												AND order_status_id>0) as orders_count
								   FROM ".$this->db->table("customers")."
								   WHERE customer_id = '".(int)$customer_id."'");

        $result_row = $this->dcrypt->decrypt_data($query->row, 'customers');
        return $result_row;
    }

    protected function _send_email($email, $data) {
        $mail = new AMail($this->config);
        $mail->setTo($email);
        $mail->setFrom($data['sender_email']);
        $mail->setSender($data['sender_name']);
        $mail->setSubject($data['subject']);
        $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

        if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
            $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
        }
        $mail->setHtml($data['html_body']);
        $mail->send();

        if ($data['notify_admin']==='1') {
            $mail = new AMail($this->config);
            $mail->setTo($this->config->get('store_main_email'));
            $mail->setFrom($data['sender_email']);
            $mail->setSender($data['sender_name']);
            $mail->setSubject('(Copy) '.$data['subject']);
            $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

            if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
                $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                    md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                    .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
            }
            $mail->setHtml($data['html_body']);
            $mail->send();
        }
    }

    public function getDetails($section) {
        $sql="SELECT mail.sender_name,mail.sender_email,mail.subject,mail.content, sigs.content as signature,notify_admin
              FROM ". $this->db->table('email_editor_templates') . " mail 
              LEFT JOIN ". $this->db->table('email_editor_signatures') . " sigs on sigs.email_signature_id=mail.email_signature_id
              WHERE mail.section='".$section."'";
        $result=$this->db->query($sql);
        return $result->row;
    }

    protected function dispatch($dispatch_rt, $args = array('')) {
        return new ADispatcher($dispatch_rt, $args);
    }
}