<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerPagesExtensionEmailLogo extends AController {
    public $data=array();

    public function main() {
        $config_mail_logo = $this->config->get('config_mail_logo');
        $config_mail_logo = !$config_mail_logo ? $this->config->get('config_logo') : $config_mail_logo;
        $logo_html=$logo_uri='';
        if ($config_mail_logo) {
            if (is_numeric($config_mail_logo)) {
                $r = new AResource('image');
                $resource_info = $r->getResource($config_mail_logo);
                if ($resource_info) {
                    $logo_html = html_entity_decode($resource_info['resource_code'], ENT_QUOTES, 'UTF-8');
                }
            } else {
                $logo_uri = 'cid:'
                    .md5(pathinfo($config_mail_logo, PATHINFO_FILENAME))
                    .'.'.pathinfo($config_mail_logo, PATHINFO_EXTENSION);
            }
        }
        $this->data['store_url']=$this->config->get('config_url');
        $this->data['store_name']=$this->config->get('store_name');
        if ($logo_uri) {
            $this->data['logo_uri'] = $logo_uri;
        } elseif($logo_html){
            $this->data['logo_html'] = $logo_html;
        }
        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/extension/email_logo.tpl');
    }
}