<?php
/**
 * ShipmentRequestShipment
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * ShipmentRequestShipment Class Doc Comment
 *
 * @category Class
 * @description Shipment Container
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipmentRequestShipment implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ShipmentRequest_Shipment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'description' => 'string',
        'return_service' => '\UPS\Shipping\Shipping\ShipmentReturnService',
        'documents_only_indicator' => 'string',
        'shipper' => '\UPS\Shipping\Shipping\ShipmentShipper',
        'ship_to' => '\UPS\Shipping\Shipping\ShipmentShipTo',
        'alternate_delivery_address' => '\UPS\Shipping\Shipping\ShipmentAlternateDeliveryAddress',
        'ship_from' => '\UPS\Shipping\Shipping\ShipmentShipFrom',
        'payment_information' => '\UPS\Shipping\Shipping\ShipmentPaymentInformation',
        'frs_payment_information' => '\UPS\Shipping\Shipping\ShipmentFRSPaymentInformation',
        'freight_shipment_information' => '\UPS\Shipping\Shipping\ShipmentFreightShipmentInformation',
        'goods_not_in_free_circulation_indicator' => 'string',
        'promotional_discount_information' => '\UPS\Shipping\Shipping\ShipmentPromotionalDiscountInformation',
        'dg_signatory_info' => '\UPS\Shipping\Shipping\ShipmentDGSignatoryInfo',
        'shipment_rating_options' => '\UPS\Shipping\Shipping\ShipmentShipmentRatingOptions',
        'movement_reference_number' => 'string',
        'reference_number' => '\UPS\Shipping\Shipping\ShipmentReferenceNumber[]',
        'service' => '\UPS\Shipping\Shipping\ShipmentService',
        'invoice_line_total' => '\UPS\Shipping\Shipping\ShipmentInvoiceLineTotal',
        'num_of_pieces_in_shipment' => 'string',
        'usps_endorsement' => 'string',
        'mi_label_cn22_indicator' => 'string',
        'sub_classification' => 'string',
        'cost_center' => 'string',
        'cost_center_barcode_indicator' => 'string',
        'package_id' => 'string',
        'package_id_barcode_indicator' => 'string',
        'irregular_indicator' => 'string',
        'shipment_indication_type' => '\UPS\Shipping\Shipping\ShipmentShipmentIndicationType[]',
        'mi_dual_return_shipment_key' => 'string',
        'mi_dual_return_shipment_indicator' => 'string',
        'rating_method_requested_indicator' => 'string',
        'tax_information_indicator' => 'string',
        'shipment_service_options' => '\UPS\Shipping\Shipping\ShipmentShipmentServiceOptions',
        'locale' => 'string',
        'shipment_value_threshold_code' => 'string',
        'master_carton_id' => 'string',
        'master_carton_indicator' => 'string',
        'shipment_date' => 'string',
        'package' => '\UPS\Shipping\Shipping\ShipmentPackage[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'description' => null,
        'return_service' => null,
        'documents_only_indicator' => null,
        'shipper' => null,
        'ship_to' => null,
        'alternate_delivery_address' => null,
        'ship_from' => null,
        'payment_information' => null,
        'frs_payment_information' => null,
        'freight_shipment_information' => null,
        'goods_not_in_free_circulation_indicator' => null,
        'promotional_discount_information' => null,
        'dg_signatory_info' => null,
        'shipment_rating_options' => null,
        'movement_reference_number' => null,
        'reference_number' => null,
        'service' => null,
        'invoice_line_total' => null,
        'num_of_pieces_in_shipment' => null,
        'usps_endorsement' => null,
        'mi_label_cn22_indicator' => null,
        'sub_classification' => null,
        'cost_center' => null,
        'cost_center_barcode_indicator' => null,
        'package_id' => null,
        'package_id_barcode_indicator' => null,
        'irregular_indicator' => null,
        'shipment_indication_type' => null,
        'mi_dual_return_shipment_key' => null,
        'mi_dual_return_shipment_indicator' => null,
        'rating_method_requested_indicator' => null,
        'tax_information_indicator' => null,
        'shipment_service_options' => null,
        'locale' => null,
        'shipment_value_threshold_code' => null,
        'master_carton_id' => null,
        'master_carton_indicator' => null,
        'shipment_date' => null,
        'package' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'description' => 'Description',
        'return_service' => 'ReturnService',
        'documents_only_indicator' => 'DocumentsOnlyIndicator',
        'shipper' => 'Shipper',
        'ship_to' => 'ShipTo',
        'alternate_delivery_address' => 'AlternateDeliveryAddress',
        'ship_from' => 'ShipFrom',
        'payment_information' => 'PaymentInformation',
        'frs_payment_information' => 'FRSPaymentInformation',
        'freight_shipment_information' => 'FreightShipmentInformation',
        'goods_not_in_free_circulation_indicator' => 'GoodsNotInFreeCirculationIndicator',
        'promotional_discount_information' => 'PromotionalDiscountInformation',
        'dg_signatory_info' => 'DGSignatoryInfo',
        'shipment_rating_options' => 'ShipmentRatingOptions',
        'movement_reference_number' => 'MovementReferenceNumber',
        'reference_number' => 'ReferenceNumber',
        'service' => 'Service',
        'invoice_line_total' => 'InvoiceLineTotal',
        'num_of_pieces_in_shipment' => 'NumOfPiecesInShipment',
        'usps_endorsement' => 'USPSEndorsement',
        'mi_label_cn22_indicator' => 'MILabelCN22Indicator',
        'sub_classification' => 'SubClassification',
        'cost_center' => 'CostCenter',
        'cost_center_barcode_indicator' => 'CostCenterBarcodeIndicator',
        'package_id' => 'PackageID',
        'package_id_barcode_indicator' => 'PackageIDBarcodeIndicator',
        'irregular_indicator' => 'IrregularIndicator',
        'shipment_indication_type' => 'ShipmentIndicationType',
        'mi_dual_return_shipment_key' => 'MIDualReturnShipmentKey',
        'mi_dual_return_shipment_indicator' => 'MIDualReturnShipmentIndicator',
        'rating_method_requested_indicator' => 'RatingMethodRequestedIndicator',
        'tax_information_indicator' => 'TaxInformationIndicator',
        'shipment_service_options' => 'ShipmentServiceOptions',
        'locale' => 'Locale',
        'shipment_value_threshold_code' => 'ShipmentValueThresholdCode',
        'master_carton_id' => 'MasterCartonID',
        'master_carton_indicator' => 'MasterCartonIndicator',
        'shipment_date' => 'ShipmentDate',
        'package' => 'Package'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'description' => 'setDescription',
        'return_service' => 'setReturnService',
        'documents_only_indicator' => 'setDocumentsOnlyIndicator',
        'shipper' => 'setShipper',
        'ship_to' => 'setShipTo',
        'alternate_delivery_address' => 'setAlternateDeliveryAddress',
        'ship_from' => 'setShipFrom',
        'payment_information' => 'setPaymentInformation',
        'frs_payment_information' => 'setFrsPaymentInformation',
        'freight_shipment_information' => 'setFreightShipmentInformation',
        'goods_not_in_free_circulation_indicator' => 'setGoodsNotInFreeCirculationIndicator',
        'promotional_discount_information' => 'setPromotionalDiscountInformation',
        'dg_signatory_info' => 'setDgSignatoryInfo',
        'shipment_rating_options' => 'setShipmentRatingOptions',
        'movement_reference_number' => 'setMovementReferenceNumber',
        'reference_number' => 'setReferenceNumber',
        'service' => 'setService',
        'invoice_line_total' => 'setInvoiceLineTotal',
        'num_of_pieces_in_shipment' => 'setNumOfPiecesInShipment',
        'usps_endorsement' => 'setUspsEndorsement',
        'mi_label_cn22_indicator' => 'setMiLabelCn22Indicator',
        'sub_classification' => 'setSubClassification',
        'cost_center' => 'setCostCenter',
        'cost_center_barcode_indicator' => 'setCostCenterBarcodeIndicator',
        'package_id' => 'setPackageId',
        'package_id_barcode_indicator' => 'setPackageIdBarcodeIndicator',
        'irregular_indicator' => 'setIrregularIndicator',
        'shipment_indication_type' => 'setShipmentIndicationType',
        'mi_dual_return_shipment_key' => 'setMiDualReturnShipmentKey',
        'mi_dual_return_shipment_indicator' => 'setMiDualReturnShipmentIndicator',
        'rating_method_requested_indicator' => 'setRatingMethodRequestedIndicator',
        'tax_information_indicator' => 'setTaxInformationIndicator',
        'shipment_service_options' => 'setShipmentServiceOptions',
        'locale' => 'setLocale',
        'shipment_value_threshold_code' => 'setShipmentValueThresholdCode',
        'master_carton_id' => 'setMasterCartonId',
        'master_carton_indicator' => 'setMasterCartonIndicator',
        'shipment_date' => 'setShipmentDate',
        'package' => 'setPackage'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'description' => 'getDescription',
        'return_service' => 'getReturnService',
        'documents_only_indicator' => 'getDocumentsOnlyIndicator',
        'shipper' => 'getShipper',
        'ship_to' => 'getShipTo',
        'alternate_delivery_address' => 'getAlternateDeliveryAddress',
        'ship_from' => 'getShipFrom',
        'payment_information' => 'getPaymentInformation',
        'frs_payment_information' => 'getFrsPaymentInformation',
        'freight_shipment_information' => 'getFreightShipmentInformation',
        'goods_not_in_free_circulation_indicator' => 'getGoodsNotInFreeCirculationIndicator',
        'promotional_discount_information' => 'getPromotionalDiscountInformation',
        'dg_signatory_info' => 'getDgSignatoryInfo',
        'shipment_rating_options' => 'getShipmentRatingOptions',
        'movement_reference_number' => 'getMovementReferenceNumber',
        'reference_number' => 'getReferenceNumber',
        'service' => 'getService',
        'invoice_line_total' => 'getInvoiceLineTotal',
        'num_of_pieces_in_shipment' => 'getNumOfPiecesInShipment',
        'usps_endorsement' => 'getUspsEndorsement',
        'mi_label_cn22_indicator' => 'getMiLabelCn22Indicator',
        'sub_classification' => 'getSubClassification',
        'cost_center' => 'getCostCenter',
        'cost_center_barcode_indicator' => 'getCostCenterBarcodeIndicator',
        'package_id' => 'getPackageId',
        'package_id_barcode_indicator' => 'getPackageIdBarcodeIndicator',
        'irregular_indicator' => 'getIrregularIndicator',
        'shipment_indication_type' => 'getShipmentIndicationType',
        'mi_dual_return_shipment_key' => 'getMiDualReturnShipmentKey',
        'mi_dual_return_shipment_indicator' => 'getMiDualReturnShipmentIndicator',
        'rating_method_requested_indicator' => 'getRatingMethodRequestedIndicator',
        'tax_information_indicator' => 'getTaxInformationIndicator',
        'shipment_service_options' => 'getShipmentServiceOptions',
        'locale' => 'getLocale',
        'shipment_value_threshold_code' => 'getShipmentValueThresholdCode',
        'master_carton_id' => 'getMasterCartonId',
        'master_carton_indicator' => 'getMasterCartonIndicator',
        'shipment_date' => 'getShipmentDate',
        'package' => 'getPackage'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['return_service'] = isset($data['return_service']) ? $data['return_service'] : null;
        $this->container['documents_only_indicator'] = isset($data['documents_only_indicator']) ? $data['documents_only_indicator'] : null;
        $this->container['shipper'] = isset($data['shipper']) ? $data['shipper'] : null;
        $this->container['ship_to'] = isset($data['ship_to']) ? $data['ship_to'] : null;
        $this->container['alternate_delivery_address'] = isset($data['alternate_delivery_address']) ? $data['alternate_delivery_address'] : null;
        $this->container['ship_from'] = isset($data['ship_from']) ? $data['ship_from'] : null;
        $this->container['payment_information'] = isset($data['payment_information']) ? $data['payment_information'] : null;
        $this->container['frs_payment_information'] = isset($data['frs_payment_information']) ? $data['frs_payment_information'] : null;
        $this->container['freight_shipment_information'] = isset($data['freight_shipment_information']) ? $data['freight_shipment_information'] : null;
        $this->container['goods_not_in_free_circulation_indicator'] = isset($data['goods_not_in_free_circulation_indicator']) ? $data['goods_not_in_free_circulation_indicator'] : null;
        $this->container['promotional_discount_information'] = isset($data['promotional_discount_information']) ? $data['promotional_discount_information'] : null;
        $this->container['dg_signatory_info'] = isset($data['dg_signatory_info']) ? $data['dg_signatory_info'] : null;
        $this->container['shipment_rating_options'] = isset($data['shipment_rating_options']) ? $data['shipment_rating_options'] : null;
        $this->container['movement_reference_number'] = isset($data['movement_reference_number']) ? $data['movement_reference_number'] : null;
        $this->container['reference_number'] = isset($data['reference_number']) ? $data['reference_number'] : null;
        $this->container['service'] = isset($data['service']) ? $data['service'] : null;
        $this->container['invoice_line_total'] = isset($data['invoice_line_total']) ? $data['invoice_line_total'] : null;
        $this->container['num_of_pieces_in_shipment'] = isset($data['num_of_pieces_in_shipment']) ? $data['num_of_pieces_in_shipment'] : null;
        $this->container['usps_endorsement'] = isset($data['usps_endorsement']) ? $data['usps_endorsement'] : null;
        $this->container['mi_label_cn22_indicator'] = isset($data['mi_label_cn22_indicator']) ? $data['mi_label_cn22_indicator'] : null;
        $this->container['sub_classification'] = isset($data['sub_classification']) ? $data['sub_classification'] : null;
        $this->container['cost_center'] = isset($data['cost_center']) ? $data['cost_center'] : null;
        $this->container['cost_center_barcode_indicator'] = isset($data['cost_center_barcode_indicator']) ? $data['cost_center_barcode_indicator'] : null;
        $this->container['package_id'] = isset($data['package_id']) ? $data['package_id'] : null;
        $this->container['package_id_barcode_indicator'] = isset($data['package_id_barcode_indicator']) ? $data['package_id_barcode_indicator'] : null;
        $this->container['irregular_indicator'] = isset($data['irregular_indicator']) ? $data['irregular_indicator'] : null;
        $this->container['shipment_indication_type'] = isset($data['shipment_indication_type']) ? $data['shipment_indication_type'] : null;
        $this->container['mi_dual_return_shipment_key'] = isset($data['mi_dual_return_shipment_key']) ? $data['mi_dual_return_shipment_key'] : null;
        $this->container['mi_dual_return_shipment_indicator'] = isset($data['mi_dual_return_shipment_indicator']) ? $data['mi_dual_return_shipment_indicator'] : null;
        $this->container['rating_method_requested_indicator'] = isset($data['rating_method_requested_indicator']) ? $data['rating_method_requested_indicator'] : null;
        $this->container['tax_information_indicator'] = isset($data['tax_information_indicator']) ? $data['tax_information_indicator'] : null;
        $this->container['shipment_service_options'] = isset($data['shipment_service_options']) ? $data['shipment_service_options'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['shipment_value_threshold_code'] = isset($data['shipment_value_threshold_code']) ? $data['shipment_value_threshold_code'] : null;
        $this->container['master_carton_id'] = isset($data['master_carton_id']) ? $data['master_carton_id'] : null;
        $this->container['master_carton_indicator'] = isset($data['master_carton_indicator']) ? $data['master_carton_indicator'] : null;
        $this->container['shipment_date'] = isset($data['shipment_date']) ? $data['shipment_date'] : null;
        $this->container['package'] = isset($data['package']) ? $data['package'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['shipper'] === null) {
            $invalidProperties[] = "'shipper' can't be null";
        }
        if ($this->container['ship_to'] === null) {
            $invalidProperties[] = "'ship_to' can't be null";
        }
        if ($this->container['service'] === null) {
            $invalidProperties[] = "'service' can't be null";
        }
        if ($this->container['package'] === null) {
            $invalidProperties[] = "'package' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description The Description of Goods for the shipment. Applies to international and domestic shipments.   Provide a detailed description of items being shipped for documents and non-documents.   Examples: \"annual reports\" and \"9 mm steel screws\".  Required if all of the listed conditions are true:  ShipFrom and ShipTo countries or territories are not the same; The packaging type is not UPS Letter; The ShipFrom and or ShipTo countries or territories are not in the European Union or the ShipFrom and ShipTo countries or territories are both in the European Union and the shipments service type is not UPS Standard.
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets return_service
     *
     * @return \UPS\Shipping\Shipping\ShipmentReturnService
     */
    public function getReturnService()
    {
        return $this->container['return_service'];
    }

    /**
     * Sets return_service
     *
     * @param \UPS\Shipping\Shipping\ShipmentReturnService $return_service return_service
     *
     * @return $this
     */
    public function setReturnService($return_service)
    {
        $this->container['return_service'] = $return_service;

        return $this;
    }

    /**
     * Gets documents_only_indicator
     *
     * @return string
     */
    public function getDocumentsOnlyIndicator()
    {
        return $this->container['documents_only_indicator'];
    }

    /**
     * Sets documents_only_indicator
     *
     * @param string $documents_only_indicator Indicates a shipment contains written, typed, or printed communication of no commercial value.   If DocumentsOnly is not specified then it implies that the shipment contains non documents or documents of commercial value.   Default is a shipment contains non- documents or documents of commercial value.  This is an empty tag, any value inside is ignored.   Valid only for shipments with different origin and destination countries or territories. The origin country or territory is not US, and the destination country or territory is not CA, PR or MX.
     *
     * @return $this
     */
    public function setDocumentsOnlyIndicator($documents_only_indicator)
    {
        $this->container['documents_only_indicator'] = $documents_only_indicator;

        return $this;
    }

    /**
     * Gets shipper
     *
     * @return \UPS\Shipping\Shipping\ShipmentShipper
     */
    public function getShipper()
    {
        return $this->container['shipper'];
    }

    /**
     * Sets shipper
     *
     * @param \UPS\Shipping\Shipping\ShipmentShipper $shipper shipper
     *
     * @return $this
     */
    public function setShipper($shipper)
    {
        $this->container['shipper'] = $shipper;

        return $this;
    }

    /**
     * Gets ship_to
     *
     * @return \UPS\Shipping\Shipping\ShipmentShipTo
     */
    public function getShipTo()
    {
        return $this->container['ship_to'];
    }

    /**
     * Sets ship_to
     *
     * @param \UPS\Shipping\Shipping\ShipmentShipTo $ship_to ship_to
     *
     * @return $this
     */
    public function setShipTo($ship_to)
    {
        $this->container['ship_to'] = $ship_to;

        return $this;
    }

    /**
     * Gets alternate_delivery_address
     *
     * @return \UPS\Shipping\Shipping\ShipmentAlternateDeliveryAddress
     */
    public function getAlternateDeliveryAddress()
    {
        return $this->container['alternate_delivery_address'];
    }

    /**
     * Sets alternate_delivery_address
     *
     * @param \UPS\Shipping\Shipping\ShipmentAlternateDeliveryAddress $alternate_delivery_address alternate_delivery_address
     *
     * @return $this
     */
    public function setAlternateDeliveryAddress($alternate_delivery_address)
    {
        $this->container['alternate_delivery_address'] = $alternate_delivery_address;

        return $this;
    }

    /**
     * Gets ship_from
     *
     * @return \UPS\Shipping\Shipping\ShipmentShipFrom
     */
    public function getShipFrom()
    {
        return $this->container['ship_from'];
    }

    /**
     * Sets ship_from
     *
     * @param \UPS\Shipping\Shipping\ShipmentShipFrom $ship_from ship_from
     *
     * @return $this
     */
    public function setShipFrom($ship_from)
    {
        $this->container['ship_from'] = $ship_from;

        return $this;
    }

    /**
     * Gets payment_information
     *
     * @return \UPS\Shipping\Shipping\ShipmentPaymentInformation
     */
    public function getPaymentInformation()
    {
        return $this->container['payment_information'];
    }

    /**
     * Sets payment_information
     *
     * @param \UPS\Shipping\Shipping\ShipmentPaymentInformation $payment_information payment_information
     *
     * @return $this
     */
    public function setPaymentInformation($payment_information)
    {
        $this->container['payment_information'] = $payment_information;

        return $this;
    }

    /**
     * Gets frs_payment_information
     *
     * @return \UPS\Shipping\Shipping\ShipmentFRSPaymentInformation
     */
    public function getFrsPaymentInformation()
    {
        return $this->container['frs_payment_information'];
    }

    /**
     * Sets frs_payment_information
     *
     * @param \UPS\Shipping\Shipping\ShipmentFRSPaymentInformation $frs_payment_information frs_payment_information
     *
     * @return $this
     */
    public function setFrsPaymentInformation($frs_payment_information)
    {
        $this->container['frs_payment_information'] = $frs_payment_information;

        return $this;
    }

    /**
     * Gets freight_shipment_information
     *
     * @return \UPS\Shipping\Shipping\ShipmentFreightShipmentInformation
     */
    public function getFreightShipmentInformation()
    {
        return $this->container['freight_shipment_information'];
    }

    /**
     * Sets freight_shipment_information
     *
     * @param \UPS\Shipping\Shipping\ShipmentFreightShipmentInformation $freight_shipment_information freight_shipment_information
     *
     * @return $this
     */
    public function setFreightShipmentInformation($freight_shipment_information)
    {
        $this->container['freight_shipment_information'] = $freight_shipment_information;

        return $this;
    }

    /**
     * Gets goods_not_in_free_circulation_indicator
     *
     * @return string
     */
    public function getGoodsNotInFreeCirculationIndicator()
    {
        return $this->container['goods_not_in_free_circulation_indicator'];
    }

    /**
     * Sets goods_not_in_free_circulation_indicator
     *
     * @param string $goods_not_in_free_circulation_indicator Goods Not In Free Circulation indicator.  This is an empty tag, any value inside is ignored. This indicator is invalid for a package type of UPS Letter and DocumentsOnly.
     *
     * @return $this
     */
    public function setGoodsNotInFreeCirculationIndicator($goods_not_in_free_circulation_indicator)
    {
        $this->container['goods_not_in_free_circulation_indicator'] = $goods_not_in_free_circulation_indicator;

        return $this;
    }

    /**
     * Gets promotional_discount_information
     *
     * @return \UPS\Shipping\Shipping\ShipmentPromotionalDiscountInformation
     */
    public function getPromotionalDiscountInformation()
    {
        return $this->container['promotional_discount_information'];
    }

    /**
     * Sets promotional_discount_information
     *
     * @param \UPS\Shipping\Shipping\ShipmentPromotionalDiscountInformation $promotional_discount_information promotional_discount_information
     *
     * @return $this
     */
    public function setPromotionalDiscountInformation($promotional_discount_information)
    {
        $this->container['promotional_discount_information'] = $promotional_discount_information;

        return $this;
    }

    /**
     * Gets dg_signatory_info
     *
     * @return \UPS\Shipping\Shipping\ShipmentDGSignatoryInfo
     */
    public function getDgSignatoryInfo()
    {
        return $this->container['dg_signatory_info'];
    }

    /**
     * Sets dg_signatory_info
     *
     * @param \UPS\Shipping\Shipping\ShipmentDGSignatoryInfo $dg_signatory_info dg_signatory_info
     *
     * @return $this
     */
    public function setDgSignatoryInfo($dg_signatory_info)
    {
        $this->container['dg_signatory_info'] = $dg_signatory_info;

        return $this;
    }

    /**
     * Gets shipment_rating_options
     *
     * @return \UPS\Shipping\Shipping\ShipmentShipmentRatingOptions
     */
    public function getShipmentRatingOptions()
    {
        return $this->container['shipment_rating_options'];
    }

    /**
     * Sets shipment_rating_options
     *
     * @param \UPS\Shipping\Shipping\ShipmentShipmentRatingOptions $shipment_rating_options shipment_rating_options
     *
     * @return $this
     */
    public function setShipmentRatingOptions($shipment_rating_options)
    {
        $this->container['shipment_rating_options'] = $shipment_rating_options;

        return $this;
    }

    /**
     * Gets movement_reference_number
     *
     * @return string
     */
    public function getMovementReferenceNumber()
    {
        return $this->container['movement_reference_number'];
    }

    /**
     * Sets movement_reference_number
     *
     * @param string $movement_reference_number Movement Reference Number (MRN) information.  Must contain alphanumeric characters only. Must be a length of 18 characters. The 3rd and 4th Characters must be the Shipper country or territory ISO Code.
     *
     * @return $this
     */
    public function setMovementReferenceNumber($movement_reference_number)
    {
        $this->container['movement_reference_number'] = $movement_reference_number;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return \UPS\Shipping\Shipping\ShipmentReferenceNumber[]
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param \UPS\Shipping\Shipping\ShipmentReferenceNumber[] $reference_number reference_number
     *
     * @return $this
     */
    public function setReferenceNumber($reference_number)
    {
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets service
     *
     * @return \UPS\Shipping\Shipping\ShipmentService
     */
    public function getService()
    {
        return $this->container['service'];
    }

    /**
     * Sets service
     *
     * @param \UPS\Shipping\Shipping\ShipmentService $service service
     *
     * @return $this
     */
    public function setService($service)
    {
        $this->container['service'] = $service;

        return $this;
    }

    /**
     * Gets invoice_line_total
     *
     * @return \UPS\Shipping\Shipping\ShipmentInvoiceLineTotal
     */
    public function getInvoiceLineTotal()
    {
        return $this->container['invoice_line_total'];
    }

    /**
     * Sets invoice_line_total
     *
     * @param \UPS\Shipping\Shipping\ShipmentInvoiceLineTotal $invoice_line_total invoice_line_total
     *
     * @return $this
     */
    public function setInvoiceLineTotal($invoice_line_total)
    {
        $this->container['invoice_line_total'] = $invoice_line_total;

        return $this;
    }

    /**
     * Gets num_of_pieces_in_shipment
     *
     * @return string
     */
    public function getNumOfPiecesInShipment()
    {
        return $this->container['num_of_pieces_in_shipment'];
    }

    /**
     * Sets num_of_pieces_in_shipment
     *
     * @param string $num_of_pieces_in_shipment Total number of pieces in all pallets in a UPS Worldwide Express Freight Shipment.  It is required for UPS Worldwide Express Freight and UPS Worldwide Express Freight Midday Shipment. Valid values are 1 to 99999.
     *
     * @return $this
     */
    public function setNumOfPiecesInShipment($num_of_pieces_in_shipment)
    {
        $this->container['num_of_pieces_in_shipment'] = $num_of_pieces_in_shipment;

        return $this;
    }

    /**
     * Gets usps_endorsement
     *
     * @return string
     */
    public function getUspsEndorsement()
    {
        return $this->container['usps_endorsement'];
    }

    /**
     * Sets usps_endorsement
     *
     * @param string $usps_endorsement USPS Endorsement. Valid values:  1 = Return Service Requested  2 = Forwarding Service Requested  3 = Address Service Requested  4 = Change Service Requested and  5 = No Service Selected.  Note: For International Mail Innovations shipments use No Service Selected. International Mail Innovations shipments are applicable for Priority Mail Innovations and Mail Innovations Economy Mail Innovations services only.  Required for Mail Innovations forward shipments.
     *
     * @return $this
     */
    public function setUspsEndorsement($usps_endorsement)
    {
        $this->container['usps_endorsement'] = $usps_endorsement;

        return $this;
    }

    /**
     * Gets mi_label_cn22_indicator
     *
     * @return string
     */
    public function getMiLabelCn22Indicator()
    {
        return $this->container['mi_label_cn22_indicator'];
    }

    /**
     * Sets mi_label_cn22_indicator
     *
     * @param string $mi_label_cn22_indicator Indicates single label with both MI label and CN22 form.  International CN22 form is required.
     *
     * @return $this
     */
    public function setMiLabelCn22Indicator($mi_label_cn22_indicator)
    {
        $this->container['mi_label_cn22_indicator'] = $mi_label_cn22_indicator;

        return $this;
    }

    /**
     * Gets sub_classification
     *
     * @return string
     */
    public function getSubClassification()
    {
        return $this->container['sub_classification'];
    }

    /**
     * Sets sub_classification
     *
     * @param string $sub_classification A component encoded on the barcode of the Mail Innovations label.   Valid values:  IR = Irregular MA = Machineable SubClass is only required if the customer's contract have them subclass the package not UPS.
     *
     * @return $this
     */
    public function setSubClassification($sub_classification)
    {
        $this->container['sub_classification'] = $sub_classification;

        return $this;
    }

    /**
     * Gets cost_center
     *
     * @return string
     */
    public function getCostCenter()
    {
        return $this->container['cost_center'];
    }

    /**
     * Sets cost_center
     *
     * @param string $cost_center Customer assigned identifier for report and billing summarization displays to the right of the Cost Center title.  Required for Mail Innovations Return shipments. It is shown on the bottom of the shipping label as reference 2.  Cost Center length is alphanumeric with a max length of 30 for Mail Innovations forward shipments.  Cost Center length is numeric with a max length of 4 for Mail Innovations Return shipments.
     *
     * @return $this
     */
    public function setCostCenter($cost_center)
    {
        $this->container['cost_center'] = $cost_center;

        return $this;
    }

    /**
     * Gets cost_center_barcode_indicator
     *
     * @return string
     */
    public function getCostCenterBarcodeIndicator()
    {
        return $this->container['cost_center_barcode_indicator'];
    }

    /**
     * Sets cost_center_barcode_indicator
     *
     * @param string $cost_center_barcode_indicator Presence/Absence indicator. Presence of this indicator means that the customer is requesting for the CostCenter field to be barcoded at the bottom of the label.
     *
     * @return $this
     */
    public function setCostCenterBarcodeIndicator($cost_center_barcode_indicator)
    {
        $this->container['cost_center_barcode_indicator'] = $cost_center_barcode_indicator;

        return $this;
    }

    /**
     * Gets package_id
     *
     * @return string
     */
    public function getPackageId()
    {
        return $this->container['package_id'];
    }

    /**
     * Sets package_id
     *
     * @param string $package_id Customer-assigned unique piece identifier that returns visibility events.  Required only for Mail Innovations forward shipments. Alpha numeric values only. It is shown on the bottom of the shipping label as reference 1.
     *
     * @return $this
     */
    public function setPackageId($package_id)
    {
        $this->container['package_id'] = $package_id;

        return $this;
    }

    /**
     * Gets package_id_barcode_indicator
     *
     * @return string
     */
    public function getPackageIdBarcodeIndicator()
    {
        return $this->container['package_id_barcode_indicator'];
    }

    /**
     * Sets package_id_barcode_indicator
     *
     * @param string $package_id_barcode_indicator Presence/Absence indicator. Presence of this indicator means that the customer is requesting for the PackageID field to be barcoded at the bottom of the label.
     *
     * @return $this
     */
    public function setPackageIdBarcodeIndicator($package_id_barcode_indicator)
    {
        $this->container['package_id_barcode_indicator'] = $package_id_barcode_indicator;

        return $this;
    }

    /**
     * Gets irregular_indicator
     *
     * @return string
     */
    public function getIrregularIndicator()
    {
        return $this->container['irregular_indicator'];
    }

    /**
     * Sets irregular_indicator
     *
     * @param string $irregular_indicator Mail classification defined by the USPS.   Valid values:  1 = Balloon 2 = Oversize 3 = Not Applicable
     *
     * @return $this
     */
    public function setIrregularIndicator($irregular_indicator)
    {
        $this->container['irregular_indicator'] = $irregular_indicator;

        return $this;
    }

    /**
     * Gets shipment_indication_type
     *
     * @return \UPS\Shipping\Shipping\ShipmentShipmentIndicationType[]
     */
    public function getShipmentIndicationType()
    {
        return $this->container['shipment_indication_type'];
    }

    /**
     * Sets shipment_indication_type
     *
     * @param \UPS\Shipping\Shipping\ShipmentShipmentIndicationType[] $shipment_indication_type shipment_indication_type
     *
     * @return $this
     */
    public function setShipmentIndicationType($shipment_indication_type)
    {
        $this->container['shipment_indication_type'] = $shipment_indication_type;

        return $this;
    }

    /**
     * Gets mi_dual_return_shipment_key
     *
     * @return string
     */
    public function getMiDualReturnShipmentKey()
    {
        return $this->container['mi_dual_return_shipment_key'];
    }

    /**
     * Sets mi_dual_return_shipment_key
     *
     * @param string $mi_dual_return_shipment_key MIDualReturnShipmentKey is unique key required to process Mail Innovations Dual Return Shipment.   The unique identifier (key) would be returned in response of first phase of Mail Innovations Dual Return Shipments.   This unique identifier (key) would be part of request for second phase of Mail Innovations Dual Return Shipments.  Format:  For Package return shipments, the package tracking number is concatenated with the system time (YYYY-MM-DDHH.MM.SS.NNN), followed by service code.   For MI Return shipments, the Mail Manifest ID (MMI) is concatenated with the system time.  The unique identifier (key) is required to link the package and the Mail Innovations portion of Dual Return shipment.   If unique identifier (key) is empty in the request for UPS Mail Innovations Return Service, the request will be treated as the first phase of the Mail Innovations Dual Returns Request.   If the MIDualReturnShipmentIndicator is present with empty or null MIDualReturnShipmentKey in UPS Package Return Shipment, the request will be treated as the first phase of Dual MI Return Label Shipment.   This field would be ignored if MIDualReturnShipmentIndicator is not present in UPS Package Return Shipment request.
     *
     * @return $this
     */
    public function setMiDualReturnShipmentKey($mi_dual_return_shipment_key)
    {
        $this->container['mi_dual_return_shipment_key'] = $mi_dual_return_shipment_key;

        return $this;
    }

    /**
     * Gets mi_dual_return_shipment_indicator
     *
     * @return string
     */
    public function getMiDualReturnShipmentIndicator()
    {
        return $this->container['mi_dual_return_shipment_indicator'];
    }

    /**
     * Sets mi_dual_return_shipment_indicator
     *
     * @param string $mi_dual_return_shipment_indicator MIDualReturnShipmentIndicator is an indicator to identify a Package Shipment is part of UPS Mail Innovations Dual Label Shipment.   Its presence means Package Shipment is part of UPS Mail Innovations Dual Label shipment.  If the indicator is present in Package Shipment request, shipment would be considered as part of a Dual Mail Innovations Returns.   This indicator is not valid with UPS Mail Innovations Returns Service code.
     *
     * @return $this
     */
    public function setMiDualReturnShipmentIndicator($mi_dual_return_shipment_indicator)
    {
        $this->container['mi_dual_return_shipment_indicator'] = $mi_dual_return_shipment_indicator;

        return $this;
    }

    /**
     * Gets rating_method_requested_indicator
     *
     * @return string
     */
    public function getRatingMethodRequestedIndicator()
    {
        return $this->container['rating_method_requested_indicator'];
    }

    /**
     * Sets rating_method_requested_indicator
     *
     * @param string $rating_method_requested_indicator Presence/Absence Indicator. Any value inside is ignored. RatingMethodRequestedIndicator is an indicator. If present, Billable Weight Calculation method information and Rating Method information would be returned in response.
     *
     * @return $this
     */
    public function setRatingMethodRequestedIndicator($rating_method_requested_indicator)
    {
        $this->container['rating_method_requested_indicator'] = $rating_method_requested_indicator;

        return $this;
    }

    /**
     * Gets tax_information_indicator
     *
     * @return string
     */
    public function getTaxInformationIndicator()
    {
        return $this->container['tax_information_indicator'];
    }

    /**
     * Sets tax_information_indicator
     *
     * @param string $tax_information_indicator Presence/Absence Indicator. Any value inside is ignored. TaxInformationIndicator is an indicator. If present, any taxes that may be applicable to a shipment would be returned in response. If this indicator is requested with NegotiatedRatesIndicator, Tax related information, if applicable, would be returned only for Negotiated Rates and not for Published Rates. The Tax related information includes any type of Taxes, corresponding Monetary Values, Total Charges with Taxes and disclaimers (if applicable) would be returned in response.
     *
     * @return $this
     */
    public function setTaxInformationIndicator($tax_information_indicator)
    {
        $this->container['tax_information_indicator'] = $tax_information_indicator;

        return $this;
    }

    /**
     * Gets shipment_service_options
     *
     * @return \UPS\Shipping\Shipping\ShipmentShipmentServiceOptions
     */
    public function getShipmentServiceOptions()
    {
        return $this->container['shipment_service_options'];
    }

    /**
     * Sets shipment_service_options
     *
     * @param \UPS\Shipping\Shipping\ShipmentShipmentServiceOptions $shipment_service_options shipment_service_options
     *
     * @return $this
     */
    public function setShipmentServiceOptions($shipment_service_options)
    {
        $this->container['shipment_service_options'] = $shipment_service_options;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param string $locale Represents 5 character ISO Locale that allows the user to request Reference Number Code on Label, Label instructions and Receipt instructions (if applicable) in desired language.  Locale is specified by the combination of language code and country or territory code - 2 character language code and 2 character country or territory code seperated by an underscore ('_') character.  If Locale element is requested along with LabelLinksIndicator, the URL to retrieve Label and Receipts (if applicable) will be returned in the requested Locale. Please note only LabelURL and ReceiptURL (if applicable) will be returned. LocalLanguageLabelURL and LocalLanguageReceiptURL will not be returned if Locale element is present in request. Queen's English (en_GB) is the default
     *
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets shipment_value_threshold_code
     *
     * @return string
     */
    public function getShipmentValueThresholdCode()
    {
        return $this->container['shipment_value_threshold_code'];
    }

    /**
     * Sets shipment_value_threshold_code
     *
     * @param string $shipment_value_threshold_code Shipment Value Threshold Code. 01 = Shipment value is below or equals to threshold value 02 = Shipment value is above threshold value.     NA = Not Applicable
     *
     * @return $this
     */
    public function setShipmentValueThresholdCode($shipment_value_threshold_code)
    {
        $this->container['shipment_value_threshold_code'] = $shipment_value_threshold_code;

        return $this;
    }

    /**
     * Gets master_carton_id
     *
     * @return string
     */
    public function getMasterCartonId()
    {
        return $this->container['master_carton_id'];
    }

    /**
     * Sets master_carton_id
     *
     * @param string $master_carton_id Master Carton ID. If Economy Service (17 or 72) : Economy Shipment will be associated with given Master Carton ID. If Non-Economy Service: Master Carton Shipment will be created for given Master Carton ID.
     *
     * @return $this
     */
    public function setMasterCartonId($master_carton_id)
    {
        $this->container['master_carton_id'] = $master_carton_id;

        return $this;
    }

    /**
     * Gets master_carton_indicator
     *
     * @return string
     */
    public function getMasterCartonIndicator()
    {
        return $this->container['master_carton_indicator'];
    }

    /**
     * Sets master_carton_indicator
     *
     * @param string $master_carton_indicator Master Carton Indicator. Presence of the indicator means Master Carton ID will be created and returned to client.  This is an empty tag, any value inside is ignored.                                                                  MasterCartonIndicator is only valid with Econmoy Shipment (Service Code 17 or 72). Will be ignored if master carton id present.
     *
     * @return $this
     */
    public function setMasterCartonIndicator($master_carton_indicator)
    {
        $this->container['master_carton_indicator'] = $master_carton_indicator;

        return $this;
    }

    /**
     * Gets shipment_date
     *
     * @return string
     */
    public function getShipmentDate()
    {
        return $this->container['shipment_date'];
    }

    /**
     * Sets shipment_date
     *
     * @param string $shipment_date User can send up to 7 days in the future with current date as day zero. Format: YYYYMMDD
     *
     * @return $this
     */
    public function setShipmentDate($shipment_date)
    {
        $this->container['shipment_date'] = $shipment_date;

        return $this;
    }

    /**
     * Gets package
     *
     * @return \UPS\Shipping\Shipping\ShipmentPackage[]
     */
    public function getPackage()
    {
        return $this->container['package'];
    }

    /**
     * Sets package
     *
     * @param \UPS\Shipping\Shipping\ShipmentPackage[] $package package
     *
     * @return $this
     */
    public function setPackage($package)
    {
        $this->container['package'] = $package;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
