<?php
/**
 * EEIInformationDDTCInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * EEIInformationDDTCInformation Class Doc Comment
 *
 * @category Class
 * @description Department of State/ Directorate of Defense Trade Control Information. This element is a container for additional information that is applicable to SDL products. It will only be evaluated if the provided license code is an SDL code.  Applies to EEI Form only.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class EEIInformationDDTCInformation implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'EEIInformation_DDTCInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'itar_exemption_number' => 'string',
        'usml_category_code' => 'string',
        'eligible_party_indicator' => 'string',
        'registration_number' => 'string',
        'quantity' => 'string',
        'unit_of_measurement' => '\UPS\Shipping\Shipping\DDTCInformationUnitOfMeasurement',
        'significant_military_equipment_indicator' => 'string',
        'acm_number' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'itar_exemption_number' => null,
        'usml_category_code' => null,
        'eligible_party_indicator' => null,
        'registration_number' => null,
        'quantity' => null,
        'unit_of_measurement' => null,
        'significant_military_equipment_indicator' => null,
        'acm_number' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'itar_exemption_number' => 'ITARExemptionNumber',
        'usml_category_code' => 'USMLCategoryCode',
        'eligible_party_indicator' => 'EligiblePartyIndicator',
        'registration_number' => 'RegistrationNumber',
        'quantity' => 'Quantity',
        'unit_of_measurement' => 'UnitOfMeasurement',
        'significant_military_equipment_indicator' => 'SignificantMilitaryEquipmentIndicator',
        'acm_number' => 'ACMNumber'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'itar_exemption_number' => 'setItarExemptionNumber',
        'usml_category_code' => 'setUsmlCategoryCode',
        'eligible_party_indicator' => 'setEligiblePartyIndicator',
        'registration_number' => 'setRegistrationNumber',
        'quantity' => 'setQuantity',
        'unit_of_measurement' => 'setUnitOfMeasurement',
        'significant_military_equipment_indicator' => 'setSignificantMilitaryEquipmentIndicator',
        'acm_number' => 'setAcmNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'itar_exemption_number' => 'getItarExemptionNumber',
        'usml_category_code' => 'getUsmlCategoryCode',
        'eligible_party_indicator' => 'getEligiblePartyIndicator',
        'registration_number' => 'getRegistrationNumber',
        'quantity' => 'getQuantity',
        'unit_of_measurement' => 'getUnitOfMeasurement',
        'significant_military_equipment_indicator' => 'getSignificantMilitaryEquipmentIndicator',
        'acm_number' => 'getAcmNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['itar_exemption_number'] = isset($data['itar_exemption_number']) ? $data['itar_exemption_number'] : null;
        $this->container['usml_category_code'] = isset($data['usml_category_code']) ? $data['usml_category_code'] : null;
        $this->container['eligible_party_indicator'] = isset($data['eligible_party_indicator']) ? $data['eligible_party_indicator'] : null;
        $this->container['registration_number'] = isset($data['registration_number']) ? $data['registration_number'] : null;
        $this->container['quantity'] = isset($data['quantity']) ? $data['quantity'] : null;
        $this->container['unit_of_measurement'] = isset($data['unit_of_measurement']) ? $data['unit_of_measurement'] : null;
        $this->container['significant_military_equipment_indicator'] = isset($data['significant_military_equipment_indicator']) ? $data['significant_military_equipment_indicator'] : null;
        $this->container['acm_number'] = isset($data['acm_number']) ? $data['acm_number'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets itar_exemption_number
     *
     * @return string
     */
    public function getItarExemptionNumber()
    {
        return $this->container['itar_exemption_number'];
    }

    /**
     * Sets itar_exemption_number
     *
     * @param string $itar_exemption_number The specific citation (exemption number) under the International Traffic in Arms Regulations (ITAR) from the Code of Federal Register (see 22 CFR 120-130) that exempts the shipment from the requirements for a license or other written authorization from the Directorate of Trade Controls (DDTC).  Refer to EEI License Codes in the Appendix for valid values.  Applies to EEI Form only. This field is applicable for EEIFiling option 1A and 3.
     *
     * @return $this
     */
    public function setItarExemptionNumber($itar_exemption_number)
    {
        $this->container['itar_exemption_number'] = $itar_exemption_number;

        return $this;
    }

    /**
     * Gets usml_category_code
     *
     * @return string
     */
    public function getUsmlCategoryCode()
    {
        return $this->container['usml_category_code'];
    }

    /**
     * Sets usml_category_code
     *
     * @param string $usml_category_code Digit numeric code (e.g. 01-18, 20 or 21). Indicates the U.S. Munitions List (USML) category article, service or related technical data as it applies to the article reported.  Applies to EEI form only. It is required for EEIFilingOption code 3.
     *
     * @return $this
     */
    public function setUsmlCategoryCode($usml_category_code)
    {
        $this->container['usml_category_code'] = $usml_category_code;

        return $this;
    }

    /**
     * Gets eligible_party_indicator
     *
     * @return string
     */
    public function getEligiblePartyIndicator()
    {
        return $this->container['eligible_party_indicator'];
    }

    /**
     * Sets eligible_party_indicator
     *
     * @param string $eligible_party_indicator Presence/Absent indicator. Certification by the U.S. exporter that the exporter is an eligible party to participate in the defense trade.
     *
     * @return $this
     */
    public function setEligiblePartyIndicator($eligible_party_indicator)
    {
        $this->container['eligible_party_indicator'] = $eligible_party_indicator;

        return $this;
    }

    /**
     * Gets registration_number
     *
     * @return string
     */
    public function getRegistrationNumber()
    {
        return $this->container['registration_number'];
    }

    /**
     * Sets registration_number
     *
     * @param string $registration_number It is a unique registration code assigned to the registrant. The DDTC registration code consist of a letter prefix, M (assigned to a manufacturer and/or exporter) or K (assigned to a broker), followed by four or five digits (e.g. K-1234 or M12345).  It is required for EEIFilingOption code 3.
     *
     * @return $this
     */
    public function setRegistrationNumber($registration_number)
    {
        $this->container['registration_number'] = $registration_number;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return string
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param string $quantity Export Quantity.  Applies to EEI form only. It is required for EEIFilingOption code 3. Only positive integer value is valid.
     *
     * @return $this
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets unit_of_measurement
     *
     * @return \UPS\Shipping\Shipping\DDTCInformationUnitOfMeasurement
     */
    public function getUnitOfMeasurement()
    {
        return $this->container['unit_of_measurement'];
    }

    /**
     * Sets unit_of_measurement
     *
     * @param \UPS\Shipping\Shipping\DDTCInformationUnitOfMeasurement $unit_of_measurement unit_of_measurement
     *
     * @return $this
     */
    public function setUnitOfMeasurement($unit_of_measurement)
    {
        $this->container['unit_of_measurement'] = $unit_of_measurement;

        return $this;
    }

    /**
     * Gets significant_military_equipment_indicator
     *
     * @return string
     */
    public function getSignificantMilitaryEquipmentIndicator()
    {
        return $this->container['significant_military_equipment_indicator'];
    }

    /**
     * Sets significant_military_equipment_indicator
     *
     * @param string $significant_military_equipment_indicator Presence/ Absence Indicator.  Applies to EEI form only.
     *
     * @return $this
     */
    public function setSignificantMilitaryEquipmentIndicator($significant_military_equipment_indicator)
    {
        $this->container['significant_military_equipment_indicator'] = $significant_military_equipment_indicator;

        return $this;
    }

    /**
     * Gets acm_number
     *
     * @return string
     */
    public function getAcmNumber()
    {
        return $this->container['acm_number'];
    }

    /**
     * Sets acm_number
     *
     * @param string $acm_number Approved Community Member Number (ACM). It is required to be provided along with ITARExemptionNumber for some License code (SGB and SAU). The ACM# for the United Kingdom (License code SGB) must begin with UK followed by 9 numbers.  The ACM# for Australia (License Code SAU) must begin with DTT followed by 8 numbers.  Applies to EEI form only.  It is required for EEIFilingOption code 1A and 3.
     *
     * @return $this
     */
    public function setAcmNumber($acm_number)
    {
        $this->container['acm_number'] = $acm_number;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
