<?php
/**
 * PickupRateRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Pickup
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Pickup\Pickup;

use \ArrayAccess;
use \UPS\Pickup\ObjectSerializer;

/**
 * PickupRateRequest Class Doc Comment
 *
 * @category Class
 * @description This request is used to rate an on-callpickup.
 * @package  UPS\Pickup
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PickupRateRequest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'PickupRateRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'request' => '\UPS\Pickup\Pickup\PickupRateRequestRequest',
        'shipper_account' => '\UPS\Pickup\Pickup\PickupRateRequestShipperAccount',
        'pickup_address' => '\UPS\Pickup\Pickup\PickupRateRequestPickupAddress',
        'alternate_address_indicator' => 'string',
        'service_date_option' => 'string',
        'pickup_date_info' => '\UPS\Pickup\Pickup\PickupRateRequestPickupDateInfo',
        'rate_chart_type' => 'string',
        'tax_information_indicator' => 'string',
        'user_level_discount_indicator' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'request' => null,
        'shipper_account' => null,
        'pickup_address' => null,
        'alternate_address_indicator' => null,
        'service_date_option' => null,
        'pickup_date_info' => null,
        'rate_chart_type' => null,
        'tax_information_indicator' => null,
        'user_level_discount_indicator' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'request' => 'Request',
        'shipper_account' => 'ShipperAccount',
        'pickup_address' => 'PickupAddress',
        'alternate_address_indicator' => 'AlternateAddressIndicator',
        'service_date_option' => 'ServiceDateOption',
        'pickup_date_info' => 'PickupDateInfo',
        'rate_chart_type' => 'RateChartType',
        'tax_information_indicator' => 'TaxInformationIndicator',
        'user_level_discount_indicator' => 'UserLevelDiscountIndicator'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'request' => 'setRequest',
        'shipper_account' => 'setShipperAccount',
        'pickup_address' => 'setPickupAddress',
        'alternate_address_indicator' => 'setAlternateAddressIndicator',
        'service_date_option' => 'setServiceDateOption',
        'pickup_date_info' => 'setPickupDateInfo',
        'rate_chart_type' => 'setRateChartType',
        'tax_information_indicator' => 'setTaxInformationIndicator',
        'user_level_discount_indicator' => 'setUserLevelDiscountIndicator'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'request' => 'getRequest',
        'shipper_account' => 'getShipperAccount',
        'pickup_address' => 'getPickupAddress',
        'alternate_address_indicator' => 'getAlternateAddressIndicator',
        'service_date_option' => 'getServiceDateOption',
        'pickup_date_info' => 'getPickupDateInfo',
        'rate_chart_type' => 'getRateChartType',
        'tax_information_indicator' => 'getTaxInformationIndicator',
        'user_level_discount_indicator' => 'getUserLevelDiscountIndicator'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['request'] = isset($data['request']) ? $data['request'] : null;
        $this->container['shipper_account'] = isset($data['shipper_account']) ? $data['shipper_account'] : null;
        $this->container['pickup_address'] = isset($data['pickup_address']) ? $data['pickup_address'] : null;
        $this->container['alternate_address_indicator'] = isset($data['alternate_address_indicator']) ? $data['alternate_address_indicator'] : null;
        $this->container['service_date_option'] = isset($data['service_date_option']) ? $data['service_date_option'] : null;
        $this->container['pickup_date_info'] = isset($data['pickup_date_info']) ? $data['pickup_date_info'] : null;
        $this->container['rate_chart_type'] = isset($data['rate_chart_type']) ? $data['rate_chart_type'] : null;
        $this->container['tax_information_indicator'] = isset($data['tax_information_indicator']) ? $data['tax_information_indicator'] : null;
        $this->container['user_level_discount_indicator'] = isset($data['user_level_discount_indicator']) ? $data['user_level_discount_indicator'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['request'] === null) {
            $invalidProperties[] = "'request' can't be null";
        }
        if ($this->container['pickup_address'] === null) {
            $invalidProperties[] = "'pickup_address' can't be null";
        }
        if ($this->container['alternate_address_indicator'] === null) {
            $invalidProperties[] = "'alternate_address_indicator' can't be null";
        }
        if ($this->container['service_date_option'] === null) {
            $invalidProperties[] = "'service_date_option' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets request
     *
     * @return \UPS\Pickup\Pickup\PickupRateRequestRequest
     */
    public function getRequest()
    {
        return $this->container['request'];
    }

    /**
     * Sets request
     *
     * @param \UPS\Pickup\Pickup\PickupRateRequestRequest $request request
     *
     * @return $this
     */
    public function setRequest($request)
    {
        $this->container['request'] = $request;

        return $this;
    }

    /**
     * Gets shipper_account
     *
     * @return \UPS\Pickup\Pickup\PickupRateRequestShipperAccount
     */
    public function getShipperAccount()
    {
        return $this->container['shipper_account'];
    }

    /**
     * Sets shipper_account
     *
     * @param \UPS\Pickup\Pickup\PickupRateRequestShipperAccount $shipper_account shipper_account
     *
     * @return $this
     */
    public function setShipperAccount($shipper_account)
    {
        $this->container['shipper_account'] = $shipper_account;

        return $this;
    }

    /**
     * Gets pickup_address
     *
     * @return \UPS\Pickup\Pickup\PickupRateRequestPickupAddress
     */
    public function getPickupAddress()
    {
        return $this->container['pickup_address'];
    }

    /**
     * Sets pickup_address
     *
     * @param \UPS\Pickup\Pickup\PickupRateRequestPickupAddress $pickup_address pickup_address
     *
     * @return $this
     */
    public function setPickupAddress($pickup_address)
    {
        $this->container['pickup_address'] = $pickup_address;

        return $this;
    }

    /**
     * Gets alternate_address_indicator
     *
     * @return string
     */
    public function getAlternateAddressIndicator()
    {
        return $this->container['alternate_address_indicator'];
    }

    /**
     * Sets alternate_address_indicator
     *
     * @param string $alternate_address_indicator Indicates if the pickup address is different than the address specified in the customer's profile.   Valid values: Y = Alternate address N = Original pickup address (default)
     *
     * @return $this
     */
    public function setAlternateAddressIndicator($alternate_address_indicator)
    {
        $this->container['alternate_address_indicator'] = $alternate_address_indicator;

        return $this;
    }

    /**
     * Gets service_date_option
     *
     * @return string
     */
    public function getServiceDateOption()
    {
        return $this->container['service_date_option'];
    }

    /**
     * Sets service_date_option
     *
     * @param string $service_date_option Indicates the pickup timeframe. - 01 = Same-Day Pickup - 02 = Future-Day Pickup - 03 = A Specific-Day Pickup  If 03 is selected, then PickupDate, EarliestReadyTime, and LatestClosetime must be specified.
     *
     * @return $this
     */
    public function setServiceDateOption($service_date_option)
    {
        $this->container['service_date_option'] = $service_date_option;

        return $this;
    }

    /**
     * Gets pickup_date_info
     *
     * @return \UPS\Pickup\Pickup\PickupRateRequestPickupDateInfo
     */
    public function getPickupDateInfo()
    {
        return $this->container['pickup_date_info'];
    }

    /**
     * Sets pickup_date_info
     *
     * @param \UPS\Pickup\Pickup\PickupRateRequestPickupDateInfo $pickup_date_info pickup_date_info
     *
     * @return $this
     */
    public function setPickupDateInfo($pickup_date_info)
    {
        $this->container['pickup_date_info'] = $pickup_date_info;

        return $this;
    }

    /**
     * Gets rate_chart_type
     *
     * @return string
     */
    public function getRateChartType()
    {
        return $this->container['rate_chart_type'];
    }

    /**
     * Sets rate_chart_type
     *
     * @param string $rate_chart_type Rate Type with which pickup is rated. Possible RateChart values for different regions will be:  US 48 origin: 1 – Daily Rates 3 – Standard List Rates 4 – Retail Rates.   Alaska/Hawaii origin: 1 – Daily Rates 3 – Standard List Rates 4 – Retail Rates.  All Other origins: 1 – Rates 5 - Regional Rates 6 - General List Rates.  3 and 4 do not apply
     *
     * @return $this
     */
    public function setRateChartType($rate_chart_type)
    {
        $this->container['rate_chart_type'] = $rate_chart_type;

        return $this;
    }

    /**
     * Gets tax_information_indicator
     *
     * @return string
     */
    public function getTaxInformationIndicator()
    {
        return $this->container['tax_information_indicator'];
    }

    /**
     * Sets tax_information_indicator
     *
     * @param string $tax_information_indicator Indicates whether to return detailed taxes for on-callpickups. Valid values: - Y = Rate this pickup with taxes - N = Do not rate this pickup with taxes (default)
     *
     * @return $this
     */
    public function setTaxInformationIndicator($tax_information_indicator)
    {
        $this->container['tax_information_indicator'] = $tax_information_indicator;

        return $this;
    }

    /**
     * Gets user_level_discount_indicator
     *
     * @return string
     */
    public function getUserLevelDiscountIndicator()
    {
        return $this->container['user_level_discount_indicator'];
    }

    /**
     * Sets user_level_discount_indicator
     *
     * @param string $user_level_discount_indicator Indicates whether to return user level promo discount for the on-callpickups.  Valid values: Y = Rate this pickup with user level promo discount N = Do not rate this pickup with user level promo discount(default)
     *
     * @return $this
     */
    public function setUserLevelDiscountIndicator($user_level_discount_indicator)
    {
        $this->container['user_level_discount_indicator'] = $user_level_discount_indicator;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
