# OAuthAuthCode
The UPS OAuth Authorization Code API helps integrate UPS services into your business application for providing the service your application grants your customers. For example, you can create UPS shipping labels with shipping rates for merchants from within your application. Since your application will not have access to your customer's UPS login credentials, the OAuth authorization code flow is used to let your customer use their UPS credentials, within your application, in a simple and secure way.  Key Business Values: - **Enhanced Transaction Security**: The OAuth Authorization Code flow is more secure and reliable since the access token and the refresh token are never exposed in the browser's URL, thus reducing the risk of leakage or theft. - **Operational Efficiency**: With the ability to obtain a refresh token when the token expires, your application can maintain a long-term and uninterrupted access to the protected resources, without requiring the user to re-authenticate or re-login.  Overview of steps in OAuth Authorization Code flow: (1) When user selects Login, the client application redirects to the authorization server's /authorize endpoint. (2) The Authorization Server authenticates the user by asking for their login credentials, and after successful login, the authorization server responds back to the application with an authorization code contained within a redirection URI. (3) The application then sends the authorization code and the redirection URI to the authorization server's /oauth/token endpoint. (4) The authorization server's /token endpoint verifies the authorization code and the application's client ID contained in the redirect URI, and responds with a with an access token, as well as a refresh token. (5) The Client application uses the access token to request information from an UPS API.  - <a href=\"https://developer.ups.com/api/reference/oauth/authorization-code\" target=\"_blank\" rel=\"noopener\">Setting-up OAuth Authorization Code flow</a> - <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">Sample integration code on GitHub</a>

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 1.0.8
- Build package: io.swagger.codegen.v3.generators.php.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/abantecart/ups-oauth-auth-code.git"
    }
  ],
  "require": {
    "abantecart/ups-oauth-auth-code": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/OAuthAuthCode/vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new UPS\OAuthAuthCode\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$client_id = "client_id_example"; // string | The public identifier for your application, obtained when you, the developer first registered the application.
$redirect_uri = "redirect_uri_example"; // string | URL that tells the authorization server where to send the user back to after they approve the request.
$response_type = "response_type_example"; // string | Valid Values: code
$state = "state_example"; // string | A random string generated by the application and included in the request to prevent CSRF attacks. The application checks that the same value is returned after the user authorizes the app.
$scope = "scope_example"; // string | One or more space-separated strings indicating which permissions the application is requesting.

try {
    $apiInstance->authorizeClient($client_id, $redirect_uri, $response_type, $state, $scope);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->authorizeClient: ', $e->getMessage(), PHP_EOL;
}
// Configure HTTP basic authorization: basicAuth
$config = UPS\OAuthAuthCode\Configuration::getDefaultConfiguration()
    ->setUsername('YOUR_USERNAME')
    ->setPassword('YOUR_PASSWORD');

$apiInstance = new UPS\OAuthAuthCode\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$grant_type = "grant_type_example"; // string | 
$code = "code_example"; // string | 
$redirect_uri = "redirect_uri_example"; // string | 

try {
    $result = $apiInstance->generateToken($grant_type, $code, $redirect_uri);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->generateToken: ', $e->getMessage(), PHP_EOL;
}
// Configure HTTP basic authorization: basicAuth
$config = UPS\OAuthAuthCode\Configuration::getDefaultConfiguration()
    ->setUsername('YOUR_USERNAME')
    ->setPassword('YOUR_PASSWORD');

$apiInstance = new UPS\OAuthAuthCode\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$grant_type = "grant_type_example"; // string | 
$refresh_token = "refresh_token_example"; // string | 

try {
    $result = $apiInstance->refreshToken($grant_type, $refresh_token);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->refreshToken: ', $e->getMessage(), PHP_EOL;
}
?>
```

## Documentation for API Endpoints

All URIs are relative to *https://wwwcie.ups.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**authorizeClient**](docs/Api/DefaultApi.md#authorizeclient) | **GET** /security/v1/oauth/authorize | Authorize Client
*DefaultApi* | [**generateToken**](docs/Api/DefaultApi.md#generatetoken) | **POST** /security/v1/oauth/token | 
*DefaultApi* | [**refreshToken**](docs/Api/DefaultApi.md#refreshtoken) | **POST** /security/v1/oauth/refresh | Refresh Token

## Documentation For Models

 - [ErrorResponseWrapper](docs/Model/ErrorResponseWrapper.md)
 - [Errors](docs/Model/Errors.md)
 - [GenerateTokenSuccessResponse](docs/Model/GenerateTokenSuccessResponse.md)
 - [OauthRefreshBody](docs/Model/OauthRefreshBody.md)
 - [OauthTokenBody](docs/Model/OauthTokenBody.md)
 - [RefreshTokenSuccessResponse](docs/Model/RefreshTokenSuccessResponse.md)
 - [TokenErrorResponse](docs/Model/TokenErrorResponse.md)

## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## Author



