<?php
/**
 * LandedCostRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\LandedCost
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Landed Cost Quote API
 *
 * The Landed Cost Quote API allows you to estimate the all-inclusive cost of international shipments - including applicable duties, VAT, taxes, brokerage fees, and other fees. Required parameters include the currency and shipment details, such as the commodity ID, price, quantity, and country code of origin.  Key Business Values: - **Enhanced Customer Experience**: Get a quick and accurate quote on the landed cost of a shipment, including the cost of goods, transportation, and any other fees associated with getting the goods to their destination. - **Operational Efficiency**: Simplify the process of calculating landed costs by eliminating the need to manually research and calculate all of the different fees involved. - **Data-Driven Decision Making**: Improve decision-making by having a clear understanding of the total cost of shipping goods before you commit to a purchase.. - **Optimizing Cash Flow**: Streamline your shipping process by integrating the Landed Cost Quote API into your existing systems.
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\LandedCost\LandedCost;

use \ArrayAccess;
use \UPS\LandedCost\ObjectSerializer;

/**
 * LandedCostRequest Class Doc Comment
 *
 * @category Class
 * @description The root element for the Landed Cost document.
 * @package  UPS\LandedCost
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class LandedCostRequest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'LandedCostRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'currency_code' => 'string',
        'trans_id' => 'string',
        'allow_partial_landed_cost_result' => 'bool',
        'alversion' => 'int',
        'shipment' => '\UPS\LandedCost\LandedCost\LandedCostRequestShipment'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'currency_code' => null,
        'trans_id' => null,
        'allow_partial_landed_cost_result' => null,
        'alversion' => null,
        'shipment' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'currency_code' => 'currencyCode',
        'trans_id' => 'transID',
        'allow_partial_landed_cost_result' => 'allowPartialLandedCostResult',
        'alversion' => 'alversion',
        'shipment' => 'shipment'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'currency_code' => 'setCurrencyCode',
        'trans_id' => 'setTransId',
        'allow_partial_landed_cost_result' => 'setAllowPartialLandedCostResult',
        'alversion' => 'setAlversion',
        'shipment' => 'setShipment'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'currency_code' => 'getCurrencyCode',
        'trans_id' => 'getTransId',
        'allow_partial_landed_cost_result' => 'getAllowPartialLandedCostResult',
        'alversion' => 'getAlversion',
        'shipment' => 'getShipment'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['currency_code'] = isset($data['currency_code']) ? $data['currency_code'] : null;
        $this->container['trans_id'] = isset($data['trans_id']) ? $data['trans_id'] : null;
        $this->container['allow_partial_landed_cost_result'] = isset($data['allow_partial_landed_cost_result']) ? $data['allow_partial_landed_cost_result'] : null;
        $this->container['alversion'] = isset($data['alversion']) ? $data['alversion'] : null;
        $this->container['shipment'] = isset($data['shipment']) ? $data['shipment'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['currency_code'] === null) {
            $invalidProperties[] = "'currency_code' can't be null";
        }
        if ($this->container['trans_id'] === null) {
            $invalidProperties[] = "'trans_id' can't be null";
        }
        if ($this->container['alversion'] === null) {
            $invalidProperties[] = "'alversion' can't be null";
        }
        if ($this->container['shipment'] === null) {
            $invalidProperties[] = "'shipment' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets currency_code
     *
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->container['currency_code'];
    }

    /**
     * Sets currency_code
     *
     * @param string $currency_code Specifies the currency of transaction or purchase.
     *
     * @return $this
     */
    public function setCurrencyCode($currency_code)
    {
        $this->container['currency_code'] = $currency_code;

        return $this;
    }

    /**
     * Gets trans_id
     *
     * @return string
     */
    public function getTransId()
    {
        return $this->container['trans_id'];
    }

    /**
     * Sets trans_id
     *
     * @param string $trans_id Unique transaction ID for the request.
     *
     * @return $this
     */
    public function setTransId($trans_id)
    {
        $this->container['trans_id'] = $trans_id;

        return $this;
    }

    /**
     * Gets allow_partial_landed_cost_result
     *
     * @return bool
     */
    public function getAllowPartialLandedCostResult()
    {
        return $this->container['allow_partial_landed_cost_result'];
    }

    /**
     * Sets allow_partial_landed_cost_result
     *
     * @param bool $allow_partial_landed_cost_result An optional flag to indicate that partial landed cost calculations are acceptable to be used by upstream systems. When set to *false*, the system will return an error when at least one commodity in the shipment is invalid (all or none), and no results  will be sent back for that request. When set to *true*, the system will return partial calculations when applicable.  Valid values: true = Partial Landed Cost result will return. false = All or No result will return (default).
     *
     * @return $this
     */
    public function setAllowPartialLandedCostResult($allow_partial_landed_cost_result)
    {
        $this->container['allow_partial_landed_cost_result'] = $allow_partial_landed_cost_result;

        return $this;
    }

    /**
     * Gets alversion
     *
     * @return int
     */
    public function getAlversion()
    {
        return $this->container['alversion'];
    }

    /**
     * Sets alversion
     *
     * @param int $alversion Version number of the instance that processed this request. This must match the major number of the corresponding ICD version.
     *
     * @return $this
     */
    public function setAlversion($alversion)
    {
        $this->container['alversion'] = $alversion;

        return $this;
    }

    /**
     * Gets shipment
     *
     * @return \UPS\LandedCost\LandedCost\LandedCostRequestShipment
     */
    public function getShipment()
    {
        return $this->container['shipment'];
    }

    /**
     * Sets shipment
     *
     * @param \UPS\LandedCost\LandedCost\LandedCostRequestShipment $shipment shipment
     *
     * @return $this
     */
    public function setShipment($shipment)
    {
        $this->container['shipment'] = $shipment;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
