<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerResponsesSalesStateReportSalesStateReportSave extends AController {
        public function update() {
            $this->loadLanguage('extension/extensions');
            $this->load->model('setting/setting');
            if (!$this->user->canModify('extension/extensions')) {
                $this->response->setOutput(sprintf($this->language->get('error_permission_modify'), 'extension/extensions'));
                return null;
            }

            $store_id = (int)$this->config->get('config_store_id');
            if (has_value($this->request->get_or_post('store_id'))) {
                $store_id = (int)$this->request->get_or_post('store_id');
            } else {
                if ($this->session->data['current_store_id']) {
                    $store_id = (int)$this->session->data['current_store_id'];
                }
            }
            $this->model_setting_setting->editSetting('sales_state_report', $this->request->post, $store_id);
    }
}