<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

class ModelOptionPriceProWithDiscountProduct extends Model {
    public function getBasePrice($product_option_id) {
        $q=$this->db->query("SELECT calculate,calculate_option_discount,base_price,show_option_savings
                            FROM " . $this->db->table("product_options") . "
                            WHERE product_option_id = '" . (int)$product_option_id . "'");
        $res=$q->row;
        return $res;
    }

    /**
     * @param $option_id
     * @return mixed
     */
    public function getSettings($option_id) {
        $sql="SELECT `minimum`, `maximum`, `maximum_status` FROM ". $this->db->table('option_validation')." WHERE product_option_id=".$option_id;
        $result=$this->db->query($sql);
        return $result->row;
    }

    /**
     * @param $option_id
     * @return mixed
     */
    public function getOptionType($option_id) {
        $sql="SELECT po.element_type,pod.name FROM ". $this->db->table('product_options')." po
              LEFT JOIN ". $this->db->table('product_option_descriptions')." pod ON pod.product_option_id = po.product_option_id  
              WHERE po.product_option_id=".(int)$option_id;
        $results=$this->db->query($sql);
        //$result=$results->row;
        return $results->row;
    }

    /**
     * @param $product_id
     * @return mixed
     * @throws AException
     */
    public function getProductSpecial($product_id) {
        $product_id = (int)$product_id;

        if ( $this->customer->isUnauthCustomer()) {
            $customer_group_id = $this->getCustomerGroupId($this->customer->isUnauthCustomer());
        } elseif ($this->customer->isLogged()) {
            $customer_group_id = $this->customer->getCustomerGroupId();
        } else {
            $customer_group_id = (int) $this->config->get('config_customer_group_id');
        }

        $query = $this->db->query(
            "SELECT ps.price_prefix, ps.price
            FROM ".$this->db->table("product_specials")." ps
            LEFT JOIN ".$this->db->table("products")." p
                            ON p.product_id = ps.product_id
            WHERE ps.product_id = '".(int) $product_id."'
                AND ps.customer_group_id = '".$customer_group_id."'
                AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW())
                AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW()))
            ORDER BY ps.priority ASC, p.price ASC 
            LIMIT 1"
        );

        return $query->row;
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getCustomerGroupId($customer_id) {
        $query = $this->db->query("SELECT `customer_group_id` FROM ".$this->db->table("customers")." WHERE `customer_id`=".(int)$customer_id);
        return $query->row['customer_group_id'];
    }

    /**
     * @param $data
     * @return void
     * @throws AException
     */
    public function addSavingsToOrderProducts($data) {
        $sql = "UPDATE " . $this->db->table("order_products") . " SET `savings`='" . $data['savings'] . "'
		        WHERE `product_id`=" . (int)$data['product_id'] . " AND `order_id`=" . (int)$data['order_id']." AND `order_product_id`='".$data['order_product_id']."'";
        $this->db->query($sql);
    }

    /**
     * @param $data
     * @return void
     * @throws AException
     */
    public function addSavingsToOrderOptions($data) {
        $sql = "UPDATE " . $this->db->table("order_options") . " SET `savings`='" . $data['savings'] . "'
		        WHERE `order_product_id`=" . (int)$data['order_product_id'] . " AND `product_option_value_id`=" . $data['product_option_value_id'] . " AND `order_id`=" . (int)$data['order_id'];
        $this->db->query($sql);
    }

    /**
     * @param $data
     * @return mixed
     * @throws AException
     */
    public function getSavings($data) {
        $sql = "SELECT `savings` FROM ".$this->db->table("order_products")." WHERE `order_product_id`=" . (int)$data['order_product_id'] . " AND `order_id`=" . (int)$data['order_id'];
        $query = $this->db->query($sql);
        return $query->row['savings'];
    }

    /**
     * @param $data
     * @return mixed
     * @throws AException
     */
    public function getOptionSavings($data) {
        $sql = "SELECT `savings` FROM ".$this->db->table("order_options")." WHERE `order_product_id`=" . (int)$data['order_product_id']  . " AND `product_option_value_id`=" . (int)$data['product_option_value_id']. " AND `order_id`=" . (int)$data['order_id'];
        $query = $this->db->query($sql);
        return $query->row['savings'];
    }

    /**
     * @param $data
     * @return mixed
     * @throws AException
     */
    public function getOrderProductId($data) {
        if (isset($data['option_name']) && $data['option_name']!=="") {
            $sql = "SELECT * FROM " . $this->db->table("order_options") . " oo LEFT JOIN 
                " . $this->db->table("order_products") . " op ON op.order_product_id = oo.order_product_id
                WHERE oo.order_id='" . (int)$data['order_id'] . "' AND oo.product_option_value_id='" . $data['product_option_value_id'] . "'";
            $query = $this->db->query($sql);
            return $query->row;
        } else {
            $sql = "SELECT * FROM " . $this->db->table("order_products") . "
                WHERE order_id='" . (int)$data['order_id'] . "' AND name='" . $data['product_name'] . "'";
            $query = $this->db->query($sql);
            return $query->row;
        }
    }
}