<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

if(!class_exists('ExtensionOptionPriceProWithDiscount')){
    include_once('core/option_price_pro_with_discount_hook.php');
}
$controllers = [
    'storefront' => [
    ],
    'admin' => [
        'pages/catalog/product_total_savings',
        'pages/extension/option_price_pro_with_discount_updater'
    ]
];

$models = [
    'storefront' => [
        'catalog/product_total_savings',
        'option_price_pro_with_discount/product',
        'extension/option_price_pro_with_discount_license_info'
    ],
    'admin' => [
        'catalog/product_total_savings',
        'extension/option_price_pro_with_discount_updater',
        'option_price_pro_with_discount/product_options',
        'option_price_pro_with_discount/options',
        'extension/option_price_pro_with_discount_license_info'
    ]
];

$templates = [
    'storefront' => [
        'block/order_summary_savings.tpl',
        'pages/account/invoice_savings.tpl',
        'pages/checkout/checkout_cart_savings.tpl',
        'pages/checkout/order_confirm_savings.tpl',
        'responses/checkout/cart_details_savings.tpl',
        'responses/checkout/fast_checkout_order_summary_savings.tpl',
        'responses/checkout/order_confirmation_savings.tpl',
        'responses/sale/order_invoice_savings.tpl',
    ],
    'admin' => [
        'pages/catalog/product_total_savings.tpl',
        'pages/extension/product_total_savings_tab.tpl',
        'pages/extension/option_price_pro_with_discount_manual.tpl',
        'pages/extension/extension_summary_button.tpl',
        'pages/extension/extensions.post.tpl',
        'pages/extension/option_price_pro_with_discount_updater.tpl',
        'responses/product/option_values.post.tpl',
        'pages/extension/extensions_edit.post.tpl',
    ]
];

$languages = [
    'storefront' => [
        'option_price_pro_with_discount/option_price_pro_with_discount'],
    'admin' => [
        'option_price_pro_with_discount/option_price_pro_with_discount']
];