<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT . "option_price_pro_with_discount" . DIR_EXT_CORE . "updater.php";

/**
 * Class ExtensionOptionPricePro
 * @property ModelOptionPriceProWithDiscountProduct $model_option_price_pro_with_discount_product
 */

class ExtensionOptionPriceProWithDiscount extends Extension {

	public $data = [];
	private $calc_status = '';
	private $error = [];
    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "option_price_pro_with_discount";

	public function __construct() {
		$this->registry = Registry::getInstance();
	}

	private function _is_enabled() {
		return $this->baseObject->config->get( 'option_price_pro_with_discount_status' ) && $this->verify();
	}

	public function verify() {
		$that =& $this->baseObject;
        $that->load->model('extension/option_price_pro_with_discount_license_info');
        $license_key = $that->config->get('option_price_pro_with_discount_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_price_pro_with_discount_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_option_price_pro_with_discount_license_info->getStoreId();
                $license_key = $that->model_extension_option_price_pro_with_discount_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_option_price_pro_with_discount_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_option_price_pro_with_discount_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $public_key = "";
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/option_price_pro_with_discount_license_info');
                    $current_version = $that->model_extension_option_price_pro_with_discount_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/option_price_pro_with_discount_license_info');
                            $that->model_extension_option_price_pro_with_discount_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
	}

    public function verifyAreaCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('area_calculator_status')==='1') {
            $that->load->model('extension/area_calculator_license_info');
            $license_key = $that->config->get('area_calculator_license_code');
            $shared_secret = 'area_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('area_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_area_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_area_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_area_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_area_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyLengthCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('length_calculator_status')==='1') {
            $that->load->model('extension/length_calculator_license_info');
            $license_key = $that->config->get('length_calculator_license_code');
            $shared_secret = 'length_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('length_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_length_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_length_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_length_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_length_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyVolumeCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('volume_calculator_status')==='1') {
            $that->load->model('extension/volume_calculator_license_info');
            $license_key = $that->config->get('volume_calculator_license_code');
            $shared_secret = 'volume_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('volume_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_volume_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_volume_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_volume_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_volume_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyWeightCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('weight_calculator_status')==='1') {
            $that->load->model('extension/weight_calculator_license_info');
            $license_key = $that->config->get('weight_calculator_license_code');
            $shared_secret = 'weight_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('weight_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_weight_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_weight_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_weight_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_weight_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyLiquidsCalculator() {
        $that  =& $this->baseObject;
        if ($that->config->get('liquids_calculator_status')==='1') {
            $that->load->model('extension/liquids_calculator_license_info');
            $license_key = $that->config->get('liquids_calculator_license_code');
            $shared_secret = 'liquids_calculator';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('liquids_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_liquids_calculator_license_info->getStoreId();
                    $license_key = $that->model_extension_liquids_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_liquids_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_liquids_calculator_license_info->getLicensedStoreStatus();

                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_price_pro_with_discount_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/option_price_pro_with_discount_license_info');
                    $store_id = $that->model_extension_option_price_pro_with_discount_license_info->getStoreId();
                    $license_info = $that->model_extension_option_price_pro_with_discount_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_option_price_pro_with_discount_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/option_price_pro_with_discount_updater');
                        $current_version = $that->model_extension_option_price_pro_with_discount_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 1209600;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/option_price_pro_with_discount_license_info');
                                $that->model_extension_option_price_pro_with_discount_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }
    
	public function onControllerPagesExtensionExtensions_InitData() {
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'edit' ) {
			$extension = $that->request->get['extension'];
			if ( $extension === 'option_price_pro_with_discount' ) {
				if ( $that->request->is_POST() ) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['option_price_pro_with_discount_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/option_price_pro_with_discount_license_info');

                    $store_id = (int) $that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int) $that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['current_store_id']) {
                            $store_id = (int) $that->session->data['current_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_option_price_pro_with_discount_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                        $that->model_extension_option_price_pro_with_discount_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_option_price_pro_with_discount_license_info->getLicenseCode($store_id);
                    $data['multi']=false;
                    $split_existing_license_key = explode('-',$existing_license_key);
                    $split_license_key = explode('-',$license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi']=true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/option_price_pro_with_discount_updater');
                    $current_version = $that->model_extension_option_price_pro_with_discount_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/option_price_pro_with_discount_license_info');
                        $data['option_price_pro_with_discount_licensed_store_id_'.$store_id] = 1;

                        $that->model_setting_setting->editSetting('option_price_pro_with_discount', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT.'option_price_pro_with_discount/core/helpers.php')) {
                                unlink(DIR_EXT.'option_price_pro_with_discount/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/option_price_pro_with_discount_license_info');
                            $that->model_extension_option_price_pro_with_discount_license_info->saveLicenseData($data);
                        }
                        if (file_exists(DIR_EXT.'option_price_pro')) {
                            $data=[];
                            if ($that->request->post['option_price_pro_with_discount_name_separator']==='') {
                                $that->request->post['option_price_pro_with_discount_name_separator'] = $that->config->get('option_price_pro_name_separator');
                            }
                            if ($that->request->post['option_price_pro_with_discount_price_separator']==='') {
                                $that->request->post['option_price_pro_with_discount_price_separator'] = $that->config->get('option_price_pro_price_separator');
                            }
                            if ($that->request->post['option_price_pro_with_discount_enter_minimum_warning']==='') {
                                $that->request->post['option_price_pro_with_discount_enter_minimum_warning'] = $that->config->get('option_price_pro_enter_minimum_warning');
                            }
                            if ($that->request->post['option_price_pro_with_discount_enter_maximum_warning']==='') {
                                $that->request->post['option_price_pro_with_discount_enter_maximum_warning'] = $that->config->get('option_price_pro_enter_maximum_warning');
                            }
                            $that->load->model('setting/setting');
                            $that->model_setting_setting->editSetting('option_price_pro_with_discount', $that->request->post);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
            if ( $extension === 'option_price_pro_with_discount' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_option_price_pro_with_discount_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/option_price_pro_with_discount_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/option-pro-with-discounts';
                $data['manual_title'] = $that->language->get('option_price_pro_with_discount_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/option_price_pro_with_discount_manual.tpl'));
                $that->load->model('extension/option_price_pro_with_discount_license_info');
                $license_key = $that->config->get('option_price_pro_with_discount_license_code');
                if ($license_key) {
                    $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_price_pro_with_discount_license_info') . "'");
                    if ($exist->num_rows === 1) {
                        $store_id = $that->model_extension_option_price_pro_with_discount_license_info->getStoreId();
                        $license_key = $that->model_extension_option_price_pro_with_discount_license_info->getLicenseCode($store_id);
                        $license_info = $that->model_extension_option_price_pro_with_discount_license_info->getLicenseData($store_id);
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_info['license_data'], $ttl);
                        $message = '';
                        if ($validate['status']==='expired') {
                            $message = $that->language->get('option_price_pro_with_discount_license_expired');
                        }
                        $that->view->assign('message',$message);
                    }
                }
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'option_price_pro_with_discount') {
            return false;
        }
        if (isset($that->request->post['option_price_pro_with_discount_license_code'])) {
            $that->request->post['option_price_pro_with_discount_license_code'] = trim($that->request->post['option_price_pro_with_discount_license_code']);
        }
    }

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('option_price_pro_with_discount_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'option_price_pro_with_discount_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion!=='') {
                                $update_now_url = $that->html->getSecureURL('extension/option_price_pro_with_discount_updater','&version='.str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    .'<br>'
                                    .sprintf(
                                        $that->language->get('text_update_option_price_pro_with_discount_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    .'</p>';
                                $that->data['response']->rows[$k]['cell'][$key] = $cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            if ($that->request->post['option_price_pro_with_discount_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['option_price_pro_with_discount_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/option_price_pro_with_discount_license_info');

                $installed_store_id = $that->model_extension_option_price_pro_with_discount_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_option_price_pro_with_discount_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/option_price_pro_with_discount_updater');
                $current_version = $that->model_extension_option_price_pro_with_discount_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/option_price_pro_with_discount_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/option_price_pro_with_discount_license_info');
                        $that->model_extension_option_price_pro_with_discount_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='option_price_pro_with_discount') {
                $that->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    } else {
                        $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

/** Admin Section */
    public function onControllerCommonListingGrid_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;

        $data = &$that->data;
        if ($data['table_id'] === 'product_grid') {
            $that->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
            $data['actions']['dropdown']['children']['product_total_savings'] = [
                'text' => $this->baseObject->language->get('entry_admin_product_total_savings_tab_name'),
                'href' => $this->baseObject->html->getSecureURL('catalog/product_total_savings', '&product_id=%ID%')
            ];
        }
    }

    public function onControllerPagesCatalogProductTabs_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
        $data = $that->data;
        $view = new AView(Registry::getInstance(), 0);
        $view->batchAssign($data);
        $this->baseObject->view->addHookVar('extension_tabs', $view->fetch('pages/extension/product_total_savings_tab.tpl'));
    }

    /** End Of Admin Section */


    /** Storefront section*/
	public function onControllerPagesCheckoutCart_InitData() {
		$that = $this->baseObject;

		if ( ! $this->_is_enabled() ) {
			return null;
		}

		if ( $this->baseObject_method === 'main' ) {
			if ( $that->request->is_POST() ) {
				$post = $that->request->post;
                $that->load->language( 'option_price_pro_with_discount/option_price_pro_with_discount' );
				if ( isset( $post['option'] ) ) {
					$options = $post['option'];
                    $exist = false;
                    $products = $that->cart->getProducts();

                    $that->load->model('option_price_pro_with_discount/product');
                    $that->load->model('catalog/product');
                    $text_errors = [];
                    foreach ($options as $option_id => $option) {
                        $options_info = $that->model_option_price_pro_with_discount_product->getOptionType($option_id);
                        $option_type = $options_info['element_type'];
                        $option_name = $options_info['name'];
                        if ($option_type === 'G' || $option_type === 'M') {
                            $id = $option_id;
                            $settings = [];
                            $error = false;
                            $error_message = $default_message = '';
                            $settings = $that->model_option_price_pro_with_discount_product->getSettings($option_id);
                            if (!is_null($settings)) {
                                $minimum = $settings['minimum'];
                                $maximum = $settings['maximum'];
                                $status = $settings['maximum_status'];
                                $total = sizeof($options[$id]);

                                if ($status === '1') {
                                    if ($minimum !== '' && $total < $minimum) {
                                        $searchArray = ['{min}', '{total}'];
                                        $replaceArray = [$minimum, $total];
                                        $error_message = str_replace($searchArray, $replaceArray, $that->config->get('option_price_pro_with_discount_enter_minimum_warning'));
                                        $default_message = str_replace('{total}', $total, $that->language->get('error_pro_minimum_warning'));
                                        $default_message = $minimum . ' ' . $default_message;
                                        $error = true;
                                    } elseif ($maximum !== '' && $total > $maximum) {
                                        $searchArray = ['{max}', '{total}'];
                                        $replaceArray = [$maximum, $total];
                                        $error_message = str_replace($searchArray, $replaceArray, $that->config->get('option_price_pro_with_discount_enter_maximum_warning'));
                                        $searchDefaultArray = ['{max}', '{total}'];
                                        $replaceDefaultArray = [$maximum, $total];
                                        $default_message = str_replace($searchDefaultArray, $replaceDefaultArray, $that->language->get('error_pro_maximum_warning'));
                                        $error = true;
                                    }
                                } elseif ($status === '0') {
                                    if ($minimum !== '' && $total < $minimum) {
                                        $searchArray = ['{min}', '{total}'];
                                        $replaceArray = [$minimum, $total];
                                        $error_message = str_replace($searchArray, $replaceArray, $that->config->get('option_price_pro_with_discount_enter_minimum_warning'));
                                        $default_message = str_replace('{total}', $total, $that->language->get('error_pro_minimum_warning'));
                                        $default_message = $minimum . ' ' . $default_message;
                                        $error = true;
                                    }
                                }
                                if ($error === true) {
                                    if ($error_message !== '') {
                                        $text_errors[] = $option_name . ": " . $error_message;
                                    } else {
                                        $text_errors[] = $option_name . ": " . $default_message;
                                    }
                                }
                            }
                        }
                    }

					if ( $text_errors ) {
						$product_rt                   = 'product/product';
						$that->session->data['error'] = $text_errors;
						//send options values back via _GET
						$url = '&' . http_build_query( ['option' => $post['option'] ] );
						redirect( $that->html->getSecureURL( $product_rt, '&product_id=' . $post['product_id'] . $url ) );
					}
				}
			}
		}
	}

    public function onControllerPagesCheckoutCart_UpdateData() {
        $that = $this->baseObject;

        if (!$this->_is_enabled()) {
            return null;
        }

        if ($this->baseObject_method === 'main') {
            if ($that->cart->hasProducts()) {
                $cart_rt = 'checkout/cart';
                $product_rt = 'product/product';
                $checkout_rt = 'checkout/shipping';
                $that->loadModel('catalog/product_total_savings');
                $form = new AForm();
                $form->setForm(['form_name' => 'cart']);
                $that->data['form']['form_open'] = $form->getFieldHtml(
                    [
                        'type'   => 'form',
                        'name'   => 'cart',
                        'action' => $that->html->getSecureURL($cart_rt),
                    ]
                );

                $cart_products = $that->cart->getProducts() + $that->cart->getVirtualProducts();

                $product_ids = array_column($cart_products, 'product_id');

                $resource = new AResource('image');
                $thumbnails = $product_ids
                    ? $resource->getMainThumbList(
                        'products',
                        $product_ids,
                        $that->config->get('config_image_cart_width'),
                        $that->config->get('config_image_cart_height')
                    )
                    : [];

                $products = [];

                foreach ($cart_products as $result) {

                    $option_data = [];
                    $thumbnail = $thumbnails[$result['product_id']] ?: $result['thumb'];
                    foreach ($result['option'] as $option) {

                        $title = '';
                        if ($option['element_type'] == 'H') {
                            continue;
                        } //hide "hidden" options

                        $value = $option['value'];
                        // hide binary value for checkbox
                        if ($option['element_type'] == 'C' && in_array($value, [0, 1])) {
                            $value = '';
                        }

                        // strip long textarea value
                        if ($option['element_type'] == 'T') {
                            $title = strip_tags($value);
                            $title = str_replace('\r\n', "\n", $title);

                            $value = str_replace('\r\n', "\n", $value);
                            if (mb_strlen($value) > 64) {
                                $value = mb_substr($value, 0, 64).'...';
                            }
                        }

                        if ($value !== '' && $option['show_option_savings'] && ($option['savings'] !== '0' && $option['savings'] !== 0.00)) {
                            $savings = $that->tax->calculate(
                                $option['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );
                            $value.= ' - '.$that->config->get('option_price_pro_with_discount_other_page_option_savings_message').' '.$that->currency->format($savings);
                        }

                        $option_data[] = [
                            'name'  => $option['name'],
                            'value' => $value,
                            'title' => $title,
                        ];

                        // product image by option value
                        $mSizes = [
                            'main'  =>
                                [
                                    'width'  => $that->config->get('config_image_cart_width'),
                                    'height' => $that->config->get('config_image_cart_height'),
                                ],
                            'thumb' => [
                                'width'  => $that->config->get('config_image_cart_width'),
                                'height' => $that->config->get('config_image_cart_height'),
                            ],
                        ];

                        $main_image = $resource->getResourceAllObjects(
                            'product_option_value',
                            $option['product_option_value_id'],
                            $mSizes,
                            1,
                            false
                        );

                        if (!empty($main_image)) {
                            $thumbnail['origin'] = $main_image['origin'];
                            $thumbnail['title'] = $main_image['title'];
                            $thumbnail['description'] = $main_image['description'];
                            $thumbnail['thumb_html'] = $main_image['thumb_html'];
                            $thumbnail['thumb_url'] = $main_image['thumb_url'];
                        }
                    }

                    $price_with_tax = $that->tax->calculate(
                        $result['price'] ?: $result['amount'],
                        $result['tax_class_id'],
                        $that->config->get('config_tax')
                    );

                    $products[] = [
                        'remove'       => $form->getFieldHtml(
                            [
                                'type' => 'checkbox',
                                'name' => 'remove['.$result['key'].']',
                            ]
                        ),
                        'remove_url'   => $that->html->getSecureURL($cart_rt, '&remove='.$result['key']),
                        'key'          => $result['key'],
                        'name'         => $result['name'],
                        'model'        => $result['model'],
                        'thumb'        => $thumbnail,
                        'option'       => $option_data,
                        'quantity'     => $form->getFieldHtml(
                            [
                                'type'  => 'input',
                                'name'  => 'quantity['.$result['key'].']',
                                'value' => $result['quantity'],
                                'style' => 'short',
                                'attr'  => ' size="6" '
                                    .( (int)$result['maximum'] ? 'max="'.(int)$result['maximum'].'"' : '')
                                    .( ' min="'.(int)$result['minimum'].'"'),
                                'size'  => 6,
                                'max'   => (int)$result['maximum'],
                                'min'   => (int)$result['minimum']
                            ]
                        ),
                        'stock'        => $result['stock'],
                        'tax_class_id' => $result['tax_class_id'],
                        'price'        => $that->currency->format($price_with_tax),
                        'total'        => $that->currency->format_total($price_with_tax, $result['quantity']),
                        'href'         => $that->html->getSEOURL(
                            $product_rt,
                            '&product_id='.$result['product_id'].'&key='.$result['key'],
                            true
                        ),
                    ];

                    if ($result['savings']!==0.00) {
                        $savings = $that->tax->calculate(
                            $result['savings'],
                            $result['tax_class_id'],
                            $that->config->get('config_tax')
                        );

                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($result['product_id']);
                        if ($show_message['show_other_page_product_total_savings']=='1') {
                            $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('checkout_cart_product_' . $result['key'] . '_additional_info_1', $message->fetch('pages/checkout/checkout_cart_savings.tpl'));
                        }
                    }
                }

                $that->view->assign('products',$products);

                $that->processTemplate();
            }
        }
    }

    public function afterModelCheckoutOrder_create($products,$order_id) {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that  =& $this->baseObject;
        if ($order_id!==0 && $order_id!=='0') {
            $cart_products = $that->cart->getProducts();
            $order_id = $that->session->data['order_id'];
            if ($cart_products) {
                foreach ($cart_products as $result) {
                    if ($result['option']) {
                        foreach ($result['option'] as $option) {
                            $data['option_name'] = $option['name'];
                            $data['option_value'] = $option['value'];
                            $data['product_option_value_id'] = $option['product_option_value_id'];
                            $data['order_id'] = $order_id;
                            $order_options_info = $that->model_option_price_pro_with_discount_product->getOrderProductId($data);
                            $order_options_info['savings'] = $option['savings'];
                            $that->model_option_price_pro_with_discount_product->addSavingsToOrderOptions($order_options_info);
                        }
                    }

                    $data['product_name'] = $result['name'];
                    $data['order_id'] = $order_id;
                    $order_products_info = $that->model_option_price_pro_with_discount_product->getOrderProductId($data);

                    $data['order_id'] = $order_id;
                    $data['product_id'] = $result['product_id'];
                    $data['savings'] = $result['savings'];
                    $data['order_product_id'] = $order_products_info['order_product_id'];
                    $that->model_option_price_pro_with_discount_product->addSavingsToOrderProducts($data);
                }
            }
        }
    }

    public function onControllerPagesCheckoutConfirm_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $cart_products = $that->cart->getProducts() + $that->cart->getVirtualProducts();
            $order_id = $that->session->data['order_id'];
            $that->load->model('option_price_pro_with_discount/product');
            $that->load->model('catalog/product_total_savings');
            if ($cart_products) {
                foreach ($cart_products as $result) {
                    if ($result['option']) {
                        foreach ($result['option'] as $option) {
                            $data['option_name'] = $option['name'];
                            $data['option_value'] = $option['value'];
                            $data['product_option_value_id'] = $option['product_option_value_id'];
                            $data['order_id'] = $order_id;
                            $order_options_info = $that->model_option_price_pro_with_discount_product->getOrderProductId($data);
                            $order_options_info['savings'] = $option['savings'];
                            $that->model_option_price_pro_with_discount_product->addSavingsToOrderOptions($order_options_info);
                        }
                    }

                    $data['product_name'] = $result['name'];
                    $data['order_id'] = $order_id;
                    $order_products_info = $that->model_option_price_pro_with_discount_product->getOrderProductId($data);

                    $data['order_id'] = $order_id;
                    $data['product_id'] = $result['product_id'];
                    $data['savings'] = $result['savings'];
                    $data['order_product_id'] = $order_products_info['order_product_id'];
                    $that->model_option_price_pro_with_discount_product->addSavingsToOrderProducts($data);
                    if ($result['savings'] !== 0.00) {
                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($result['product_id']);
                        if ($show_message['show_other_page_product_total_savings'] == '1') {
                            $savings = $that->tax->calculate(
                                $result['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );
                            $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('checkout_confirm_product_' . $result['key'] . '_additional_info_1', $message->fetch('pages/checkout/order_confirm_savings.tpl'));
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesCheckoutGuestStep3_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $cart_products = $that->cart->getProducts();
            $order_id = $that->session->data['order_id'];
            if ($cart_products) {
                foreach ($cart_products as $result) {
                    if ($result['option']) {
                        foreach ($result['option'] as $option) {
                            $data['option_name'] = $option['name'];
                            $data['option_value'] = $option['value'];
                            $data['product_option_value_id'] = $option['product_option_value_id'];
                            $data['order_id'] = $order_id;
                            $order_options_info = $that->model_option_price_pro_with_discount_product->getOrderProductId($data);
                            $order_options_info['savings'] = $option['savings'];
                            $that->model_option_price_pro_with_discount_product->addSavingsToOrderOptions($order_options_info);
                        }
                    }

                    $data['product_name'] = $result['name'];
                    $data['order_id'] = $order_id;
                    $order_products_info = $that->model_option_price_pro_with_discount_product->getOrderProductId($data);

                    $data['order_id'] = $order_id;
                    $data['product_id'] = $result['product_id'];
                    $data['savings'] = $result['savings'];
                    $data['order_product_id'] = $order_products_info['order_product_id'];
                    $that->load->model('option_price_pro_with_discount/product');
                    $that->load->model('catalog/product_total_savings');
                    $that->model_option_price_pro_with_discount_product->addSavingsToOrderProducts($data);
                    if ($result['savings']!==0.00) {
                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($result['product_id']);
                        if ($show_message['show_other_page_product_total_savings']=='1') {
                            $savings = $that->tax->calculate(
                                $result['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );

                            $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('checkout_confirm_product_' . $result['key'] . '_additional_info_1', $message->fetch('pages/checkout/order_confirm_savings.tpl'));
                        }
                    }
                }
            }
        }
    }

    public function onControllerBlocksOrderSummary_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $cart_products = $that->cart->getProducts();
            $that->load->model('catalog/product_total_savings');
            $products = [];
            if ($cart_products) {
                $mSizes = [
                    'main'  =>
                        [
                            'width'  => $that->config->get('config_image_cart_width'),
                            'height' => $that->config->get('config_image_cart_height'),
                        ],
                    'thumb' => [
                        'width'  => $that->config->get('config_image_cart_width'),
                        'height' => $that->config->get('config_image_cart_height'),
                    ],
                ];
                $resource = new AResource('image');
                foreach ($cart_products as $result) {
                    $option_data = [];

                    foreach ($result['option'] as $option) {
                        $value = $option['value'];
                        // hide binary value for checkbox
                        if ($option['element_type'] == 'C' && in_array($value, [0, 1])) {
                            $value = '';
                        }
                        $title = '';
                        // strip long textarea value
                        if ($option['element_type'] == 'T') {
                            $title = strip_tags($value);
                            $title = str_replace('\r\n', "\n", $title);

                            $value = str_replace('\r\n', "\n", $value);
                            if (mb_strlen($value) > 64) {
                                $value = mb_substr($value, 0, 64).'...';
                            }
                        }

                        if ($value !== '' && $option['show_option_savings'] && ($option['savings'] !== '0' && $option['savings'] !== 0.00)) {
                            $savings = $that->tax->calculate(
                                $option['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );
                            $value.= ' - '.$that->config->get('option_price_pro_with_discount_other_page_option_savings_message').' '.$that->currency->format($savings);
                        }

                        $option_data[] = [
                            'name'  => $option['name'],
                            'value' => $value,
                            'title' => $title,
                        ];
                    }

                    $qty += $result['quantity'];

                    //get main image
                    $thumbnail = $resource->getMainImage(
                        'products',
                        $result['product_id'],
                        $that->config->get('config_image_grid_width'),
                        $that->config->get('config_image_grid_height')
                    );

                    $main_image = $resource->getResourceAllObjects(
                        'product_option_value',
                        $option['product_option_value_id'],
                        $mSizes,
                        1,
                        false
                    );

                    if (!empty($main_image)) {
                        $thumbnail['origin'] = $main_image['origin'];
                        $thumbnail['title'] = $main_image['title'];
                        $thumbnail['description'] = $main_image['description'];
                        $thumbnail['thumb_html'] = $main_image['thumb_html'];
                        $thumbnail['thumb_url'] = $main_image['thumb_url'];
                        $thumbnail['main_url'] = $main_image['main_url'];
                    }

                    $products[] = [
                        'key'       => $result['key'],
                        'name'      => $result['name'],
                        'option'    => $option_data,
                        'thumbnail' => $thumbnail,
                        'quantity'  => $result['quantity'],
                        'stock'     => $result['stock'],
                        'price'     => $that->currency->format(
                            $that->tax->calculate(
                                $result['price'] ?: $result['amount'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            )
                        ),
                        'href'      => $result['product_id']
                            ? $that->html->getSEOURL(
                                'product/product',
                                '&product_id='.$result['product_id'],
                                true
                            )
                            : null,
                    ];

                    if ($result['savings']!==0.00) {
                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($result['product_id']);
                        if ($show_message['show_other_page_product_total_savings']=='1') {
                            $savings = $that->tax->calculate(
                                $result['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );

                            $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('order_summary_product_' . $result['key'] . '_additional_info_1', $message->fetch('block/order_summary_savings.tpl'));
                        }
                    }
                    $that->view->assign('products',$products);
                }
            }
        }
    }

    public function onControllerBlocksCart_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $cart_products = $that->cart->getProducts() + $that->cart->getVirtualProducts();
            $product_ids = array_column($cart_products, 'product_id');
            $that->load->model('catalog/product_total_savings');
            if ($cart_products) {
                $products = [];
                $option_data = [];
                $resource = new AResource('image');
                $thumbnails = $product_ids
                    ? $resource->getMainThumbList(
                        'products',
                        $product_ids,
                        $that->config->get('config_image_additional_width'),
                        $that->config->get('config_image_additional_width')
                    )
                    : [];
                foreach ($cart_products as $result) {
                    $thumbnail = $thumbnails[$result['product_id']] ?: $result['thumb'];
                    foreach ($result['option'] as $option) {
                        $title = '';
                        if ($option['element_type'] == 'H') {
                            continue;
                        } //hide hidden options
                        $value = $option['value'];
                        // hide binary value for checkbox
                        if ($option['element_type'] == 'C' && in_array($value, [0, 1])) {
                            $value = '';
                        }
                        // strip long textarea value
                        if ($option['element_type'] == 'T') {
                            $title = strip_tags($value);
                            $title = str_replace('\r\n', "\n", $title);

                            $value = str_replace('\r\n', "\n", $value);
                            if (mb_strlen($value) > 64) {
                                $value = mb_substr($value, 0, 64) . '...';
                            }
                        }

                        if ($value !== '' && $option['show_option_savings'] && ($option['savings'] !== '0' && $option['savings'] !== 0.00)) {
                            $savings = $that->tax->calculate(
                                $option['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );
                            $value .= ' - ' . $that->config->get('option_price_pro_with_discount_other_page_option_savings_message') . ' ' . $that->currency->format($savings);
                        }

                        $option_data[] = [
                            'name' => $option['name'],
                            'value' => $value,
                            'title' => $title,
                        ];

                        // product image by option value
                        $mSizes = [
                            'main' =>
                                [
                                    'width' => $that->config->get('config_image_cart_width'),
                                    'height' => $that->config->get('config_image_cart_height'),
                                ],
                            'thumb' => [
                                'width' => $that->config->get('config_image_cart_width'),
                                'height' => $that->config->get('config_image_cart_height'),
                            ],
                        ];
                        $main_image = $resource->getResourceAllObjects(
                            'product_option_value',
                            $option['product_option_value_id'],
                            $mSizes,
                            1,
                            false
                        );

                        if (!empty($main_image)) {
                            $thumbnail['origin'] = $main_image['origin'];
                            $thumbnail['title'] = $main_image['title'];
                            $thumbnail['description'] = $main_image['description'];
                            $thumbnail['thumb_html'] = $main_image['thumb_html'];
                            $thumbnail['thumb_url'] = $main_image['thumb_url'];
                        }
                    }
                    $products[] = [
                        'key' => $result['key'],
                        'name' => $result['name'],
                        'option' => $option_data,
                        'quantity' => $result['quantity'],
                        'stock' => $result['stock'],
                        'price' => $that->currency->format(
                            $that->tax->calculate(
                                $result['price'] ?: $result['amount'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            )
                        ),
                        'href' => $that->html->getSEOURL(
                            'product/product',
                            '&product_id=' . $result['product_id'],
                            true
                        ),
                        'thumb' => $thumbnail,
                    ];


                    if ($result['savings'] !== 0.00) {
                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($result['product_id']);
                        if ($show_message['show_other_page_product_total_savings'] == '1') {
                            $savings = $that->tax->calculate(
                                $result['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );

                            $data['message'] = $that->config->get('option_price_pro_with_discount_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('cart_details_' . $result['key'] . '_additional_info_1', $message->fetch('responses/checkout/cart_details_savings.tpl'));
                        }
                    }
                }
                $that->data['products'] = $products;
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesCheckoutFastCheckoutSummary_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $cart_products = $that->cart->getProducts();
            $that->load->model('catalog/product_total_savings');
            if ($cart_products) {
                $resource = new AResource('image');
                $products = [];
                $mSizes = [
                    'main'  =>
                        [
                            'width'  => $that->config->get('config_image_cart_width'),
                            'height' => $that->config->get('config_image_cart_height'),
                        ],
                    'thumb' => [
                        'width'  => $that->config->get('config_image_cart_width'),
                        'height' => $that->config->get('config_image_cart_height'),
                    ],
                ];

                foreach ($that->cart->getProducts() as $result) {
                    $option_data = [];
                    $option = [];
                    foreach ($result['option'] as $option) {
                        $value = $option['value'];
                        // hide binary value for checkbox
                        if ($option['element_type'] == 'C' && in_array($value, [0, 1], true)) {
                            $value = '';
                        }
                        $title = '';
                        // strip long textarea value
                        if ($option['element_type'] == 'T') {
                            $title = strip_tags($value);
                            $title = str_replace('\r\n', "\n", $title);

                            $value = str_replace('\r\n', "\n", $value);
                            if (mb_strlen($value) > 64) {
                                $value = mb_substr($value, 0, 64).'...';
                            }
                        }

                        if ($value !== '' && $option['show_option_savings'] && ($option['savings'] !== '0' && $option['savings'] !== 0.00)) {
                            $savings = $that->tax->calculate(
                                $option['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );
                            $value.= ' - '.$that->config->get('option_price_pro_with_discount_other_page_option_savings_message').' '.$that->currency->format($savings);
                        }

                        $option_data[] = [
                            'name'  => $option['name'],
                            'value' => $value,
                            'title' => $title,
                        ];
                    }

                    $qty += $result['quantity'];

                    //get main image
                    $thumbnail = $resource->getMainImage(
                        'products',
                        $result['product_id'],
                        $that->config->get('config_image_grid_width'),
                        $that->config->get('config_image_grid_height')
                    );

                    $main_image = $resource->getResourceAllObjects(
                        'product_option_value',
                        $option['product_option_value_id'],
                        $mSizes,
                        1,
                        false
                    );

                    if (!empty($main_image)) {
                        $thumbnail['origin'] = $main_image['origin'];
                        $thumbnail['title'] = $main_image['title'];
                        $thumbnail['description'] = $main_image['description'];
                        $thumbnail['thumb_html'] = $main_image['thumb_html'];
                        $thumbnail['thumb_url'] = $main_image['thumb_url'];
                        $thumbnail['main_url'] = $main_image['main_url'];
                    }

                    $products[] = [
                        'key'       => $result['key'],
                        'name'      => $result['name'],
                        'thumbnail' => $thumbnail,
                        'option'    => $option_data,
                        'quantity'  => $result['quantity'],
                        'stock'     => $result['stock'],
                        'price'     => $that->currency->format(
                            $that->tax->calculate(
                                $result['price'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            )
                        ),
                        'href'      => $that->html->getSEOURL(
                            'product/product',
                            '&product_id='.$result['product_id'],
                            true
                        ),
                    ];
                }

                $that->view->assign('products',$products);

                foreach ($cart_products as $result) {
                    if ($result['savings']!==0.00) {
                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($result['product_id']);
                        if ($show_message['show_other_page_product_total_savings']=='1') {
                            $savings = $that->tax->calculate(
                                $result['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );

                            $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('fast_checkout_summary_product_' . $result['key'] . '_additional_info_1', $message->fetch('responses/checkout/fast_checkout_order_summary_savings.tpl'));
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesCheckoutFastCheckout_InitData() {
        if ( ! $this->_is_enabled() ) {
            return null;
        }
        $that =& $this->baseObject;
        if ( $this->baseObject_method === '__construct' ) {
            if ( $that->request->is_POST() ) {
                $that->load->model( 'option_price_pro_with_discount/product' );
                $that->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
                $fcSession =& $that->session->data['fc'];
                $cartClassName = get_class($that->cart);
                //create new cart with single product (onclick buy-now button)
                if ($that->request->get['single_checkout'] && $that->request->is_POST()) {
                    $post = $that->request->post;
                    $fcSession['single_checkout'] = $that->data['single_checkout'] = true;
                    $fcSession['cart'] = [];
                    $this->registry->set(
                        'cart',
                        new $cartClassName($this->registry, $fcSession)
                    );
                    if (isset($that->request->post['product_id'])) {
                        $that->loadModel('catalog/product', 'storefront');
                        $productId = $post['product_id'];

                        if (isset($post['option'])) {
                            $options = $post['option'];
                        } else {
                            $options = [];
                        }

                        //for FILE-attributes
                        if (has_value($that->request->files['option']['name'])) {
                            $fm = new AFile();
                            foreach ($that->request->files['option']['name'] as $id => $name) {
                                $attributeData = $that->model_catalog_product->getProductOption($productId, $id);
                                $attributeData['settings'] = unserialize($attributeData['settings']);
                                $filePathInfo = $fm->getUploadFilePath($attributeData['settings']['directory'], $name);

                                $options[$id] = $filePathInfo['name'];

                                if (!has_value($name)) {
                                    continue;
                                }

                                if ($attributeData['required'] && !$that->request->files['option']['size'][$id]) {
                                    $that->session->data['error'] = $that->language->get('error_required_options');
                                    redirect($_SERVER['HTTP_REFERER']);
                                }

                                $fileData = [
                                    'option_id' => $id,
                                    'name'      => $filePathInfo['name'],
                                    'path'      => $filePathInfo['path'],
                                    'type'      => $that->request->files['option']['type'][$id],
                                    'tmp_name'  => $that->request->files['option']['tmp_name'][$id],
                                    'error'     => $that->request->files['option']['error'][$id],
                                    'size'      => $that->request->files['option']['size'][$id],
                                ];

                                $fileErrors = $fm->validateFileOption($attributeData['settings'], $fileData);

                                if (has_value($fileErrors)) {
                                    $that->session->data['error'] = implode('<br/>', $fileErrors);
                                    redirect($_SERVER['HTTP_REFERER']);
                                } else {
                                    $result = move_uploaded_file($fileData['tmp_name'], $filePathInfo['path']);

                                    if (!$result || $that->request->files['package_file']['error']) {
                                        $that->session->data['error'] .= '<br>Error: '.getTextUploadError(
                                                $that->request->files['option']['error'][$id]
                                            );
                                        redirect($_SERVER['HTTP_REFERER']);
                                    }
                                }

                                $dataset = new ADataset('file_uploads', 'admin');
                                $dataset->addRows(
                                    [
                                        'date_added' => date("Y-m-d H:i:s", time()),
                                        'name'       => $filePathInfo['name'],
                                        'type'       => $fileData['type'],
                                        'section'    => 'product_option',
                                        'section_id' => $attributeData['attribute_id'],
                                        'path'       => $filePathInfo['path'],
                                    ]
                                );
                            }
                        }

                        foreach ( $options as $option_id => $option ) {
                            $options_info = $that->model_option_price_pro_with_discount_product->getOptionType( $option_id );
                            $option_type  = $options_info['element_type'];
                            $option_name  = $options_info['name'];
                            if ( $option_type === 'G' || $option_type === 'M' ) {
                                $id            = $option_id;
                                $settings      = [];
                                $error         = false;
                                $error_message = $default_message = '';
                                $settings      = $that->model_option_price_pro_with_discount_product->getSettings( $option_id );
                                if ( ! is_null( $settings ) ) {
                                    $minimum = $settings['minimum'];
                                    $maximum = $settings['maximum'];
                                    $status  = $settings['maximum_status'];
                                    $total   = sizeof( $options[ $id ] );
                                    if ( $status === '1' ) {
                                        if ( $minimum !== '' && $total < $minimum ) {
                                            $searchArray     = [ '{min}', '{total}' ];
                                            $replaceArray    = [ $minimum, $total ];
                                            $error_message   = str_replace( $searchArray, $replaceArray, $that->config->get( 'option_price_pro_with_discount_enter_minimum_warning' ) !=='0' ?: $that->config->get( 'option_price_pro_with_discount_enter_minimum_warning' ) );
                                            $default_message = str_replace( '{total}', $total, $that->language->get( 'error_pro_minimum_warning' ) );
                                            $default_message = $minimum . ' ' . $default_message;
                                            $error           = true;
                                        } elseif ( $maximum !== '' && $total > $maximum ) {
                                            $searchArray         = [ '{max}', '{total}' ];
                                            $replaceArray        = [ $maximum, $total ];
                                            $error_message       = str_replace( $searchArray, $replaceArray, $that->config->get( 'option_price_pro_with_discount_enter_maximum_warning' ) !=='0' ?: $that->config->get( 'option_price_pro_with_discount_enter_maximum_warning' ));
                                            $searchDefaultArray  = [ '{max}', '{total}' ];
                                            $replaceDefaultArray = [ $maximum, $total ];
                                            $default_message     = str_replace( $searchDefaultArray, $replaceDefaultArray, $that->language->get( 'error_pro_maximum_warning' ) );
                                            $error               = true;
                                        }
                                    } elseif ( $status === '0' ) {
                                        if ( $minimum !== '' && $total < $minimum ) {
                                            $searchArray     = [ '{min}', '{total}' ];
                                            $replaceArray    = [ $minimum, $total ];
                                            $error_message   = str_replace( $searchArray, $replaceArray, $that->config->get( 'option_price_pro_with_discount_enter_minimum_warning' ) !=='0' ?: $that->config->get( 'option_price_pro_with_discount_enter_minimum_warning' ) );
                                            $default_message = str_replace( '{total}', $total, $that->language->get( 'error_pro_minimum_warning' ) );
                                            $default_message = $minimum . ' ' . $default_message;
                                            $error           = true;
                                        }
                                    }
                                    if ( $error === true ) {
                                        if ( $error_message !== '' ) {
                                            $errors[] = $option_name . ": " . $error_message;
                                        } else {
                                            $errors[] = $option_name . ": " . $default_message;
                                        }
                                    }
                                }
                            }
                        }

                        if ($errors) {
                            $that->session->data['error'] = $errors;
                            //send options values back via _GET
                            $url = '&'.http_build_query(['option' => $post['option']]);
                            redirect(
                                $that->html->getSecureURL(
                                    'product/product',
                                    '&product_id='.$post['product_id'].$url
                                )
                            );
                        } elseif ($textErrors = $that->model_catalog_product->validateProductOptions($productId, $options)) {
                            $that->session->data['error'] = $textErrors;
                            //send options values back via _GET
                            $url = '&'.http_build_query(['option' => $post['option']]);
                            redirect(
                                $that->html->getSecureURL(
                                    'product/product',
                                    '&product_id='.$post['product_id'].$url
                                )
                            );
                        }

                        $that->cart->add($post['product_id'], $post['quantity'], $options);
                        $productCartKey = !$options ? $productId : $productId.':'.md5(serialize($options));
                        if (!$that->cart->hasProducts() || (!$that->cart->hasStock() && !$that->config->get('config_stock_checkout'))) {
                            $that->session->data['error'] = $that->language->get('fast_checkout_text_not_enough_stock');
                            //send options values back via _GET
                            $url = '&'.http_build_query(['option' => $post['option']]);
                            redirect(
                                $that->html->getSecureURL(
                                    'product/product',
                                    '&product_id='.$post['product_id'].$url
                                )
                            );
                        }
                    }
                    //if we added single product via POST request - do redirect to self
                    redirect($that->html->getSecureURL('checkout/fast_checkout', '&fc=1&product_key='.$productCartKey));
                } //do clone of default cart
                else {
                    if (!$fcSession['single_checkout']) {
                        $fcSession['single_checkout'] = false;
                    }
                    $fcSession['cart'] = $fcSession['cart'] ? : $that->session->data['cart'];
                    $this->removeNoStockProducts();
                    if (isset($that->session->data['coupon'])) {
                        $fcSession['coupon'] = $that->session->data['coupon'];
                    }
                    $this->registry->set(
                        'cart',
                        new $cartClassName($this->registry, $fcSession)
                    );
                }
            }
        }
    }

    protected function removeNoStockProducts() {
        $that =& $this->baseObject;
        $cartProducts = $that->cart->getProducts();
        foreach ($cartProducts as $key => $cartProduct) {
            if (!$cartProduct['stock'] && !$that->config->get('config_stock_checkout')) {
                unset(
                    $that->session->data['fc']['cart'][$key]
                );
            }
        }
    }

    public function onControllerPagesProductProduct_UpdateData() {
        if ( ! $this->_is_enabled() ) {
            return null;
        }
        if ( $this->baseObject_method === 'main' ) {
            if ( $this->verifyAreaCalculator()===false
                && $this->verifyLengthCalculator()===false
                && $this->verifyWeightCalculator()===false
                && $this->verifyLiquidsCalculator()===false
                && $this->verifyVolumeCalculator()===false
            ) {
                $key = [];
                $that = $this->baseObject;
                $request = $that->request->get;
                $cart = new ACart($this->registry);
                //if ($calc_status === '0' || is_null($calc_status) || empty($calc_status)) {
                $key = [];
                $option_price = '';
                if (has_value($that->request->get['key'])) {
                    $key = explode(':', $that->request->get['key']);
                    $product_id = (int)$key[0];
                } elseif (has_value($that->request->get['product_id'])) {
                    $product_id = (int)$that->request->get['product_id'];
                } else {
                    $product_id = 0;
                }
                $that->loadModel('catalog/product');
                $that->loadModel('option_price_pro_with_discount/product');
                $product_info = $that->model_catalog_product->getProduct($product_id);

                $promotion = new APromotion();
                $discount = $promotion->getProductDiscount($product_id);

                //Need to round price after discounts and specials
                //round main price to currency decimal_place setting (most common 2, but still...)

                $currency = $that->currency->getCurrency();
                $decimal_place = (int) $currency['decimal_place'];
                $decimal_place = !$decimal_place ? 2 : $decimal_place;
                $discounts = 0;
                if ($discount) {
                    $product_price = round((float)$discount, $decimal_place);
                    $this->data['price_num'] = round($that->tax->calculate(
                        $discount,
                        $product_info['tax_class_id'],
                        (bool)$that->config->get('config_tax')
                    ),
                    $decimal_place);
                    $this->data['special'] = false;
                } else {
                    $product_price = round((float)$product_info['price'], $decimal_place);
                    $this->data['price_num'] = round($that->tax->calculate(
                        $product_info['price'],
                        $product_info['tax_class_id'],
                        (bool)$that->config->get('config_tax')
                    ),
                    $decimal_place);

                    $special = $promotion->getProductSpecial($product_id);
                    if ($special) {
                        $discounts = $product_price - $special;
                        $product_price = round($special, $decimal_place);

                        $this->data['special_num'] = round($that->tax->calculate(
                            $special,
                            $product_info['tax_class_id'],
                            (bool)$that->config->get('config_tax')
                        ),
                        $decimal_place);
                    } else {
                        $this->data['special'] = false;
                    }
                }

                $elements_with_options = HtmlElementFactory::getElementsWithOptions();
                $product_options = $that->model_catalog_product->getProductOptions($product_id);

                $options = [];
                $cart_product_info = [];
                if ($key) {
                    $cart_product_info = $cart->getProduct($that->request->get['key']);
                }

                $special_price_info = $that->model_option_price_pro_with_discount_product->getProductSpecial($product_id);

                foreach ($product_options as $option) {
                    $configs = $that->model_option_price_pro_with_discount_product->getBasePrice($option['product_option_id']);

                    $calculate = $configs['calculate'];
                    $calculate_option_discount = $configs['calculate_option_discount'];
                    $show_option_discount = $configs['show_option_savings'];
                    $base_price = $configs['base_price'];
                    $values = [];
                    $disabled_values = [];
                    $name = $price = '';
                    $default_value = $cart_product_info['options'][$option['product_option_id']];
                    if ($option['element_type'] == 'R') {
                        $default_value = is_array($default_value) ? current($default_value) : (string)$default_value;
                    }
                    $preset_value = $default_value;
                    $option_discount = 0;
                    foreach ($option['option_value'] as $option_value) {
                        $default_value = $option_value['default'] ? $option_value['product_option_value_id'] : $default_value;
                        // for case when trying to add to cart withot required options. we get option-array back inside _GET
                        if (has_value($that->request->get['option'][$option['product_option_id']])) {
                            $default_value = $that->request->get['option'][$option['product_option_id']];
                        }

                        $option_price = $option_value['price'];
                        $option_pricing = $option_value['price'];
                        if ($calculate_option_discount==='1') {
                            if ($special_price_info['price_prefix'] === '%') {
                                if ($option_value['prefix'] === '%') {
                                    $option_pricing = (float)($product_info['price'] * ($option_value['price'] / 100));
                                    $option_price = $option_pricing - ($option_pricing * $special_price_info['price'] / 100);
                                } else {
                                    $option_price = (float)$option_value['price'] - ((float)$option_value['price'] * ($special_price_info['price'] / 100));
                                }
                            } else {
                                if ($option_value['prefix'] === '%') {
                                    $option_pricing = (float)($product_info['price'] * ($option_value['price'] / 100));
                                    $option_price = $option_pricing - ($option_pricing * $special_price_info['price'] / 100);
                                } else {
                                    $option_price = (float)$option_price - (float)$special_price_info['price'];
                                }
                            }
                            $option_discount = $option_pricing - $option_price;

                        } else {
                            if ($option_value['prefix'] === '%') {
                                $option_price = (float)$product_info['price'] * ($option_value['price'] / 100);
                            }
                        }

                        $name = $option_value['name'];
                        //check if we disable options based on out of stock setting
                        if ($option_value['subtract'] && $that->config->get('config_nostock_autodisable') && $option_value['quantity'] <= 0) {
                            continue;
                        }

                        //Apply option price modifier
                        if ($option_value['prefix'] === '%') {
                            if ($calculate === '0') {
                                $price = round($that->tax->calculate(
                                    $option_price,
                                    $product_info['tax_class_id'],
                                    (bool)$that->config->get('config_tax')),$decimal_place);
                            } else {
                                $price = round($that->tax->calculate(
                                    $product_price + $option_price,
                                    $product_info['tax_class_id'],
                                    (bool)$that->config->get('config_tax')),$decimal_place);
                            }
                            if ($price != 0) {
                                $price = $that->currency->format($price);
                            } else {
                                $price = '';
                            }
                        } else {
                            if ($calculate === '0') {
                                $price = round($that->tax->calculate($option_price, $product_info['tax_class_id'], (bool)$that->config->get('config_tax')),$decimal_place);
                            } else {
                                $price = round($that->tax->calculate($product_price + $option_price, $product_info['tax_class_id'], (bool)$that->config->get('config_tax')),$decimal_place);
                            }
                            if ($price != 0) {
                                $price = $that->currency->format($price);
                            } else {
                                $price = '';
                            }
                        }

                        if ($option_discount!==0.00 && $show_option_discount) {
                            if ($calculate !=='0') {
                                $discount_price = $option_discount+$discounts;
                                $price .= ' - ' . $that->config->get('option_price_pro_with_discount_per_option_savings_message') . ' ' . $that->currency->format($discount_price);
                            } else {
                                $price .= ' - ' . $that->config->get('option_price_pro_with_discount_per_option_savings_message') . ' ' . $that->currency->format($option_discount);
                            }
                        }
                        $opt_stock_message = '';
                        //if options has stock tracking and not allowed to be purchased out of stock
                        if ($option_value['subtract'] && !$product_info['stock_checkout']) {
                            if ($option_value['quantity'] <= 0) {
                                //show out of stock message
                                $opt_stock_message = $that->language->get('text_out_of_stock');
                                $disabled_values[] = $option_value['product_option_value_id'];
                            } else {
                                if ($that->config->get('config_stock_display')) {
                                    if ($option_value['quantity'] > 0) {
                                        $opt_stock_message = $option_value['quantity'] . " " . $that->language->get('text_instock');
                                        $opt_stock_message = "($opt_stock_message)";
                                    }
                                }
                            }
                        } else {
                            if ($option_value['subtract'] && $product_info['stock_checkout']) {
                                if ($option_value['quantity'] <= 0) {
                                    $opt_stock_message = $product_info['stock_status'] ? "({$product_info['stock_status']})" : '';
                                }
                            }
                        }

                        $optionSeparator = $that->config->get('option_price_pro_with_discount_name_separator');
                        $priceSeparator = $that->config->get('option_price_pro_with_discount_price_separator');
                        if ($optionSeparator === '0') {
                            $optionSymbol = '&nbsp;&nbsp;';
                        } else {
                            $optionSymbol = '&nbsp;' . $optionSeparator . '&nbsp;';
                        }

                        if ($opt_stock_message) {
                            if ($priceSeparator === '' || $priceSeparator === '0') {
                                $priceSymbol = '&nbsp;&nbsp;&nbsp;';
                            } else {
                                $priceSymbol = '&nbsp;' . $priceSeparator . '&nbsp;';
                            }
                        } else {
                            $priceSymbol = '';
                        }

                        if (!empty($opt_stock_message)) {
                            $stock_message = $priceSymbol . $opt_stock_message;
                        } else {
                            $stock_message = '';
                        }

                        if ($base_price === '1' && $price !== '') {
                            $values[$option_value['product_option_value_id']] = $name . $optionSymbol . $price . $stock_message;
                        } else {
                            if ($option_price != '0.0000' && $price !== '') {
                                $values[$option_value['product_option_value_id']] = $name . $optionSymbol . $price . $stock_message;
                            } else {
                                $values[$option_value['product_option_value_id']] = $name . $stock_message;
                            }
                        }

                        if ($option['element_type'] == 'B') {
                            $name = $default_value = preg_replace("/\r|\n/", " ", $option_value['name']);
                            if ($price) {
                                $default_value .= '</br>';
                                $name .= ' ';
                            }
                            if ($price) {
                                $default_value .= $price . ' ';
                                $name .= $price;
                            }
                            $option['required'] = false;
                        }
                    }

                    //if not values are build, nothing to show
                    if (sizeof($values)) {
                        $value = $attr = '';
                        //add price to option name if it is not element with options
                        if (!in_array($option['element_type'], $elements_with_options) && $option['element_type'] != 'B') {
                            if ($option_price === '0.0000') {
                                if ($opt_stock_message) {
                                    $option['name'] .= '<br />' . $opt_stock_message;
                                }
                            } else {
                                $option['name'] .= ' <small>' . $price . '</small>';
                                if ($opt_stock_message) {
                                    $option['name'] .= '<br />' . $opt_stock_message;
                                }
                            }
                            $value = $name;
                        } else {
                            if ($option['element_type'] == 'B') {
                                $value = $name;
                            }
                        }

                        //set default selection is nothing selected
                        if (!has_value($value)) {
                            if (has_value($default_value)) {
                                $value = $default_value;
                            }
                        }

                        if ($option['element_type'] == 'C') {
                            if ($value == '') {
                                $value = 1;
                            }
                            $attr = key($option['option_value']);
                        }

                        if ($option['element_type'] == 'C') {
                            if (!in_array($value, ['0', '1'])) {
                                $option_data['label_text'] = $value;
                            }
                            $option_data['checked'] = (bool) $preset_value;
                        }
                        $option_data['attr'] = ' data-attribute-value-id="' . $attr . '"';
                        $option_data['disabled_options'] = $disabled_values;

                        $option_data = [
                            'type' => $option['html_type'],
                            'name' =>
                                !in_array($option['element_type'], HtmlElementFactory::getMultivalueElements())
                                    ? 'option[' . $option['product_option_id'] . ']'
                                    : 'option[' . $option['product_option_id'] . '][]',
                            'attr' => ' data-attribute-value-id="' . $attr . '"',
                            'value' => $value,
                            'options' => $values,
                            'disabled_options' => $disabled_values,
                            'required' => $option['required'],
                            'placeholder' => $option['option_placeholder'],
                            'regexp_pattern' => $option['regexp_pattern'],
                            'error_text' => $option['error_text']
                        ];

                        $options[] = [
                            'name' => $option['name'],
                            'html' => $that->html->buildElement($option_data),  // not a string!!! it's object!
                        ];
                    }
                }
                $this->data['options'] = $options;
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

	public function onControllerResponsesProductProduct_UpdateData() {
		if ( ! $this->_is_enabled() ) {
			return null;
		}
		$that        = $this->baseObject;
		if ( $this->baseObject_method === 'load_option' ) {
            $type = $that->data['option_data']['element_type'];
            if ($type!=='LQ' && $type!=='V' && $type!=='W' && $type!=='X' && $type!=='Y') {
                $that->loadLanguage('option_price_pro_with_discount/option_price_pro_with_discount');
                $that->load->model('option_price_pro_with_discount/options');
                $product_id = $that->request->get['product_id'];
                $this->data['fields'] = [
                    'entry_status' => 'status',
                    'entry_option_name' => 'option_name',
                    'entry_option_placeholder' => 'option_placeholder',
                    'entry_sort_order' => 'option_sort_order',
                    'entry_required' => 'required',
                    'entry_calculate' => 'calculate',
                    'entry_calculate_option_discount' => 'calculate_option_discount',
                    'entry_show_option_savings' => 'show_option_savings',
                    'entry_base_price' => 'base_price',
                    'entry_maximum_status' => 'maximum_status',
                    'entry_minimum' => 'minimum',
                    'entry_maximum' => 'maximum',
                    'entry_allowed_extensions' => 'extensions',
                    'entry_min_size' => 'min_size',
                    'entry_max_size' => 'max_size',
                    'entry_upload_dir' => 'directory',
                    'entry_regexp_pattern' => 'option_regexp_pattern',
                    'entry_error_text' => 'option_error_text'
                ];
                $this->data['calculate'] = $that->html->buildElement([
                    'type' => 'checkbox',
                    'name' => 'calculate',
                    'value' => $that->data['option_data']['calculate'],
                    'style' => 'btn_switch btn-group-xs',
                ]);

                $discounts = $that->model_option_price_pro_with_discount_options->getPriceDiscount($product_id);
                $special_prefix = $that->model_option_price_pro_with_discount_options->getPriceSpecialCalculation($product_id);

                if (!$discounts && $special_prefix==='%') {
                    $this->data['calculate_option_discount'] = $that->html->buildElement([
                        'type' => 'checkbox',
                        'name' => 'calculate_option_discount',
                        'value' => $that->data['option_data']['calculate_option_discount'],
                        'style' => 'btn_switch btn-group-xs',
                    ]);

                    $this->data['show_option_savings'] = $that->html->buildElement([
                        'type' => 'checkbox',
                        'name' => 'show_option_savings',
                        'value' => $that->data['option_data']['show_option_savings'],
                        'style' => 'btn_switch btn-group-xs',
                    ]);
                }

                $this->data['base_price'] = $that->html->buildElement([
                    'type' => 'checkbox',
                    'name' => 'base_price',
                    'value' => $that->data['option_data']['base_price'],
                    'style' => 'btn_switch btn-group-xs',
                ]);

                $type = $that->data['option_data']['element_type'];
                $option_id  = (int) $that->request->get['option_id'];
                $that->load->model( 'option_price_pro_with_discount/options' );
                $option_settings = $that->model_option_price_pro_with_discount_options->getSettings( $option_id );

                if ($type === 'G' || $type === 'M') {
                    $this->data['entry_maximum_status'] = $that->language->get('text_pro_maximum_status');
                    $this->data['maximum_status'] = $that->html->buildElement([
                        'type' => 'checkbox',
                        'name' => 'maximum_status',
                        'value' => $option_settings['maximum_status'],
                        'style' => 'btn_switch btn-group-xs',
                    ]);
                    $this->data['entry_minimum'] = $that->language->get('enter_pro_minimum');
                    $this->data['minimum'] = $that->html->buildElement([
                        'type' => 'input',
                        'name' => 'minimum',
                        'value' => $option_settings['minimum'],
                        'style' => 'tiny-field'
                    ]);
                    $this->data['entry_maximum'] = $that->language->get('enter_pro_maximum');
                    $this->data['maximum'] = $that->html->buildElement([
                        'type' => 'input',
                        'name' => 'maximum',
                        'value' => $option_settings['maximum'],
                        'style' => 'tiny-field'
                    ]);
                }

                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        } elseif ($this->baseObject_method==='update_option_values') {
            $that->load->model('option_price_pro_with_discount/options');
            $that->model_option_price_pro_with_discount_options->updateProductOptionValues($that->request->get['product_id'], $that->request->get['option_id'], $that->request->post);
        }  elseif ($this->baseObject_method==='update_option') {
            $that->load->model('option_price_pro_with_discount/options');
            $data['minimum']=$that->request->get['minimum'];
            $data['maximum']=$that->request->get['maximum'];
            $data['maximum_status']=$that->request->get['maximum_status'];
            $that->model_option_price_pro_with_discount_options->updateProductOption( $that->request->get['option_id'], $that->request->get);
            $that->model_option_price_pro_with_discount_options->addSettings($that->request->get['option_id'],$data);
        } elseif ($this->baseObject_method==='calculateTotal') {
            if (has_value($that->request->post['product_id']) && is_numeric($that->request->post['product_id'])) {
                $product_id = $that->request->post['product_id'];
                $config_tax = $that->request->get['admin'] ? 0 : (int) $that->config->get('config_tax');

                $option = $that->request->post['option'] ?? [];
                $quantity = (int)$that->request->post['quantity'] ?: 1;

                $result = $that->cart->buildProductDetails($product_id, $quantity, $option);
                $output['price'] = $that->tax->calculate(
                    $result['price'],
                    $result['tax_class_id'],
                    $config_tax
                );

                $output['original_option_price'] = $that->tax->calculate(
                    $result['original_option_price'],
                    $result['tax_class_id'],
                    $config_tax
                );

                if ($result['original_option_price'] !==0.00 && $result['original_option_price'] !== $result['total']) {
                    $output['total'] = $that->currency->format_total($output['price'], $quantity).'&nbsp;&nbsp;<s>'.$that->currency->format($output['original_option_price']).'</s>';
                } else {
                    $output['total'] = $that->currency->format_total($output['price'], $quantity);
                }

                $that->load->model('catalog/product_total_savings');

                $show_product_total_savings = $that->model_catalog_product_total_savings->getProductSavings($product_id);

                if ($show_product_total_savings['show_product_total_savings']==='1' && $result['savings']!==0.00) {
                   $output['total'] .= ' <br> <label class="control-label">' . $that->config->get('option_price_pro_with_discount_product_page_savings_message') . ' ' . $that->currency->format($result['savings']) . '</label>';
                }

                $output['price'] = $that->currency->format($output['price']);
                $output['original_option_price'] = $that->currency->format($output['original_option_price']);
                $that->data['output'] = $output;
            }
        } elseif ($this->baseObject_method === 'get_cart_details') {
            $cart_products = $that->cart->getProducts() + $that->cart->getVirtualProducts();
            $product_ids = array_column($cart_products, 'product_id');
            $resource = new AResource('image');
            $thumbnails = $product_ids
                ? $resource->getMainThumbList(
                    'products',
                    $product_ids,
                    $that->config->get('config_image_product_width'),
                    $that->config->get('config_image_product_height')
                )
                : $product_ids;
            $products = [];
            if ($cart_products) {
                foreach ($cart_products as $result) {
                    $option_data = [];
                    $thumbnail = $thumbnails[$result['product_id']] ?: $result['thumb'];
                    foreach ($result['option'] as $option) {
                        $value = $option['value'];
                        // hide binary value for checkbox
                        if ($option['element_type'] == 'C' && in_array($value, [0, 1])) {
                            $value = '';
                        }
                        // strip long textarea value
                        $title = '';
                        if ($option['element_type'] == 'T') {
                            $title = strip_tags($value);
                            $title = str_replace('\r\n', "\n", $title);

                            $value = str_replace('\r\n', "\n", $value);
                            if (mb_strlen($value) > 64) {
                                $value = mb_substr($value, 0, 64).'...';
                            }
                        }

                        if ($value !== '' && $option['show_option_savings'] && ($option['savings'] !== '0' && $option['savings'] !== 0.00)) {
                            $savings = $that->tax->calculate(
                                $option['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );
                            $value.= ' <br> - '.$that->config->get('option_price_pro_with_discount_other_page_option_savings_message').' '.$that->currency->format($savings);
                        }

                        $option_data[] = [
                            'name'  => $option['name'],
                            'value' => $value,
                            'title' => $title,
                        ];

                        // product image by option value
                        $mSizes = [
                            'main'  =>
                                [
                                    'width'  => $that->config->get('config_image_cart_width'),
                                    'height' => $that->config->get('config_image_cart_height'),
                                ],
                            'thumb' => [
                                'width'  => $that->config->get('config_image_cart_width'),
                                'height' => $that->config->get('config_image_cart_height'),
                            ],
                        ];
                        $main_image = $resource->getResourceAllObjects(
                            'product_option_value',
                            $option['product_option_value_id'],
                            $mSizes,
                            1,
                            false
                        );

                        if (!empty($main_image)) {
                            $thumbnail['origin'] = $main_image['origin'];
                            $thumbnail['title'] = $main_image['title'];
                            $thumbnail['description'] = $main_image['description'];
                            $thumbnail['thumb_html'] = $main_image['thumb_html'];
                            $thumbnail['thumb_url'] = $main_image['thumb_url'];
                        }
                    }

                    $products[] = [
                        'key'      => $result['key'],
                        'name'     => $result['name'],
                        'option'   => $option_data,
                        'quantity' => $result['quantity'],
                        'stock'    => $result['stock'],
                        'price'    => $that->currency->format(
                            $that->tax->calculate(
                                $result['price'] ?: $result['amount'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            )
                        ),
                        'href'     => $result['product_id'] ? $that->html->getSEOURL('product/product', '&product_id='.$result['product_id']) : null,
                        'thumb'    => $thumbnail,
                    ];

                    if ($result['savings']!==0.00) {
                        $that->load->model('catalog/product_total_savings');
                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($result['product_id']);
                        if ($show_message['show_other_page_product_total_savings']=='1') {
                            $savings = $that->tax->calculate(
                                $result['savings'],
                                $result['tax_class_id'],
                                $that->config->get('config_tax')
                            );

                            $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('cart_details_' . $result['key'] . '_additional_info_1', $message->fetch('responses/checkout/cart_details_savings.tpl'));
                        }
                    }
                }
                $that->view->assign('products',$products);
            }
        }
	}

    public function onACart_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'ACart::buildProductDetails') {
            $args = func_get_args();
            $output = $that->data['output'];

            $product_id = $output['product_id'];
            $that->load->model('option_price_pro_with_discount/product');
            $sf_product_mdl = $that->load->model('catalog/product', 'storefront');
            $customer_group_id = $that->customer->getCustomerGroupId();
            $product_query = $sf_product_mdl->getProductDataForCart($product_id);
            $quantity = $output['quantity'];
            $option_data=$output['option'];
            $discount_quantity = 0; // this is used to calculate total QTY of 1 product in the cart

            // check is product is in cart and calculate quantity to define item price with product discount
            if ($that->customer->isLogged()) {
                $cart_products = $that->customer->getCustomerCart();
                $customer_group_id = $that->customer->getCustomerGroupId();
            } else {
                $cart_products = $that->session->data['cart'];
                $customer_group_id = $that->session->data['customer_group_id'];
            }
            $promotion = new APromotion($customer_group_id);

            $that->load->model('option_price_pro_with_discount/product');

            $special_price_info = $that->model_option_price_pro_with_discount_product->getProductSpecial($product_id);

            foreach ($cart_products as $k => $v) {
                $array2 = explode(':', $k);
                if ($array2[0] == $product_id) {
                    $discount_quantity += $v['qty'];
                }
            }

            if (!$discount_quantity) {
                $discount_quantity = $quantity;
            }

            //Apply group and quantity discount first and if non, reply product discount
            $orig_price = $product_query['price'];
            $price = $promotion->getProductQtyDiscount($product_id, $discount_quantity);
            if (!$price) {
                $price = $promotion->getProductSpecial($product_id);
            }
            //Still no special price, use regular price
            if (!$price) {
                $price = $product_query['price'];
            }

            $option_price = $original_option_price = 0;

            foreach ($option_data as $item) {
                $configs = $that->model_option_price_pro_with_discount_product->getBasePrice($item['product_option_id']);
                $calculate_option_discount = $configs['calculate_option_discount'];
                $show_option_savings = $configs['show_option_savings'];
                $currency = $that->currency->getCurrency();

                if ($item['prefix'] === '%') {
                    $original_option_price += (float)$orig_price * ($item['price'] / 100);
                } else {
                    $original_option_price += $item['price'];
                }

                $savings = 0;
                if ($calculate_option_discount === '1') {
                    if ($special_price_info['price_prefix'] === '%') {
                        if ($item['prefix'] === '%') {
                            $option_pricing = (float)($orig_price * ($item['price'] / 100));
                            $option_price += $option_pricing - ($option_pricing * $special_price_info['price'] / 100);
                            $savings = $option_pricing - ($option_pricing - ($option_pricing * $special_price_info['price'] / 100));
                        } else {
                            $option_price += (float)$item['price'] - ((float)$item['price'] * ($special_price_info['price'] / 100));
                            $savings = $item['price'] - ((float)$item['price'] - ((float)$item['price'] * ($special_price_info['price'] / 100)));
                        }
                    } else {
                        if ($item['prefix'] === '%') {
                            $option_pricing = (float)($orig_price * ($item['price'] / 100));
                            $option_price += $option_pricing - ($option_pricing * $special_price_info['price'] / 100);
                            $savings = $option_pricing - ($option_pricing * $special_price_info['price'] / 100);
                        } else {
                            $option_price += (float)$item['price'] - $special_price_info['price'];
                            $savings = (float)$item['price'] - ((float)$item['price'] - $special_price_info['price']);
                        }
                    }
                } else {
                    if ($item['prefix'] === '%') {
                        $option_price += (float)$orig_price * ($item['price'] / 100);
                    } else {
                        $option_price += $item['price'];
                    }
                }

                $options[] = [
                    'product_option_value_id' => $item['product_option_value_id'],
                    'product_option_id'       => $item['product_option_id'],
                    'name'                    => $item['name'],
                    'element_type'            => $item['element_type'],
                    'settings'                => $item['settings'],
                    'value'                   => $item['value'],
                    'prefix'                  => $item['prefix'],
                    'price'                   => $item['price'],
                    'savings'                 => $savings,
                    'show_option_savings'     => $show_option_savings,
                    'cost'                    => $item['cost'],
                    'sku'                     => $item['sku'],
                    'inventory_quantity'      => $item['inventory_quantity'],
                    'weight'                  => $item['weight'],
                    'weight_type'             => $item['weight_type'],
                ];
            }

            $currency = $that->currency->getCurrency();
            $decimal_place = (int) $currency['decimal_place'];
            $decimal_place = !$decimal_place ? 2 : $decimal_place;

            $price = number_format($price,$decimal_place,$that->language->get('decimal_point'),$that->language->get('thousand_point'));
            $orig_price = number_format($orig_price,$decimal_place,$that->language->get('decimal_point'),$that->language->get('thousand_point'));
            $option_price = number_format($option_price,$decimal_place,$that->language->get('decimal_point'),$that->language->get('thousand_point'));
            $original_option_price = number_format($original_option_price,$decimal_place,$that->language->get('decimal_point'),$that->language->get('thousand_point'));

            $total_price = ($price + $option_price) * $quantity;
            $orig_total_price = ($orig_price + $original_option_price) * $quantity;

            $that->data['output']['option'] = $options;
            $that->data['output']['price'] = $price + $option_price;
            $that->data['output']['total'] = ($price + $option_price) * $quantity;
            $that->data['output']['original_option_price'] = ($orig_price + $original_option_price) * $quantity;
            $that->data['output']['savings'] = (float)$orig_total_price - (float)$total_price;
        }
    }

    public function onAOrder_ProcessData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'build_order_data') {
            $product_data = $this->processProduct($that);
            $that->data['products'] = $product_data;
        }
    }

    private function processProduct($that) {
        $products = $that->cart->getProducts();
        $product_data = [];
        foreach ($products as $key => $product) {
            foreach ($product['option'] as $key => $option) {
                if ($option['value'] !== '' && $option['show_option_savings'] && ($option['savings'] !== '0' && $option['savings'] !== 0.00)) {
                    $savings = $that->tax->calculate(
                        $option['savings'],
                        $product['tax_class_id'],
                        $that->config->get('config_tax')
                    );
                    $product['option'][$key]['value'] = $option['value'] . ' - ' . $that->config->get('option_price_pro_with_discount_other_page_option_savings_message') . ' ' . $that->currency->format($savings);
                }
            }

            $product_data[] = [
                'key'             => $product['key'],
                'product_id'      => $product['product_id'],
                'name'            => $product['name'],
                'model'           => $product['model'],
                'sku'             => $product['sku'],
                'option'          => $product['option'],
                'download'        => $product['download'],
                'quantity'        => $product['quantity'],
                'weight'          => (float) $product['weight'],
                'weight_iso_code' => $product['weight_class'],
                'width'           => (float) $product['width'],
                'height'          => (float) $product['height'],
                'length'          => (float) $product['length'],
                'length_iso_code' => $product['length_class'],
                //ternary for virtual products
                'price'           => $product['amount'] ? : $product['price'],
                'cost'            => $product['cost'],
                'total'           => $product['amount']
                    ? ($product['amount'] * $product['quantity'])
                    : $product['total'],
                'tax'             => $that->tax->calcTotalTaxAmount($product['total'], $product['tax_class_id']),
                'stock'           => $product['stock'],
                'savings'         => $product['savings']
            ];
        }
        return $product_data;
    }

    public function beforeModelCheckoutOrder_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $template_data = $that->data['mail_template_data'];
        if ($this->baseObject_method === 'sf_order_confirm_mail') {
            $products = [];
            $that->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
            $that->load->model('option_price_pro_with_discount/product');
            $template_products = $template_data['products'];
            foreach ($template_products as $product) {
                $data['order_id'] = $template_data['order_id'];
                $data['product_id'] = $product['product_id'];
                $data['order_product_id'] = $product['order_product_id'];
                $saves = (float)$that->model_option_price_pro_with_discount_product->getSavings($data);
                if ($saves !==0.00) {
                    $savings = $that->tax->calculate(
                        $saves,
                        $product['tax_class_id'],
                        $that->config->get('config_tax')
                    );

                    $that->load->model('catalog/product_total_savings');
                    $show_message = $that->model_catalog_product_total_savings->getProductSavings($data['product_id']);
                    if ($show_message['show_other_page_product_total_savings']==='1') {
                        $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                    }
                }
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $products[] = [
                    'product_id' => $product['product_id'],
                    'name' => $product['name'],
                    'model' => $product['model'],
                    'option' => $product['option'],
                    'quantity' => $product['quantity'],
                    'price' => $product['price'],
                    'total' => $product['total'],
                    'savings' => $view->fetch('responses/checkout/order_confirmation_savings.tpl')
                ];
                $that->data['mail_template_data']['products'] = $products;
            }
        }
    }

    public function onControllerPagesAccountInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadModel('account/customer');
            $that->loadModel('account/order');
            $that->loadModel('catalog/product_total_savings');
            $that->loadModel('option_price_pro_with_discount/product');

            if (isset($that->request->get['order_id'])) {
                $order_id = (int)$that->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $guest = false;
            $enc = new AEncryption($that->config->get('encryption_key'));
            if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                //try to decrypt order token
                $order_token = $that->request->get['ot'];
                if ($order_token) {
                    list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $guest = true;
                        $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                    }
                }
            }
            if ($that->request->is_POST()) {
                $order_id = $that->request->post['order_id'];
                $email = $that->request->post['email'];
                $order_token = $enc->encrypt($order_id . '::' . $email);
                $order_info = $that->model_account_order->getOrder($order_id, '', 'view');

                //compare emails
                if ($order_info['email'] != $email) {
                    unset($order_info, $order_id, $email);
                }
            }

            $products_info = $that->data['products'];
            $order_products = $that->model_account_order->getOrderProducts($order_id);

            if (!$order_info) {
                $order_info = $that->model_account_order->getOrder($order_id);
            }

            if ($order_info && $order_products) {
                foreach ($order_products as $product) {
                    $data['order_product_id'] = $product['order_product_id'];
                    $data['product_id'] = $product['product_id'];
                    $data['order_id'] = $order_id;
                    $saves = (float)$that->model_option_price_pro_with_discount_product->getSavings($data);
                    if ($saves !==0.00) {
                        $savings = $that->tax->calculate(
                            $saves,
                            $product['tax_class_id'],
                            $that->config->get('config_tax')
                        );

                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($data['product_id']);
                        if ($show_message['show_other_page_product_total_savings']=='1') {
                            $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('product_' . $product['order_product_id'] . '_additional_info', $message->fetch('pages/account/invoice_savings.tpl'));
                        }
                    }
                }
            }
            $that->processTemplate();
        }
    }

    public function onControllerPagesAccountOrderDetails_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadModel('account/customer');
            $that->loadModel('account/order');
            $that->loadModel('catalog/product_total_savings');
            $that->load->model('option_price_pro_with_discount/product');

            if (isset($that->request->get['order_id'])) {
                $order_id = (int)$that->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $guest = false;
            $enc = new AEncryption($that->config->get('encryption_key'));
            if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                //try to decrypt order token
                $order_token = $that->request->get['ot'];
                if ($order_token) {
                    list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $guest = true;
                        $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                    }
                }
            }
            if ($that->request->is_POST()) {
                $order_id = $that->request->post['order_id'];
                $email = $that->request->post['email'];
                $order_token = $enc->encrypt($order_id . '::' . $email);
                $order_info = $that->model_account_order->getOrder($order_id, '', 'view');

                //compare emails
                if ($order_info['email'] != $email) {
                    unset($order_info, $order_id, $email);
                }
            }

            $order_products = $that->model_account_order->getOrderProducts($order_id);

            if (!$order_info) {
                $order_info = $that->model_account_order->getOrder($order_id);
            }

            if ($order_info && $order_products) {
                foreach ($order_products as $product) {
                    $data['product_id'] = $product['product_id'];
                    $data['order_product_id'] = $product['order_product_id'];
                    $data['order_id'] = $order_id;
                    $saves = (float)$that->model_option_price_pro_with_discount_product->getSavings($data);
                    if ($saves !==0.00) {
                        $savings = $that->tax->calculate(
                            $saves,
                            $product['tax_class_id'],
                            $that->config->get('config_tax')
                        );
                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($data['product_id']);
                        if ($show_message['show_other_page_product_total_savings']=='1') {
                            $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('product_' . $product['order_product_id'] . '_additional_info_1', $message->fetch('pages/account/invoice_savings.tpl'));
                        }
                    }
                }
            }
            $that->processTemplate();
        }
    }

    public function onControllerResponsesSaleInvoice_UpdateData()  {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->load->model('option_price_pro_with_discount/options');
            $that->loadModel('sale/order');
            $that->loadModel('catalog/product_total_savings');

            $orders = $that->data['orders'];
            foreach ($orders as $order_key => $order) {
                $order_info = $that->model_sale_order->getOrder($order['order_id']);
                $order_products = $that->model_sale_order->getOrderProducts($order['order_id']);
                foreach ($order_products as $product) {
                    $data['product_id'] = $product['id'];
                    $data['order_id'] = $order['order_id'];
                    $data['order_product_id'] = $order['order_product_id'];
                    $saves = (float)$that->model_option_price_pro_with_discount_options->getSavings($data);
                    if ($saves !==0.00) {
                        $savings = $that->tax->calculate(
                            $saves,
                            $product['tax_class_id'],
                            $that->config->get('config_tax')
                        );
                        $show_message = $that->model_catalog_product_total_savings->getProductSavings($data['product_id']);
                        if ($show_message['show_other_page_product_total_savings']=='1') {
                            $data['message'] = $that->config->get('option_price_pro_with_discount_other_page_savings_message') . ' ' . $that->currency->format($savings);
                            $message = new AView($this->registry, 0);
                            $message->batchAssign($data);
                            $that->view->addHookVar('order_invoice_' . $order['order_id'] . '_product_' . $product['name'] . '_additional_info', $message->fetch('responses/sale/order_invoice_savings.tpl'));
                        }
                    }
                }
            }
        }
    }

    /** End Storefront section*/

    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
                    $that->load->model('extension/option_price_pro_with_discount_updater');
                    $total = $that->model_extension_option_price_pro_with_discount_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_option_price_pro_with_discount_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_option_price_pro_with_discount_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_option_price_pro_with_discount_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_option_price_pro_with_discount_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_option_price_pro_with_discount_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('option_price_pro_with_discount_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_price_pro_with_discount_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/option_price_pro_with_discount_license_info');
                $store_id = $that->model_extension_option_price_pro_with_discount_license_info->getStoreId();

                $license_key = $that->model_extension_option_price_pro_with_discount_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_option_price_pro_with_discount_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
                $getVersions = optionProWithDiscountUpdaterGetAllVersions();
                $that->load->model('extension/option_price_pro_with_discount_updater');
                $current_version = $that->model_extension_option_price_pro_with_discount_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_option_price_pro_with_discount_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_option_price_pro_with_discount_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }
}