<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

class ModelOptionPriceProWithDiscountOptions extends Model {
	/**
	 * @param $product_option_id
	 * @param $data
	 *
	 * @return bool
	 */
	public function updateProductOption( $product_option_id, $data ) {
		$fields = ["sort_order", "status", "required", "calculate", "base_price", "calculate_option_discount", "show_option_savings","regexp_pattern", "settings" ];
		$update = [];
		foreach ( $fields as $f ) {
			if ( isset( $data[ $f ] ) ) {
				if ( $f == 'settings' ) {
					$data[ $f ] = serialize( $data[ $f ] );
				}
				$update[] = $f . " = '" . $this->db->escape( $data[ $f ] ) . "'";
			}
		}
		if ( ! empty( $update ) ) {
			$this->db->query( "UPDATE " . $this->db->table( "product_options" ) . "
								SET " . implode( ',', $update ) . "
								WHERE product_option_id = '" . (int) $product_option_id . "'" );
		}

		if ( ! empty( $data['name'] ) ) {

			$language_id = $this->language->getContentLanguageID();

			$this->language->replaceDescriptions( 'product_option_descriptions',
				[ 'product_option_id' => (int) $product_option_id ],
				[
					(int) $language_id => [
						'name'               => $data['name'],
						'error_text'         => $data['error_text'],
						'option_placeholder' => $data['option_placeholder'],
					]
				] );
		}

		$this->cache->remove( 'product' );

		return true;
	}

	/**
	 * @param $option_id
	 * @param array $data
	 */
	public function addSettings( $option_id, $data ) {
	    $this->deleteSettings( $option_id );
		$sql = "INSERT INTO " . $this->db->table( 'option_validation' ) . " 
              SET product_option_id=" . (int) $option_id . ",
              minimum=" . (int) $data['minimum'] . ",
              maximum=" . (int) $data['maximum'] . ",
              maximum_status=" . (int) $data['maximum_status'];
		$this->db->query( $sql );
	}

	/**
	 * @param $option_id
	 */
	public function deleteSettings( $option_id ) {
		$sql = "DELETE FROM " . $this->db->table( 'option_validation' ) . " WHERE product_option_id=" . $option_id;
		$this->db->query( $sql );
	}

	/**
	 * @param $option_id
	 *
	 * @return mixed
	 */
	public function getSettings( $option_id ) {
		$sql    = "SELECT `minimum`, `maximum`, `maximum_status` FROM " . $this->db->table( 'option_validation' ) . " WHERE product_option_id=" . $option_id;
		$result = $this->db->query( $sql );

		return $result->row;
	}

	/**
	 * @param $option_id
	 * @param $minimum
	 */
	public function updateMinimumSelection( $option_id, $minimum ) {
		$sql = "UPDATE " . $this->db->table( 'option_validation' ) . " 
              SET minimum=" . (int) $minimum . " WHERE product_option_id=" . (int) $option_id;
		$this->db->query( $sql );
	}

	/**
	 * @param $option_id
	 *
	 * @return mixed
	 */
	public function getOptionType( $option_id ) {
		$sql     = "SELECT element_type FROM " . $this->db->table( 'product_options' ) . " 
              WHERE product_option_id=" . (int) $option_id;
		$results = $this->db->query( $sql );
		$result  = $results->row;

		return $result['element_type'];
	}

    /**
     * @param $product_id
     * @return mixed
     * @throws AException
     */
    public function getPriceSpecialCalculation($product_id) {
        $query = $this->db->query("SELECT `price_prefix` FROM ".$this->db->table("product_specials")." WHERE `product_id`=".(int)$product_id);
        return $query->row['price_prefix'];
    }

    /**
     * @param $product_id
     * @return mixed
     * @throws AException
     */
    public function getPriceDiscount($product_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table("product_discounts")." WHERE `product_id`=".(int)$product_id);
        return $query->row;
    }

    /**
     * @param $data
     * @return mixed
     * @throws AException
     */
    public function getSavings($data) {
        $sql = "SELECT `savings` FROM ".$this->db->table("order_products")." WHERE `order_product_id`=" . (int)$data['order_product_id'] . " AND `order_id`=" . (int)$data['order_id'];
        $query = $this->db->query($sql);
        return $query->row['savings'];
    }

}