<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require_once DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'lib/ctct/vendor/autoload.php';

class ModelExtensionCtct extends Model{
    public $data = [];
    private $error = [];

    public function addContact($id,$email) {
        $sql="INSERT INTO " . $this->db->table("constantcontact_integration"). "
				(`contactId`,`email`)
				VALUES ('" . $id . "',
				        '" . $email . "')";
        $this->db->query($sql);
        $contact_id = $this->db->getLastId();
        return $contact_id;
    }

    public function updateNewsletter($newsletter,$email) {
        $this->db->query("UPDATE " . $this->db->table("customers") . " SET newsletter = '" . (int)$newsletter . "' WHERE email = '" . $email . "'");
    }

    public function getContent($position) {
        $store_id = $this->getStoreId();
        $sql="SELECT * FROM " . $this->db->table("constantcontact_integration_content"). " WHERE positions='" . $position . "' AND `store_id`=".$store_id;
        $results=$this->db->query($sql);
        return $results->row;
    }

    public  function getNewsletterStatus($email)
    {
        $sql="SELECT newsletter FROM " . $this->db->table("customers")." WHERE email='" . $email . "'";
        $results=$this->db->query($sql);
        return $results->row;
    }

    /**
     * @param $email
     * @param $first_name
     * @param $last_name
     * @param $action - subscribe for new, resubscribe for existing
     * @param string $id
     * @param string $opt_in
     */

    public function Subscribe($email,$first_name,$last_name,$action,$id='') {
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration', $store_id);
        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];
        $last_error = $client->getLastError();
        if ($last_error!=='') {
            if (stripos($last_error,'401 Unauthorized')!==false) {
                $this->refreshToken();
                $client->accessToken = $token_info['access_token'];
                $client->refreshToken = $token_info['refresh_token'];
            } else {
                $this->log->write($last_error);
            }
        }
        $contactsEndPoint = new \PHPFUI\ConstantContact\V3\Contacts($client);
        $contactClientEndPoint = new \PHPFUI\ConstantContact\V3\Contact($client);

        $list_id = $settings['constantcontact_integration_list'];
        $contactsResponse = $contactsEndPoint->get(status:'all',email:$email);

        if ($contactsResponse['contacts'] || $action==1) {
            $contact['list_memberships'][] = $list_id;
            $email_address = new \PHPFUI\ConstantContact\Definition\EmailAddressPut($contactsResponse['contacts'][0]['email_address']);
            $email_address->permission_to_send = 'explicit';
            $contact['email_address'] = $email_address;
            $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPutRequest($contact);
            $contactBody->update_source = 'Contact';
            $contactClientEndPoint->put($contactsResponse['contacts'][0]['contact_id'], $contactBody);
            if (!$contactClientEndPoint->success()) {
                $this->log->write('Constant Contact Subscribe Result: ' . $contactsEndPoint->getLastError());
            }
        } else {
            $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPostRequest();
            $contactBody->first_name = $first_name;
            $contactBody->last_name = $last_name;
            $contactBody->create_source = 'Account';
            $contactBody->list_memberships = [new \PHPFUI\ConstantContact\UUID($list_id)];
            $email_address = new \PHPFUI\ConstantContact\Definition\EmailAddressPost();
            $email_address->address = $email;
            $email_address->permission_to_send = 'explicit';
            $contactBody->email_address = $email_address;
            $contactsEndPoint->post($contactBody);
            if (!$contactsEndPoint->success()) {
                $this->log->write('Constant Contact Subscribe Result: ' . $contactsEndPoint->getLastError());
            }
        }
    }

    public function SubscribePopup($email,$first_name,$last_name,$action,$id='') {
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration', $store_id);
        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];
        $last_error = $client->getLastError();
        if ($last_error!=='') {
            if (stripos($last_error,'401 Unauthorized')!==false) {
                $this->refreshToken();
                $client->accessToken = $token_info['access_token'];
                $client->refreshToken = $token_info['refresh_token'];
            } else {
                $this->log->write($last_error);
            }
        }
        $contactsEndPoint = new \PHPFUI\ConstantContact\V3\Contacts($client);
        $contactClientEndPoint = new \PHPFUI\ConstantContact\V3\Contact($client);

        $list_id = $settings['constantcontact_integration_popup_list'];
        $contactsResponse = $contactsEndPoint->get(status:'all',email:$email);

        if ($contactsResponse['contacts'] || $action==1) {
            $contact['list_memberships'][] = $list_id;
            $email_address = new \PHPFUI\ConstantContact\Definition\EmailAddressPut($contactsResponse['contacts'][0]['email_address']);
            $email_address->permission_to_send = 'explicit';
            $contact['email_address'] = $email_address;
            $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPutRequest($contact);
            $contactBody->update_source = 'Contact';
            $contactClientEndPoint->put($contactsResponse['contacts'][0]['contact_id'], $contactBody);
            if (!$contactClientEndPoint->success()) {
                $this->log->write('Constant Contact Subscribe Result: ' . $contactsEndPoint->getLastError());
            }
        } else {
            $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPostRequest();
            $contactBody->first_name = $first_name;
            $contactBody->last_name = $last_name;
            $contactBody->create_source = 'Account';
            $contactBody->list_memberships = [new \PHPFUI\ConstantContact\UUID($list_id)];
            $email_address = new \PHPFUI\ConstantContact\Definition\EmailAddressPost();
            $email_address->address = $email;
            $email_address->permission_to_send = 'explicit';
            $contactBody->email_address = $email_address;
            $contactsEndPoint->post($contactBody);
            if (!$contactsEndPoint->success()) {
                $this->log->write('Constant Contact Subscribe Result: ' . $contactsEndPoint->getLastError());
            }
        }
    }

    /**
     * @param string $email
     */
    public function Unsubscribe($email) {
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration', $store_id);

        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];
        $last_error = $client->getLastError();
        if ($last_error!=='') {
            if (stripos($last_error,'401 Unauthorized')!==false) {
                $this->refreshToken();
                $client->accessToken = $token_info['access_token'];
                $client->refreshToken = $token_info['refresh_token'];
            } else {
                $this->log->write($last_error);
            }
        }
        $contactsEndPoint = new \PHPFUI\ConstantContact\V3\Contacts($client);
        $contactClientEndPoint = new \PHPFUI\ConstantContact\V3\Contact($client);
        $list_id = $settings['constantcontact_integration_list'];
        $contactsResponse = $contactsEndPoint->get(status:'all',email:$email,lists:$list_id);

        if ($contactsResponse['contacts']) {
            $email_address = new \PHPFUI\ConstantContact\Definition\EmailAddressPut($contactsResponse['contacts'][0]['email_address']);
            $email_address->permission_to_send = 'unsubscribed';
            $email_address->opt_out_reason = '';
            $contact['email_address'] = $email_address;
            $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPutRequest($contact);
            $contactBody->update_source = 'Account';
            $contactClientEndPoint->put($contactsResponse['contacts'][0]['contact_id'], $contactBody);
            if (!$contactClientEndPoint->success()) {
                $this->log->write('Constant Contact Unsubscribe Result: ' . $contactClientEndPoint->getLastError());
            }
        }
    }

    /**
     * @param $email
     * @return array
     */
    public function getContact($email) {
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration', $store_id);
        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];
        $last_error = $client->getLastError();
        if ($last_error!=='') {
            if (stripos($last_error,'401 Unauthorized')!==false) {
                $this->refreshToken();
                $client->accessToken = $token_info['access_token'];
                $client->refreshToken = $token_info['refresh_token'];
            } else {
                $this->log->write($last_error);
            }
        }
        $contactsEndPoint = new \PHPFUI\ConstantContact\V3\Contacts($client);
        $list_id = $settings['constantcontact_integration_list'];

        $contactsResponse = $contactsEndPoint->get(status: 'all',email: $email,lists: $list_id);
        if (!$contactsEndPoint->success()) {
            $this->log->write('Constant Contact Get Contact Result: ' . $contactsEndPoint->getLastError());
        }
        return $contactsResponse['contacts'];
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getRedirect() {
        $sql = "SELECT `redirect_url` FROM ".$this->db->table("constantcontact_integration_redirect");
        $query = $this->db->query($sql);
        return $query->row['redirect_url'];
    }

    public function refreshToken() {
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration', $store_id);
        if ($settings['client_id']) {
            $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
            $token_info = $this->getInfo();
            if ($token_info) {
                // Set access and refresh tokens on client
                $client->accessToken = $token_info['access_token'];
                $client->refreshToken = $token_info['refresh_token'];
                // Refresh the tokens.  This should be done on a regular (daily) basis so the token does not expire.
                $token = $client->refreshToken();
                $data['access_token'] = $client->accessToken;
                $data['refresh_token'] = $client->refreshToken;
                $this->updateInfo($data);
            }
        }
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getInfo() {
        $sql = "SELECT * FROM ".$this->db->table("constantcontact_integration_token");
        $query = $this->db->query($sql);
        return $query->row;
    }

    /**
     * @param $data
     * @return void
     */
    public function updateInfo($data) {
        $sql = "UPDATE ".$this->db->table("constantcontact_integration_token")." SET `access_token`='".$data['access_token']."',`refresh_token`='".$data['refresh_token']."' WHERE `store_id`='".$data['store_id']."'";
        $this->db->query($sql);
    }

    /**
     * @return int
     */
    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

    /**
     * @param string $group
     * @param int    $store_id
     *
     * @return array
     */
    public function getSetting($group, $store_id = 0) {
        $data = [];

        $query = $this->db->query(
            "SELECT *
            FROM ".$this->db->table("settings")." 
            WHERE `group` = '".$this->db->escape($group)."'
                AND store_id = '".(int)$store_id."'"
        );
        foreach ($query->rows as $result) {
            $value = $result['value'];
            if (is_serialized($value)) {
                $value = unserialize($value);
            }
            $data[$result['key']] = $value;
        }
        return $data;
    }
}