<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT. "banner_statistic_manager" . DIR_EXT_CORE ."helpers.php";
require DIR_EXT.'banner_statistic_manager'.DIR_EXT_CORE.'lib/exports/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Dompdf\Dompdf;

/**
 * @property ModelExtensionBannerStatisticManager $model_extension_banner_statistic_manager
 */
class ControllerPagesExtensionBannerStatisticManager extends AController {
    public $data = [];
    public $error = [];

	public function verify() {
		if ($this->config->get('banner_statistic_manager_status')==='1') {
		    $validation = bannerStatisticManagerVerifyLicense();
			if ( $validation['notification_case'] === 'notification_license_ok' ) {
				return true;
			} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
				return false;
			}
		} else {
			return false;
		}
	}

    public function main() {
	    $this->extensions->hk_InitData($this, __FUNCTION__);
		$this->load->language('banner_statistic_manager/banner_statistic_manager');
	    $this->document->setTitle($this->language->get('banner_statistic_manager_heading_title'));

	    $this->document->addScript('https://www.gstatic.com/charts/loader.js');

		$this->view->assign('error_warning', $this->session->data['warning']);
	    if (isset($this->session->data['warning'])) {
		    unset($this->session->data['warning']);
	    }
	    $this->view->assign('success', $this->session->data['success']);
	    if (isset($this->session->data['success'])) {
		    unset($this->session->data['success']);
	    }

	    $this->document->initBreadcrumb([
		    'href'      => $this->html->getSecureURL('index/home'),
		    'text'      => $this->language->get('text_home'),
		    'separator' => false,
	    ]);
	    $this->document->addBreadcrumb([
		    'href'      => $this->html->getSecureURL('extension/banner_statistic_manager'),
		    'text'      => $this->language->get('banner_statistic_manager_heading_title'),
		    'separator' => ' :: ',
		    'current'   => true,
	    ]);

	    $grid_settings = [
		    'table_id'     => 'banner_stat_grid',
		    'url'          => $this->html->getSecureURL('listing_grid/banner_statistic_manager'),
		    'editurl'      => $this->html->getSecureURL('listing_grid/banner_statistic_manager/update'),
		    'sortname'     => 'name',
		    'sortorder'    => 'asc',
		    'actions'      => [
			    'delete' => [
				    'text' => $this->language->get('button_delete')
			    ],
		    ],
	    ];

	    $grid_settings['colNames'] = [
		    $this->language->get('column_banner_name'),
		    $this->language->get('column_banner_time'),
		    $this->language->get('column_banner_viewed'),
		    $this->language->get('column_banner_clicked'),
	    ];
	    $grid_settings['colModel'] = [
		    [
			    'name'  => 'name',
			    'index' => 'name',
			    'align' => 'center',
			    'width' => 200,
			    'search'   => false,
		    ],
		    [
			    'name'  => 'time',
			    'index' => 'time',
			    'align' => 'center',
			    'width' => 120,
			    'search'   => false,
		    ],
		    [
			    'name'   => 'viewed',
			    'index'  => 'viewed',
			    'align'  => 'center',
			    'width'  => 90,
			    'search' => false,
		    ],
		    [
			    'name'   => 'clicked',
			    'index'  => 'clicked',
			    'align'  => 'center',
			    'width'  => 130,
			    'search' => false,
		    ],
	    ];

	    $form = new AForm();
	    $form->setForm([
		    'form_name' => 'banner_stat_grid_search',
	    ]);

	    //get search filter from cookie if required
	    $search_params = [];
	    if ($this->request->get['saved_list']) {
		    $grid_search_form = json_decode(html_entity_decode($this->request->cookie['banner_stat_grid_search']));
		    if ($grid_search_form->table_id == $grid_settings['table_id']) {
			    parse_str($grid_search_form->params, $search_params);
		    }
	    }

	    $grid_search_form = [];
	    $grid_search_form['id'] = 'banner_stat_grid_search';
	    $grid_search_form['form_open'] = $form->getFieldHtml([
		    'type'   => 'form',
		    'name'   => 'banner_stat_grid_search',
		    'action' => '',
	    ]);
	    $grid_search_form['submit'] = $form->getFieldHtml([
		    'type'  => 'button',
		    'name'  => 'submit',
		    'text'  => $this->language->get('button_go'),
		    'style' => 'button1',
	    ]);

	    $grid_search_form['export'] = $form->getFieldHtml([
		    'type'  => 'button',
		    'name'  => 'submit',
		    'text'  => $this->language->get('button_go'),
		    'style' => 'button1',
	    ]);

	    $grid_search_form['reset'] = $form->getFieldHtml([
		    'type'  => 'button',
		    'name'  => 'reset',
		    'text'  => $this->language->get('button_reset'),
		    'style' => 'button2',
	    ]);

	    $this->load->model('extension/banner_statistic_manager');
	    $allBanners = $this->model_extension_banner_statistic_manager->getBanners();
	    foreach ($allBanners as $banner) {
	    	$banners[$banner['banner_id']]=$banner['name'];
	    }

	    $grid_search_form['fields']['banner_id'] = $form->getFieldHtml([
		    'type'    => 'selectbox',
		    'name'    => 'banner_id',
		    'options' => $banners
	    ]);

	    $grid_search_form['fields']['period'] = $form->getFieldHtml([
		    'type'    => 'selectbox',
		    'name'    => 'period',
		    'value'   => $search_params['period'],
		    'options' => [
		    	'all' => $this->language->get('text_all'),
			    'today'   => $this->language->get('text_today'),
			    'yesterday'   => $this->language->get('text_yesterday'),
			    'last_seven_days' => $this->language->get('text_last_seven_days'),
			    'last_week' => $this->language->get('text_last_week'),
			    'last_business_week' => $this->language->get('text_last_business_week'),
			    'this_month' => $this->language->get('text_this_month'),
			    'last_month' => $this->language->get('text_last_month'),
			    'custom_range' => $this->language->get('text_custom_range'),
		    ],
	    ]);

	    $grid_search_form['fields']['filter_date_start'] = $form->getFieldHtml([
		    'type'        => 'input',
		    'name'        => 'filter_date_start',
		    'value'       => $search_params['filter_date_start'],
		    'style'       => 'small-field',
	    ]);

	    $grid_search_form['fields']['filter_date_end'] = $form->getFieldHtml([
		    'type'        => 'input',
		    'name'        => 'filter_date_end',
		    'value'       => $search_params['filter_date_end'],
		    'style'       => 'small-field',
	    ]);

	    $this->data['entry_name'] = $this->language->get('entry_name');
	    $this->data['entry_period'] = $this->language->get('entry_period');
	    $this->data['entry_filter_date_start'] = $this->language->get('entry_filter_date_start');
	    $this->data['entry_filter_date_end'] = $this->language->get('entry_filter_date_end');
	    $this->data['text_date'] = $this->language->get('column_banner_time');
	    $this->data['text_viewed'] = $this->language->get('column_banner_viewed');
	    $this->data['text_clicked'] = $this->language->get('column_banner_clicked');
	    $this->data['text_xlsx'] = $this->language->get('text_xlsx');
	    $this->data['text_xls'] = $this->language->get('text_xls');
	    $this->data['text_csv'] = $this->language->get('text_csv');
	    $this->data['text_pdf'] = $this->language->get('text_pdf');
	    $this->data['entry_export_to'] = $this->language->get('entry_export_to');
	    $this->data['text_export'] = $this->language->get('text_export');
		$this->data['license_status'] = $this->verify();
		$this->data['text_unauthorized'] = $this->language->get('text_banner_statistic_manager_unauthorized');
	    $grid_settings['search_form'] = true;
	    $grid_settings['multiaction_options']['delete'] = $this->language->get('text_delete_selected');
		$this->data['export_url'] = $this->html->getSecureURL('extension/banner_statistic_manager/export');
	    $this->data['save_chart'] = $this->html->getSecureURL('r/extension/banner_statistic_manager_chart/saveChart');
	    //$this->data['export_pdf'] = $this->html->getSecureURL('r/extension/banner_statistic_manager_chart/exportPdf');

	    $grid = $this->dispatch('common/listing_grid', [$grid_settings]);

	    $this->data['listing_grid'] =  $grid->dispatchGetOutput();
	    $this->data['search_form'] =  $grid_search_form;
	    $this->data['chart_url'] = $this->html->getSecureURL('r/extension/banner_statistic_manager_chart');
		$this->view->batchAssign($this->data);
	    $this->processTemplate('pages/extension/banner_statistic_manager.tpl');
    }

	public function export() {
		$data['name'] = $this->request->get['banner_name'];
    	$filter['filter']['banner_id'] = $this->request->get['banner_id'];
    	$data['banner_id'] = $this->request->get['banner_id'];
		$filter['filter']['period'] = $this->request->get['period'];
		$data['period'] = $this->request->get['period'];
    	$filter['filter']['filter_date_start']= $this->request->get['from'];
		$data['from'] = $this->request->get['from'];
		$filter['filter']['filter_date_end'] = $this->request->get['to'];
		$data['to'] = $this->request->get['to'];
		$data['type'] = $this->request->get['export_type'];
		$export_type = $this->request->get['export_type'];
		$this->load->model('extension/banner_statistic_manager');
		$results = $this->model_extension_banner_statistic_manager->getBannersStat($filter);
		$data['results'] = $results;
		$this->load->language('banner_statistic_manager/banner_statistic_manager');
		$periods = '';
		switch ($data['period']) {
			case 'all' :
				$periods = $this->language->get('text_all_period');
				break;
			case 'today' :
				$today = date('F d Y');
				$periods = $today;
				break;
			case 'yesterday' :
				$yesterday = date('F d Y',strtotime('yesterday'));
				$periods = $yesterday;
				break;
			case 'last_seven_days' :
				$date_start = date('F d Y',strtotime("-7 days"));
				$date_end = date('F d Y');
				$periods = $date_start.' '.$this->language->get('text_to').' '.$date_end;
				break;
			case 'last_week' :
				$date_start = date('F d Y',strtotime('-2 Sunday'));
				$date_end = date('F d Y',strtotime('-2 Saturday'));
				$periods = $date_start.' '.$this->language->get('text_to').' '.$date_end;
				break;
			case 'last_business_week' :
				$date_start = date('F d Y',strtotime("last monday midnight"));
				$date_end = date('F d Y',strtotime("last friday midnight"));
				$periods = $date_start.' '.$this->language->get('text_to').' '.$date_end;
				break;
			case 'this_month' :
				$date_start = date('F 1 Y');
				$date_end = date('F t Y');
				$periods = $date_start.' '.$this->language->get('text_to').' '.$date_end;
				break;
			case 'last_month' :
				$date_start = date('F 1 Y',strtotime("last month"));
				$date_end = date('F t Y',strtotime("last month"));
				$periods = $date_start.' '.$this->language->get('text_to').' '.$date_end;
				break;
			case 'custom_range' :
				$periods = $data['from'].' '.$this->language->get('text_to').' '.$data['to'];
				break;
		}

		$data['periods'] = $periods;
		if ($export_type==='pdf') {
			$this->toPdf($data);
		} else {
			$this->toExcel($data );
		}
    }

	public function toExcel($data) {
    	$index=2;

		$spreadsheet = new Spreadsheet();
		$sheet       = $spreadsheet->getActiveSheet();
		$sheet->setCellValue( 'A1', 'Banner Name' );
		$sheet->setCellValue( 'B1', 'Time' );
		$sheet->setCellValue( 'C1', 'Viewed' );
		$sheet->setCellValue( 'D1', 'Clicked' );
		$styleArray = [
			'borders' => [
				'top'    => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
				],
				'left'   => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
				],
				'right'  => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
				],
				'bottom' => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
				],
			]
		];

		$spreadsheet->getActiveSheet()->getColumnDimension( 'A' )->setAutoSize( true );
		$spreadsheet->getActiveSheet()->getStyle( 'A1' )->applyFromArray( $styleArray );
		$spreadsheet->getActiveSheet()->getColumnDimension( 'B' )->setAutoSize( true );
		$spreadsheet->getActiveSheet()->getStyle( 'B1' )->applyFromArray( $styleArray );
		$spreadsheet->getActiveSheet()->getColumnDimension( 'C' )->setAutoSize( true );
		$spreadsheet->getActiveSheet()->getStyle( 'C1' )->applyFromArray( $styleArray );
		$spreadsheet->getActiveSheet()->getColumnDimension( 'D' )->setAutoSize( true );
		$spreadsheet->getActiveSheet()->getStyle( 'D1' )->applyFromArray( $styleArray );

		foreach ($data['results'] as $items) {
			$sheet->setCellValue( 'A' . $index, $items['name'] );
			$spreadsheet->getActiveSheet()->getStyle( 'A' . $index )->applyFromArray( $styleArray );
			$sheet->setCellValue( 'B' . $index, $items['time'] );
			$spreadsheet->getActiveSheet()->getStyle( 'B' . $index )->applyFromArray( $styleArray );
			$sheet->setCellValue( 'C' . $index, $items['viewed'] );
			$spreadsheet->getActiveSheet()->getStyle( 'C' . $index )->applyFromArray( $styleArray );
			$sheet->setCellValue( 'D' . $index, $items['clicked'] );
			$spreadsheet->getActiveSheet()->getStyle( 'D' . $index )->applyFromArray( $styleArray );
			$index++;
		}
		$filename = $this->language->get('text_banner_report').' '.$data['name'].' '.$this->language->get('text_as').' '.$data['periods'].".".$data['type'];
		header( 'Content-type: application/vnd.ms-excel' );
		// It will be called order.xls
		header( "Content-Disposition: attachment; filename=".$filename);
		$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter( $spreadsheet, ucfirst($data['type']) );
		ob_end_clean();
		// Write file to the browser
		$writer->save( 'php://output' );
		die();
	}

	public function toPdf($data) {
		$this->load->language('banner_statistic_manager/banner_statistic_manager');
		@ini_set( "memory_limit", "512M" );
		$pdf = new Dompdf();
		$pdf->add_info( 'Title', 'Banner Statistic Report' );
		$pdf->add_info( 'Subject', 'Banner Statistic Report' );
		$pdf->add_info( 'Author', 'Banner Statistic Report' );
		$pdf->set_option( 'isRemoteEnabled', true );
		$this->load->model('extension/banner_statistic_manager');
		$img = $this->model_extension_banner_statistic_manager->getChart($data['banner_id']);
		$this->data['license_status'] = $this->verify();
		$this->data['img'] = $img;
		$this->data['export'] = 'pdf';
		$this->data['results'] = $data['results'];
		$this->data['column_banner_name'] = $this->language->get('column_banner_name');
		$this->data['column_banner_time'] = $this->language->get('column_banner_time');
		$this->data['column_banner_viewed'] = $this->language->get('column_banner_viewed');
		$this->data['column_banner_clicked'] = $this->language->get('column_banner_clicked');
		$filename = $this->language->get('text_banner_report').' '.$data['name'].' '.$this->language->get('text_as').' '.$data['periods'];
		$this->data['title'] =$filename;
		$this->view->batchAssign( $this->data );
		$this->processTemplate( 'pages/extension/banner_statistic_manager.tpl' );
		$pdf->loadHtml( $this->view->getOutput() );
		$pdf->setPaper( 'A4', 'landscape' );
		$pdf->render();
		$pdf->stream( $filename.'.pdf' );
		//Close and output PDF document
		$pdf->output();
		die();
	}
}