<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
header('Location: static_pages/');
}

require_once DIR_EXT. "sales_state_report" . DIR_EXT_CORE ."helpers.php";


class ControllerPagesSalesStateReportSalesStateReport extends AController {

	public $data = [];
    private $error=[];
	private $errors = [];
    private $fields = [
        'sales_state_report_export_pdf_paper',
        'sales_state_report_export_pdf_orientation',
    ];

	public function verify() {
		$validation = salesStateReportVerifyLicense();
		if ( $validation['notification_case'] === 'notification_license_ok' ) {
			return true;
		} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
			return false;
		}
	}

    public function main(){
        $this->extensions->hk_InitData($this,__FUNCTION__);
        $this->request->get['extension'] = 'sales_state_report';
        $this->language->load('sales_state_report/sales_state_report');
        $this->language->load('extension/extensions');
        $this->view->assign('heading_title',$this->language->get('sales_state_report_name'));
        $this->document->setTitle( $this->language->get('text_additional_settings') );
        $this->load->model('setting/setting');
        if ($this->request->is_POST() && $this->_validate()) {
            $this->model_setting_setting->editSetting('sales_state_report', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->redirect($this->html->getSecureURL('sales_state_report/sales_state_report'));
        }
        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }
        if (isset($this->error['report_limit'])) {
            $this->data['error']['report_limit'] = $this->error['report_limit'];
        }

        $this->data['success'] = $this->session->data['success'];
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('sales_state_report/sales_state_report'),
            'text'      => $this->language->get('heading_title'),
            'separator' => ' :: ',
            'current' => true
        ));

        foreach ( $this->fields as $f ) {
            if (isset ( $this->request->post [$f] )) {
                $this->data [$f] = $this->request->post [$f];
            } else {
                $this->data [$f] = $this->config->get($f);
            }
        }

        $this->data['action'] = $this->html->getSecureURL ( 'sales_state_report/sales_state_report', '&extension=sales_state_report' );
        $this->data['cancel'] = $this->html->getSecureURL('extension/extensions');
        $this->data['heading_title'] = $this->language->get ( 'text_additional_settings' );
        
        $this->data['update'] = $this->html->getSecureURL ( 'r/sales_state_report/sales_state_report_save/update' );
        $this->data['ext_man']='https://why2central.net/v1/sales-state';
        $this->data['note']=$this->language->get('sales_state_report_ext_note');

        $pdfType = [
            "A1" => "A1",
            "A2" => "A2",
            "A3" => "A3",
            "A4" => "A4",
            "A5" => "A5",
            "A6" => "A6",
            "A7" => "A7",
            "A8" => "A8",
            "A9" => "A9",
            "A10" => "A10",
            "b0" => "B0",
            "b1" => "B1",
            "b2" => "B2",
            "b3" => "B3",
            "b4" => "B4",
            "b5" => "B5",
            "b6" => "B6",
            "b7" => "B7",
            "b8" => "B8",
            "b9" => "B9",
            "b10" => "B10",
            "c0" => "C0",
            "c1" => "C1",
            "c2" => "C2",
            "c3" => "C3",
            "c4" => "C4",
            "c5" => "C5",
            "c6" => "C6",
            "c7" => "C7",
            "c8" => "C8",
            "c9" => "C9",
            "c10" => "C10",
            "ra0" => "RA0",
            "ra1" => "RA1",
            "ra2" => "RA2",
            "ra3" => "RA3",
            "ra4" => "RA4",
            "sra0" => "SRA0",
            "sra1" => "SRA1",
            "sra2" => "SRA2",
            "sra3" => "SRA3",
            "sra4" => "SRA4",
            "letter" => "LETTER",
            "legal" => "LEGAL",
            "ledger" => "LEDGER",
            "tabloid" => "TABLOID",
            "executive" => "EXECUTIVE",
            "folio" => "FOLIO",
            "commercial #10 envelope" => "COMMERCIAL 10 ENVELOPE",
            "catalog #10 1/2 envelope" => "COMMERCIAL 10 1/2 ENVELOPE",
            "8.5x11" => "8.5x11",
            "8.5x14" => "8.5x14",
            "11x17"  => "11x17",
        ];

        $pdfOrientation=[
            "portrait" => $this->language->get("text_portrait"),
            "landscape" => $this->language->get("text_landscape")
        ];

        $form = new AForm ( 'HS' );
        $form->setForm ( array ('form_name' => 'editFrm', 'update' => $this->data ['update'] ) );

        $this->data['form']['form_open'] = $form->getFieldHtml ( array (
            'type' => 'form',
            'name' => 'editFrm',
            'action' => $this->data ['action'],
            'attr' => 'data-confirm-exit="true" class="aform form-horizontal"'
        ) );
        $this->data['form']['submit'] = $form->getFieldHtml ( array (
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get ( 'button_save' )
        ) );
        $this->data['form']['cancel'] = $form->getFieldHtml ( array (
            'type' => 'button',
            'name' => 'cancel',
            'text' => $this->language->get ( 'button_cancel' )
        ) );

        if ($this->data['sales_state_report_export_pdf_paper']!='') {
            $export_pdf_paper=$this->data['sales_state_report_export_pdf_paper'];
        } else {
            $export_pdf_paper='letter';
        }

        $this->data['form']['fields']['export_pdf_paper'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'sales_state_report_export_pdf_paper',
            'options' => $pdfType,
            'value' => $export_pdf_paper,
            'style'=>'small-field',
        ]);

        if ($this->data['sales_state_report_export_pdf_orientation']!='') {
            $export_pdf_orientation=$this->data['sales_state_report_export_pdf_orientation'];
        } else {
            $export_pdf_orientation='P';
        }

        $this->data['form']['fields']['export_pdf_orientation'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'sales_state_report_export_pdf_orientation',
            'options' => $pdfOrientation,
            'value' => $export_pdf_orientation,
            'style'=>'small-field',
        ]);

        $this->view->batchAssign (  $this->language->getASet () );
        $this->data['groups'][] = 'additional_settings';
        $this->data['link_additional_settings'] = $this->data['add_sett']->href;
        $this->data['active_group'] = 'additional_settings';

        $tabs_obj = $this->dispatch('pages/extension/extension_tabs', [ $this->data ] );
        $this->data['tabs'] = $tabs_obj->dispatchGetOutput();
        unset($tabs_obj);

        $obj = $this->dispatch('pages/extension/extension_summary', [ $this->data ] );
        $this->data['extension_summary'] = $obj->dispatchGetOutput();
        unset($obj);

	    $this->data['license_status'] = $this->verify();
	    $this->data['text_unauthorized'] = $this->language->get( 'text_sale_state_report_unauthorized' );

	    $this->view->batchAssign( $this->data );

        $this->processTemplate('pages/sales_state_report/sales_state_report.tpl' );
    }

    private function _validate() {
        if (!$this->user->canModify('extension/sales_state_report')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['sales_state_report_chart_width']) {
            $this->error['width'] = $this->language->get('error_chart_width');
        }

        if (!$this->request->post['sales_state_report_chart_height']) {
            $this->error['height'] = $this->language->get('error_chart_height');
        }

        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

 }
