<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ModelExtensionEnhancedFlatRateShipping
 * @property ModelExtensionEnhancedFlatRateShippingLicenseInfo $model_extension_enhanced_flat_rate_shipping_license_info
 */

class ModelExtensionEnhancedFlatRateShipping extends Model {

    private $shared_secret = "enhanced_flat_rate_shipping";

    public function verify() {
        $this->load->model('extension/enhanced_flat_rate_shipping_license_info');
        $license_key = $this->config->get('enhanced_flat_rate_shipping_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('enhanced_flat_rate_shipping_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_enhanced_flat_rate_shipping_license_info->getStoreId();
                $license_key = $this->model_extension_enhanced_flat_rate_shipping_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_enhanced_flat_rate_shipping_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 604800;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_enhanced_flat_rate_shipping_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function getQuote($address) {
        if ($this->verify()) {
            //create new instance of language for case when model called from admin-side
            $language = new ALanguage($this->registry, $this->language->getLanguageCode(), 0);
            $language->load($language->language_details['directory']);
            $language->load('enhanced_flat_rate_shipping/enhanced_flat_rate_shipping');
            $status = false;
            $method_data = [];

            if ($this->config->get('enhanced_flat_rate_shipping_status')) {
                $default_cost = $this->config->get('enhanced_flat_rate_shipping_default_cost');
                $default_tax_class_id = (int)$this->config->get('enhanced_flat_rate_shipping_default_tax_class_id');
                $default_status = $this->config->get('enhanced_flat_rate_shipping_default_status');
                //get location_id
                $sql = "SELECT location_id
					FROM " . $this->db->table('zones_to_locations') . "
					WHERE country_id = '" . (int)$address['country_id'] . "'
						AND (zone_id = '" . (int)$address['zone_id'] . "')";
                $result = $this->db->query($sql);
                $customer_location_id = (int)$result->row['location_id'];
                if ($customer_location_id) {
                    $cost = $this->config->get('enhanced_flat_rate_shipping_cost_' . $customer_location_id);
                    $location_status = $this->config->get('enhanced_flat_rate_shipping_status_' . $customer_location_id);
                    if (!$location_status && !$default_status) {
                        $status = false;
                    } elseif ($location_status && $cost) {
                        $tax_class_id = $this->config->get('enhanced_flat_rate_shipping_tax_class_id_' . $customer_location_id);
                        $status = true;
                    } else {
                        //if cost not set - use default cost
                        $customer_location_id = 0;
                        $status = $default_status;
                        $cost = $default_cost;
                    }
            } else
                //if cost not set or unknown location - try use default settings
            {
                    if (empty($default_cost) || !$default_status) {
                        $status = false;
                    } //use default settings for other locations
                    else {
                        $status = true;
                        $cost = $default_cost;
                        $tax_class_id = $default_tax_class_id;
                    }
                }
            }

            if (!$status) {
                return $method_data;
            }

            $quote_data = [];
           //Process all products shipped together with not special shipping settings on a product level
            if (sizeof($this->cart->basicShippingProducts()) > 0) {
                $quote_data['enhanced_flat_rate_shipping'] = [
                    'id' => 'enhanced_flat_rate_shipping.enhanced_flat_rate_shipping',
                    'title' => $this->config->get("enhanced_flat_rate_shipping_message") . ' ' . $language->get('text_description'),
                'cost'         => $this->tax->calculate(
                                    $cost,
                                    $tax_class_id,
                                    true
                                ),
                'tax_class_id' => (int)$tax_class_id,
                'text'         => $this->currency->format(
                                        $this->tax->calculate(
                                            $cost,
                                            $tax_class_id,
                                            true
                                        )
                                  )
            ];
        }

            $special_ship_products = $this->cart->specialShippingProducts();
            foreach ($special_ship_products as $product) {
                //check if free or fixed shipping
                if ($product['free_shipping']) {
                    $fixed_cost = 0;
                } else {
                    if ($product['shipping_price'] > 0) {
                        $fixed_cost = $product['shipping_price'];
                        //If ship individually count every quantity
                        if ($product['ship_individually']) {
                            $fixed_cost = $fixed_cost * $product['quantity'];
                        }
                    } else {
                        $fixed_cost = $cost;
                    }
                }
                //merge data and accumulate shipping cost
                if (isset($quote_data['enhanced_flat_rate_shipping'])) {
                    $quote_data['enhanced_flat_rate_shipping']['cost'] = $quote_data['enhanced_flat_rate_shipping']['cost'] + $fixed_cost;
                    if ($quote_data['enhanced_flat_rate_shipping']['cost'] > 0) {
                        $quote_data['enhanced_flat_rate_shipping']['text'] = $this->currency->format(
                            $this->tax->calculate(
                                $quote_data['enhanced_flat_rate_shipping']['cost'],
                                $tax_class_id,
                            true
                            )
                        );
                    } else {
                        $quote_data['enhanced_flat_rate_shipping']['text'] = $language->get('text_free');
                    }
                } else {
                    $quote_data['enhanced_flat_rate_shipping'] = [
                        'id' => 'enhanced_flat_rate_shipping.enhanced_flat_rate_shipping',
                        'title' => $this->config->get("enhanced_flat_rate_shipping_message") . ' ' . $language->get('text_description'),
                        'cost' => $fixed_cost,
                        'tax_class_id' => $tax_class_id,
                        'text' => '',
                    ];
                    if ($fixed_cost > 0) {
                        $quote_data['enhanced_flat_rate_shipping']['text'] = $this->currency->format(
                            $this->tax->calculate($fixed_cost,
                                $tax_class_id,
                            true
                            )
                        );
                    } else {
                        $quote_data['enhanced_flat_rate_shipping']['text'] = $language->get('text_free');
                    }
                }
            }

            if ($quote_data) {
                $method_data = [
                    'id' => 'enhanced_flat_rate_shipping',
                    'title' => $this->config->get("enhanced_flat_rate_shipping_message") . ' ' . $language->get('text_description'),
                    'quote' => $quote_data,
                    'sort_order' => $this->config->get('enhanced_flat_rate_shipping_sort_order'),
                    'error' => false
                ];
            }

            $subtotal = $this->cart->getSubTotal();
            $threshold = $this->config->get('enhanced_flat_rate_shipping_threshold');
            if ($threshold <= $subtotal || $threshold == '') {
                return $method_data;
            } else {
                return '';
            }
        }
    }
}
